/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexMediaDescriptor;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.data.DataUtil;
import mpi.annex.util.AnnexUtil;
import mpi.util.MimeType;
import mpi.util.OurURL;
import org.xml.sax.InputSource;

public class AnnexChatParser {
    public static void parse(File file, AnnexTranscription annexTranscription) throws Exception {
        int n;
        String[] stringArray = DataUtil.readLines(file, null);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].trim();
        }
        String string = null;
        for (n = 0; n < stringArray.length && !stringArray2[n].startsWith("*"); ++n) {
            if (!stringArray2[n].startsWith("@")) continue;
            if (stringArray2[n].toLowerCase().indexOf("utf8") >= 0) {
                string = "UTF-8";
                break;
            }
            if (stringArray2[n].toLowerCase().indexOf("utf16") < 0) continue;
            string = "UTF-16";
            break;
        }
        if (string != null) {
            stringArray = DataUtil.readLines(file, string);
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n] = stringArray[n].trim();
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray2[n].indexOf("%snd") != 0) continue;
            stringArray[n] = stringArray2[n];
        }
        AnnexChatParser.parse(file.getName(), stringArray, stringArray2, annexTranscription);
    }

    public static void parse(OurURL ourURL, AnnexTranscription annexTranscription) throws Exception {
        int n;
        InputSource inputSource = new InputSource(ourURL.openStream());
        String[] stringArray = DataUtil.readLines(inputSource, null);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].trim();
        }
        String string = null;
        for (n = 0; n < stringArray.length && !stringArray2[n].startsWith("*"); ++n) {
            if (!stringArray2[n].startsWith("@")) continue;
            if (stringArray2[n].toLowerCase().indexOf("utf8") >= 0) {
                string = "UTF-8";
                break;
            }
            if (stringArray2[n].toLowerCase().indexOf("utf16") < 0) continue;
            string = "UTF-16";
            break;
        }
        if (string != null) {
            inputSource = new InputSource(ourURL.openStream());
            stringArray = DataUtil.readLines(inputSource, string);
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n] = stringArray[n].trim();
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray2[n].indexOf("%snd") != 0) continue;
            stringArray[n] = stringArray2[n];
        }
        AnnexChatParser.parse("remote node", stringArray, stringArray2, annexTranscription);
    }

    public static void parse(String string, String[] stringArray, String[] stringArray2, AnnexTranscription annexTranscription) throws Exception {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        int n2;
        String[] stringArray3;
        String string2;
        int n3;
        String string3 = "qqqq";
        String string4 = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (n3 = 0; n3 < stringArray.length && !stringArray2[n3].startsWith("*"); ++n3) {
            String[] stringArray4;
            if (stringArray2[n3].startsWith("%act") || stringArray2[n3].startsWith("%sit") || stringArray2[n3].startsWith("%com")) {
                if (n3 <= 0) break;
                stringArray2[n3 - 1] = "*" + string3 + ": xxx";
                break;
            }
            if (stringArray2[n3].startsWith("@")) {
                string4 = string4 + stringArray2[n3] + "\n";
            }
            if (stringArray2[n3].toLowerCase().startsWith("@participants")) {
                string2 = stringArray2[n3].substring(14);
                stringArray4 = string2.split(",");
                stringArray3 = string2.split(";");
                if (stringArray3.length > stringArray4.length) {
                    stringArray4 = stringArray3;
                }
                for (n2 = 0; n2 < stringArray4.length; ++n2) {
                    object4 = stringArray4[n2].trim();
                    int n4 = ((String)object4).indexOf(32);
                    if (n4 < 0) continue;
                    String string5 = "*" + ((String)object4).substring(0, n4).trim();
                    String string6 = ((String)object4).substring(n4).trim();
                    hashMap.put(string5, string6);
                }
            }
            if (!stringArray2[n3].toLowerCase().startsWith("@mediafile")) continue;
            string2 = stringArray2[n3].substring(14);
            stringArray4 = string2.split(",");
            for (int i = 0; i < stringArray4.length; ++i) {
                String string7 = stringArray4[i].trim();
                object4 = new AnnexMediaDescriptor();
                ((AnnexMediaDescriptor)object4).fileName = string7;
                ((AnnexMediaDescriptor)object4).mimeType = MimeType.getMimeTypeStringFromExtension((String)((AnnexMediaDescriptor)object4).fileName);
                annexTranscription.getMediaDescriptors().add(object4);
            }
        }
        annexTranscription.setInfo(string4);
        n3 = 0;
        string2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray2[n].startsWith("%snd")) continue;
            n3 = 1;
            stringArray3 = stringArray2[n].split("\\s");
            string2 = stringArray3[1].replaceAll("\"", "");
            break;
        }
        if (n3 != 0) {
            n = -1;
            stringArray3 = annexTranscription.getMediaDescriptors();
            for (n2 = 0; n2 < stringArray3.size(); ++n2) {
                object4 = (AnnexMediaDescriptor)stringArray3.get(n2);
                if (!((AnnexMediaDescriptor)object4).fileName.toLowerCase().equals(string2.toLowerCase())) continue;
                n = n2;
                break;
            }
            AnnexMediaDescriptor annexMediaDescriptor = new AnnexMediaDescriptor();
            annexMediaDescriptor.fileName = string2;
            annexMediaDescriptor.mimeType = MimeType.getMimeTypeStringFromExtension((String)annexMediaDescriptor.fileName);
            annexTranscription.getMediaDescriptors().add(0, annexMediaDescriptor);
            if (n > 0) {
                annexTranscription.getMediaDescriptors().remove(n + 1);
            }
        }
        String string8 = "-aligned";
        long l = 0L;
        object4 = new HashMap();
        ArrayList arrayList = new ArrayList();
        int n5 = 0;
        try {
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                int n6;
                int n7;
                if (!stringArray2[n5].startsWith("*")) continue;
                int n8 = n5;
                if (n3 != 0) {
                    for (n7 = n5; n7 < stringArray.length && stringArray2[n7].indexOf("%snd") != 0; ++n7) {
                    }
                    if (n7 == stringArray.length) {
                        n3 = 0;
                        --n5;
                        continue;
                    }
                    n6 = n7;
                    while (n7 + 1 < stringArray.length && stringArray[n7 + 1].indexOf("*") != 0) {
                        object3 = stringArray2[++n7 - 1];
                        stringArray2[n7 - 1] = stringArray2[n7];
                        stringArray2[n7] = object3;
                        object3 = stringArray[n7 - 1];
                        stringArray[n7 - 1] = stringArray[n7];
                        stringArray[n7] = object3;
                    }
                } else {
                    while (n7 + 1 < stringArray.length && stringArray[n7 + 1].indexOf("%") == 0) {
                        ++n7;
                    }
                }
                n6 = n7 - n8 + 1;
                object3 = new ChatBlock();
                ((ChatBlock)object3).tierNames = new String[n6];
                ((ChatBlock)object3).annotationValues = new String[n6];
                ((ChatBlock)object3).beginTime = l;
                ((ChatBlock)object3).endTime = ((ChatBlock)object3).beginTime + 1000L;
                object2 = "";
                String[] stringArray5 = new String[4];
                for (int i = 0; i < n6; ++i) {
                    AnnexTier annexTier;
                    Serializable serializable;
                    int n9;
                    object = stringArray2[n8 + i];
                    String string9 = stringArray[n8 + i];
                    if (((String)object).startsWith("@")) {
                        ((ChatBlock)object3).tierNames[i] = null;
                        continue;
                    }
                    if (((String)object).startsWith("%snd")) {
                        ((ChatBlock)object3).tierNames[i] = null;
                        StringTokenizer stringTokenizer = new StringTokenizer(stringArray2[n8 + i]);
                        int n10 = 0;
                        while (n10 < stringArray5.length && stringTokenizer.hasMoreTokens()) {
                            stringArray5[n10++] = stringTokenizer.nextToken();
                        }
                        try {
                            ((ChatBlock)object3).beginTime = (long)Float.parseFloat(stringArray5[2]);
                            ((ChatBlock)object3).endTime = (long)Float.parseFloat(stringArray5[3]);
                            continue;
                        }
                        catch (Exception exception) {
                            AnnexUtil.log("AnnexParser", 1, "chat parser number format error");
                            AnnexUtil.log("AnnexParser", 1, "line: " + (n8 + i));
                            AnnexUtil.log("AnnexParser", 1, stringArray[n8 + i]);
                            for (int j = 0; j < stringArray5.length; ++j) {
                                AnnexUtil.log("AnnexParser", 1, j + "  |" + stringArray5[j] + "|");
                            }
                            throw exception;
                        }
                    }
                    if (((String)object).startsWith("*")) {
                        n9 = stringArray2[n8 + i].indexOf(58);
                        if (n9 < 1) {
                            throw new Exception("chat parse error, missing colon in main tier line: " + (String)object);
                        }
                        stringArray5[0] = ((String)object).substring(0, n9);
                        stringArray5[1] = ((String)object).substring(n9 + 1).trim();
                        ((ChatBlock)object3).tierNames[i] = object2 = stringArray5[0];
                        ((ChatBlock)object3).annotationValues[i] = stringArray5[1];
                        if (((HashMap)object4).containsKey(object2)) continue;
                        serializable = new AnnexTier();
                        serializable.name = (String)object2 + string8;
                        serializable.hasVirtualTime = true;
                        serializable.annotations = new ArrayList();
                        annexTranscription.getTiers().add(serializable);
                        ((HashMap)object4).put(serializable.name, serializable);
                        annexTier = new AnnexTier();
                        annexTier.name = object2;
                        annexTier.annotations = new ArrayList();
                        annexTier.participant = (String)hashMap.get(annexTier.name);
                        annexTier.parentTier = serializable;
                        annexTranscription.getTiers().add(annexTier);
                        ((HashMap)object4).put(annexTier.name, annexTier);
                        continue;
                    }
                    if (((String)object).startsWith("%")) {
                        n9 = stringArray2[n8 + i].indexOf(58);
                        stringArray5[0] = ((String)object).substring(0, n9);
                        stringArray5[1] = ((String)object).substring(n9 + 1).trim();
                        ((ChatBlock)object3).tierNames[i] = (String)object2 + "-" + stringArray5[0];
                        ((ChatBlock)object3).annotationValues[i] = stringArray5[1];
                        if (((HashMap)object4).containsKey(((ChatBlock)object3).tierNames[i])) continue;
                        serializable = annexTranscription.getTiers();
                        annexTier = new AnnexTier();
                        annexTier.name = ((ChatBlock)object3).tierNames[i];
                        annexTier.annotations = new ArrayList();
                        annexTier.parentTier = (AnnexTier)((HashMap)object4).get(object2);
                        annexTranscription.getTiers().add(annexTier);
                        ((HashMap)object4).put(annexTier.name, annexTier);
                        continue;
                    }
                    ((ChatBlock)object3).tierNames[i] = ((ChatBlock)object3).tierNames[i - 1];
                    ((ChatBlock)object3).annotationValues[i] = ((ChatBlock)object3).annotationValues[i - 1] + " " + ((String)object).trim();
                    ((ChatBlock)object3).tierNames[i - 1] = null;
                    ((ChatBlock)object3).annotationValues[i - 1] = null;
                }
                arrayList.add(object3);
                l = ((ChatBlock)object3).endTime;
                n5 = n7;
            }
        }
        catch (Exception exception) {
            AnnexUtil.log("AnnexParser", 1, "problem is near line " + n5 + " in the chat file");
            throw exception;
        }
        HashMap hashMap2 = new HashMap();
        for (n5 = 0; n5 < arrayList.size(); ++n5) {
            ChatBlock chatBlock = (ChatBlock)arrayList.get(n5);
            AnnexAnnotation annexAnnotation = null;
            object3 = null;
            object2 = null;
            hashMap2.clear();
            for (int i = 0; i < chatBlock.tierNames.length; ++i) {
                if (chatBlock.tierNames[i] == null || hashMap2.containsKey(chatBlock.tierNames[i]) || chatBlock.tierNames[i].indexOf(45) >= 0) continue;
                String string10 = chatBlock.tierNames[i];
                object = string10 + string8;
                annexAnnotation = new AnnexAnnotation();
                annexAnnotation.value = "";
                annexAnnotation.refAnnotation = null;
                annexAnnotation.isTimeAligned = true;
                annexAnnotation.beginTime = chatBlock.beginTime;
                annexAnnotation.endTime = chatBlock.endTime;
                ((AnnexTier)((HashMap)object4).get((Object)object)).annotations.add(annexAnnotation);
                int n11 = 0;
                for (int j = i; j < chatBlock.tierNames.length; ++j) {
                    if (chatBlock.tierNames[j] == null || !chatBlock.tierNames[j].equals(string10)) continue;
                    ++n11;
                }
                long l2 = (annexAnnotation.endTime - annexAnnotation.beginTime) / (long)n11;
                long l3 = annexAnnotation.beginTime;
                for (int j = i; j < chatBlock.tierNames.length; ++j) {
                    if (chatBlock.tierNames[j] == null || !chatBlock.tierNames[j].equals(string10)) continue;
                    object3 = new AnnexAnnotation();
                    ((AnnexAnnotation)object3).value = chatBlock.annotationValues[j];
                    ((AnnexAnnotation)object3).refAnnotation = annexAnnotation;
                    ((AnnexAnnotation)object3).isTimeAligned = false;
                    ((AnnexAnnotation)object3).beginTime = l3;
                    ((AnnexAnnotation)object3).endTime = ((AnnexAnnotation)object3).beginTime + l2;
                    ((AnnexTier)((HashMap)object4).get((Object)string10)).annotations.add(object3);
                    l3 = ((AnnexAnnotation)object3).endTime;
                    for (int k = j + 1; k < chatBlock.tierNames.length && chatBlock.tierNames[k] != null && chatBlock.tierNames[k].startsWith(string10) && chatBlock.tierNames[k].indexOf(37) > 0; ++k) {
                        object2 = new AnnexAnnotation();
                        ((AnnexAnnotation)object2).value = chatBlock.annotationValues[k];
                        ((AnnexAnnotation)object2).refAnnotation = object3;
                        ((AnnexAnnotation)object2).isTimeAligned = false;
                        ((AnnexAnnotation)object2).beginTime = ((AnnexAnnotation)object3).beginTime;
                        ((AnnexAnnotation)object2).endTime = ((AnnexAnnotation)object3).endTime;
                        ((AnnexTier)((HashMap)object4).get((Object)chatBlock.tierNames[k])).annotations.add(object2);
                    }
                }
                if (object3 != null && annexAnnotation != null) {
                    ((AnnexAnnotation)object3).endTime = annexAnnotation.endTime;
                    if (object2 != null) {
                        ((AnnexAnnotation)object2).endTime = ((AnnexAnnotation)object3).endTime;
                    }
                }
                hashMap2.put(chatBlock.tierNames[i], null);
            }
        }
        ArrayList arrayList2 = annexTranscription.getTiers();
        for (n5 = 0; n5 < arrayList2.size(); ++n5) {
            AnnexTier annexTier = (AnnexTier)arrayList2.get(n5);
            if (annexTier.name.indexOf(string8) < 0) continue;
            object3 = null;
            object2 = null;
            for (int i = 0; i < annexTier.annotations.size(); ++i) {
                object3 = (AnnexAnnotation)annexTier.annotations.get(i);
                if (object2 != null && ((AnnexAnnotation)object2).endTime > ((AnnexAnnotation)object3).beginTime) {
                    for (int j = 0; j < arrayList.size(); ++j) {
                        object = (ChatBlock)arrayList.get(j);
                        if (((AnnexAnnotation)object3).beginTime != ((ChatBlock)object).beginTime || ((AnnexAnnotation)object3).endTime != ((ChatBlock)object).endTime) continue;
                        String string11 = ((ChatBlock)object).tierNames[0] + string8;
                        if (string11.equals(annexTier.name)) {
                            ((AnnexAnnotation)object2).endTime = ((AnnexAnnotation)object3).beginTime;
                            AnnexChatParser.updateReferencesTo((AnnexAnnotation)object2, annexTranscription);
                            continue;
                        }
                        ((AnnexAnnotation)object3).beginTime = ((AnnexAnnotation)object2).endTime;
                        AnnexChatParser.updateReferencesTo((AnnexAnnotation)object3, annexTranscription);
                    }
                }
                object2 = object3;
            }
        }
        String[] stringArray6 = new String[]{"%act", "%sit", "%com"};
        arrayList2 = annexTranscription.getTiers();
        for (n5 = 0; n5 < stringArray6.length; ++n5) {
            Object object5;
            AnnexTier annexTier;
            object3 = new ArrayList();
            for (int i = 0; i < arrayList2.size(); ++i) {
                annexTier = (AnnexTier)arrayList2.get(i);
                if (annexTier.name.toLowerCase().indexOf(stringArray6[n5]) < 0) continue;
                ((ArrayList)object3).add(annexTier);
            }
            if (((ArrayList)object3).size() <= 0) continue;
            AnnexTier annexTier2 = new AnnexTier();
            annexTier2.name = stringArray6[n5] + string8;
            annexTier2.hasVirtualTime = true;
            annexTier2.annotations = new ArrayList();
            arrayList2.add(annexTier2);
            annexTier = new AnnexTier();
            annexTier.name = stringArray6[n5];
            annexTier.annotations = new ArrayList();
            annexTier.parentTier = annexTier2;
            arrayList2.add(annexTier);
            TreeSet treeSet = new TreeSet(new AnnotationTimeComparator());
            for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                object5 = (AnnexTier)((ArrayList)object3).get(i);
                treeSet.addAll(((AnnexTier)object5).annotations);
                arrayList2.remove(object5);
            }
            object = null;
            object5 = treeSet.iterator();
            while (object5.hasNext()) {
                AnnexAnnotation annexAnnotation = (AnnexAnnotation)object5.next();
                if (object != null && ((AnnexAnnotation)object).endTime > annexAnnotation.beginTime) {
                    annexAnnotation.beginTime = ((AnnexAnnotation)object).endTime;
                }
                AnnexAnnotation annexAnnotation2 = new AnnexAnnotation();
                annexAnnotation2.beginTime = annexAnnotation.beginTime;
                annexAnnotation2.endTime = annexAnnotation.endTime;
                annexAnnotation2.isTimeAligned = true;
                annexAnnotation2.value = "";
                annexAnnotation.refAnnotation = annexAnnotation2;
                annexTier2.annotations.add(annexAnnotation2);
                annexTier.annotations.add(annexAnnotation);
            }
        }
        for (n5 = 0; n5 < arrayList2.size(); ++n5) {
            object3 = (AnnexTier)arrayList2.get(n5);
            if (((AnnexTier)object3).name.toLowerCase().indexOf(string3) < 0) continue;
            arrayList2.remove(object3);
            break;
        }
        for (n5 = 0; n5 < arrayList2.size(); ++n5) {
            object3 = (AnnexTier)arrayList2.get(n5);
            if (((AnnexTier)object3).name.toLowerCase().indexOf(string3) < 0) continue;
            arrayList2.remove(object3);
            break;
        }
        for (n5 = 0; n5 < arrayList2.size(); ++n5) {
            object3 = (AnnexTier)arrayList2.get(n5);
            int n12 = ((AnnexTier)object3).name.lastIndexOf("%");
            if (n12 < 0) continue;
            ((AnnexTier)object3).type = ((AnnexTier)object3).name.substring(n12);
        }
    }

    private static void updateReferencesTo(AnnexAnnotation annexAnnotation, AnnexTranscription annexTranscription) {
        ArrayList<AnnexAnnotation> arrayList = new ArrayList<AnnexAnnotation>();
        ArrayList arrayList2 = annexTranscription.getTiers();
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n;
            AnnexTier annexTier = (AnnexTier)arrayList2.get(i);
            arrayList.clear();
            for (int j = 0; j < annexTier.annotations.size(); ++j) {
                AnnexAnnotation annexAnnotation2 = (AnnexAnnotation)annexTier.annotations.get(j);
                if (annexAnnotation2.refAnnotation != annexAnnotation) continue;
                arrayList.add(annexAnnotation2);
            }
            if (arrayList.size() <= 0) continue;
            AnnexAnnotation annexAnnotation3 = null;
            long l = (annexAnnotation.endTime - annexAnnotation.beginTime) / (long)arrayList.size();
            for (n = 0; n < arrayList.size(); ++n) {
                annexAnnotation3 = (AnnexAnnotation)arrayList.get(n);
                annexAnnotation3.beginTime = annexAnnotation.beginTime + (long)n * l;
                annexAnnotation3.endTime = annexAnnotation3.beginTime + l;
            }
            annexAnnotation3.endTime = annexAnnotation.endTime;
            for (n = 0; n < arrayList.size(); ++n) {
                annexAnnotation3 = (AnnexAnnotation)arrayList.get(n);
                AnnexChatParser.updateReferencesTo(annexAnnotation3, annexTranscription);
            }
        }
    }

    private static class AnnotationTimeComparator
    implements Comparator {
        private AnnotationTimeComparator() {
        }

        public int compare(Object object, Object object2) {
            AnnexAnnotation annexAnnotation = (AnnexAnnotation)object;
            AnnexAnnotation annexAnnotation2 = (AnnexAnnotation)object2;
            if (annexAnnotation.beginTime - annexAnnotation2.beginTime < 0L) {
                return -1;
            }
            if (annexAnnotation.beginTime - annexAnnotation2.beginTime > 0L) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }
    }

    private static class ChatBlock {
        public String[] tierNames;
        public String[] annotationValues;
        public long beginTime;
        public long endTime;

        private ChatBlock() {
        }
    }
}

