/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexMediaDescriptor;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.util.MimeType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AnnexEAFHandler
extends DefaultHandler {
    private ArrayList tiers;
    private AnnexTier tier;
    private AnnexAnnotation annotation;
    private HashMap timeSlots;
    private HashMap beginTimeHash;
    private HashMap endTimeHash;
    private HashMap refHash;
    private HashMap prevHash;
    private HashMap annToId;
    private HashMap idToAnn;
    private String id;
    private StringBuffer textBuffer;
    private boolean isAnnotationValue;
    private String beginTimeRef;
    private String endTimeRef;
    private long maxTime;
    private ArrayList mediaDescriptors;
    private HashMap parentHash;
    private HashMap refererHash;

    public AnnexEAFHandler(AnnexTranscription annexTranscription) {
        this.tiers = annexTranscription.getTiers();
        this.mediaDescriptors = annexTranscription.getMediaDescriptors();
        this.timeSlots = new HashMap();
        this.beginTimeHash = new HashMap();
        this.endTimeHash = new HashMap();
        this.refHash = new HashMap();
        this.prevHash = new HashMap();
        this.annToId = new HashMap();
        this.idToAnn = new HashMap();
        this.maxTime = -1L;
        this.parentHash = new HashMap();
        this.refererHash = new HashMap();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.isAnnotationValue = false;
        if (string3.equals("TIER")) {
            this.tier = new AnnexTier();
            this.tiers.add(this.tier);
            this.tier.name = attributes.getValue("TIER_ID");
            this.tier.defaultLocale = attributes.getValue("DEFAULT_LOCALE");
            this.tier.type = attributes.getValue("LINGUISTIC_TYPE_REF");
            this.parentHash.put(this.tier.name, attributes.getValue("PARENT_REF"));
            this.tier.participant = attributes.getValue("PARTICIPANT");
            this.tier.annotations = new ArrayList();
        } else if (string3.equals("ANNOTATION_VALUE")) {
            this.isAnnotationValue = true;
            this.textBuffer = new StringBuffer();
        } else if (string3.equals("ALIGNABLE_ANNOTATION")) {
            this.annotation = new AnnexAnnotation();
            this.tier.annotations.add(this.annotation);
            this.annotation.isTimeAligned = true;
            this.annotation.id = this.id = attributes.getValue("ANNOTATION_ID");
            this.beginTimeRef = attributes.getValue("TIME_SLOT_REF1");
            if (this.timeSlots.get(this.beginTimeRef) == null) {
                this.annotation.isTimeAligned = false;
            }
            this.endTimeRef = attributes.getValue("TIME_SLOT_REF2");
            if (this.timeSlots.get(this.endTimeRef) == null) {
                this.annotation.isTimeAligned = false;
            }
            this.beginTimeHash.put(this.id, this.beginTimeRef);
            this.endTimeHash.put(this.id, this.endTimeRef);
            this.refHash.put(this.id, null);
            this.annToId.put(this.annotation, this.id);
            this.idToAnn.put(this.id, this.annotation);
        } else if (string3.equals("REF_ANNOTATION")) {
            ArrayList arrayList;
            this.annotation = new AnnexAnnotation();
            this.tier.annotations.add(this.annotation);
            this.annotation.isTimeAligned = false;
            this.id = attributes.getValue("ANNOTATION_ID");
            String string4 = attributes.getValue("ANNOTATION_REF");
            this.refHash.put(this.id, string4);
            if (!this.refererHash.containsKey(string4)) {
                arrayList = new ArrayList();
                this.refererHash.put(string4, arrayList);
            }
            arrayList = (ArrayList)this.refererHash.get(string4);
            arrayList.add(this.id);
            String string5 = attributes.getValue("PREVIOUS_ANNOTATION");
            if (string5 != null) {
                this.prevHash.put(this.id, string5);
            }
            this.annToId.put(this.annotation, this.id);
            this.idToAnn.put(this.id, this.annotation);
        } else if (string3.equals("TIME_SLOT")) {
            Long l;
            String string6 = attributes.getValue("TIME_SLOT_ID");
            String string7 = attributes.getValue("TIME_VALUE");
            try {
                l = new Long(string7);
                if (l > this.maxTime) {
                    this.maxTime = l;
                }
            }
            catch (Exception exception) {
                l = null;
            }
            this.timeSlots.put(string6, l);
        } else if (string3.equals("HEADER")) {
            String string8 = attributes.getValue("MEDIA_FILE");
            if (string8 != null && string8.length() > 1) {
                int n;
                int n2 = string8.lastIndexOf(47);
                int n3 = n2 > (n = string8.lastIndexOf(92)) ? n2 : n;
                string8 = string8.substring(n3 + 1);
                AnnexMediaDescriptor annexMediaDescriptor = new AnnexMediaDescriptor();
                annexMediaDescriptor.fileName = string8;
                annexMediaDescriptor.mimeType = MimeType.getMimeTypeStringFromExtension((String)string8);
                this.mediaDescriptors.add(annexMediaDescriptor);
                if (annexMediaDescriptor.mimeType.indexOf("audio") < 0) {
                    n3 = string8.lastIndexOf(46);
                    String string9 = string8.subSequence(0, n3 + 1) + "wav";
                    annexMediaDescriptor = new AnnexMediaDescriptor();
                    annexMediaDescriptor.fileName = string9;
                    annexMediaDescriptor.extractedFrom = string8;
                    annexMediaDescriptor.mimeType = MimeType.getMimeTypeStringFromExtension((String)string9);
                    this.mediaDescriptors.add(annexMediaDescriptor);
                }
            }
        } else if (string3.equals("MEDIA_DESCRIPTOR")) {
            String string10 = attributes.getValue("MEDIA_URL");
            String string11 = attributes.getValue("EXTRACTED_FROM");
            String string12 = attributes.getValue("TIME_ORIGIN");
            if (string10 != null) {
                int n;
                AnnexMediaDescriptor annexMediaDescriptor = new AnnexMediaDescriptor();
                int n4 = string10.lastIndexOf(47);
                int n5 = n4 > (n = string10.lastIndexOf(92)) ? n4 : n;
                annexMediaDescriptor.fileName = string10 = string10.substring(n5 + 1);
                annexMediaDescriptor.mimeType = MimeType.getMimeTypeStringFromExtension((String)string10);
                if (string11 != null) {
                    n4 = string11.lastIndexOf(47);
                    n5 = n4 > (n = string11.lastIndexOf(92)) ? n4 : n;
                    annexMediaDescriptor.extractedFrom = string11 = string11.substring(n5 + 1);
                }
                if (string12 != null) {
                    annexMediaDescriptor.offset = Long.parseLong(string12);
                }
                this.mediaDescriptors.add(annexMediaDescriptor);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("ANNOTATION_VALUE")) {
            this.annotation.value = this.textBuffer.toString();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isAnnotationValue) {
            this.textBuffer.append(cArray, n, n2);
        }
    }

    public void endDocument() throws SAXException {
        Serializable serializable;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block0: for (int i = 0; i < this.tiers.size(); ++i) {
            Object object2;
            AnnexAnnotation annexAnnotation;
            int n;
            object = (AnnexTier)this.tiers.get(i);
            serializable = ((AnnexTier)object).annotations;
            arrayList.clear();
            boolean bl = true;
            for (n = 0; n < ((ArrayList)serializable).size(); ++n) {
                annexAnnotation = (AnnexAnnotation)((ArrayList)serializable).get(n);
                String string = this.getAlignedAnnotationID(annexAnnotation);
                object2 = (String)this.beginTimeHash.get(string);
                arrayList.add(object2);
                if (this.timeSlots.get(object2) == null) {
                    bl = false;
                }
                object2 = (String)this.endTimeHash.get(string);
                arrayList.add(object2);
                if (this.timeSlots.get(object2) != null) continue;
                bl = false;
            }
            if (!bl) {
                long l = 0L;
                for (int j = 0; j < arrayList.size(); ++j) {
                    object2 = (Long)this.timeSlots.get(arrayList.get(j));
                    if (object2 == null) {
                        int n2 = 0;
                        Long l2 = null;
                        for (int k = j + 1; k < arrayList.size(); ++k) {
                            ++n2;
                            l2 = (Long)this.timeSlots.get(arrayList.get(k));
                            if (l2 != null) break;
                        }
                        if (l2 == null) {
                            l2 = new Long(this.maxTime);
                        }
                        long l3 = (l2 - l) / (long)n2;
                        this.timeSlots.put(arrayList.get(j), new Long(l += l3));
                        continue;
                    }
                    l = (Long)object2;
                }
            }
            for (n = 0; n < ((ArrayList)serializable).size(); ++n) {
                annexAnnotation = (AnnexAnnotation)((ArrayList)serializable).get(n);
                String string = this.getAlignedAnnotationID(annexAnnotation);
                object2 = (String)this.beginTimeHash.get(string);
                annexAnnotation.beginTime = (Long)this.timeSlots.get(object2);
                object2 = (String)this.endTimeHash.get(string);
                annexAnnotation.endTime = (Long)this.timeSlots.get(object2);
                string = (String)this.annToId.get(annexAnnotation);
                String string2 = (String)this.refHash.get(string);
                annexAnnotation.refAnnotation = (AnnexAnnotation)this.idToAnn.get(string2);
            }
            String string = (String)this.parentHash.get(((AnnexTier)object).name);
            for (int j = 0; j < this.tiers.size(); ++j) {
                AnnexTier annexTier = (AnnexTier)this.tiers.get(j);
                if (!annexTier.name.equals(string)) continue;
                ((AnnexTier)object).parentTier = annexTier;
                continue block0;
            }
        }
        Iterator iterator = this.refererHash.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            serializable = (AnnexAnnotation)this.idToAnn.get(object);
            ArrayList arrayList2 = (ArrayList)this.refererHash.get(object);
            if (!((AnnexAnnotation)serializable).isTimeAligned || arrayList2 == null || arrayList2.size() <= 0) continue;
            this.alignReferersFor((String)object, this.refererHash);
        }
    }

    private void alignReferersFor(String string, HashMap hashMap) {
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        AnnexAnnotation annexAnnotation = (AnnexAnnotation)this.idToAnn.get(string);
        long l = annexAnnotation.endTime - annexAnnotation.beginTime;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            if (this.prevHash.get(arrayList.get(i)) != null) continue;
            for (n = i + 1; n < arrayList.size() && this.prevHash.get(arrayList.get(n)) != null; ++n) {
            }
            long l2 = l / (long)(n - i);
            for (int j = i; j < n; ++j) {
                AnnexAnnotation annexAnnotation2 = (AnnexAnnotation)this.idToAnn.get(arrayList.get(j));
                annexAnnotation2.beginTime = annexAnnotation.beginTime + (long)(j - i) * l2;
                annexAnnotation2.endTime = annexAnnotation2.beginTime + l2;
            }
            AnnexAnnotation annexAnnotation3 = (AnnexAnnotation)this.idToAnn.get(arrayList.get(n - 1));
            annexAnnotation3.endTime = annexAnnotation.endTime;
            for (int j = i; j < n; ++j) {
                ArrayList arrayList2 = (ArrayList)hashMap.get(arrayList.get(j));
                if (arrayList2 == null || arrayList2.size() <= 0) continue;
                this.alignReferersFor((String)arrayList.get(j), hashMap);
            }
            i = n;
        }
    }

    private String getAlignedAnnotationID(AnnexAnnotation annexAnnotation) {
        String string = (String)this.annToId.get(annexAnnotation);
        while (this.refHash.get(string) != null) {
            string = (String)this.refHash.get(string);
        }
        return string;
    }
}

