/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexChatParser;
import mpi.annex.data.AnnexEAFHandler;
import mpi.annex.data.AnnexMediaDescriptor;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.data.DataUtil;
import mpi.annex.data.ShoeboxParser;
import mpi.util.MimeType;
import mpi.util.OurURL;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class AnnexParser {
    public static final int UNKNOWN_TYPE = -1;
    public static final int EAF_TYPE = 0;
    public static final int CHAT_TYPE = 1;
    public static final int SHOEBOX_TYPE = 2;
    public static final int TEXT_PLAIN_TYPE = 3;
    public static final int TEXT_HTML_TYPE = 4;
    public static final int TEXT_XML_TYPE = 5;
    public static File typFile;

    public static void setTypFile(File file) {
        typFile = file;
    }

    public static boolean parse(File file, int n, AnnexTranscription annexTranscription) {
        boolean bl = true;
        try {
            switch (n) {
                case 0: {
                    AnnexParser.parseEAF(file, annexTranscription);
                    break;
                }
                case 1: {
                    AnnexParser.parseChat(file, annexTranscription);
                    break;
                }
                case 2: {
                    AnnexParser.parseShoebox(file, annexTranscription);
                    bl = true;
                    break;
                }
                case 3: {
                    AnnexParser.parseText(file, annexTranscription);
                    break;
                }
                case 5: {
                    AnnexParser.parseText(file, annexTranscription);
                    break;
                }
                case 4: {
                    AnnexParser.parseHTML(file, annexTranscription);
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("\nProblem in: " + file.getAbsolutePath());
            System.out.println(exception.toString());
        }
        return bl;
    }

    private static void parseEAF(File file, AnnexTranscription annexTranscription) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        AnnexEAFHandler annexEAFHandler = new AnnexEAFHandler(annexTranscription);
        sAXParser.parse(file, (DefaultHandler)annexEAFHandler);
        if (annexTranscription.getMediaDescriptors().size() == 0) {
            String string = file.getName();
            string = string.substring(0, string.length() - 3);
            AnnexMediaDescriptor annexMediaDescriptor = new AnnexMediaDescriptor();
            annexMediaDescriptor.fileName = string + "mpg";
            annexMediaDescriptor.mimeType = MimeType.getMimeTypeStringFromExtension((String)annexMediaDescriptor.fileName);
            annexTranscription.getMediaDescriptors().add(annexMediaDescriptor);
            annexMediaDescriptor = new AnnexMediaDescriptor();
            annexMediaDescriptor.fileName = string + "wav";
            annexMediaDescriptor.mimeType = MimeType.getMimeTypeStringFromExtension((String)annexMediaDescriptor.fileName);
            annexMediaDescriptor.extractedFrom = string + "mpg";
            annexTranscription.getMediaDescriptors().add(annexMediaDescriptor);
        }
    }

    public static void parseChat(File file, AnnexTranscription annexTranscription) throws Exception {
        AnnexChatParser.parse(file, annexTranscription);
    }

    public static void parseShoebox(File file, AnnexTranscription annexTranscription) throws Exception {
        if (typFile != null) {
            new ShoeboxParser(file, typFile).parse(annexTranscription);
        } else {
            new ShoeboxParser(file).parse(annexTranscription);
        }
    }

    public static void parseText(File file, AnnexTranscription annexTranscription) throws Exception {
        String[] stringArray = DataUtil.readLines(file, null);
        AnnexParser.parseTextLines(stringArray, annexTranscription);
    }

    public static void parseHTML(File file, AnnexTranscription annexTranscription) throws Exception {
        String[] stringArray = DataUtil.readLines(file, null);
        String[] stringArray2 = AnnexParser.filterHTML(stringArray);
        AnnexParser.parseTextLines(stringArray2, annexTranscription);
    }

    public static String[] filterHTML(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().indexOf("/body") >= 0) {
                arrayList.add(stringArray[i]);
                break;
            }
            if (stringArray[i].toLowerCase().indexOf("body") >= 0) {
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(stringArray[i]);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = false;
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (c == '<') {
                    bl2 = true;
                }
                if (!bl2) {
                    stringBuffer.append(c);
                }
                if (c != '>') continue;
                bl2 = false;
            }
            if (stringBuffer.length() <= 0) continue;
            arrayList2.add(stringBuffer.toString());
        }
        String[] stringArray2 = new String[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            stringArray2[i] = (String)arrayList2.get(i);
        }
        return stringArray2;
    }

    public static void parseTextLines(String[] stringArray, AnnexTranscription annexTranscription) throws Exception {
        AnnexTier annexTier = new AnnexTier();
        annexTier.name = "text";
        annexTier.type = "text";
        annexTier.hasVirtualTime = true;
        annexTier.annotations = new ArrayList();
        long l = 0L;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            if (string.length() <= 0) continue;
            String[] stringArray2 = string.split("\\s+");
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = stringArray2[j].replaceAll("\\!|\\.|\\,|\\;|\\?", "");
                if ((string2 = string2.replaceAll("!", "")).length() <= 0) continue;
                AnnexAnnotation annexAnnotation = new AnnexAnnotation();
                annexAnnotation.value = string2;
                annexAnnotation.isTimeAligned = false;
                annexAnnotation.beginTime = l;
                annexAnnotation.endTime = annexAnnotation.beginTime + 1000L;
                annexTier.annotations.add(annexAnnotation);
                l = annexAnnotation.endTime;
            }
        }
        annexTranscription.getTiers().add(annexTier);
    }

    public static boolean parse(OurURL ourURL, int n, AnnexTranscription annexTranscription) {
        boolean bl = true;
        try {
            InputSource inputSource = null;
            inputSource = new InputSource(ourURL.openStream());
            String string = ourURL.toString();
            int n2 = string.lastIndexOf("/");
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            inputSource.setSystemId(string + "/");
            switch (n) {
                case 0: {
                    AnnexParser.parseEAF(inputSource, annexTranscription);
                    break;
                }
                case 1: {
                    AnnexParser.parseChat(ourURL, annexTranscription);
                    break;
                }
                case 3: {
                    AnnexParser.parseText(inputSource, annexTranscription);
                    break;
                }
                case 5: {
                    AnnexParser.parseText(inputSource, annexTranscription);
                    break;
                }
                case 4: {
                    AnnexParser.parseHTML(inputSource, annexTranscription);
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        return bl;
    }

    private static void parseEAF(InputSource inputSource, AnnexTranscription annexTranscription) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        AnnexEAFHandler annexEAFHandler = new AnnexEAFHandler(annexTranscription);
        sAXParser.parse(inputSource, (DefaultHandler)annexEAFHandler);
    }

    public static void parseChat(OurURL ourURL, AnnexTranscription annexTranscription) throws Exception {
        AnnexChatParser.parse(ourURL, annexTranscription);
    }

    public static void parseHTML(InputSource inputSource, AnnexTranscription annexTranscription) throws Exception {
        String[] stringArray = DataUtil.readLines(inputSource, null);
        String[] stringArray2 = AnnexParser.filterHTML(stringArray);
        AnnexParser.parseTextLines(stringArray2, annexTranscription);
    }

    public static void parseText(InputSource inputSource, AnnexTranscription annexTranscription) throws Exception {
        String[] stringArray = DataUtil.readLines(inputSource, null);
        AnnexParser.parseTextLines(stringArray, annexTranscription);
    }
}

