/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import mpi.annex.data.AnnexMediaDescriptor;
import mpi.annex.data.AnnexParser;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.DataUtil;
import mpi.annex.util.AnnexUtil;
import mpi.util.OurURL;

public class AnnexTranscription
implements Serializable {
    private String nodeId;
    private boolean valid;
    private boolean hasVirtualTime;
    private ArrayList mediaDescriptors;
    private ArrayList tiers;
    private int type;
    private String info;

    public AnnexTranscription(String string, int n, File file) {
        this.nodeId = string;
        this.type = n;
        this.mediaDescriptors = new ArrayList();
        this.tiers = new ArrayList();
        this.valid = AnnexParser.parse(file, n, this);
        this.hasVirtualTime = false;
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier annexTier = (AnnexTier)this.tiers.get(i);
            if (!annexTier.hasVirtualTime) continue;
            this.hasVirtualTime = true;
            break;
        }
    }

    public AnnexTranscription(String string, int n, OurURL ourURL) {
        this.nodeId = string;
        this.type = n;
        this.mediaDescriptors = new ArrayList();
        this.tiers = new ArrayList();
        this.valid = AnnexParser.parse(ourURL, n, this);
        this.hasVirtualTime = false;
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier annexTier = (AnnexTier)this.tiers.get(i);
            if (!annexTier.hasVirtualTime) continue;
            this.hasVirtualTime = true;
            break;
        }
    }

    public AnnexTranscription(String string, File file, File file2) {
        this.nodeId = string;
        this.type = this.type;
        this.mediaDescriptors = new ArrayList();
        this.tiers = new ArrayList();
        AnnexParser.setTypFile(file2);
        this.valid = AnnexParser.parse(file, 2, this);
        this.hasVirtualTime = false;
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier annexTier = (AnnexTier)this.tiers.get(i);
            if (!annexTier.hasVirtualTime) continue;
            this.hasVirtualTime = true;
            break;
        }
    }

    public AnnexTranscription(String string, File file) {
        this.nodeId = string;
        this.mediaDescriptors = new ArrayList();
        this.tiers = new ArrayList();
        this.type = string != null ? AnnexUtil.getTypeFor(string) : DataUtil.getAnnotationType(file);
        this.valid = AnnexParser.parse(file, this.type, this);
        this.hasVirtualTime = false;
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier annexTier = (AnnexTier)this.tiers.get(i);
            if (!annexTier.hasVirtualTime) continue;
            this.hasVirtualTime = true;
            break;
        }
    }

    public AnnexTranscription(String string, OurURL ourURL) {
        this.nodeId = string;
        this.mediaDescriptors = new ArrayList();
        this.tiers = new ArrayList();
        if (string != null) {
            this.type = AnnexUtil.getTypeFor(string);
        }
        this.valid = AnnexParser.parse(ourURL, this.type, this);
        this.hasVirtualTime = false;
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier annexTier = (AnnexTier)this.tiers.get(i);
            if (!annexTier.hasVirtualTime) continue;
            this.hasVirtualTime = true;
            break;
        }
    }

    public boolean hasVirtualTime() {
        return this.hasVirtualTime;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getType() {
        return this.type;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public ArrayList getMediaDescriptors() {
        return this.mediaDescriptors;
    }

    public ArrayList getTiers() {
        return this.tiers;
    }

    public ArrayList getRealTiers() {
        ArrayList<AnnexTier> arrayList = new ArrayList<AnnexTier>();
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier annexTier = (AnnexTier)this.tiers.get(i);
            if (annexTier.hasVirtualTime) continue;
            arrayList.add(annexTier);
        }
        return arrayList;
    }

    public ArrayList getVirtualTiers() {
        ArrayList<AnnexTier> arrayList = new ArrayList<AnnexTier>();
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier annexTier = (AnnexTier)this.tiers.get(i);
            if (!annexTier.hasVirtualTime) continue;
            arrayList.add(annexTier);
        }
        return arrayList;
    }

    public AnnexMediaDescriptor getMasterMedia() {
        if (this.mediaDescriptors.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.mediaDescriptors.size(); ++i) {
            AnnexMediaDescriptor annexMediaDescriptor = (AnnexMediaDescriptor)this.mediaDescriptors.get(i);
            String string = annexMediaDescriptor.fileName;
        }
        return (AnnexMediaDescriptor)this.mediaDescriptors.get(0);
    }

    public ArrayList getAllMasterMedia() {
        if (this.mediaDescriptors.size() == 0) {
            return null;
        }
        return this.mediaDescriptors;
    }

    public AnnexMediaDescriptor getMasterAudio() {
        AnnexMediaDescriptor annexMediaDescriptor = this.getMasterMedia();
        if (annexMediaDescriptor == null || annexMediaDescriptor.mimeType.indexOf("audio") >= 0) {
            return annexMediaDescriptor;
        }
        for (int i = 1; i < this.mediaDescriptors.size(); ++i) {
            AnnexMediaDescriptor annexMediaDescriptor2 = (AnnexMediaDescriptor)this.mediaDescriptors.get(i);
            if (annexMediaDescriptor2.extractedFrom == null || !annexMediaDescriptor2.extractedFrom.equals(annexMediaDescriptor.fileName)) continue;
            return annexMediaDescriptor2;
        }
        return null;
    }
}

