/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mpi.annex.data.CountHash;
import mpi.annex.data.FlexEncReader;
import mpi.annex.data.UTF8Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexEncReader
extends Reader {
    public static final int BUFFER_SIZE = 100;
    public static final int SUBBUFFER_SIZE = 1000;
    public static final boolean DEBUG = false;
    public static final byte SPACE_CHAR = 32;
    public static final byte BACKSLASH_CHAR = 92;
    public static final byte LF_CHAR = 10;
    public static final byte CR_CHAR = 13;
    private byte[] buffer;
    private int position;
    private int bytesInBuffer;
    private InputStream in;
    private String currentCharset;
    private Hashtable<String, String> encodings;
    private boolean windowsLineDelim;
    private JTextArea textAreaGUI;

    public FlexEncReader(InputStream inputStream, Hashtable<String, String> hashtable) {
        this.in = inputStream;
        this.encodings = hashtable;
        if (this.encodings == null) {
            this.encodings = new Hashtable();
        }
        this.buffer = new byte[100];
        this.currentCharset = "ISO-8859-1";
        this.windowsLineDelim = false;
    }

    public FlexEncReader(File file) throws FileNotFoundException {
        this.in = new FileInputStream(file);
        this.buffer = new byte[100];
        try {
            this.encodings = this.guessUTF8();
            this.in.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.position = 0;
        this.bytesInBuffer = 0;
        this.in = new FileInputStream(file);
        this.currentCharset = "ISO-8859-1";
        this.windowsLineDelim = false;
    }

    private byte nextByte() throws EOFException, IOException {
        if (this.position == this.bytesInBuffer) {
            this.bytesInBuffer = this.in.read(this.buffer);
            this.position = 0;
        }
        if (this.bytesInBuffer > 0) {
            return this.buffer[this.position++];
        }
        throw new EOFException(this, null);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        throw new RuntimeException("not implemented. use readLine");
    }

    public String readTagOrContent(String string) throws EOFException, IOException {
        byte[] byArray = new byte[1000];
        int n = 0;
        boolean bl = false;
        byArray[0] = this.nextByte();
        if (byArray[0] == 92) {
            bl = true;
        } else if (byArray[0] == 10 || byArray[0] == 13) {
            return new String(byArray, 0, 1, string);
        }
        do {
            if (++n >= 1000) {
                throw new RuntimeException("this implementation supports lines of max length 1000");
            }
            byArray[n] = this.nextByte();
        } while ((!bl || byArray[n] != 32) && byArray[n] != 10 && byArray[n] != 13);
        String string2 = null;
        string2 = bl ? new String(byArray, 0, n + 1, "ISO-8859-1") : new String(byArray, 0, n + 1, string);
        return string2;
    }

    public int readTagOrContent(byte[] byArray) throws EOFException, IOException {
        int n = 0;
        boolean bl = false;
        byArray[0] = this.nextByte();
        if (byArray[0] == 92) {
            bl = true;
        } else if (byArray[0] == 10 || byArray[0] == 13) {
            return 1;
        }
        do {
            if (++n >= 1000) {
                throw new RuntimeException("this implementation supports lines of max length 1000");
            }
            byArray[n] = this.nextByte();
        } while ((!bl || byArray[n] != 32) && byArray[n] != 10 && byArray[n] != 13);
        return n;
    }

    public String readLine() throws IOException {
        String string = null;
        try {
            string = this.readTagOrContent(this.currentCharset);
        }
        catch (EOFException eOFException) {
            return null;
        }
        if (string.startsWith("\\")) {
            this.currentCharset = this.encodings.get(string.substring(1, string.length() - 1));
            if (this.currentCharset == null) {
                this.currentCharset = "ISO-8859-1";
            }
            if (string.charAt(string.length() - 1) != '\n') {
                try {
                    string = string + this.readTagOrContent(this.currentCharset);
                }
                catch (EOFException eOFException) {
                    return string;
                }
            }
        }
        if (string.equals("\n") && this.windowsLineDelim) {
            this.windowsLineDelim = false;
            return this.readLine();
        }
        this.windowsLineDelim = string.endsWith("\r");
        return string.substring(0, string.length() - 1);
    }

    public Hashtable<String, String> guessUTF8() throws IOException {
        System.out.println("Guessing encodings of Shoebox tiers");
        CountHash<String> countHash = new CountHash<String>();
        CountHash<String> countHash2 = new CountHash<String>();
        Vector<String> vector = new Vector<String>();
        byte[] byArray = new byte[1000];
        int n = 0;
        String string = "";
        try {
            while (true) {
                n = this.readTagOrContent(byArray);
                if (byArray[0] == 92) {
                    string = new String(byArray, 1, n - 1, "ISO-8859-1");
                    continue;
                }
                int n2 = UTF8Validator.validateUTF8(byArray, n, false);
                vector.add(string);
                if (n2 == -1) {
                    countHash2.put(string, 1);
                    continue;
                }
                countHash.put(string, n2);
            }
        }
        catch (EOFException eOFException) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (String string2 : vector) {
                if (countHash2.getCount(string2) != 0 || countHash.getCount(string2) <= 0) continue;
                hashtable.put(string2, "UTF-8");
            }
            System.out.println("multibytes: " + countHash + ", errors: " + countHash2 + ", conclusion: " + hashtable);
            return hashtable;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public void buildGUI() {
        JFrame jFrame = new JFrame();
        this.textAreaGUI = new JTextArea();
        this.textAreaGUI.setFont(new Font("Arial Unicode MS", 0, 12));
        jFrame.getContentPane().add(new JScrollPane(this.textAreaGUI));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private void test() {
        this.buildGUI();
        try {
            String string = null;
            while ((string = this.readLine()) != null) {
                System.out.println("[LINE] " + string);
                this.textAreaGUI.append(string + "\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("iso", "ISO-8859-1");
        hashtable.put("uni", "UTF-8");
        try {
            FlexEncReader flexEncReader = new FlexEncReader(new FileInputStream(stringArray[0]), hashtable);
            flexEncReader.test();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }
}

