/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.TreeMap;
import java.util.Vector;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.data.FlexEncReader;
import mpi.annex.data.ShoeboxRecord;
import mpi.annex.data.ShoeboxTiers;
import mpi.annex.data.TierType;

public class ShoeboxParser {
    public String REF_TAG = "ref";
    private ShoeboxTiers tiers;
    private File file;
    private boolean knownTiers;

    public ShoeboxParser(File file) {
        this.file = file;
        this.tiers = new ShoeboxTiers();
        this.knownTiers = false;
        this.guessRefTag();
    }

    public ShoeboxParser(File file, File file2) {
        this.knownTiers = true;
        this.file = file;
        if (file2.getName().endsWith(".mkr")) {
            this.readMarkerFile(file2);
        } else {
            this.readMetaFiles(file2, null);
        }
    }

    public void readMarkerFile(File file) {
        System.out.println("Reading marker file " + file);
        this.tiers = new ShoeboxTiers();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("marker:")) {
                    string2 = string.substring(7, string.length()).trim();
                    continue;
                }
                if (string.startsWith("parent:")) {
                    string5 = string.substring(7, string.length()).trim();
                    continue;
                }
                if (string.startsWith("stereotype:")) {
                    string4 = string.substring(11, string.length()).trim();
                    continue;
                }
                if (!string.startsWith("charset:")) continue;
                string3 = string.substring(8, string.length()).trim();
                if ("null".equals(string5)) {
                    this.REF_TAG = string2;
                    this.tiers.put("ref", TierType.REF);
                    continue;
                }
                TierType tierType = TierType.UNKNOWN;
                if ("Symbolic Subdivision".equals(string4)) {
                    tierType = TierType.ALIGNED;
                } else if ("Time".equals(string4)) {
                    tierType = TierType.TIME;
                }
                if ("UTF-8".equals(string3)) {
                    this.tiers.put(string2, tierType, "UTF-8");
                } else {
                    this.tiers.put(string2, tierType);
                }
                this.tiers.setParent(string2, string5);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("typ file tier structure: " + this.tiers);
    }

    public void readMetaFiles(File file, File file2) {
        System.out.println("Reading typ file " + file);
        this.tiers = new ShoeboxTiers();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("\\mkrRecord ")) {
                    this.REF_TAG = string.substring(11, string.length()).trim();
                    this.tiers.put("ref", TierType.REF);
                }
                if (string.startsWith("\\+mkr ")) {
                    string2 = string.substring(6, string.length()).trim();
                    this.tiers.put(string2, TierType.UNKNOWN);
                    continue;
                }
                if (!string.startsWith("\\mkrOverThis ") || string2 == null) continue;
                String string3 = string.substring(13, string.length()).trim();
                this.tiers.setParent(string2, string3);
                string2 = null;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("typ file tier structure: " + this.tiers);
    }

    private void guessRefTag() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            String string = null;
            int n = 0;
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("\\ref ")) {
                    ++n2;
                }
                if (!string.startsWith("\\r ")) continue;
                ++n;
            }
            bufferedReader.close();
            if (n2 > 0) {
                this.REF_TAG = "ref";
            }
            if (n2 == 0 && n > 0) {
                this.REF_TAG = "r";
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Assuming record marker " + this.REF_TAG);
    }

    public void parse(AnnexTranscription annexTranscription) throws Exception {
        System.out.println("ShoeboxParser.parse: " + this.file.getPath());
        try {
            FlexEncReader flexEncReader = null;
            flexEncReader = this.knownTiers ? new FlexEncReader(new FileInputStream(this.file), this.tiers.getEncodingHash()) : new FlexEncReader(this.file);
            ShoeboxRecord shoeboxRecord = null;
            ShoeboxRecord shoeboxRecord2 = null;
            boolean bl = false;
            int n = 0;
            String string = null;
            while ((string = flexEncReader.readLine()) != null) {
                if (string.length() == 0) continue;
                if (this.REF_TAG.equals(ShoeboxRecord.getTierTag(string))) {
                    if (shoeboxRecord2 != null) {
                        shoeboxRecord2.provideAlternativeTime(shoeboxRecord, n++);
                        this.createTranscription(shoeboxRecord2, annexTranscription);
                    }
                    shoeboxRecord2 = shoeboxRecord;
                    shoeboxRecord = new ShoeboxRecord(string, this.tiers, this.knownTiers);
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                shoeboxRecord.put(string);
            }
            if (shoeboxRecord2 != null) {
                shoeboxRecord2.provideAlternativeTime(shoeboxRecord, n++);
                this.createTranscription(shoeboxRecord2, annexTranscription);
            }
            if (shoeboxRecord != null) {
                shoeboxRecord.provideAlternativeTime(null, n++);
                this.createTranscription(shoeboxRecord, annexTranscription);
            }
            flexEncReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        System.out.println("ShoeboxParser.parse: creating associations");
        this.createTierAssociations(annexTranscription);
        System.out.println("ShoeboxParser.parse finished\n");
    }

    public void tokenizeTier(AnnexTier annexTier, String string, int n, long l, long l2) {
        TreeMap treeMap = new TreeMap();
        int n2 = 0;
        int n3 = 0;
        while (string.length() > 0) {
            String string2 = null;
            int n4 = string.indexOf(" ");
            if (n4 == -1) {
                string2 = string;
                string = "";
                n3 = n2;
                n2 = n;
            } else {
                n3 = n2;
                string2 = string.substring(0, n4);
                n2 += string2.length();
                string = string.substring(n4);
                while (string.length() > 0 && string.charAt(0) == ' ') {
                    string = string.substring(1);
                    ++n2;
                }
            }
            AnnexAnnotation annexAnnotation = new AnnexAnnotation(string2, this.getAlignTime(n3, n, l, l2), this.getAlignTime(n2, n, l, l2), true);
            annexTier.addAnnotation(annexAnnotation);
        }
    }

    private void createTranscription(ShoeboxRecord shoeboxRecord, AnnexTranscription annexTranscription) {
        for (String string : shoeboxRecord.tags()) {
            if (shoeboxRecord.getContent(string) == null) continue;
            switch (shoeboxRecord.getTierType(string)) {
                case TIME: {
                    break;
                }
                case ALIGNED: {
                    this.tokenizeTier(this.getOrCreateTier(annexTranscription, string), shoeboxRecord.getContent(string), shoeboxRecord.getLongestAlignedTier(), shoeboxRecord.getStartTime(), shoeboxRecord.getEndTime());
                    break;
                }
                case UNKNOWN: 
                case BLOCK: 
                case REF: {
                    this.getOrCreateTier(annexTranscription, string).addAnnotation(new AnnexAnnotation(shoeboxRecord.getContent(string), shoeboxRecord.getStartTime(), shoeboxRecord.getEndTime(), true));
                }
            }
        }
    }

    private void createTierAssociations(AnnexTranscription annexTranscription) {
        System.out.println("createTierAssociations: ");
        for (String string : this.tiers.names(false)) {
            AnnexTier annexTier;
            System.out.println("Creating tier structure: " + string + "<" + this.tiers.getParent(string));
            AnnexTier annexTier2 = null;
            try {
                annexTier2 = this.getTier(annexTranscription, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Warning (createTierAssociations): tier not found: " + string);
                continue;
            }
            if (this.tiers.getParent(string) == null) {
                annexTier2.parentTier = null;
                continue;
            }
            annexTier2.parentTier = annexTier = this.getTier(annexTranscription, this.tiers.getParent(string));
            if (this.tiers.getType(string) != TierType.ALIGNED) continue;
            System.out.println("...aligning element wise");
            annexTier2.type = "ALIGNED";
            for (int i = 0; i < annexTier2.annotations.size(); ++i) {
                AnnexAnnotation annexAnnotation = (AnnexAnnotation)annexTier2.annotations.get(i);
                AnnexAnnotation annexAnnotation2 = null;
                for (int j = 0; j < annexTier.annotations.size(); ++j) {
                    AnnexAnnotation annexAnnotation3 = (AnnexAnnotation)annexTier.annotations.get(j);
                    if (annexAnnotation3.beginTime > annexAnnotation.beginTime) break;
                    annexAnnotation2 = annexAnnotation3;
                }
                if (annexAnnotation2 == null) {
                    System.out.println("Warning: could not find mother for element " + string + "." + annexAnnotation.value + " on level " + this.tiers.getParent(string));
                }
                annexAnnotation.refAnnotation = annexAnnotation2;
            }
        }
    }

    private AnnexTier getOrCreateTier(AnnexTranscription annexTranscription, String string) {
        try {
            return this.getTier(annexTranscription, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AnnexTier annexTier = new AnnexTier(string);
            annexTranscription.getTiers().add(annexTier);
            return annexTier;
        }
    }

    private AnnexTier getTier(AnnexTranscription annexTranscription, String string) throws IllegalArgumentException {
        AnnexTier annexTier = null;
        for (int i = 0; i < annexTranscription.getTiers().size(); ++i) {
            AnnexTier annexTier2 = (AnnexTier)annexTranscription.getTiers().get(i);
            if (!annexTier2.name.equals(string)) continue;
            annexTier = annexTier2;
            break;
        }
        if (annexTier == null) {
            throw new IllegalArgumentException("tier not found: " + string);
        }
        return annexTier;
    }

    private long getAlignTime(int n, int n2, long l, long l2) {
        double d = (double)n / (double)n2;
        long l3 = l2 - l;
        return (long)(d * (double)l3) + l;
    }

    private void printAnnexTranscription(AnnexTranscription annexTranscription) {
        for (Object e : annexTranscription.getTiers()) {
            System.out.println("| " + ((AnnexTier)e).name + ": " + ((AnnexTier)e).annotations.size());
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length > 2) {
            System.out.println("ShoeboxParser sbxfile");
            System.out.println("ShoeboxParser sbxfile typfile");
            System.out.println("ShoeboxParser -d directory");
            System.out.println("[typfile is of format .typ or .mkr]");
            return;
        }
        if ("-d".equals(stringArray[0])) {
            Vector<String> vector = new Vector<String>();
            File file = new File(stringArray[1]);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    System.out.println("Parsing " + fileArray[i].getPath());
                    new AnnexTranscription("test", 2, fileArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    vector.add(fileArray[i].getPath());
                }
            }
            System.out.println("Parsed " + fileArray.length + " files.");
            System.out.println("Exceptions in: " + vector);
        } else if (stringArray.length == 1) {
            new AnnexTranscription("test", 2, new File(stringArray[0]));
        } else if (stringArray.length == 2) {
            new AnnexTranscription("test", new File(stringArray[0]), new File(stringArray[1]));
        }
    }
}

