/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import mpi.annex.data.ShoeboxTiers;
import mpi.annex.data.TierType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoeboxRecord {
    private Hashtable<String, Vector<String>> record = new Hashtable();
    private ShoeboxTiers tiers;
    private boolean knownTiers;
    private long startTime;
    private long endTime;
    private String recordInfo;
    private String lastTag;
    private boolean lineBreaksCleaned;
    private int longestAlignedTier;
    private boolean virtualTime;

    public ShoeboxRecord(String string, ShoeboxTiers shoeboxTiers, boolean bl) {
        this.recordInfo = ShoeboxRecord.getTierContent(string);
        this.tiers = shoeboxTiers;
        this.startTime = -1L;
        this.endTime = -1L;
        this.virtualTime = false;
        this.lastTag = null;
        this.lineBreaksCleaned = false;
        this.longestAlignedTier = -1;
        Vector<String> vector = new Vector<String>();
        vector.add(this.recordInfo);
        this.record.put("ref", vector);
        shoeboxTiers.put("ref", TierType.REF);
    }

    public void put(String string) {
        Vector<String> vector;
        String string2;
        if (this.knownTiers && this.tiers.getType(ShoeboxRecord.getTierTag(string)) == TierType.TIME && !this.parseTime(ShoeboxRecord.getTierTag(string), ShoeboxRecord.getTierContent(string))) {
            System.out.println("Warning: illegal time " + string);
        }
        if ((string2 = ShoeboxRecord.getTierTag(string)) == null) {
            string2 = this.lastTag;
        }
        this.lastTag = string2;
        if (string2 == null) {
            System.err.println("Warning: no tag in line " + string);
            return;
        }
        if (this.knownTiers && this.tiers.getType(string2) == null) {
            System.out.println("Warning: ignoring unspecified tag " + string2);
        }
        if (!this.knownTiers && this.parseTime(string2, ShoeboxRecord.getTierContent(string))) {
            this.tiers.put(string2, TierType.TIME);
        }
        if ((vector = this.record.get(string2)) == null) {
            vector = new Vector();
            this.record.put(string2, vector);
        }
        vector.add(ShoeboxRecord.getTierContent(string));
        if (!this.knownTiers && this.tiers.getType(string2) != TierType.TIME || this.tiers.getType(string2) == TierType.UNKNOWN) {
            if (ShoeboxRecord.isProbablyAligned(string2, ShoeboxRecord.getTierContent(string))) {
                this.tiers.put(string2, TierType.ALIGNED);
            } else {
                this.tiers.put(string2, TierType.BLOCK);
            }
        }
    }

    public void provideAlternativeTime(ShoeboxRecord shoeboxRecord, int n) {
        if (this.startTime == -1L || this.endTime == -1L) {
            this.virtualTime = true;
        }
        if (this.startTime == -1L) {
            this.startTime = n * 10000;
        }
        if (this.endTime == -1L && shoeboxRecord != null) {
            this.endTime = shoeboxRecord.startTime;
        }
        if (this.endTime == -1L) {
            this.endTime = (n + 1) * 10000;
        }
    }

    private void cleanLineBreaks() {
        this.longestAlignedTier = 0;
        boolean bl = true;
        int n = 0;
        while (bl) {
            bl = false;
            this.findNewLongestAlignedTier();
            for (String string : this.tags()) {
                Vector<String> vector = this.record.get(string);
                if (vector == null) continue;
                if (vector.size() > 1) {
                    if (TierType.ALIGNED.equals((Object)this.tiers.getType(string))) {
                        while (vector.elementAt(0).length() < this.longestAlignedTier + 1) {
                            vector.set(0, vector.elementAt(0) + " ");
                        }
                    }
                    vector.set(0, vector.elementAt(0) + vector.elementAt(1));
                    vector.remove(1);
                }
                if (vector.size() <= 1) continue;
                bl = true;
            }
            ++n;
        }
        this.findNewLongestAlignedTier();
        this.lineBreaksCleaned = true;
    }

    private void findNewLongestAlignedTier() {
        for (String string : this.tags()) {
            if (!TierType.ALIGNED.equals((Object)this.getTierType(string)) || this.record.get(string) == null || this.record.get(string).firstElement().length() <= this.longestAlignedTier) continue;
            this.longestAlignedTier = this.record.get(string).firstElement().length();
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Collection<String> tags() {
        return this.tiers.names(true);
    }

    public ShoeboxTiers tiers() {
        return this.tiers;
    }

    public String getContent(String string) {
        if (!this.lineBreaksCleaned) {
            this.cleanLineBreaks();
        }
        if (this.record.get(string) == null) {
            return null;
        }
        return this.record.get(string).firstElement();
    }

    public TierType getTierType(String string) {
        return this.tiers.getType(string);
    }

    public int getLongestAlignedTier() {
        if (!this.lineBreaksCleaned) {
            this.cleanLineBreaks();
        }
        return this.longestAlignedTier;
    }

    public String toString() {
        return this.record.toString() + this.tiers.toString();
    }

    private boolean parseTime(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string != null && string.startsWith("EUDICOt")) {
            long l = ShoeboxRecord.parseTimeString(string2);
            if (string.equals("EUDICOt0")) {
                this.startTime = l;
                return this.startTime != -1L;
            }
            if (string.equals("EUDICOt1")) {
                this.endTime = l;
                return this.endTime != -1L;
            }
            return false;
        }
        if (string != null && string.startsWith("ELAN")) {
            long l = ShoeboxRecord.parseTimeString(string2);
            if (string.equals("ELANBegin")) {
                this.startTime = l;
                return this.startTime != -1L;
            }
            if (string.equals("ELANEnd")) {
                this.endTime = l;
                return this.endTime != -1L;
            }
            return false;
        }
        long l = ShoeboxRecord.parseTimeString(string2);
        if (l != -1L) {
            this.startTime = l;
            return true;
        }
        return false;
    }

    public static long parseTimeString(String string) {
        try {
            double d = Double.parseDouble(string);
            return (long)(d * 1000.0);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static String getTierTag(String string) {
        if (!string.startsWith("\\")) {
            return null;
        }
        if (string.indexOf(" ") == -1) {
            return string.substring(1, string.length());
        }
        return string.substring(1, string.indexOf(" "));
    }

    public static String getTierContent(String string) {
        if (!string.startsWith("\\")) {
            return string;
        }
        if (string.indexOf(" ") == -1) {
            return "";
        }
        return string.substring(string.indexOf(" ") + 1, string.length());
    }

    private static boolean isProbablyAligned(String string, String string2) {
        return string2.trim().indexOf("  ") != -1;
    }
}

