/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import mpi.annex.data.TierType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoeboxTiers {
    private Hashtable<String, Tier> byName;
    private TreeSet<Tier> byOrder = new TreeSet();
    private int count = 0;

    public ShoeboxTiers() {
        this.byName = new Hashtable();
    }

    public void put(String string, TierType tierType, String string2) {
        Tier tier = this.byName.get(string);
        if (tier == null) {
            tier = new Tier(string, this.count++, tierType, string2);
            this.byOrder.add(tier);
            this.byName.put(string, tier);
        } else {
            tier.type = tierType;
            tier.encoding = string2;
        }
    }

    public void put(String string, TierType tierType) {
        this.put(string, tierType, "ISO-8859-1");
    }

    public TierType getType(String string) {
        if (this.byName.get(string) == null) {
            return null;
        }
        return this.byName.get((Object)string).type;
    }

    public String getEncoding(String string) {
        if (this.byName.get(string) == null) {
            return null;
        }
        return this.byName.get((Object)string).encoding;
    }

    public Collection<String> names(boolean bl) {
        Vector<String> vector = new Vector<String>();
        for (Tier tier : this.byOrder) {
            if (!bl && tier.type == TierType.TIME) continue;
            vector.add(tier.name);
        }
        return vector;
    }

    public String getParent(String string) {
        if (this.byName.get(string) == null) {
            return null;
        }
        return this.byName.get((Object)string).parent;
    }

    public void setParent(String string, String string2) {
        if (this.byName.get(string) == null) {
            throw new IllegalArgumentException("unknown tier name: " + string);
        }
        this.byName.get((Object)string).parent = string2;
    }

    public Hashtable<String, String> getEncodingHash() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (String string : this.names(true)) {
            hashtable.put(string, this.byName.get((Object)string).encoding);
        }
        return hashtable;
    }

    public int size() {
        return this.byName.size();
    }

    public String toString() {
        return this.byOrder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tier
    implements Comparable<Tier> {
        public String name;
        public int order;
        public TierType type;
        public String encoding;
        public String parent;

        public Tier(String string, int n, TierType tierType, String string2) {
            this.name = string;
            this.order = n;
            this.type = tierType;
            this.encoding = string2;
            this.parent = "ref".equals(string) ? null : "ref";
        }

        @Override
        public int compareTo(Tier tier) {
            if (this.order < tier.order) {
                return -1;
            }
            if (this.order > tier.order) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return object instanceof Tier && this.order == ((Tier)object).order;
        }

        public String toString() {
            return this.name + "/" + (Object)((Object)this.type);
        }
    }
}

