/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.oldsearch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.oldsearch.AnnexSearchAnnotation;
import mpi.annex.oldsearch.AnnexSearchTier;
import mpi.annex.oldsearch.AnnexSearchTranscription;
import mpi.annex.oldsearch.AnnotationInfo;
import mpi.annex.oldsearch.SearchEngineCommand;
import mpi.annex.oldsearch.SearchStatistics;
import mpi.annex.oldsearch.SearchUtil;
import mpi.annex.util.AnnexUtil;
import mpi.corpusstructure.CorpusStructureDB;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class AnnexSearchEngine {
    private int nIndexedTranscriptions;
    private int nIndexedTiers;
    private int nIndexedAnnotations;
    private int nUniqueAnnotations;
    private HashMap nodeIdToTranscriptionHash;
    private ArrayList transcriptionList;
    private HashMap annotationHash;
    private ArrayList annotationList;
    private ArrayList annotationRefList;
    private HashMap nodeIdHash;
    private ArrayList nodeIdList;
    private ArrayList nodeIdAnnotationIndexSetList;
    private HashMap tierNameHash;
    private ArrayList tierNameList;
    private HashMap participantHash;
    private ArrayList participantList;
    private HashMap defaultLocaleHash;
    private ArrayList defaultLocaleList;
    private HashMap linguisticTypeHash;
    private ArrayList linguisticTypeList;
    private long uniqueKey = System.currentTimeMillis();
    private HashMap resultHash;
    private HashMap sessionHash;
    private HashMap treeToNode;
    private HashMap nodeToTree;
    private HashMap subNodes;
    int nLeipzigNodes;

    public AnnexSearchEngine() {
        this.nodeIdToTranscriptionHash = new HashMap();
        this.transcriptionList = new ArrayList();
        this.annotationHash = new HashMap();
        this.annotationList = new ArrayList();
        this.annotationRefList = new ArrayList();
        this.nodeIdHash = new HashMap();
        this.nodeIdList = new ArrayList();
        this.nodeIdAnnotationIndexSetList = new ArrayList();
        this.tierNameHash = new HashMap();
        this.tierNameList = new ArrayList();
        this.participantHash = new HashMap();
        this.participantList = new ArrayList();
        this.defaultLocaleHash = new HashMap();
        this.defaultLocaleList = new ArrayList();
        this.linguisticTypeHash = new HashMap();
        this.linguisticTypeList = new ArrayList();
        this.resultHash = new HashMap();
        this.sessionHash = new HashMap();
        this.treeToNode = new HashMap();
        this.nodeToTree = new HashMap();
        this.subNodes = new HashMap();
    }

    public synchronized ArrayList process(SearchEngineCommand searchEngineCommand) {
        ArrayList arrayList = null;
        try {
            String string = searchEngineCommand.getName();
            System.out.println("command: " + string);
            if (string.equals("Ping")) {
                arrayList = new ArrayList();
            } else if (string.equals("Reset")) {
                this.reset();
            } else if (string.equals("Add")) {
                String string2 = (String)searchEngineCommand.getParameters().get(0);
                boolean bl = this.add(string2);
                arrayList = new ArrayList();
                arrayList.add(new Boolean(bl));
            } else if (string.equals("Remove")) {
                String string3 = (String)searchEngineCommand.getParameters().get(0);
                this.remove(string3);
            } else if (string.equals("Update")) {
                String string4 = (String)searchEngineCommand.getParameters().get(0);
                this.update(string4);
            } else if (string.equals("PURGE")) {
                String string5 = (String)searchEngineCommand.getParameters().get(0);
                this.purge(string5);
            } else if (string.equals("TierNames")) {
                ArrayList arrayList2 = (ArrayList)searchEngineCommand.getParameters().get(0);
                arrayList = this.getTierNamesIn(arrayList2);
            } else if (string.equals("AllTierNames")) {
                arrayList = this.getAllTierNames();
            } else if (string.equals("Participants")) {
                ArrayList arrayList3 = (ArrayList)searchEngineCommand.getParameters().get(0);
                arrayList = this.getParticipantsIn(arrayList3);
            } else if (string.equals("CheckNodes")) {
                ArrayList arrayList4 = (ArrayList)searchEngineCommand.getParameters().get(0);
                arrayList = this.checkNodes(arrayList4);
            } else if (string.equals("Find")) {
                String string6 = (String)searchEngineCommand.getParameters().get(0);
                ArrayList arrayList5 = (ArrayList)searchEngineCommand.getParameters().get(1);
                ArrayList arrayList6 = (ArrayList)searchEngineCommand.getParameters().get(2);
                ArrayList arrayList7 = (ArrayList)searchEngineCommand.getParameters().get(3);
                ArrayList arrayList8 = (ArrayList)searchEngineCommand.getParameters().get(4);
                ArrayList arrayList9 = (ArrayList)searchEngineCommand.getParameters().get(5);
                ArrayList arrayList10 = (ArrayList)searchEngineCommand.getParameters().get(6);
                arrayList = this.find(string6, arrayList5, arrayList6, arrayList7, arrayList8, arrayList9, arrayList10);
            } else if (string.equals("GetResult")) {
                ArrayList arrayList11 = searchEngineCommand.getParameters();
                Long l = (Long)arrayList11.get(0);
                if (arrayList11.size() == 1) {
                    arrayList = this.getHitNodeIds(l);
                } else if (arrayList11.size() == 2) {
                    String string7 = (String)arrayList11.get(1);
                    arrayList = this.getHitInfo(l, string7);
                } else if (arrayList11.size() == 3) {
                    int n = (Integer)arrayList11.get(1);
                    int n2 = (Integer)arrayList11.get(2);
                    arrayList = this.getHitInfo(l, n, n2);
                }
            } else if (string.equals("Statistics")) {
                arrayList = this.getStatistics();
            } else if (string.equals("SubNodes")) {
                String string8 = (String)searchEngineCommand.getParameters().get(0);
                arrayList = this.getAnnotationSubNodes(string8);
            } else if (string.equals("TierContent")) {
                String string9 = (String)searchEngineCommand.getParameters().get(0);
                String string10 = (String)searchEngineCommand.getParameters().get(1);
                arrayList = this.getTierContent(string9, string10);
            } else if (string.equals("TreePathToNodeId")) {
                String string11 = (String)searchEngineCommand.getParameters().get(0);
                String string12 = this.getNodeIdForTreePath(string11);
                arrayList = new ArrayList();
                arrayList.add(string12);
            } else if (string.equals("NodeIdToTreePath")) {
                String string13 = (String)searchEngineCommand.getParameters().get(0);
                String string14 = this.getTreePathForNodeId(string13);
                arrayList = new ArrayList();
                arrayList.add(string14);
            }
        }
        catch (Exception exception) {
            AnnexUtil.log((Object)"AnnexSearchEngine", 0, exception);
            arrayList = null;
        }
        return arrayList;
    }

    private ArrayList find(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, ArrayList arrayList6) {
        Object object;
        AnnexSearchAnnotation annexSearchAnnotation;
        int n;
        ArrayList arrayList7;
        int n2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n3;
        AnnexSearchTranscription annexSearchTranscription;
        Object object6;
        int n4;
        ArrayList<Object> arrayList8;
        boolean bl;
        long l = System.currentTimeMillis();
        String string2 = (String)arrayList2.get(0);
        String string3 = (String)arrayList.get(0);
        boolean bl2 = string3.indexOf("regexp") >= 0;
        boolean bl3 = bl = ((String)arrayList.get(0)).indexOf("case") >= 0;
        if (arrayList4 != null || arrayList5 != null) {
            arrayList8 = new ArrayList<Object>();
            block0: for (n4 = 0; n4 < arrayList6.size(); ++n4) {
                object6 = (String)arrayList6.get(n4);
                annexSearchTranscription = (AnnexSearchTranscription)this.nodeIdToTranscriptionHash.get(object6);
                for (n3 = 0; n3 < annexSearchTranscription.tiers.size(); ++n3) {
                    object5 = (AnnexSearchTier)annexSearchTranscription.tiers.get(n3);
                    object4 = (String)this.tierNameList.get(((AnnexSearchTier)object5).tierNameIndex);
                    String string4 = (String)this.participantList.get(((AnnexSearchTier)object5).participantIndex);
                    if (!arrayList4.contains(object4) && !arrayList5.contains(string4)) continue;
                    arrayList8.add(object6);
                    continue block0;
                }
            }
            arrayList6 = arrayList8;
        } else if (string2.trim().toLowerCase().startsWith("[mor]")) {
            arrayList8 = new ArrayList();
            block2: for (n4 = 0; n4 < arrayList6.size(); ++n4) {
                object6 = (String)arrayList6.get(n4);
                annexSearchTranscription = (AnnexSearchTranscription)this.nodeIdToTranscriptionHash.get(object6);
                for (n3 = 0; n3 < annexSearchTranscription.tiers.size(); ++n3) {
                    object5 = (AnnexSearchTier)annexSearchTranscription.tiers.get(n3);
                    object4 = (String)this.tierNameList.get(((AnnexSearchTier)object5).tierNameIndex);
                    if (((String)object4).indexOf("%mor") < 0) continue;
                    arrayList8.add(object6);
                    continue block2;
                }
            }
            arrayList6 = arrayList8;
        }
        int n5 = 0;
        n4 = 0;
        object6 = new HashSet();
        System.out.println("nodeIds.size(): " + arrayList6.size());
        for (int i = 0; i < arrayList6.size(); ++i) {
            String string5 = (String)arrayList6.get(i);
            object5 = (Integer)this.nodeIdHash.get(string5);
            if (object5 == null) continue;
            object4 = (HashSet)this.nodeIdAnnotationIndexSetList.get((Integer)object5);
            ((AbstractCollection)object6).addAll(object4);
            n5 += ((AnnexSearchTranscription)this.nodeIdToTranscriptionHash.get((Object)string5)).nAnnotations;
            ++n4;
        }
        ArrayList arrayList9 = new ArrayList(object6);
        int[] nArray = new int[arrayList9.size()];
        object5 = new int[arrayList9.size()];
        int n6 = 0;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        if (string2.trim().toLowerCase().startsWith("[mor]")) {
            bl6 = true;
            bl5 = false;
        }
        if (string2.trim().toLowerCase().startsWith("[sdt]")) {
            bl5 = false;
        }
        String string6 = null;
        Pattern pattern = null;
        String string7 = null;
        Pattern pattern2 = null;
        if (string2.trim().toLowerCase().startsWith("[mor]") || string2.trim().toLowerCase().startsWith("[sdt]")) {
            if (SearchUtil.hasNOTPattern(string2)) {
                if (SearchUtil.tokenize(string2).size() > 2) {
                    bl2 = true;
                    string6 = SearchUtil.convertSpecialPattern(SearchUtil.disableNOT(string2), bl2);
                    pattern = SearchUtil.getRegExpPattern(string6, bl2, bl);
                    string7 = SearchUtil.convertSpecialPattern(SearchUtil.enableNOT(string2), bl2);
                    pattern2 = SearchUtil.getRegExpPattern(string7, bl2, bl);
                } else {
                    object3 = (String)SearchUtil.tokenize(string2).get(1);
                    string2 = SearchUtil.convertSpecialPattern((String)object3, bl2);
                    bl2 = true;
                }
            } else {
                object3 = SearchUtil.convertSpecialPattern(string2, bl2);
                if (!((String)object3).equals(string2)) {
                    string2 = object3;
                    bl2 = true;
                }
            }
        } else {
            object3 = SearchUtil.convertSpecialPattern(string2, bl2);
            if (!((String)object3).equals(string2)) {
                string2 = object3;
                bl2 = true;
            }
        }
        if (string2.trim().toLowerCase().startsWith("\\[sdt]") || string2.trim().toLowerCase().startsWith("\\[mor]")) {
            string2 = string2.substring(1);
        }
        System.out.println("pattern: " + string2);
        System.out.println("dis NOT: " + string6);
        System.out.println("ena NOT: " + string7);
        object3 = SearchUtil.getRegExpPattern(string2, bl2, bl);
        System.out.println("allIndices.size(): " + arrayList9.size());
        for (int i = 0; i < arrayList9.size(); ++i) {
            int n7 = (Integer)arrayList9.get(i);
            object2 = (String)this.annotationList.get(n7);
            if (bl6) {
                object2 = ((String)object2).replaceAll("\\[.*?\\]", "");
            }
            int n8 = 0;
            if (pattern != null) {
                n8 = SearchUtil.countHits((String)object2, string6, pattern, bl, bl5);
                n8 -= SearchUtil.countHits((String)object2, string7, pattern2, bl, bl5);
            } else {
                n8 = SearchUtil.countHits((String)object2, string2, (Pattern)object3, bl, bl5);
            }
            if (n8 <= 0) continue;
            nArray[n6] = n7;
            object5[n6] = n8;
            ++n6;
        }
        HashMap<AnnexSearchAnnotation, Integer> hashMap = new HashMap<AnnexSearchAnnotation, Integer>();
        Object object7 = new ArrayList<AnnexSearchAnnotation>();
        object2 = new HashSet(arrayList6);
        HashSet<String> hashSet = new HashSet<String>();
        for (n2 = 0; n2 < n6; ++n2) {
            int n9 = nArray[n2];
            Object object8 = object5[n2];
            arrayList7 = (ArrayList)this.annotationRefList.get(n9);
            for (n = 0; n < arrayList7.size(); ++n) {
                annexSearchAnnotation = (AnnexSearchAnnotation)arrayList7.get(n);
                String string8 = (String)this.nodeIdList.get(annexSearchAnnotation.tier.transcription.nodeIdIndex);
                if (!((HashSet)object2).contains(string8)) continue;
                if (hashSet.add(string8)) {
                    // empty if block
                }
                if (bl6) {
                    String string9 = (String)this.tierNameList.get(annexSearchAnnotation.tier.tierNameIndex);
                    if (string9.indexOf("%mor") < 0) continue;
                    ((ArrayList)object7).add(annexSearchAnnotation);
                    hashMap.put(annexSearchAnnotation, new Integer((int)object8));
                    continue;
                }
                if (arrayList4 == null && arrayList5 == null) {
                    ((ArrayList)object7).add(annexSearchAnnotation);
                    hashMap.put(annexSearchAnnotation, new Integer((int)object8));
                    continue;
                }
                boolean bl7 = false;
                if (arrayList4.size() > 0 && arrayList4.contains(object = (String)this.tierNameList.get(annexSearchAnnotation.tier.tierNameIndex))) {
                    ((ArrayList)object7).add(annexSearchAnnotation);
                    hashMap.put(annexSearchAnnotation, new Integer((int)object8));
                    bl7 = true;
                }
                if (bl7 || arrayList5.size() <= 0 || !arrayList5.contains(object = (String)this.participantList.get(annexSearchAnnotation.tier.participantIndex))) continue;
                ((ArrayList)object7).add(annexSearchAnnotation);
                hashMap.put(annexSearchAnnotation, new Integer((int)object8));
            }
        }
        for (n2 = 1; n2 < arrayList3.size(); ++n2) {
            Object object9;
            String string10 = (String)arrayList3.get(n2);
            string2 = (String)arrayList2.get(n2);
            string3 = (String)arrayList.get(n2);
            bl2 = string3.indexOf("regexp") >= 0;
            bl = arrayList.indexOf("case") >= 0;
            System.out.println("Constraint " + n2);
            System.out.println(string2 + "/" + string3);
            bl5 = true;
            bl6 = false;
            if (string2.trim().toLowerCase().startsWith("[mor]")) {
                bl6 = true;
                bl5 = false;
            }
            if (string2.trim().toLowerCase().startsWith("[sdt]")) {
                bl5 = false;
            }
            string6 = null;
            pattern = null;
            string7 = null;
            pattern2 = null;
            if (string2.trim().toLowerCase().startsWith("[mor]") || string2.trim().toLowerCase().startsWith("[sdt]")) {
                if (SearchUtil.hasNOTPattern(string2)) {
                    if (SearchUtil.tokenize(string2).size() > 2) {
                        bl2 = true;
                        string6 = SearchUtil.convertSpecialPattern(SearchUtil.disableNOT(string2), bl2);
                        pattern = SearchUtil.getRegExpPattern(string6, bl2, bl);
                        string7 = SearchUtil.convertSpecialPattern(SearchUtil.enableNOT(string2), bl2);
                        pattern2 = SearchUtil.getRegExpPattern(string7, bl2, bl);
                    } else {
                        object9 = (String)SearchUtil.tokenize(string2).get(1);
                        string2 = SearchUtil.convertSpecialPattern((String)object9, bl2);
                        bl2 = true;
                    }
                } else {
                    object9 = SearchUtil.convertSpecialPattern(string2, bl2);
                    if (!((String)object9).equals(string2)) {
                        string2 = object9;
                        bl2 = true;
                    }
                }
            } else {
                object9 = SearchUtil.convertSpecialPattern(string2, bl2);
                if (!((String)object9).equals(string2)) {
                    string2 = object9;
                    bl2 = true;
                }
            }
            if (string2.trim().toLowerCase().startsWith("\\[sdt]") || string2.trim().toLowerCase().startsWith("\\[mor]")) {
                string2 = string2.substring(1);
            }
            object3 = SearchUtil.getRegExpPattern(string2, bl2, bl);
            object9 = new ArrayList();
            arrayList7 = new ArrayList();
            for (n = 0; n < ((ArrayList)object7).size(); ++n) {
                annexSearchAnnotation = (AnnexSearchAnnotation)((ArrayList)object7).get(n);
                arrayList7.clear();
                SearchUtil.getRange(annexSearchAnnotation, string10, arrayList7);
                boolean bl8 = false;
                for (int i = 0; i < arrayList7.size(); ++i) {
                    object = (AnnexSearchAnnotation)arrayList7.get(i);
                    String string11 = (String)this.annotationList.get(((AnnexSearchAnnotation)object).annotationValueIndex);
                    if (bl6) {
                        string11 = string11.replaceAll("\\[.*?\\]", "");
                    }
                    int n10 = 0;
                    if (pattern != null) {
                        n10 = SearchUtil.countHits(string11, string6, pattern, bl, bl5);
                        n10 -= SearchUtil.countHits(string11, string7, pattern2, bl, bl5);
                    } else {
                        n10 = SearchUtil.countHits(string11, string2, (Pattern)object3, bl, bl5);
                    }
                    if (n10 <= 0) continue;
                    bl8 = true;
                    break;
                }
                if (!bl8) continue;
                ((ArrayList)object9).add(annexSearchAnnotation);
            }
            object7 = object9;
        }
        Collections.sort(object7);
        Long l2 = this.getUniqueKey();
        this.resultHash.put(l2, object7);
        if (!this.sessionHash.containsKey(string)) {
            this.sessionHash.put(string, new ArrayList());
        }
        ArrayList arrayList10 = (ArrayList)this.sessionHash.get(string);
        arrayList10.add(l2);
        int n11 = 0;
        for (int i = 0; i < ((ArrayList)object7).size(); ++i) {
            n11 += ((Integer)hashMap.get(((ArrayList)object7).get(i))).intValue();
        }
        SearchStatistics searchStatistics = new SearchStatistics();
        searchStatistics.queryDuration = System.currentTimeMillis() - l;
        searchStatistics.nHits = n11;
        searchStatistics.nAnnotationsWithHit = ((ArrayList)object7).size();
        searchStatistics.nAnnotationsSearched = arrayList9.size();
        searchStatistics.nAnnotationsInNodes = n5;
        searchStatistics.nNodesSearched = n4;
        searchStatistics.nHitsInNodes = hashSet.size();
        ArrayList<Serializable> arrayList11 = new ArrayList<Serializable>();
        arrayList11.add(searchStatistics);
        arrayList11.add(l2);
        return arrayList11;
    }

    public ArrayList findInFiles(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, ArrayList arrayList6) {
        long l = System.currentTimeMillis();
        ArrayList<SearchStatistics> arrayList7 = new ArrayList<SearchStatistics>();
        SearchStatistics searchStatistics = new SearchStatistics();
        String string = "node0";
        ArrayList<String> arrayList8 = new ArrayList<String>();
        arrayList8.add(string);
        for (int i = 0; i < arrayList6.size(); ++i) {
            int n;
            AnnexTranscription annexTranscription;
            File file = (File)arrayList6.get(i);
            String string2 = file.getAbsolutePath();
            if (!file.exists() || !(annexTranscription = new AnnexTranscription(string, n = SearchUtil.getAnnotationType(file), file)).isValid()) continue;
            this.reset();
            this.add(annexTranscription);
            ArrayList arrayList9 = this.find("fakeSessionId", arrayList, arrayList2, arrayList3, arrayList4, arrayList5, arrayList8);
            SearchStatistics searchStatistics2 = (SearchStatistics)arrayList9.get(0);
            searchStatistics.nAnnotationsWithHit += searchStatistics2.nAnnotationsWithHit;
            searchStatistics.nAnnotationsSearched += searchStatistics2.nAnnotationsSearched;
            searchStatistics.nAnnotationsInNodes += searchStatistics2.nAnnotationsInNodes;
            ++searchStatistics.nNodesSearched;
            Long l2 = (Long)arrayList9.get(1);
            ArrayList arrayList10 = this.getHitInfo(l2, 0, searchStatistics2.nHits);
            searchStatistics.nHits += arrayList10.size();
            System.out.println("ASE: adding #hits: " + searchStatistics2.nHits);
            System.out.println("ASE: hits size: " + arrayList10.size());
            for (int j = 0; j < arrayList10.size(); ++j) {
                ((AnnotationInfo)arrayList10.get((int)j)).filePath = string2;
            }
            arrayList7.addAll(arrayList10);
        }
        searchStatistics.queryDuration = System.currentTimeMillis() - l;
        arrayList7.add(0, searchStatistics);
        return arrayList7;
    }

    public ArrayList getTierNamesInFiles(ArrayList arrayList) {
        String string = "node0";
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            AnnexTranscription annexTranscription;
            File file = (File)arrayList.get(i);
            String string2 = file.getAbsolutePath();
            if (!file.exists() || !(annexTranscription = new AnnexTranscription(string, n = SearchUtil.getAnnotationType(file), file)).isValid()) continue;
            ArrayList arrayList3 = annexTranscription.getTiers();
            for (int j = 0; j < arrayList3.size(); ++j) {
                AnnexTier annexTier = (AnnexTier)arrayList3.get(j);
                treeSet.add(annexTier.name);
            }
        }
        ArrayList arrayList4 = new ArrayList(treeSet);
        return arrayList4;
    }

    private ArrayList getHitNodeIds(Long l) {
        return null;
    }

    private ArrayList getHitInfo(Long l, String string) {
        return null;
    }

    private ArrayList getHitInfo(Long l, int n, int n2) {
        ArrayList<AnnotationInfo> arrayList = new ArrayList<AnnotationInfo>();
        ArrayList arrayList2 = (ArrayList)this.resultHash.get(l);
        if (arrayList2 != null) {
            for (int i = n; i < n2; ++i) {
                AnnexSearchAnnotation annexSearchAnnotation;
                if (i >= arrayList2.size()) continue;
                AnnexSearchAnnotation annexSearchAnnotation2 = (AnnexSearchAnnotation)arrayList2.get(i);
                AnnexSearchTier annexSearchTier = annexSearchAnnotation2.tier;
                AnnexSearchTranscription annexSearchTranscription = annexSearchTier.transcription;
                AnnotationInfo annotationInfo = new AnnotationInfo();
                annotationInfo.annotation = (String)this.annotationList.get(annexSearchAnnotation2.annotationValueIndex);
                if (annexSearchAnnotation2.annotationIndex > 0) {
                    annexSearchAnnotation = (AnnexSearchAnnotation)annexSearchTier.annotations.get(annexSearchAnnotation2.annotationIndex - 1);
                    annotationInfo.annotationBefore = (String)this.annotationList.get(annexSearchAnnotation.annotationValueIndex);
                } else {
                    annotationInfo.annotationBefore = "";
                }
                if (annexSearchAnnotation2.annotationIndex + 1 < annexSearchTier.annotations.size()) {
                    annexSearchAnnotation = (AnnexSearchAnnotation)annexSearchTier.annotations.get(annexSearchAnnotation2.annotationIndex + 1);
                    annotationInfo.annotationAfter = (String)this.annotationList.get(annexSearchAnnotation.annotationValueIndex);
                } else {
                    annotationInfo.annotationAfter = "";
                }
                annotationInfo.tierName = (String)this.tierNameList.get(annexSearchTier.tierNameIndex);
                annotationInfo.participant = this.participantList.get(annexSearchTier.participantIndex) != null ? (String)this.participantList.get(annexSearchTier.participantIndex) : "";
                annotationInfo.nodeId = (String)this.nodeIdList.get(annexSearchTranscription.nodeIdIndex);
                annotationInfo.indexInTier = annexSearchAnnotation2.annotationIndex;
                annotationInfo.beginTime = annexSearchAnnotation2.beginTime;
                annotationInfo.endTime = annexSearchAnnotation2.beginTime + (long)annexSearchAnnotation2.duration;
                annotationInfo.isTimeAligned = annexSearchAnnotation2.isTimeAligned;
                arrayList.add(annotationInfo);
            }
        }
        return arrayList;
    }

    private void purge(String string) {
        ArrayList arrayList = (ArrayList)this.sessionHash.get(string);
        if (arrayList != null) {
            this.sessionHash.remove(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                Long l = (Long)arrayList.get(i);
                this.resultHash.remove(l);
            }
        }
    }

    private ArrayList getTierNamesIn(ArrayList arrayList) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnexSearchTranscription annexSearchTranscription = (AnnexSearchTranscription)this.nodeIdToTranscriptionHash.get(arrayList.get(i));
            if (annexSearchTranscription == null) continue;
            ArrayList arrayList2 = annexSearchTranscription.tiers;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AnnexSearchTier annexSearchTier = (AnnexSearchTier)arrayList2.get(j);
                String string = (String)this.tierNameList.get(annexSearchTier.tierNameIndex);
                if (string == null || string.trim().equals("")) continue;
                treeSet.add(string);
            }
        }
        ArrayList arrayList3 = new ArrayList(treeSet);
        return arrayList3;
    }

    private ArrayList getAllTierNames() {
        return this.tierNameList;
    }

    public ArrayList getParticipantsIn(ArrayList arrayList) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnexSearchTranscription annexSearchTranscription = (AnnexSearchTranscription)this.nodeIdToTranscriptionHash.get(arrayList.get(i));
            if (annexSearchTranscription == null) continue;
            ArrayList arrayList2 = annexSearchTranscription.tiers;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AnnexSearchTier annexSearchTier = (AnnexSearchTier)arrayList2.get(j);
                String string = (String)this.participantList.get(annexSearchTier.participantIndex);
                if (string == null || string.trim().equals("")) continue;
                treeSet.add(string);
            }
        }
        ArrayList arrayList3 = new ArrayList(treeSet);
        return arrayList3;
    }

    public ArrayList checkNodes(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<String> arrayList8 = new ArrayList<String>();
        System.out.println("Starting checkNodes.");
        block8: for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (!this.nodeIdHash.containsKey(string)) {
                arrayList2.add(string);
                continue;
            }
            AnnexSearchTranscription annexSearchTranscription = (AnnexSearchTranscription)this.nodeIdToTranscriptionHash.get(string);
            switch (annexSearchTranscription.type) {
                case 0: {
                    arrayList3.add(string);
                    continue block8;
                }
                case 1: {
                    arrayList4.add(string);
                    continue block8;
                }
                case 2: {
                    arrayList5.add(string);
                    continue block8;
                }
                case 3: {
                    arrayList6.add(string);
                    continue block8;
                }
                case 4: {
                    arrayList7.add(string);
                    continue block8;
                }
                case 5: {
                    arrayList8.add(string);
                }
            }
        }
        ArrayList<ArrayList<String>> arrayList9 = new ArrayList<ArrayList<String>>();
        arrayList9.add(arrayList2);
        arrayList9.add(arrayList3);
        arrayList9.add(arrayList4);
        arrayList9.add(arrayList5);
        arrayList9.add(arrayList6);
        arrayList9.add(arrayList7);
        arrayList9.add(arrayList8);
        return arrayList9;
    }

    private boolean add(String string) {
        AnnexUtil.log("AnnexSearchEngine", 1, "add: " + string);
        String string2 = AnnexUtil.getFilePathFor(string);
        File file = new File(string2);
        if (file.exists()) {
            int n = AnnexUtil.getTypeFor(string);
            AnnexTranscription annexTranscription = new AnnexTranscription(string, n, file);
            if (annexTranscription.isValid()) {
                this.add(annexTranscription);
                return true;
            }
            AnnexUtil.log("AnnexSearchEngine", 1, "not parsable file: " + string2);
        } else {
            AnnexUtil.log("AnnexSearchEngine", 1, "non existing file: " + string2);
        }
        return false;
    }

    private int add_new(String string) {
        String string2 = AnnexUtil.getFilePathFor(string);
        File file = new File(string2);
        if (file.exists()) {
            int n = AnnexUtil.getTypeFor(string);
            AnnexTranscription annexTranscription = new AnnexTranscription(string, n, file);
            if (annexTranscription.isValid()) {
                this.add(annexTranscription);
                return 1;
            }
            AnnexUtil.log("AnnexSearchEngine", 1, "not parsable file: " + string2);
            return 2;
        }
        AnnexUtil.log("AnnexSearchEngine", 1, "non existing file: " + string2);
        return 0;
    }

    private void add(AnnexTranscription annexTranscription) {
        AnnexAnnotation annexAnnotation;
        ArrayList arrayList;
        Serializable serializable;
        Serializable serializable2;
        int n;
        HashMap<AnnexTier, AnnexSearchTier> hashMap = new HashMap<AnnexTier, AnnexSearchTier>();
        hashMap.put(null, null);
        HashMap<Object, Comparable<Integer>> hashMap2 = new HashMap<Object, Comparable<Integer>>();
        hashMap2.put(null, null);
        String string = annexTranscription.getNodeId();
        if (this.nodeIdHash.containsKey(string)) {
            this.remove(string);
        }
        this.nodeIdList.add(string);
        int n2 = this.nodeIdList.size() - 1;
        this.nodeIdAnnotationIndexSetList.add(new HashSet());
        this.nodeIdHash.put(string, new Integer(n2));
        HashSet hashSet = (HashSet)this.nodeIdAnnotationIndexSetList.get(n2);
        AnnexSearchTranscription annexSearchTranscription = new AnnexSearchTranscription();
        annexSearchTranscription.type = annexTranscription.getType();
        annexSearchTranscription.nodeIdIndex = n2;
        annexSearchTranscription.tiers = new ArrayList();
        this.transcriptionList.add(annexSearchTranscription);
        int n3 = this.transcriptionList.size() - 1;
        this.nodeIdToTranscriptionHash.put(string, annexSearchTranscription);
        ArrayList arrayList2 = annexTranscription.getTiers();
        for (n = 0; n < arrayList2.size(); ++n) {
            serializable2 = new AnnexSearchTier();
            serializable2.annotations = new ArrayList();
            serializable = (AnnexTier)arrayList2.get(n);
            arrayList = serializable.annotations;
            for (int i = 0; i < arrayList.size(); ++i) {
                int n4;
                AnnexSearchAnnotation annexSearchAnnotation = new AnnexSearchAnnotation();
                annexAnnotation = (AnnexAnnotation)arrayList.get(i);
                if (!hashMap2.containsKey(annexAnnotation.value)) {
                    this.annotationList.add(annexAnnotation.value);
                    n4 = this.annotationList.size() - 1;
                    hashMap2.put(annexAnnotation.value, new Integer(n4));
                    this.annotationRefList.add(new ArrayList());
                    ++this.nUniqueAnnotations;
                } else {
                    n4 = (Integer)hashMap2.get(annexAnnotation.value);
                }
                hashSet.add(new Integer(n4));
                ArrayList arrayList3 = (ArrayList)this.annotationRefList.get(n4);
                arrayList3.add(annexSearchAnnotation);
                hashMap2.put(annexAnnotation, annexSearchAnnotation);
                serializable2.annotations.add(annexSearchAnnotation);
                ++this.nIndexedAnnotations;
            }
            hashMap.put((AnnexTier)serializable, (AnnexSearchTier)serializable2);
            annexSearchTranscription.tiers.add(serializable2);
            ++this.nIndexedTiers;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            serializable2 = (AnnexTier)arrayList2.get(n);
            serializable = (AnnexSearchTier)annexSearchTranscription.tiers.get(n);
            ((AnnexSearchTier)serializable).tierNameIndex = this.add(((AnnexTier)serializable2).name, this.tierNameHash, this.tierNameList);
            ((AnnexSearchTier)serializable).participantIndex = this.add(((AnnexTier)serializable2).participant, this.participantHash, this.participantList);
            ((AnnexSearchTier)serializable).defaultLocaleIndex = this.add(((AnnexTier)serializable2).defaultLocale, this.defaultLocaleHash, this.defaultLocaleList);
            ((AnnexSearchTier)serializable).linguisticTypeIndex = this.add(((AnnexTier)serializable2).type, this.linguisticTypeHash, this.linguisticTypeList);
            ((AnnexSearchTier)serializable).parentTier = (AnnexSearchTier)hashMap.get(((AnnexTier)serializable2).parentTier);
            ((AnnexSearchTier)serializable).isTimeAligned = ((AnnexTier)serializable2).hasVirtualTime;
            ((AnnexSearchTier)serializable).transcription = annexSearchTranscription;
            arrayList = ((AnnexTier)serializable2).annotations;
            ArrayList arrayList4 = ((AnnexSearchTier)serializable).annotations;
            int n5 = 0;
            while (n5 < arrayList.size()) {
                annexAnnotation = (AnnexAnnotation)arrayList.get(n5);
                AnnexSearchAnnotation annexSearchAnnotation = (AnnexSearchAnnotation)arrayList4.get(n5);
                annexSearchAnnotation.annotationValueIndex = (Integer)hashMap2.get(annexAnnotation.value);
                annexSearchAnnotation.beginTime = annexAnnotation.beginTime;
                annexSearchAnnotation.duration = (int)(annexAnnotation.endTime - annexAnnotation.beginTime);
                annexSearchAnnotation.isTimeAligned = annexAnnotation.isTimeAligned;
                annexSearchAnnotation.refAnnotation = (AnnexSearchAnnotation)hashMap2.get(annexAnnotation.refAnnotation);
                annexSearchAnnotation.annotationIndex = n5++;
                annexSearchAnnotation.tier = serializable;
            }
            annexSearchTranscription.nAnnotations += arrayList4.size();
        }
        ++this.nIndexedTranscriptions;
    }

    private void remove(String string) {
        if (!this.nodeIdHash.containsKey(string)) {
            return;
        }
        int n = (Integer)this.nodeIdHash.get(string);
        HashSet hashSet = (HashSet)this.nodeIdAnnotationIndexSetList.get(n);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            String string2 = (String)this.annotationList.get(n2);
            ArrayList arrayList = (ArrayList)this.annotationRefList.get(n2);
            for (int i = 0; i < arrayList.size(); ++i) {
                AnnexSearchAnnotation annexSearchAnnotation = (AnnexSearchAnnotation)arrayList.get(i);
                if (annexSearchAnnotation.annotationValueIndex != n2 || !this.getNodeIdFor(annexSearchAnnotation).equals(string)) continue;
                arrayList.remove(annexSearchAnnotation);
                break;
            }
            if (arrayList.size() != 0) continue;
            this.annotationRefList.set(n2, null);
            this.annotationList.set(n2, null);
            this.annotationHash.remove(string2);
            --this.nUniqueAnnotations;
        }
        this.nodeIdToTranscriptionHash.put(string, null);
        hashSet.clear();
        this.nodeIdAnnotationIndexSetList.set(n, null);
        this.nodeIdList.set(n, null);
        this.nodeIdHash.remove(string);
    }

    private void update(String string) {
        this.remove(string);
        this.add(string);
    }

    private String getNodeIdFor(AnnexSearchAnnotation annexSearchAnnotation) {
        return this.getNodeIdFor(annexSearchAnnotation.tier);
    }

    private String getNodeIdFor(AnnexSearchTier annexSearchTier) {
        return (String)this.nodeIdList.get(annexSearchTier.transcription.nodeIdIndex);
    }

    private ArrayList getStatistics() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(this.nIndexedTranscriptions));
        arrayList.add(new Integer(this.nIndexedTiers));
        arrayList.add(new Integer(this.nIndexedAnnotations));
        arrayList.add(new Integer(this.nUniqueAnnotations));
        return arrayList;
    }

    private void save() {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        arrayList.add(new Integer(this.nIndexedTranscriptions));
        arrayList.add(new Integer(this.nIndexedTiers));
        arrayList.add(new Integer(this.nIndexedAnnotations));
        arrayList.add(new Integer(this.nUniqueAnnotations));
        arrayList.add(this.nodeIdToTranscriptionHash);
        arrayList.add(this.transcriptionList);
        arrayList.add(this.annotationHash);
        arrayList.add(this.annotationList);
        arrayList.add(this.annotationRefList);
        arrayList.add(this.nodeIdHash);
        arrayList.add(this.nodeIdList);
        arrayList.add(this.nodeIdAnnotationIndexSetList);
        arrayList.add(this.tierNameHash);
        arrayList.add(this.tierNameList);
        arrayList.add(this.participantHash);
        arrayList.add(this.participantList);
        arrayList.add(this.defaultLocaleHash);
        arrayList.add(this.defaultLocaleList);
        arrayList.add(this.linguisticTypeHash);
        arrayList.add(this.linguisticTypeList);
        arrayList.add(this.treeToNode);
        arrayList.add(this.nodeToTree);
        arrayList.add(this.subNodes);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("search-engine.dat");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(arrayList);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load() {
        this.reset();
        System.out.println("loading search engine data...");
        ArrayList arrayList = null;
        try {
            FileInputStream fileInputStream = new FileInputStream("search-engine.dat");
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            arrayList = (ArrayList)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (arrayList != null) {
            this.nIndexedTranscriptions = (Integer)arrayList.get(0);
            this.nIndexedTiers = (Integer)arrayList.get(1);
            this.nIndexedAnnotations = (Integer)arrayList.get(2);
            this.nUniqueAnnotations = (Integer)arrayList.get(3);
            this.nodeIdToTranscriptionHash = (HashMap)arrayList.get(4);
            this.transcriptionList = (ArrayList)arrayList.get(5);
            this.annotationHash = (HashMap)arrayList.get(6);
            this.annotationList = (ArrayList)arrayList.get(7);
            this.annotationRefList = (ArrayList)arrayList.get(8);
            this.nodeIdHash = (HashMap)arrayList.get(9);
            this.nodeIdList = (ArrayList)arrayList.get(10);
            this.nodeIdAnnotationIndexSetList = (ArrayList)arrayList.get(11);
            this.tierNameHash = (HashMap)arrayList.get(12);
            this.tierNameList = (ArrayList)arrayList.get(13);
            this.participantHash = (HashMap)arrayList.get(14);
            this.participantList = (ArrayList)arrayList.get(15);
            this.defaultLocaleHash = (HashMap)arrayList.get(16);
            this.defaultLocaleList = (ArrayList)arrayList.get(17);
            this.linguisticTypeHash = (HashMap)arrayList.get(18);
            this.linguisticTypeList = (ArrayList)arrayList.get(19);
            this.treeToNode = (HashMap)arrayList.get(20);
            this.nodeToTree = (HashMap)arrayList.get(21);
            this.subNodes = (HashMap)arrayList.get(22);
        } else {
            System.out.println("Error while loading search engine data file");
        }
    }

    private void reset() {
        this.nIndexedTranscriptions = 0;
        this.nIndexedTiers = 0;
        this.nIndexedAnnotations = 0;
        this.nUniqueAnnotations = 0;
        this.nodeIdToTranscriptionHash.clear();
        this.transcriptionList.clear();
        this.annotationHash.clear();
        this.annotationList.clear();
        this.annotationRefList.clear();
        this.nodeIdHash.clear();
        this.nodeIdList.clear();
        this.nodeIdAnnotationIndexSetList.clear();
        this.tierNameHash.clear();
        this.tierNameList.clear();
        this.participantHash.clear();
        this.participantList.clear();
        this.defaultLocaleHash.clear();
        this.defaultLocaleList.clear();
        this.linguisticTypeHash.clear();
        this.linguisticTypeList.clear();
        this.resultHash.clear();
        this.sessionHash.clear();
        this.treeToNode.clear();
        this.nodeToTree.clear();
        this.subNodes.clear();
    }

    private String[] read_nodelist() {
        String string = null;
        String[] stringArray = null;
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("nodes.txt"));
            stringArray = new String[10];
            while ((string = bufferedReader.readLine()) != null) {
                stringArray[n++] = string;
                if (n <= 9) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    private void read_config() {
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("search_config.txt"));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("=");
                if (stringArray.length <= 1) continue;
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                if (string2.equals("corpusDbName")) {
                    AnnexUtil.setCorpusDbURL(string3);
                    continue;
                }
                if (string2.equals("corpusDbUser")) {
                    AnnexUtil.setCorpusDbUser(string3);
                    continue;
                }
                if (string2.equals("corpusDbPassword")) {
                    AnnexUtil.setCorpusDbPassword(string3);
                    continue;
                }
                if (string2.equals("searchServerName")) {
                    AnnexUtil.setSearchDbURL(string3);
                    continue;
                }
                if (!string2.equals("searchServerPort")) continue;
                AnnexUtil.setSearchServerPort(string3);
            }
        }
        catch (Exception exception) {
            AnnexUtil.log("AnnexSearchEngine", 1, "Problems with search_config.txt");
        }
    }

    public void init() {
        AnnexUtil.log("AnnexSearchEngine", 1, "\n\n");
        AnnexUtil.log("AnnexSearchEngine", 1, "Initializing....");
        this.reset();
        this.read_config();
        CorpusStructureDB corpusStructureDB = AnnexUtil.getCorpusStructureDB();
        String[] stringArray = new String[1];
        String[] stringArray2 = null;
        String string = null;
        String string2 = corpusStructureDB.getRootNodeId();
        String[] stringArray3 = this.read_nodelist();
        if (stringArray3 == null) {
            stringArray3 = new String[]{string2};
        }
        for (int i = 0; i < stringArray3.length && stringArray3[i] != null; ++i) {
            string2 = stringArray3[i];
            AnnexUtil.log("AnnexSearchEngine", 1, "Indexing: " + string2);
            AnnexUtil.log("AnnexSearchEngine", 1, "\n\n");
            stringArray[0] = "text/x-shoebox-text";
            stringArray2 = corpusStructureDB.getDescendants(string2, 8, stringArray, string, true);
            AnnexUtil.log("AnnexSearchEngine", 1, "found " + stringArray2.length + " SHOEBOX files");
            int n = stringArray2.length;
            int n2 = this.add(stringArray2);
            AnnexUtil.log("AnnexSearchEngine", 1, "\n\n");
            stringArray[0] = "text/x-chat";
            stringArray2 = corpusStructureDB.getDescendants(string2, 8, stringArray, string, true);
            AnnexUtil.log("AnnexSearchEngine", 1, "parsing " + stringArray2.length + " CHAT files");
            int n3 = stringArray2.length;
            int n4 = this.add(stringArray2);
            AnnexUtil.log("AnnexSearchEngine", 1, "\n\n");
            stringArray[0] = "text/x-eaf+xml";
            stringArray2 = corpusStructureDB.getDescendants(string2, 8, stringArray, string, true);
            AnnexUtil.log("AnnexSearchEngine", 1, "parsing " + stringArray2.length + " EAF files");
            int n5 = stringArray2.length;
            int n6 = this.add(stringArray2);
            AnnexUtil.log("AnnexSearchEngine", 1, "\n\n");
            stringArray[0] = "text/plain";
            stringArray2 = corpusStructureDB.getDescendants(string2, 8, stringArray, string, true);
            AnnexUtil.log("AnnexSearchEngine", 1, "parsing " + stringArray2.length + " PLAIN TEXT files");
            int n7 = stringArray2.length;
            int n8 = this.add(stringArray2);
            AnnexUtil.log("AnnexSearchEngine", 1, "\n\n");
            stringArray[0] = "text/html";
            stringArray2 = corpusStructureDB.getDescendants(string2, 8, stringArray, string, true);
            AnnexUtil.log("AnnexSearchEngine", 1, "parsing " + stringArray2.length + " HTML TEXT files");
            n7 += stringArray2.length;
            n8 += this.add(stringArray2);
            AnnexUtil.log("AnnexSearchEngine", 1, "\n\n");
            stringArray[0] = "text/xml";
            stringArray2 = corpusStructureDB.getDescendants(string2, 8, stringArray, string, true);
            AnnexUtil.log("AnnexSearchEngine", 1, "parsing " + stringArray2.length + " XML TEXT files");
            n7 += stringArray2.length;
            n8 += this.add(stringArray2);
            AnnexUtil.log("AnnexSearchEngine", 0, "\n\n");
            AnnexUtil.log("AnnexSearchEngine", 0, "Summary:");
            AnnexUtil.log("AnnexSearchEngine", 0, "Tried to parse " + n + " SHOEBOX files, " + n2 + " were existing and valid");
            AnnexUtil.log("AnnexSearchEngine", 0, "Tried to parse " + n3 + " CHAT files, " + n4 + " were existing and valid");
            AnnexUtil.log("AnnexSearchEngine", 0, "Tried to parse " + n5 + " EAF files, " + n6 + " were existing and valid");
            AnnexUtil.log("AnnexSearchEngine", 0, "Tried to parse " + n7 + " TEXT files, " + n8 + " were existing and valid");
            AnnexUtil.log("AnnexSearchEngine", 0, "The search engine now contains " + this.nIndexedAnnotations + " annotations (" + this.annotationList.size() + " are unique)");
            this.collectGarbage();
            AnnexUtil.log("AnnexSearchEngine", 0, "Used memory = " + Runtime.getRuntime().totalMemory() / 1000000L + "Mbyte (max alowed = " + Runtime.getRuntime().maxMemory() / 1000000L + " MByte)");
            AnnexUtil.log("AnnexSearchEngine", 0, "Bytes per annotation: " + Runtime.getRuntime().totalMemory() / (long)this.nIndexedAnnotations);
        }
    }

    private int add(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = new int[3];
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = this.add_new(stringArray[i]);
            boolean bl3 = n2 == 1;
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
            if (!bl3 || ++n % 10 != 0) continue;
            AnnexUtil.log("AnnexSearchEngine", 0, "The search engine now contains " + this.nIndexedAnnotations + " annotations (" + this.annotationList.size() + " are unique)");
            AnnexUtil.log("AnnexSearchEngine", 0, "Used memory = " + Runtime.getRuntime().totalMemory() / 1000000L + "Mbyte (max alowed = " + Runtime.getRuntime().maxMemory() / 1000000L + " MByte)");
            if (this.nIndexedAnnotations <= 0) continue;
            AnnexUtil.log("AnnexSearchEngine", 0, "STAT(f,a,u,bpa,um): " + n + "," + this.nIndexedAnnotations + "," + this.annotationList.size() + "," + Runtime.getRuntime().totalMemory() / (long)this.nIndexedAnnotations + "," + Runtime.getRuntime().totalMemory());
        }
        System.out.println("NON_EXIST: " + nArray[0]);
        System.out.println("   **GOOD: " + nArray[1]);
        System.out.println("PARSE_ERR: " + nArray[2]);
        return n;
    }

    private int add(Object object, HashMap hashMap, ArrayList arrayList) {
        int n;
        if (!hashMap.containsKey(object)) {
            arrayList.add(object);
            n = arrayList.size() - 1;
            hashMap.put(object, new Integer(n));
        } else {
            n = (Integer)hashMap.get(object);
        }
        return n;
    }

    private synchronized Long getUniqueKey() {
        return new Long(this.uniqueKey++);
    }

    private void collectGarbage() {
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void initLeipzig(String string) {
        String string2 = AnnexUtil.getCorpusStructureDB().getNamePath(string);
        this.nodeToTree.put(string, string2);
        this.treeToNode.put(string2, string);
        ArrayList<String> arrayList = new ArrayList<String>();
        this.subNodes.put(string, arrayList);
        try {
            String[] stringArray = AnnexUtil.getCorpusStructureDB().getSubnodes(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!AnnexUtil.getArchiveObjectsDB().isAccessible(stringArray[i])) continue;
                    ++this.nLeipzigNodes;
                    arrayList.add(stringArray[i]);
                    this.initLeipzig(stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ArrayList getTierContent(String string, String string2) {
        AnnexSearchTranscription annexSearchTranscription = (AnnexSearchTranscription)this.nodeIdToTranscriptionHash.get(string);
        if (annexSearchTranscription == null) {
            return null;
        }
        boolean bl = false;
        TreeSet treeSet = new TreeSet();
        for (int i = 0; i < annexSearchTranscription.tiers.size(); ++i) {
            AnnexSearchTier annexSearchTier = (AnnexSearchTier)annexSearchTranscription.tiers.get(i);
            String string3 = (String)this.tierNameList.get(annexSearchTier.tierNameIndex);
            if (!string2.equals(string3)) continue;
            bl = true;
            for (int j = 0; j < annexSearchTier.annotations.size(); ++j) {
                AnnexSearchAnnotation annexSearchAnnotation = (AnnexSearchAnnotation)annexSearchTier.annotations.get(j);
                treeSet.add(this.annotationList.get(annexSearchAnnotation.annotationValueIndex));
            }
            break;
        }
        if (bl) {
            return new ArrayList(treeSet);
        }
        return null;
    }

    private String getNodeIdForTreePath(String string) {
        return (String)this.treeToNode.get(string);
    }

    private String getTreePathForNodeId(String string) {
        return (String)this.nodeToTree.get(string);
    }

    private ArrayList getAnnotationSubNodes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.nodeIdHash.containsKey(string)) {
            arrayList.add(string);
        } else {
            ArrayList arrayList2 = (ArrayList)this.subNodes.get(string);
            if (arrayList2 != null) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ArrayList arrayList3 = this.getAnnotationSubNodes((String)arrayList2.get(i));
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        arrayList.add((String)arrayList3.get(j));
                    }
                }
            }
        }
        return arrayList;
    }

    static {
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout()));
        Logger.getRootLogger().setLevel(Level.ALL);
    }
}

