/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.oldsearch;

import java.io.File;
import java.util.ArrayList;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.util.AnnexUtil;
import mpi.corpusstructure.CorpusStructureDB;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class CorpusChecker {
    private static void parse(String[] stringArray, int n, CorpusStructureDB corpusStructureDB, String string) {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string2 = AnnexUtil.getFilePathFor(stringArray[n2]);
            File file = new File(string2);
            if (file.exists()) {
                arrayList.add(string2);
                AnnexTranscription annexTranscription = new AnnexTranscription(string2, n, file);
                if (annexTranscription.isValid()) {
                    arrayList3.add(string2);
                    continue;
                }
                arrayList4.add(string2);
                continue;
            }
            arrayList2.add(string2);
        }
        System.out.println();
        System.out.println("Non existing files: ");
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            System.out.println(string + " NE: " + arrayList2.get(n2));
        }
        System.out.println();
        System.out.println("Non parsable files: ");
        for (n2 = 0; n2 < arrayList4.size(); ++n2) {
            System.out.println(string + " NP: " + arrayList4.get(n2));
        }
        System.out.println();
        System.out.println("Parsable files: ");
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            System.out.println(string + " OK: " + arrayList3.get(n2));
        }
        System.out.println();
        System.out.println(string + " summary");
        System.out.println("Total checked files : " + stringArray.length);
        System.out.println("non existing files  : " + arrayList2.size());
        System.out.println("existing files      : " + arrayList.size());
        System.out.println("not parsable files  : " + arrayList4.size());
        System.out.println("parsable files      : " + arrayList3.size());
        System.out.println();
        System.out.println();
        System.out.println();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 2) {
            int n;
            String string = stringArray[0];
            int n2 = -1;
            if (string.toLowerCase().equals("chat")) {
                n2 = 1;
            } else if (string.toLowerCase().equals("eaf")) {
                n2 = 0;
            } else if (string.toLowerCase().equals("textplain")) {
                n2 = 3;
            } else if (string.toLowerCase().equals("texthtml")) {
                n2 = 4;
            } else if (string.toLowerCase().equals("textxml")) {
                n2 = 5;
            }
            if (n2 == -1) {
                System.out.println("Unknown type: " + string);
                System.out.println("Please choose one from: chat eaf textplain textxml texthtml");
                System.exit(0);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 1; n < stringArray.length; ++n) {
                arrayList.add(stringArray[n]);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                String string2 = (String)arrayList.get(n);
                File file = new File(string2);
                if (file.exists()) {
                    AnnexTranscription annexTranscription = new AnnexTranscription(string2, n2, file);
                    if (annexTranscription.isValid()) {
                        System.out.println("Valid " + string + " file:\n" + string2 + "\n");
                        continue;
                    }
                    System.out.println("ERROR!\nNOT Valid " + string + " file:\n" + string2 + "\n");
                    continue;
                }
                System.out.println("non existing file: " + string2);
            }
        } else if (stringArray.length == 2) {
            File file;
            String string = stringArray[0];
            String string3 = stringArray[1];
            int n = -1;
            if (string.toLowerCase().equals("chat")) {
                n = 1;
            } else if (string.toLowerCase().equals("eaf")) {
                n = 0;
            } else if (string.toLowerCase().equals("textplain")) {
                n = 3;
            } else if (string.toLowerCase().equals("texthtml")) {
                n = 4;
            } else if (string.toLowerCase().equals("textxml")) {
                n = 5;
            }
            if (n == -1) {
                System.out.println("Unknown type: " + string);
                System.out.println("Please choose one from: chat eaf textplain textxml texthtml");
                System.exit(0);
            }
            if ((file = new File(string3)).exists()) {
                AnnexTranscription annexTranscription = new AnnexTranscription(string3, n, file);
                if (annexTranscription.isValid()) {
                    System.out.println("Valid " + string + " file");
                } else {
                    System.out.println("ERROR!\nNOT Valid " + string + " file:\n" + string3);
                }
            } else {
                System.out.println("non existing file: " + string3);
            }
        } else if (stringArray.length == 0) {
            CorpusStructureDB corpusStructureDB = AnnexUtil.getCorpusStructureDB();
            String[] stringArray2 = corpusStructureDB.getDescendants(corpusStructureDB.getRootNodeId(), 8, "text/x-chat");
            System.out.println("Number of CHAT files = " + stringArray2.length);
            CorpusChecker.parse(stringArray2, 1, corpusStructureDB, "CHAT");
            stringArray2 = corpusStructureDB.getDescendants(corpusStructureDB.getRootNodeId(), 8, "text/x-eaf+xml");
            System.out.println("Number of EAF files = " + stringArray2.length);
            CorpusChecker.parse(stringArray2, 0, corpusStructureDB, "EAF");
            stringArray2 = corpusStructureDB.getDescendants(corpusStructureDB.getRootNodeId(), 8, "text/plain");
            System.out.println("Number of PLAIN TEXT files = " + stringArray2.length);
            CorpusChecker.parse(stringArray2, 3, corpusStructureDB, "TEXT PLAIN");
            stringArray2 = corpusStructureDB.getDescendants(corpusStructureDB.getRootNodeId(), 8, "text/xml");
            System.out.println("Number of XML TEXT files = " + stringArray2.length);
            CorpusChecker.parse(stringArray2, 5, corpusStructureDB, "TEXT XML");
            stringArray2 = corpusStructureDB.getDescendants(corpusStructureDB.getRootNodeId(), 8, "text/html");
            System.out.println("Number of HTML TEXT files = " + stringArray2.length);
            CorpusChecker.parse(stringArray2, 4, corpusStructureDB, "TEXT HTML");
        } else {
            System.out.println("\nUsage:\n");
            System.out.println("java -jar corpus-check.jar [type] [path+] | grep -v \"###\"\n");
            System.out.println("\t\tvalid type strings: chat eaf text\n");
            System.out.println("Or for a check of all chat, eaf and text resources under the corpus root:");
            System.out.println("java -jar corpus-check.jar | grep -v \"###\"\n\n");
        }
    }

    static {
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout()));
        Logger.getRootLogger().setLevel(Level.ALL);
    }
}

