/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.oldsearch;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import mpi.annex.oldsearch.SearchEngineCommand;
import mpi.annex.util.AnnexUtil;

public class SearchClient {
    private String serverName;
    private int serverPort;

    public SearchClient(String string) {
        this.serverName = string != null ? string : "lux08.mpi.nl";
        this.serverPort = 2000;
    }

    public SearchClient(String string, int n) {
        this.serverName = string != null ? string : "lux08.mpi.nl";
        this.serverPort = n;
    }

    public boolean serverIsUp() {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("Ping");
        ArrayList arrayList = this.process(searchEngineCommand);
        return arrayList != null;
    }

    public void resetDB() {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("Reset");
        this.process(searchEngineCommand);
    }

    public void initialize(ArrayList arrayList) {
        long l = System.currentTimeMillis();
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("Init");
        searchEngineCommand.addParameter(arrayList);
        this.process(searchEngineCommand);
        long l2 = System.currentTimeMillis() - l;
        AnnexUtil.log("SearchClient", 0, "init took " + l2 / 1000L + "seconds");
        this.printSearchEngineStatistics();
    }

    public void initializeClientSide(ArrayList arrayList) {
        this.resetDB();
        long l = System.currentTimeMillis();
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnexUtil.log("SearchClient", 0, i + " " + arrayList.size());
            String string = (String)arrayList.get(i);
            this.add(string);
        }
        long l2 = System.currentTimeMillis() - l;
        AnnexUtil.log("SearchClient", 0, "init took " + l2 / 1000L + "seconds");
        this.printSearchEngineStatistics();
    }

    public void printSearchEngineStatistics() {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("Statistics");
        ArrayList arrayList = this.process(searchEngineCommand);
        AnnexUtil.log("SearchClient", 0, "\nSearch engine statistics");
        AnnexUtil.log("SearchClient", 0, "Number of added transcriptions      : " + (Integer)arrayList.get(0));
        AnnexUtil.log("SearchClient", 0, "Number of added tiers      : " + (Integer)arrayList.get(1));
        AnnexUtil.log("SearchClient", 0, "Number of added annotions  : " + (Integer)arrayList.get(2));
        AnnexUtil.log("SearchClient", 0, "Number of unique annotions : " + (Integer)arrayList.get(3));
    }

    public ArrayList checkNodes(ArrayList arrayList) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("CheckNodes");
        searchEngineCommand.addParameter(arrayList);
        return this.process(searchEngineCommand);
    }

    public void add(String string) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("Add");
        searchEngineCommand.addParameter(string);
        this.process(searchEngineCommand);
    }

    public void remove(String string) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("Remove");
        searchEngineCommand.addParameter(string);
        this.process(searchEngineCommand);
    }

    public void update(String string) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("Update");
        searchEngineCommand.addParameter(string);
        this.process(searchEngineCommand);
    }

    public void purge(String string) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("PURGE");
        searchEngineCommand.addParameter(string);
        this.process(searchEngineCommand);
    }

    public ArrayList getTierNamesIn(ArrayList arrayList) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("TierNames");
        searchEngineCommand.addParameter(arrayList);
        return this.process(searchEngineCommand);
    }

    public ArrayList getAllTierNames() {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("AllTierNames");
        return this.process(searchEngineCommand);
    }

    public ArrayList getParticipantsIn(ArrayList arrayList) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("Participants");
        searchEngineCommand.addParameter(arrayList);
        return this.process(searchEngineCommand);
    }

    public ArrayList find(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, ArrayList arrayList6) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("Find");
        searchEngineCommand.addParameter(string);
        searchEngineCommand.addParameter(arrayList);
        searchEngineCommand.addParameter(arrayList2);
        searchEngineCommand.addParameter(arrayList3);
        searchEngineCommand.addParameter(arrayList4);
        searchEngineCommand.addParameter(arrayList5);
        searchEngineCommand.addParameter(arrayList6);
        return this.process(searchEngineCommand);
    }

    public ArrayList getHitNodeIds(Long l) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("GetResult");
        searchEngineCommand.addParameter(l);
        return this.process(searchEngineCommand);
    }

    public ArrayList getHitInfo(Long l, String string) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("GetResult");
        searchEngineCommand.addParameter(l);
        searchEngineCommand.addParameter(string);
        return this.process(searchEngineCommand);
    }

    public ArrayList getHitInfo(Long l, int n, int n2) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("GetResult");
        searchEngineCommand.addParameter(l);
        searchEngineCommand.addParameter(new Integer(n));
        searchEngineCommand.addParameter(new Integer(n2));
        return this.process(searchEngineCommand);
    }

    public ArrayList saveDB() {
        ArrayList arrayList = this.process(new SearchEngineCommand("Save"));
        AnnexUtil.log("SearchClient", 0, "Save status: " + (Boolean)arrayList.get(0));
        AnnexUtil.log("SearchClient", 0, "save took " + (Long)arrayList.get(1) / 1000L + "seconds");
        return arrayList;
    }

    public ArrayList loadDB() {
        ArrayList arrayList = this.process(new SearchEngineCommand("Load"));
        AnnexUtil.log("SearchClient", 0, "Save status: " + (Boolean)arrayList.get(0));
        AnnexUtil.log("SearchClient", 0, "load took " + (Long)arrayList.get(1) / 1000L + "seconds");
        return arrayList;
    }

    private ArrayList process(SearchEngineCommand searchEngineCommand) {
        ArrayList arrayList = null;
        try {
            Socket socket = new Socket(this.serverName, this.serverPort);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(searchEngineCommand);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            arrayList = (ArrayList)objectInputStream.readObject();
            objectInputStream.close();
            objectOutputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            AnnexUtil.log((Object)"SearchClient", 0, exception);
        }
        return arrayList;
    }

    public ArrayList getTierNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return this.getTierNamesIn(arrayList);
    }

    public ArrayList getTierContent(String string, String string2) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("TierContent");
        searchEngineCommand.addParameter(string);
        searchEngineCommand.addParameter(string2);
        return this.process(searchEngineCommand);
    }

    public String getNodeIdForTreePath(String string) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("TreePathToNodeId");
        searchEngineCommand.addParameter(string);
        ArrayList arrayList = this.process(searchEngineCommand);
        return (String)arrayList.get(0);
    }

    public String getTreePathForNodeId(String string) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("NodeIdToTreePath");
        searchEngineCommand.addParameter(string);
        ArrayList arrayList = this.process(searchEngineCommand);
        return (String)arrayList.get(0);
    }

    public ArrayList getAnnotationSubNodes(String string) {
        SearchEngineCommand searchEngineCommand = new SearchEngineCommand("SubNodes");
        searchEngineCommand.addParameter(string);
        return this.process(searchEngineCommand);
    }
}

