/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.oldsearch;

import java.io.File;
import java.io.FileInputStream;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mpi.annex.oldsearch.AnnexSearchAnnotation;
import mpi.annex.util.AnnexUtil;

public class SearchUtil {
    public static final String regExMetaChars = "\\.^$*+?{}[]()|";
    public static final String delimiterString = "{}{[]3q)]";
    public static final String CONSTRAINT_SAME_ANNOTATION = "in the same annotation";
    public static final String CONSTRAINT_PREVIOUS_ANNOTATION = "in the annotation before";
    public static final String CONSTRAINT_NEXT_ANNOTATION = "in the annotation after";
    public static final String CONSTRAINT_POSITION = "at relative position";
    public static final String CONSTRAINT_BEFORE_TIME_BEFORE = "before time before";
    public static final String CONSTRAINT_WITHIN_TIME_BEFORE = "within time before";
    public static final String CONSTRAINT_WITHIN_TIME_AFTER = "within time after";
    public static final String CONSTRAINT_AFTER_TIME_AFTER = "after time after";

    public static void getRange(AnnexSearchAnnotation annexSearchAnnotation, String string, ArrayList arrayList) {
        try {
            int n;
            long l;
            if (string.indexOf(CONSTRAINT_SAME_ANNOTATION) >= 0) {
                arrayList.add(annexSearchAnnotation);
            } else if (string.indexOf(CONSTRAINT_PREVIOUS_ANNOTATION) >= 0) {
                if (annexSearchAnnotation.annotationIndex > 0) {
                    arrayList.add(annexSearchAnnotation.tier.annotations.get(annexSearchAnnotation.annotationIndex - 1));
                }
            } else if (string.indexOf(CONSTRAINT_NEXT_ANNOTATION) >= 0) {
                if (annexSearchAnnotation.annotationIndex + 1 < annexSearchAnnotation.tier.annotations.size()) {
                    arrayList.add(annexSearchAnnotation.tier.annotations.get(annexSearchAnnotation.annotationIndex + 1));
                }
            } else if (string.indexOf(CONSTRAINT_POSITION) >= 0) {
                int n2 = string.indexOf("&");
                int n3 = Integer.parseInt(string.substring(n2 + 1).trim());
                if (n3 < 0) {
                    if (annexSearchAnnotation.annotationIndex + n3 >= 0) {
                        arrayList.add(annexSearchAnnotation.tier.annotations.get(annexSearchAnnotation.annotationIndex + n3));
                    }
                } else if (annexSearchAnnotation.annotationIndex + n3 < annexSearchAnnotation.tier.annotations.size()) {
                    arrayList.add(annexSearchAnnotation.tier.annotations.get(annexSearchAnnotation.annotationIndex + n3));
                }
            } else if (string.indexOf(CONSTRAINT_BEFORE_TIME_BEFORE) >= 0) {
                int n4 = string.indexOf("&");
                long l2 = Long.parseLong(string.substring(n4 + 1).trim());
                if (l2 >= 0L) {
                    long l3 = annexSearchAnnotation.beginTime - l2;
                    for (int i = 0; i < annexSearchAnnotation.tier.annotations.size(); ++i) {
                        AnnexSearchAnnotation annexSearchAnnotation2 = (AnnexSearchAnnotation)annexSearchAnnotation.tier.annotations.get(i);
                        if (annexSearchAnnotation2.beginTime < l3) {
                            arrayList.add(annexSearchAnnotation2);
                            continue;
                        }
                        break;
                    }
                }
            } else if (string.indexOf(CONSTRAINT_WITHIN_TIME_BEFORE) >= 0) {
                int n5 = string.indexOf("&");
                long l4 = Long.parseLong(string.substring(n5 + 1).trim());
                if (l4 >= 0L) {
                    long l5 = annexSearchAnnotation.beginTime - l4;
                    for (int i = 0; i < annexSearchAnnotation.tier.annotations.size(); ++i) {
                        AnnexSearchAnnotation annexSearchAnnotation3 = (AnnexSearchAnnotation)annexSearchAnnotation.tier.annotations.get(i);
                        if (annexSearchAnnotation3.beginTime > l5) break;
                    }
                    for (int i = i; i < annexSearchAnnotation.tier.annotations.size(); ++i) {
                        AnnexSearchAnnotation annexSearchAnnotation4 = (AnnexSearchAnnotation)annexSearchAnnotation.tier.annotations.get(i);
                        if (annexSearchAnnotation4.beginTime < annexSearchAnnotation.beginTime) {
                            arrayList.add(annexSearchAnnotation4);
                            continue;
                        }
                        break;
                    }
                }
            } else if (string.indexOf(CONSTRAINT_WITHIN_TIME_AFTER) >= 0) {
                int n6 = string.indexOf("&");
                long l6 = Long.parseLong(string.substring(n6 + 1).trim());
                if (l6 >= 0L) {
                    long l7 = annexSearchAnnotation.beginTime + (long)annexSearchAnnotation.duration + l6;
                    for (int i = annexSearchAnnotation.annotationIndex + 1; i < annexSearchAnnotation.tier.annotations.size(); ++i) {
                        AnnexSearchAnnotation annexSearchAnnotation5 = (AnnexSearchAnnotation)annexSearchAnnotation.tier.annotations.get(i);
                        if (annexSearchAnnotation5.beginTime < l7) {
                            arrayList.add(annexSearchAnnotation5);
                            continue;
                        }
                        break;
                    }
                }
            } else if (string.indexOf(CONSTRAINT_AFTER_TIME_AFTER) >= 0 && (l = Long.parseLong(string.substring((n = string.indexOf("&")) + 1).trim())) >= 0L) {
                long l8 = annexSearchAnnotation.beginTime + (long)annexSearchAnnotation.duration + l;
                for (int i = annexSearchAnnotation.annotationIndex + 1; i < annexSearchAnnotation.tier.annotations.size(); ++i) {
                    AnnexSearchAnnotation annexSearchAnnotation6 = (AnnexSearchAnnotation)annexSearchAnnotation.tier.annotations.get(i);
                    if (annexSearchAnnotation6.beginTime > l8) break;
                }
                for (int i = i; i < annexSearchAnnotation.tier.annotations.size(); ++i) {
                    AnnexSearchAnnotation annexSearchAnnotation7 = (AnnexSearchAnnotation)annexSearchAnnotation.tier.annotations.get(i);
                    arrayList.add(annexSearchAnnotation7);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Pattern getRegExpPattern(String string, boolean bl, boolean bl2) {
        Pattern pattern = null;
        if (bl) {
            pattern = bl2 ? Pattern.compile(string) : Pattern.compile(string, 2);
        }
        return pattern;
    }

    public static int countHits(String string, String string2, Pattern pattern, boolean bl, boolean bl2) {
        int n = 0;
        try {
            if (pattern != null) {
                Matcher matcher = pattern.matcher(string);
                if (bl2) {
                    if (matcher.find()) {
                        ++n;
                        while (matcher.find()) {
                            ++n;
                        }
                    }
                } else if (matcher.find()) {
                    ++n;
                    int n2 = matcher.start() + 1;
                    while (matcher.find(n2)) {
                        ++n;
                        n2 = matcher.start() + 1;
                    }
                }
            } else {
                if (!bl) {
                    string = string.toLowerCase();
                    string2 = string2.toLowerCase();
                }
                int n3 = string.length();
                int n4 = string2.length();
                int n5 = 0;
                if (bl2) {
                    if ((n5 = string.indexOf(string2, n5)) >= 0) {
                        ++n;
                        n5 += n4;
                        while (n5 < n3 && (n5 = string.indexOf(string2, n5)) >= 0) {
                            ++n;
                            n5 += n4;
                        }
                    }
                } else if ((n5 = string.indexOf(string2, n5)) >= 0) {
                    ++n;
                    ++n5;
                    while (n5 < n3 && (n5 = string.indexOf(string2, n5)) >= 0) {
                        ++n;
                        ++n5;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static String checkSearchPatterns(String string, boolean bl) {
        ArrayList arrayList = new ArrayList();
        SearchUtil.tokenize(string, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            String string3 = SearchUtil.convertSpecialPattern(string2, bl);
            if (!string3.equals(string2)) {
                string2 = string3;
                bl = true;
            }
            if (!bl) continue;
            try {
                Pattern pattern = Pattern.compile(string2);
                continue;
            }
            catch (Exception exception) {
                return exception.getMessage();
            }
        }
        return null;
    }

    public static String convertSpecialPattern(String string, boolean bl) {
        string = string.replaceAll("NOT\\s*\\(", "NOT(");
        String string2 = SearchUtil.processOR(string, bl);
        String string3 = "";
        if (string2.trim().toLowerCase().startsWith("[sdt]") || string2.trim().toLowerCase().startsWith("[mor]")) {
            if (string2.trim().length() == 5) {
                return string2;
            }
            string2 = string2.trim().substring(5).trim();
            ArrayList arrayList = SearchUtil.tokenize(string2);
            String string4 = "";
            String string5 = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                string5 = string4;
                string4 = (String)arrayList.get(i);
                if (string4.equals("^") && i == 0) {
                    string3 = string3 + "^\\s*";
                    continue;
                }
                if (string4.equals("$") && i == arrayList.size() - 1) {
                    string3 = string3 + "\\s*$";
                    continue;
                }
                if (string4.equals("#")) {
                    if (i == 0) {
                        string3 = string3 + "(^|\\s+)";
                    } else if (!string5.equals("^")) {
                        string3 = string3 + "\\s+";
                    }
                    string3 = string3 + "(\\S+)";
                    if (i != arrayList.size() - 1) continue;
                    string3 = string3 + "(\\s+|$)";
                    continue;
                }
                if (string4.indexOf(")|(") > 0) {
                    if (i == 0) {
                        string3 = string3 + "(^|\\s+)";
                    } else if (!string5.equals("^")) {
                        string3 = string3 + "\\s+";
                    }
                    string3 = string3 + string4;
                    continue;
                }
                if (!bl) {
                    string4 = SearchUtil.escapeRegExpChars(string4, null);
                }
                if (i == 0) {
                    string3 = string3 + "(^|\\s+)";
                } else if (!string5.equals("^")) {
                    string3 = string3 + "\\s+";
                }
                string4 = string4.startsWith("<") ? string4.substring(1) : "\\S*" + string4;
                string4 = string4.endsWith(">") ? (i == arrayList.size() - 1 ? string4.substring(0, string4.length() - 1) + "(\\s+|$)" : string4.substring(0, string4.length() - 1)) : string4 + "\\S*";
                string3 = string3 + string4;
            }
        } else if (string2.trim().startsWith("NOT(") && string2.trim().endsWith(")")) {
            string2 = string2.trim().substring(4, string2.trim().length() - 1);
            if (!bl) {
                string2 = SearchUtil.escapeRegExpChars(string2, null);
            }
            if (string2.startsWith("<")) {
                string2 = "(^|\\s+)" + string2.substring(1);
            }
            if (string2.endsWith(">")) {
                string2 = string2.substring(0, string2.length() - 1) + "(\\s+|$)";
            }
            string3 = "^((?!" + string2 + ").)*$";
        } else {
            string3 = !string2.equals(string) ? "(^|\\s+)" + string2 + "(\\s+|$)" : string2;
        }
        return string3;
    }

    public static String escapeRegExpChars(String string, ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (regExMetaChars.indexOf(c) >= 0) {
                if (c != '(' && c != ')' && c != '|') {
                    stringBuffer.append('\\');
                } else {
                    Integer n = new Integer(i);
                    if (arrayList == null || !arrayList.contains(n)) {
                        stringBuffer.append('\\');
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String processOR(String string, boolean bl) {
        if (string.equals(string.replaceAll("\\)\\s*OR\\s*\\(", ")|("))) {
            return string;
        }
        string = string.replaceAll("\\)\\s*OR\\s*\\(", ")|(");
        ArrayList arrayList = SearchUtil.tokenize(string);
        String string2 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3.indexOf(")|(") > 0) {
                ArrayList arrayList2 = SearchUtil.getTokensInORExpression(string3);
                string3 = "((";
                for (int j = 0; j < arrayList2.size(); ++j) {
                    String string4 = (String)arrayList2.get(j);
                    if (!bl) {
                        string4 = SearchUtil.escapeRegExpChars(string4, null);
                    }
                    string4 = (string4 = string4.startsWith("<") ? string4.substring(1) : "\\S*" + string4).endsWith(">") ? (i == arrayList.size() - 1 ? string4.substring(0, string4.length() - 1) + "(\\s+|$)" : string4.substring(0, string4.length() - 1)) : string4 + "\\S*";
                    string3 = j == arrayList2.size() - 1 ? string3 + string4 + "))" : string3 + string4 + ")|(";
                }
            }
            string2 = string2 + string3 + " ";
        }
        return string2.trim();
    }

    public static ArrayList getTokensInORExpression(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '(') continue;
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = i + 1; j < string.length(); ++j) {
                c = string.charAt(j);
                if (c == ')') {
                    arrayList.add(stringBuffer.toString());
                    i = j;
                    continue block0;
                }
                stringBuffer.append(c);
            }
        }
        return arrayList;
    }

    public static ArrayList tokenize(String string) {
        char c;
        if ((string = string.trim()).startsWith("^")) {
            string = "^ " + string.substring(1);
        }
        int n = string.lastIndexOf("$");
        int n2 = string.lastIndexOf("\\");
        if (n == string.length() - 1 && n2 != string.length() - 2) {
            string = string.substring(0, string.length() - 1) + " $";
        }
        ArrayList arrayList = SearchUtil.getORPatternInfo(string);
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        for (c = '\u0000'; c < arrayList.size(); c += 5) {
            arrayList2.add(arrayList.get(c));
            arrayList3.add(arrayList.get(c + 4));
        }
        ArrayList<String> arrayList4 = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c != ' ') {
                stringBuffer.append(c);
                continue;
            }
            boolean bl = false;
            for (int j = 0; j < arrayList2.size(); ++j) {
                int n3 = (Integer)arrayList2.get(j);
                int n4 = (Integer)arrayList3.get(j);
                if (n3 >= i || i >= n4) continue;
                bl = true;
                break;
            }
            if (bl) {
                stringBuffer.append(c);
                continue;
            }
            arrayList4.add(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            while (c == ' ' && i < string.length()) {
                c = string.charAt(++i);
            }
            --i;
        }
        if (stringBuffer.length() > 0) {
            arrayList4.add(stringBuffer.toString());
        }
        return arrayList4;
    }

    public static boolean hasNOTPattern(String string) {
        string = string.replaceAll("NOT\\s*\\(", "NOT(");
        int n = string.indexOf("NOT(");
        while (n >= 0) {
            if (n == 0) {
                return true;
            }
            char c = string.charAt(n - 1);
            if (c != '\\') {
                return true;
            }
            n = string.indexOf("NOT(", n + 1);
        }
        return false;
    }

    public static String disableNOT(String string) {
        string = string.replaceAll("NOT\\s*\\(", "NOT(");
        int n = string.indexOf("NOT(");
        while (n >= 0) {
            int n2;
            int n3 = 0;
            for (n2 = n + 4; n2 < string.length(); ++n2) {
                char c = string.charAt(n2);
                if (c == ')') {
                    if (--n3 >= 0) continue;
                    break;
                }
                if (c != '(') continue;
                ++n3;
                if (string.charAt(n2 - 1) != '\\') continue;
                --n3;
            }
            string = string.substring(0, n) + "#" + string.substring(n2 + 1);
            n = string.indexOf("NOT(", n + 1);
        }
        return string;
    }

    public static String enableNOT(String string) {
        string = string.replaceAll("NOT\\s*\\(", "NOT(");
        int n = string.indexOf("NOT(");
        while (n >= 0) {
            int n2;
            int n3 = 0;
            for (n2 = n + 4; n2 < string.length(); ++n2) {
                char c = string.charAt(n2);
                if (c == ')') {
                    if (--n3 >= 0) continue;
                    break;
                }
                if (c != '(') continue;
                ++n3;
                if (string.charAt(n2 - 1) != '\\') continue;
                --n3;
            }
            string = string.substring(0, n) + string.substring(n + 4, n2) + string.substring(n2 + 1);
            n = string.indexOf("NOT(", n + 1);
        }
        return string;
    }

    public static ArrayList getORPatternInfo(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = string.indexOf(")|(");
        while (n >= 0) {
            char c;
            int n2;
            int n3 = 0;
            for (n2 = n - 1; n2 >= 0; --n2) {
                c = string.charAt(n2);
                if (c == '(') {
                    if (--n3 >= 0) continue;
                    arrayList.add(new Integer(n2));
                    break;
                }
                if (c != ')') continue;
                ++n3;
                if (n2 <= 0 || string.charAt(n2 - 1) != '\\') continue;
                --n3;
            }
            if (n2 < 0) {
                arrayList.add(new Integer(-1));
            }
            arrayList.add(new Integer(n));
            arrayList.add(new Integer(n + 1));
            arrayList.add(new Integer(n + 2));
            n3 = 0;
            for (n2 = n + 3; n2 < string.length(); ++n2) {
                c = string.charAt(n2);
                if (c == ')') {
                    if (--n3 >= 0) continue;
                    arrayList.add(new Integer(n2));
                    break;
                }
                if (c != '(') continue;
                ++n3;
                if (string.charAt(n2 - 1) != '\\') continue;
                --n3;
            }
            if (n2 >= string.length()) {
                arrayList.add(new Integer(-1));
            }
            n = string.indexOf(")|(", n + 1);
        }
        return arrayList;
    }

    public static void tokenize(String string, ArrayList arrayList) {
        arrayList.clear();
        int n = 0;
        int n2 = string.indexOf(delimiterString);
        while (n2 >= 0) {
            arrayList.add(string.substring(n, n2));
            n = n2 + delimiterString.length();
            n2 = string.indexOf(delimiterString, n2 + 1);
        }
    }

    public static int getAnnotationType(File file) {
        int n = -1;
        try {
            String[] stringArray = SearchUtil.readLines(file, null);
            String string = null;
            String string2 = null;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            if (stringArray.length > 1) {
                string2 = stringArray[1];
            }
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            if (string != null) {
                n2 = string.indexOf("<ANNOTATION_DOCUMENT");
                n3 = string.indexOf("\\_sh");
                n4 = string.indexOf("@Begin");
                n5 = string.indexOf("<!DOCTYPE Trans");
            }
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            if (string2 != null) {
                n6 = string2.indexOf("ANNOTATION_DOCUMENT");
                n7 = string2.indexOf("\\_sh");
                n8 = string2.indexOf("@Begin");
                n9 = string2.indexOf("<!DOCTYPE Trans");
            }
            if (n2 >= 0 || n6 >= 0) {
                n = 0;
            } else if (n3 >= 0 || n7 >= 0) {
                n = 2;
            } else if (n4 >= 0 || n8 >= 0) {
                n = 1;
            }
        }
        catch (Exception exception) {
            System.out.println("file name: " + file.getAbsolutePath());
            exception.printStackTrace();
        }
        return n;
    }

    public static String[] readLines(File file, String string) throws Exception {
        String[] stringArray = new String[]{""};
        if (file == null) {
            return stringArray;
        }
        try {
            Charset charset = Charset.forName("ISO-8859-1");
            if (string != null) {
                charset = Charset.forName(string);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            int n = (int)fileChannel.size();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            CharBuffer charBuffer = charsetDecoder.decode(mappedByteBuffer);
            String string2 = charBuffer.toString();
            stringArray = string2.split("\r?\n");
            fileChannel.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            if (AnnexUtil.debugLevel > 0) {
                System.out.println("readLines problem for file: " + file.getAbsolutePath() + "\nwith charset " + string);
            }
            throw exception;
        }
        return stringArray;
    }

    public static boolean contains(String[] stringArray, String string) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList getUniqueEAFFilesIn(ArrayList arrayList, ArrayList arrayList2) {
        Object object;
        int n;
        TreeSet<File> treeSet = new TreeSet<File>();
        for (n = 0; n < arrayList.size(); ++n) {
            object = new File((String)arrayList.get(n));
            if (!((File)object).exists() || !((File)object).isDirectory() || !((File)object).canRead()) continue;
            treeSet.addAll(SearchUtil.getAllEafFilesUnder((File)object));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            File file;
            object = (String)arrayList2.get(n);
            if (!((String)object).toLowerCase().endsWith(".eaf") || !(file = new File((String)object)).exists() || !file.canRead()) continue;
            treeSet.add(file);
        }
        ArrayList<File> arrayList3 = new ArrayList<File>();
        arrayList3.addAll(treeSet);
        return arrayList3;
    }

    public static ArrayList getAllEafFilesUnder(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isFile() && file2.canRead()) {
                if (!file2.getName().toLowerCase().endsWith(".eaf")) continue;
                arrayList.add(file2);
                continue;
            }
            if (!file2.isDirectory() || !file2.canRead()) continue;
            arrayList.addAll(SearchUtil.getAllEafFilesUnder(file2));
        }
        return arrayList;
    }
}

