/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchQuery;

public class HSQLDBQuery
extends SearchQuery
implements Runnable {
    private Connection queryCon;
    private Statement queryStatement;
    private Connection hitCon;
    private Statement hitStatement;
    private String queryId;
    private HSQLDBQuery cloneQuery;
    private ArrayList eafFiles;
    private ArrayList problemFiles;
    private ArrayList tierNames;
    private ArrayList tierTypes;
    private ArrayList participants;
    private float domainInitializationProgress;
    private static Pattern staticRegExpPattern;

    public HSQLDBQuery(String string) {
        this.queryId = string;
        this.problemFiles = new ArrayList();
        try {
            this.queryCon = DriverManager.getConnection("jdbc:hsqldb:mem:doQuery", "sa", "");
            this.queryStatement = this.queryCon.createStatement();
            this.hitCon = DriverManager.getConnection("jdbc:hsqldb:mem:getHits", "sa", "");
            this.hitStatement = this.hitCon.createStatement();
            this.schemaName = "search" + string;
            String string2 = "CREATE SCHEMA " + this.schemaName + " AUTHORIZATION DBA";
            String string3 = "CREATE TABLE " + this.schemaName + ".tiers (" + "tier_id INTEGER, " + "tier_name VARCHAR, " + "tier_type VARCHAR, " + "default_locale VARCHAR, " + "participant VARCHAR, " + "n_annotations INTEGER, " + "ref_tier_id INTEGER, " + "transcription_type INTEGER, " + "node_id VARCHAR)";
            String string4 = "CREATE TABLE " + this.schemaName + ".annotations (" + "ann_id INTEGER, " + "annotation VARCHAR, " + "ann_position INTEGER, " + "begin_time BIGINT, " + "end_time BIGINT, " + "ref_ann_id INTEGER, " + "aligned BOOLEAN, " + "ann_tier_id INTEGER)";
            this.queryStatement.executeUpdate(string2);
            this.queryStatement.executeUpdate(string3);
            this.queryStatement.executeUpdate(string4);
            this.queryStatement.executeUpdate("CREATE INDEX ann_begin_time_index ON " + this.schemaName + ".annotations( begin_time )");
            this.queryStatement.executeUpdate("CREATE INDEX ann_end_time_index ON " + this.schemaName + ".annotations( end_time )");
            this.hitStatement.executeUpdate(string2);
            this.hitStatement.executeUpdate(string3);
            this.hitStatement.executeUpdate(string4);
            this.hitStatement.executeUpdate("CREATE INDEX ann_begin_time_index ON " + this.schemaName + ".annotations( begin_time )");
            this.hitStatement.executeUpdate("CREATE INDEX ann_end_time_index ON " + this.schemaName + ".annotations( end_time )");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doQuery(String string) {
        this.cancelQuery();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        if (this.eafFiles.size() == 0) {
            return;
        }
        this.createLayers(string);
        this.keepExecuting = true;
        this.isExecuting = true;
        new Thread(new QueryExecutor()).start();
    }

    public void cancelQuery() {
        if (this.isExecuting) {
            this.keepExecuting = false;
            try {
                while (this.isExecuting) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isExecuting = false;
    }

    protected String createQueryPatternPart(String string, String[] stringArray, Pattern pattern, boolean bl) {
        int n = string.length();
        String string2 = "";
        this.patternNeedsFullStatistics = false;
        if (stringArray[0].equals(" Annotation")) {
            if (stringArray[1].equals(" case sensitive")) {
                if (stringArray[2].equals(" exact match")) {
                    string2 = bl ? "annotation != '" + string + "'" : "annotation = '" + string + "'";
                } else if (stringArray[2].equals(" substring match")) {
                    if (bl) {
                        string2 = "annotation NOT LIKE '%" + this.escape(string) + "%' ESCAPE '\u00b1'";
                    } else {
                        string2 = "annotation LIKE '%" + this.escape(string) + "%' ESCAPE '\u00b1'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (stringArray[2].equals(" regular expression")) {
                    staticRegExpPattern = pattern;
                    if (bl) {
                        string2 = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, true, true)";
                    } else {
                        string2 = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, true, false)";
                        this.patternNeedsFullStatistics = true;
                    }
                }
            } else if (stringArray[2].equals(" exact match")) {
                string2 = bl ? "LCASE(annotation) != '" + string.toLowerCase() + "'" : "LCASE(annotation) = '" + string.toLowerCase() + "'";
            } else if (stringArray[2].equals(" substring match")) {
                if (bl) {
                    string2 = "LCASE(annotation) NOT LIKE '%" + this.escape(string.toLowerCase()) + "%' ESCAPE '\u00b1'";
                } else {
                    string2 = "LCASE(annotation) LIKE '%" + this.escape(string.toLowerCase()) + "%' ESCAPE '\u00b1'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (stringArray[2].equals(" regular expression")) {
                staticRegExpPattern = pattern;
                if (bl) {
                    string2 = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, false, true)";
                } else {
                    string2 = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, false, false)";
                    this.patternNeedsFullStatistics = true;
                }
            }
        } else if (stringArray[0].equals(" N-gram over annotations") || stringArray[0].equals(" N-gram within annotation")) {
            String string3 = this.getLongestNonWildcardPart(string);
            if (stringArray[2].equals(" regular expression")) {
                if (stringArray[0].equals(" N-gram within annotation")) {
                    if (string3.startsWith("^")) {
                        string3 = string3.substring(1);
                    }
                    if (string3.endsWith("$")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                }
                staticRegExpPattern = Pattern.compile(string3);
                if (stringArray[1].equals(" case sensitive")) {
                    if (bl) {
                        string2 = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, true, true)";
                    } else {
                        string2 = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, true, false)";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (bl) {
                    string2 = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, false, true)";
                } else {
                    string2 = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, false, false)";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (stringArray[1].equals(" case sensitive")) {
                if (bl) {
                    string2 = "annotation NOT LIKE '%" + this.escape(string3) + "%'";
                } else {
                    string2 = "annotation LIKE '%" + this.escape(string3) + "%'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (bl) {
                string2 = "LCASE(annotation) NOT LIKE '%" + this.escape(string3.toLowerCase()) + "%'";
            } else {
                string2 = "LCASE(annotation) LIKE '%" + this.escape(string3.toLowerCase()) + "%'";
                this.patternNeedsFullStatistics = true;
            }
        }
        return string2;
    }

    public static boolean match(String string, boolean bl, boolean bl2) {
        Matcher matcher = bl ? staticRegExpPattern.matcher(string) : staticRegExpPattern.matcher(string.toLowerCase());
        if (bl2) {
            return !matcher.find();
        }
        return matcher.find();
    }

    public ArrayList getHits(int n, int n2, int n3) {
        ArrayList<SearchHit> arrayList = new ArrayList<SearchHit>();
        try {
            int n4 = -1;
            File file = null;
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            int[][] nArray = new int[this.nLayers][this.nPatternsPerLayer];
            int[] nArray2 = this.searchLayers[this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern(this.firstNonEmptyPatternIndex);
            int[] nArray3 = this.searchLayers[this.firstNonEmptyLayerIndex].getHitNumberForPattern(this.firstNonEmptyPatternIndex);
            int[] nArray4 = this.searchLayers[this.firstNonEmptyLayerIndex].getHitFileIds();
            for (int i = n; i < n2 && i < this.statistics.nHits && i < 10000; ++i) {
                Object object;
                int n5;
                int n6;
                Object object2;
                SearchHit searchHit = new SearchHit();
                int n7 = nArray2[i];
                int n8 = nArray4[i];
                if (n8 != n4) {
                    file = (File)this.eafFiles.get(n8);
                    object2 = new AnnexTranscription(file.getName(), 0, file);
                    this.ingest((AnnexTranscription)object2, this.hitCon);
                    n4 = n8;
                }
                object2 = this.hitStatement.executeQuery("SELECT ann_position, annotation, begin_time, end_time, ann_tier_id, aligned FROM " + this.schemaName + ".annotations WHERE ann_id = " + n7);
                object2.next();
                searchHit.positionInTier = object2.getInt(1);
                if (this.isSimpleQuery) {
                    searchHit.annotation = object2.getString(2);
                    searchHit.beginTime = object2.getLong(3);
                    searchHit.endTime = object2.getLong(4);
                } else {
                    for (n6 = 0; n6 < this.nLayers; ++n6) {
                        for (n5 = 0; n5 < this.nPatternsPerLayer; ++n5) {
                            object = this.searchLayers[n6].getHitAnnIdsForPattern(n5);
                            nArray[n6][n5] = object != null ? object[i] : -1;
                        }
                    }
                    SearchQuery.ComplexHitData complexHitData = this.constructComplexHitResultString(null, this.hitStatement, nArray, true);
                    searchHit.annotation = complexHitData.hitString;
                    searchHit.beginTime = complexHitData.beginTime;
                    searchHit.endTime = complexHitData.endTime;
                }
                n6 = object2.getInt(5);
                searchHit.aligned = object2.getBoolean(6);
                object2 = this.hitStatement.executeQuery("SELECT node_id, tier_name, tier_type, participant, n_annotations FROM " + this.schemaName + ".tiers WHERE tier_id = " + n6);
                object2.next();
                searchHit.transcriptionNodeId = object2.getString(1);
                searchHit.transcriptionName = file.getAbsolutePath();
                searchHit.tierName = object2.getString(2);
                searchHit.tierType = this.isSimpleQuery ? object2.getString(3) : "oadhohdpiouhdpiuhA;SUSey;O";
                searchHit.participant = object2.getString(4);
                n5 = object2.getInt(5);
                searchHit.hitNumberInAnnotation = nArray3[i];
                object = this.searchLayers[this.firstNonEmptyLayerIndex].getPattern(this.firstNonEmptyPatternIndex);
                boolean bl = this.searchLayers[this.firstNonEmptyLayerIndex].getPatternNOTMode(this.firstNonEmptyPatternIndex);
                Pattern pattern = this.searchLayers[this.firstNonEmptyLayerIndex].getRegExpPattern(this.firstNonEmptyPatternIndex);
                String[] stringArray = this.searchLayers[this.firstNonEmptyLayerIndex].getMode(this.firstNonEmptyPatternIndex);
                searchHit.hitPositionInAnnotation = this.getHitPosition(searchHit.annotation, searchHit.hitNumberInAnnotation, stringArray, (String)object, pattern, bl);
                searchHit.hitLength = this.getHitLength(searchHit.annotation, searchHit.hitNumberInAnnotation, stringArray, (String)object, pattern, bl);
                if (stringArray[0].equals(" N-gram over annotations")) {
                    int n9;
                    int n10 = n3 + this.nGramSizeLeftFromHit;
                    object2 = this.hitStatement.executeQuery("SELECT annotation, ann_position, begin_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + n6 + "AND ann_position < " + searchHit.positionInTier + "AND ann_position >= " + (searchHit.positionInTier - n10) + "ORDER BY ann_position DESC");
                    arrayList2.clear();
                    while (object2.next()) {
                        searchHit.leftContext.add(object2.getString(1));
                        arrayList2.add(new Long(object2.getLong(3)));
                    }
                    for (n9 = 0; n9 < this.nGramSizeLeftFromHit; ++n9) {
                        if (searchHit.leftContext.size() <= 0) continue;
                        String string = (String)searchHit.leftContext.get(0);
                        searchHit.annotation = string + " " + searchHit.annotation;
                        searchHit.beginTime = (Long)arrayList2.get(0);
                        searchHit.leftContext.remove(0);
                        arrayList2.remove(0);
                    }
                    n9 = n3 + this.nGramSizeRightFromHit;
                    object2 = this.hitStatement.executeQuery("SELECT annotation, ann_position, end_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + n6 + "AND ann_position > " + searchHit.positionInTier + "AND ann_position <= " + (searchHit.positionInTier + n9) + "ORDER BY ann_position");
                    int n11 = 0;
                    while (object2.next()) {
                        if (n11 < this.nGramSizeRightFromHit) {
                            searchHit.annotation = searchHit.annotation + " " + object2.getString(1);
                            searchHit.endTime = object2.getLong(3);
                        } else {
                            searchHit.rightContext.add(object2.getString(1));
                        }
                        ++n11;
                    }
                    searchHit.hitPositionInAnnotation = 0;
                    searchHit.hitLength = searchHit.annotation.length();
                    searchHit.positionInTier -= n10;
                    ++searchHit.positionInTier;
                } else {
                    object2 = this.hitStatement.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + n6 + "AND ann_position < " + searchHit.positionInTier + "AND ann_position >= " + (searchHit.positionInTier - n3) + "ORDER BY ann_position DESC");
                    while (object2.next()) {
                        searchHit.leftContext.add(object2.getString(1));
                    }
                    object2 = this.hitStatement.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + n6 + "AND ann_position > " + searchHit.positionInTier + "AND ann_position <= " + (searchHit.positionInTier + n3) + "ORDER BY ann_position");
                    while (object2.next()) {
                        searchHit.rightContext.add(object2.getString(1));
                    }
                    ++searchHit.positionInTier;
                }
                arrayList.add(searchHit);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList getViewerParametersFor(int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            File file = (File)this.eafFiles.get(n2);
            AnnexTranscription annexTranscription = new AnnexTranscription(file.getName(), 0, file);
            this.ingest(annexTranscription, this.hitCon);
            ResultSet resultSet = this.hitStatement.executeQuery("SELECT begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = " + n);
            resultSet.next();
            Long l = new Long(resultSet.getLong(1));
            Long l2 = new Long(resultSet.getLong(2));
            int n3 = resultSet.getInt(3);
            resultSet = this.hitStatement.executeQuery("SELECT tier_name FROM " + this.schemaName + ".tiers WHERE tier_id = " + n3);
            resultSet.next();
            String string = resultSet.getString(1);
            arrayList.add(file.getAbsolutePath());
            arrayList.add(string);
            arrayList.add(l);
            arrayList.add(l2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private String escape(String string) {
        String string2 = string.replaceAll("\u00b1", "\u00b1\u00b1");
        string2 = string2.replaceAll("%", "\u00b1%");
        string2 = string2.replaceAll("'", "\\\\'");
        string2 = string2.replaceAll("\"", "\u00b1\"");
        return string2.replaceAll("_", "\u00b1_");
    }

    private DomainStats ingest(AnnexTranscription annexTranscription, Connection connection) {
        DomainStats domainStats = new DomainStats();
        Statement statement = null;
        try {
            int n;
            Object object;
            statement = connection.createStatement();
            statement.executeUpdate("DELETE FROM " + this.schemaName + ".tiers");
            statement.executeUpdate("DELETE FROM " + this.schemaName + ".annotations");
            HashMap<Serializable, Integer> hashMap = new HashMap<Serializable, Integer>();
            int n2 = annexTranscription.getTiers().size();
            int n3 = 0;
            int n4 = 0;
            domainStats.nTiers = n2;
            for (int i = 0; i < n2; ++i) {
                object = (AnnexTier)annexTranscription.getTiers().get(i);
                hashMap.put((Serializable)object, new Integer(n3++));
                n = ((AnnexTier)object).annotations.size();
                domainStats.nAnnotations += (long)n;
                for (int j = 0; j < n; ++j) {
                    AnnexAnnotation annexAnnotation = (AnnexAnnotation)((AnnexTier)object).annotations.get(j);
                    hashMap.put(annexAnnotation, new Integer(n4++));
                    domainStats.annotationsSize += (long)((String)annexAnnotation.value).length();
                }
            }
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + this.schemaName + ".annotations VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
            object = connection.prepareStatement("INSERT INTO " + this.schemaName + ".tiers VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");
            n3 = 0;
            n4 = 0;
            for (n = 0; n < n2; ++n) {
                AnnexTier annexTier = (AnnexTier)annexTranscription.getTiers().get(n);
                int n5 = -1;
                if (annexTier.parentTier != null) {
                    n5 = (Integer)hashMap.get(annexTier.parentTier);
                }
                int n6 = annexTier.annotations.size();
                object.setInt(1, n3);
                object.setString(2, annexTier.name);
                object.setString(3, annexTier.type);
                object.setString(4, annexTier.defaultLocale);
                object.setString(5, annexTier.participant);
                object.setInt(6, n6);
                object.setInt(7, n5);
                object.setInt(8, annexTranscription.getType());
                object.setString(9, annexTranscription.getNodeId());
                object.executeUpdate();
                for (int i = 0; i < n6; ++i) {
                    AnnexAnnotation annexAnnotation = (AnnexAnnotation)annexTier.annotations.get(i);
                    int n7 = -1;
                    if (annexAnnotation.refAnnotation != null) {
                        n7 = (Integer)hashMap.get(annexAnnotation.refAnnotation);
                    }
                    preparedStatement.setInt(1, n4++);
                    preparedStatement.setString(2, (String)annexAnnotation.value);
                    preparedStatement.setInt(3, i);
                    preparedStatement.setLong(4, annexAnnotation.beginTime);
                    preparedStatement.setLong(5, annexAnnotation.endTime);
                    preparedStatement.setInt(6, n7);
                    preparedStatement.setBoolean(7, annexAnnotation.isTimeAligned);
                    preparedStatement.setInt(8, n3);
                    preparedStatement.executeUpdate();
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return domainStats;
    }

    public void setDomain(ArrayList arrayList) {
        this.eafFiles = (ArrayList)arrayList.clone();
        this.problemFiles.clear();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this.domainInitializationProgress = 0.0f;
        new Thread(this).start();
    }

    public void setDomain(HSQLDBQuery hSQLDBQuery) {
        this.problemFiles.clear();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this.cloneQuery = hSQLDBQuery;
        this.domainInitializationProgress = 0.0f;
        new Thread(this).start();
    }

    public float getDomainInitializationProgress() {
        return this.domainInitializationProgress;
    }

    public ArrayList getDomain() {
        return this.eafFiles;
    }

    public ArrayList getProblemFiles() {
        return this.problemFiles;
    }

    public ArrayList getTierNames() {
        return this.tierNames;
    }

    public ArrayList getTierTypes() {
        return this.tierTypes;
    }

    public ArrayList getParticipants() {
        return this.participants;
    }

    public void run() {
        if (this.cloneQuery != null) {
            while (this.cloneQuery.getDomainInitializationProgress() < 1.0f) {
                try {
                    this.domainInitializationProgress = this.cloneQuery.getDomainInitializationProgress() - 0.01f;
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.eafFiles = (ArrayList)this.cloneQuery.getDomain().clone();
            this.tierNames = (ArrayList)this.cloneQuery.getTierNames().clone();
            this.tierTypes = (ArrayList)this.cloneQuery.getTierTypes().clone();
            this.participants = (ArrayList)this.cloneQuery.getParticipants().clone();
            this.domainInitializationProgress = 1.0f;
            this.cloneQuery = null;
        } else {
            int n;
            AnnexTranscription annexTranscription = null;
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            TreeSet<String> treeSet3 = new TreeSet<String>();
            this.problemFiles = new ArrayList();
            for (n = 0; n < this.eafFiles.size(); ++n) {
                File file = (File)this.eafFiles.get(n);
                if (file.exists()) {
                    annexTranscription = new AnnexTranscription(file.getName(), 0, file);
                    if (annexTranscription.isValid()) {
                        ArrayList arrayList = annexTranscription.getTiers();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            AnnexTier annexTier = (AnnexTier)arrayList.get(i);
                            if (annexTier.name != null && annexTier.name.trim().length() > 0) {
                                treeSet.add(annexTier.name);
                            }
                            if (annexTier.type != null && annexTier.type.trim().length() > 0) {
                                treeSet2.add(annexTier.type);
                            }
                            if (annexTier.participant == null || annexTier.participant.trim().length() <= 0) continue;
                            treeSet3.add(annexTier.participant);
                        }
                    } else {
                        this.problemFiles.add(this.eafFiles.get(n));
                    }
                }
                this.domainInitializationProgress = (float)((double)this.domainInitializationProgress + 1.0 / (double)(this.eafFiles.size() + 1));
            }
            this.tierNames = new ArrayList(treeSet);
            this.tierTypes = new ArrayList(treeSet2);
            this.participants = new ArrayList(treeSet3);
            if (this.problemFiles.size() > 0) {
                for (n = 0; n < this.problemFiles.size(); ++n) {
                    this.eafFiles.remove(this.problemFiles.get(n));
                }
            }
            this.domainInitializationProgress = 1.0f;
        }
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class DomainStats {
        public int nFiles;
        public int nExist;
        public int nPermissionDenied;
        public int nNotParsable;
        public int nDBProblems;
        public int nEmpty;
        public int nTiers;
        public long nAnnotations;
        public long annotationsSize;

        private DomainStats() {
        }
    }

    private class QueryExecutor
    implements Runnable {
        String pattern;
        boolean patternNOTMode;
        Pattern regExpPattern;
        String[] queryModes;

        public QueryExecutor() {
            if (HSQLDBQuery.this.firstNonEmptyPatternIndex >= 0) {
                this.pattern = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.patternNOTMode = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getPatternNOTMode(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.regExpPattern = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getRegExpPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.queryModes = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getMode(HSQLDBQuery.this.firstNonEmptyPatternIndex);
            }
        }

        public void run() {
            if (this.pattern == null) {
                HSQLDBQuery.this.statistics.progress = 1.0f;
                HSQLDBQuery.this.isExecuting = false;
            } else {
                String string = "SELECT ann_id, annotation, begin_time, end_time, ann_position, ann_tier_id FROM " + HSQLDBQuery.this.schemaName + ".annotations WHERE ";
                string = string + HSQLDBQuery.this.createQueryPatternPart(this.pattern, this.queryModes, this.regExpPattern, this.patternNOTMode);
                string = string + HSQLDBQuery.this.createGlobalTimeConstraintPart();
                try {
                    AnnexTranscription annexTranscription = null;
                    for (int i = 0; i < HSQLDBQuery.this.eafFiles.size(); ++i) {
                        File file = (File)HSQLDBQuery.this.eafFiles.get(i);
                        if (file.exists()) {
                            annexTranscription = new AnnexTranscription(file.getName(), 0, file);
                            if (annexTranscription.isValid()) {
                                HSQLDBQuery.this.currentNodeId = annexTranscription.getNodeId();
                                DomainStats domainStats = HSQLDBQuery.this.ingest(annexTranscription, HSQLDBQuery.this.queryCon);
                                HSQLDBQuery.this.statistics.nAnnotationsSearched = (int)((long)HSQLDBQuery.this.statistics.nAnnotationsSearched + domainStats.nAnnotations);
                                if (i < HSQLDBQuery.this.eafFiles.size() - 1) {
                                    HSQLDBQuery.this.statistics.progress = ((float)i - 0.5f) / (float)HSQLDBQuery.this.eafFiles.size();
                                }
                                if (!HSQLDBQuery.this.isSimpleQuery) {
                                    staticRegExpPattern = this.regExpPattern;
                                }
                                HSQLDBQuery.this.setTierDomainForLayers(false, HSQLDBQuery.this.queryStatement);
                                String string2 = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getTierIdsInLayerDomain();
                                String string3 = string;
                                if (HSQLDBQuery.this.thereIsALayerWithAnEmptyTierDomain) continue;
                                if (!string2.equals(HSQLDBQuery.this.fullTranscriptionTierDomain)) {
                                    string3 = string3 + string2;
                                }
                                System.out.println("query: " + string3);
                                ResultSet resultSet = HSQLDBQuery.this.queryStatement.executeQuery(string3);
                                while (resultSet.next()) {
                                    int n = resultSet.getInt(1);
                                    String string4 = resultSet.getString(2);
                                    int n2 = resultSet.getInt(6);
                                    if (HSQLDBQuery.this.isSimpleQuery) {
                                        int n3;
                                        if (this.queryModes[0].equals(" Annotation")) {
                                            long l;
                                            long l2 = resultSet.getLong(3);
                                            if (!HSQLDBQuery.this.patternHasValidDuration(l2, l = resultSet.getLong(4), HSQLDBQuery.this.queryCon)) continue;
                                            HSQLDBQuery.this.updateFrequencyStatistics(string4, n, i, HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex);
                                            ++HSQLDBQuery.this.statistics.nAnnotationsWithHit;
                                            n3 = 1;
                                            if (HSQLDBQuery.this.patternNeedsFullStatistics) {
                                                n3 = HSQLDBQuery.this.countHitsInAnnotation(string4, this.queryModes, this.pattern, this.regExpPattern, this.patternNOTMode);
                                            }
                                            for (int j = 0; j < n3; ++j) {
                                                if (HSQLDBQuery.this.statistics.nHits < 10000) {
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = n;
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = j + 1;
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[HSQLDBQuery.this.statistics.nHits] = i;
                                                }
                                                ++HSQLDBQuery.this.statistics.nHits;
                                            }
                                        } else {
                                            String[] stringArray;
                                            if (this.queryModes[0].equals(" N-gram over annotations")) {
                                                HSQLDBQuery.this.nGramSizeLeftFromHit = HSQLDBQuery.this.getLongestNonWildcardPartPosition(this.pattern);
                                                HSQLDBQuery.this.nGramSizeRightFromHit = HSQLDBQuery.this.getNGramLength(this.pattern) - HSQLDBQuery.this.nGramSizeLeftFromHit - 1;
                                            }
                                            if ((stringArray = HSQLDBQuery.this.constructNGrams(n, HSQLDBQuery.this.queryStatement, HSQLDBQuery.this.schemaName, this.pattern, this.queryModes)) != null) {
                                                boolean bl = false;
                                                boolean bl2 = true;
                                                int n4 = 1;
                                                for (n3 = 0; n3 < stringArray.length; ++n3) {
                                                    String string5 = stringArray[n3];
                                                    if (!HSQLDBQuery.this.isNGramMatch(string5, this.pattern, this.queryModes)) continue;
                                                    if (!bl) {
                                                        string5 = string5.replace("jqzxw", " ");
                                                        HSQLDBQuery.this.updateFrequencyStatistics(string5, n, i, HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex);
                                                        bl = true;
                                                    }
                                                    if (this.queryModes[0].equals(" N-gram over annotations") || bl2) {
                                                        ++HSQLDBQuery.this.statistics.nAnnotationsWithHit;
                                                        bl2 = false;
                                                    }
                                                    if (HSQLDBQuery.this.statistics.nHits < 10000) {
                                                        HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = n;
                                                        HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = n4++;
                                                        HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[HSQLDBQuery.this.statistics.nHits] = i;
                                                    }
                                                    ++HSQLDBQuery.this.statistics.nHits;
                                                }
                                            }
                                        }
                                    } else {
                                        HSQLDBQuery.this.currentTranscriptionTierDomain = "";
                                        HSQLDBQuery.this.clearHitData(i);
                                        HSQLDBQuery.this.globalHitAnnId[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = n;
                                        HSQLDBQuery.this.globalHitTierId[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = n2;
                                        HSQLDBQuery.this.globalHitBeginTime[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = resultSet.getLong(3);
                                        HSQLDBQuery.this.globalHitEndTime[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = resultSet.getLong(4);
                                        HSQLDBQuery.this.globalHitPosition[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = resultSet.getInt(5);
                                        HSQLDBQuery.this.investigateComplexPattern(HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex, HSQLDBQuery.this.queryCon);
                                    }
                                    if (HSQLDBQuery.this.keepExecuting) continue;
                                    break;
                                }
                                if (!HSQLDBQuery.this.keepExecuting) break;
                            }
                            if (!HSQLDBQuery.this.keepExecuting) break;
                        }
                        if (!HSQLDBQuery.this.keepExecuting) break;
                        HSQLDBQuery.this.statistics.progress = (float)i / (float)HSQLDBQuery.this.eafFiles.size();
                    }
                    HSQLDBQuery.this.statistics.progress = 1.0f;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                HSQLDBQuery.this.isExecuting = false;
            }
        }
    }
}

