/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import mpi.annex.search.Constants;
import mpi.annex.search.SearchAppletMediator;
import mpi.annex.search.SearchDomainPanel;
import mpi.annex.search.SearchHistoryPanel;
import mpi.annex.search.SearchListener;
import mpi.annex.search.SearchMediator;
import mpi.annex.search.SearchResultPanel;
import mpi.annex.search.SearchUtil;

public class MultipleLayerSearchPanel
extends JPanel
implements SearchListener,
ActionListener {
    private SearchMediator mediator;
    private Color backgroundColor;
    private String queryId;
    private SearchDomainPanel domainPanel;
    private SearchResultPanel resultPanel;
    private JButton findButton;
    private JButton clearButton;
    private String[] targetModes;
    private String[] caseModes;
    private String[] matchModes;
    private JComboBox targetModeChooser;
    private JComboBox caseModeChooser;
    private JComboBox matchModeChooser;
    private JTextField patternField_1;
    private JTextField patternField_2;
    private JTextField patternField_3;
    private JTextField patternField_4;
    private JTextField patternField_5;
    private JTextField patternField_6;
    private JTextField patternField_7;
    private JTextField patternField_8;
    private JTextField patternField_9;
    private ConstraintLabel relation_1_2;
    private ConstraintLabel relation_1_4;
    private ConstraintLabel relation_2_3;
    private ConstraintLabel relation_2_5;
    private ConstraintLabel relation_3_6;
    private ConstraintLabel relation_4_5;
    private ConstraintLabel relation_4_7;
    private ConstraintLabel relation_5_6;
    private ConstraintLabel relation_5_8;
    private ConstraintLabel relation_6_9;
    private ConstraintLabel relation_7_8;
    private ConstraintLabel relation_8_9;
    private JComboBox layer1Tiers;
    private JComboBox layer2Tiers;
    private JComboBox layer3Tiers;
    private JLabel popupSource;
    private JPopupMenu horizontalRelations;
    private JPopupMenu verticalRelations;
    private JMenuItem hAnnEqual;
    private JMenuItem hAnnMore;
    private JMenuItem hAnnLess;
    private JMenuItem hMilEqual;
    private JMenuItem hMilMore;
    private JMenuItem hMilLess;
    private JMenuItem hNoConstraint;
    private JMenuItem hClear;
    private JMenuItem vFullyAligned;
    private JMenuItem vOverlap;
    private JMenuItem vLeftOverlap;
    private JMenuItem vRightOverlap;
    private JMenuItem vSurrounding;
    private JMenuItem vWithin;
    private JMenuItem vNoOverlap;
    private JMenuItem vBeginBeginEqual;
    private JMenuItem vBeginBeginLess;
    private JMenuItem vBeginBeginMore;
    private JMenuItem vBeginEndEqual;
    private JMenuItem vBeginEndLess;
    private JMenuItem vBeginEndMore;
    private JMenuItem vEndBeginEqual;
    private JMenuItem vEndBeginLess;
    private JMenuItem vEndBeginMore;
    private JMenuItem vEndEndEqual;
    private JMenuItem vEndEndLess;
    private JMenuItem vEndEndMore;
    private JMenuItem vNoConstraint;
    private JMenuItem vClear;
    private SearchHistoryPanel historyPanel;
    private JButton minDurationButton;
    private JButton maxDurationButton;
    private JButton beginAfterButton;
    private JButton endBeforeButton;
    private long minimalDuration;
    private long maximalDuration;
    private long beginAfter;
    private long endBefore;

    public MultipleLayerSearchPanel(SearchMediator searchMediator) {
        int n;
        int n2;
        int n3;
        this.mediator = searchMediator;
        this.backgroundColor = searchMediator.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.queryId = searchMediator.createQuery();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(this.backgroundColor);
        this.add((Component)jPanel, "North");
        this.domainPanel = new SearchDomainPanel(searchMediator, this.queryId, this);
        jPanel.add(this.domainPanel);
        jPanel.add(Box.createVerticalStrut(20));
        this.historyPanel = new SearchHistoryPanel(this, this.backgroundColor);
        this.historyPanel.setHistory(searchMediator.getPersistent("multipleTierHistory"));
        jPanel.add(this.historyPanel);
        jPanel.add(Box.createVerticalStrut(15));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.backgroundColor);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JLabel jLabel = new JLabel("Mode:");
        jLabel.setFont(Constants.bigBoldFont);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(10));
        ArrayList arrayList = searchMediator.getSearchModes(this.queryId);
        int n4 = 0;
        int n5 = Integer.parseInt((String)arrayList.get(n4));
        this.targetModes = new String[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            this.targetModes[n3] = (String)arrayList.get(++n4);
        }
        this.targetModeChooser = new JComboBox<String>(this.targetModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.targetModeChooser.setBackground(this.backgroundColor);
        }
        jPanel2.add(Box.createHorizontalStrut(5));
        n3 = Integer.parseInt((String)arrayList.get(++n4));
        this.caseModes = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.caseModes[n2] = (String)arrayList.get(++n4);
        }
        this.caseModeChooser = new JComboBox<String>(this.caseModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.caseModeChooser.setBackground(this.backgroundColor);
        }
        jPanel2.add(this.caseModeChooser);
        jPanel2.add(Box.createHorizontalStrut(5));
        n2 = Integer.parseInt((String)arrayList.get(++n4));
        this.matchModes = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.matchModes[n] = (String)arrayList.get(++n4);
        }
        this.matchModeChooser = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.matchModeChooser.setBackground(this.backgroundColor);
        }
        for (n = 0; n < this.matchModes.length; ++n) {
            this.matchModeChooser.addItem(this.matchModes[n]);
        }
        jPanel2.add(this.matchModeChooser);
        this.clearButton = new JButton("Clear");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.clearButton.setBackground(this.backgroundColor);
        }
        this.clearButton.addActionListener(this);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.clearButton);
        jPanel2.add(Box.createHorizontalStrut(30));
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(15));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(this.backgroundColor);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalStrut(30));
        this.minDurationButton = new JButton("Minimal Duration");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.minDurationButton.setBackground(this.backgroundColor);
        }
        this.minDurationButton.addActionListener(this);
        jPanel3.add(this.minDurationButton);
        jPanel3.add(Box.createHorizontalStrut(15));
        this.maxDurationButton = new JButton("Maximal Duration");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.maxDurationButton.setBackground(this.backgroundColor);
        }
        this.maxDurationButton.addActionListener(this);
        jPanel3.add(this.maxDurationButton);
        jPanel3.add(Box.createHorizontalStrut(15));
        this.beginAfterButton = new JButton("Begin After");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.beginAfterButton.setBackground(this.backgroundColor);
        }
        this.beginAfterButton.addActionListener(this);
        jPanel3.add(this.beginAfterButton);
        jPanel3.add(Box.createHorizontalStrut(15));
        this.endBeforeButton = new JButton("End Before");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.endBeforeButton.setBackground(this.backgroundColor);
        }
        this.endBeforeButton.addActionListener(this);
        jPanel3.add(this.endBeforeButton);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(20));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBackground(this.backgroundColor);
        jPanel.add(jPanel4);
        jPanel4.add(Box.createHorizontalStrut(30));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel5.setBackground(this.backgroundColor);
        jPanel4.add(jPanel5);
        jPanel4.add(Box.createHorizontalStrut(5));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel6.setBackground(this.backgroundColor);
        jPanel4.add(jPanel6);
        jPanel4.add(Box.createHorizontalStrut(5));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel7.setBackground(this.backgroundColor);
        jPanel4.add(jPanel7);
        jPanel4.add(Box.createHorizontalStrut(5));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel8.setBackground(this.backgroundColor);
        jPanel4.add(jPanel8);
        jPanel4.add(Box.createHorizontalStrut(5));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel9.setBackground(this.backgroundColor);
        jPanel4.add(jPanel9);
        jPanel4.add(Box.createHorizontalStrut(20));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel10.setBackground(this.backgroundColor);
        jPanel4.add(jPanel10);
        jPanel4.add(Box.createHorizontalStrut(30));
        Border border = BorderFactory.createEtchedBorder(1);
        MouseHandler mouseHandler = new MouseHandler();
        this.patternField_1 = new JTextField(10);
        this.patternField_1.setHorizontalAlignment(0);
        jPanel5.add(this.patternField_1);
        this.relation_1_4 = new ConstraintLabel();
        this.relation_1_4.setHorizontalAlignment(0);
        this.relation_1_4.setBorder(border);
        this.relation_1_4.addMouseListener(mouseHandler);
        jPanel5.add(this.relation_1_4);
        this.patternField_4 = new JTextField(10);
        this.patternField_4.setHorizontalAlignment(0);
        jPanel5.add(this.patternField_4);
        this.relation_4_7 = new ConstraintLabel();
        this.relation_4_7.setHorizontalAlignment(0);
        this.relation_4_7.setBorder(border);
        this.relation_4_7.addMouseListener(mouseHandler);
        jPanel5.add(this.relation_4_7);
        this.patternField_7 = new JTextField(10);
        this.patternField_7.setHorizontalAlignment(0);
        jPanel5.add(this.patternField_7);
        jPanel5.add(Box.createHorizontalStrut(120));
        this.relation_1_2 = new ConstraintLabel();
        this.relation_1_2.setHorizontalAlignment(0);
        this.relation_1_2.setBorder(border);
        this.relation_1_2.addMouseListener(mouseHandler);
        jPanel6.add(this.relation_1_2);
        jPanel6.add(Box.createHorizontalStrut(1));
        this.relation_4_5 = new ConstraintLabel();
        this.relation_4_5.addMouseListener(mouseHandler);
        this.relation_4_5.setHorizontalAlignment(0);
        this.relation_4_5.setBorder(border);
        jPanel6.add(this.relation_4_5);
        jPanel6.add(Box.createHorizontalStrut(1));
        this.relation_7_8 = new ConstraintLabel();
        this.relation_7_8.addMouseListener(mouseHandler);
        this.relation_7_8.setHorizontalAlignment(0);
        this.relation_7_8.setBorder(border);
        jPanel6.add(this.relation_7_8);
        jPanel6.add(Box.createHorizontalStrut(30));
        this.patternField_2 = new JTextField(10);
        this.patternField_2.setHorizontalAlignment(0);
        jPanel7.add(this.patternField_2);
        this.relation_2_5 = new ConstraintLabel();
        this.relation_2_5.setHorizontalAlignment(0);
        this.relation_2_5.setBorder(border);
        this.relation_2_5.addMouseListener(mouseHandler);
        jPanel7.add(this.relation_2_5);
        this.patternField_5 = new JTextField(10);
        this.patternField_5.setHorizontalAlignment(0);
        jPanel7.add(this.patternField_5);
        this.relation_5_8 = new ConstraintLabel();
        this.relation_5_8.setHorizontalAlignment(0);
        this.relation_5_8.setBorder(border);
        this.relation_5_8.addMouseListener(mouseHandler);
        jPanel7.add(this.relation_5_8);
        this.patternField_8 = new JTextField(10);
        this.patternField_8.setHorizontalAlignment(0);
        jPanel7.add(this.patternField_8);
        jPanel7.add(Box.createHorizontalStrut(120));
        this.relation_2_3 = new ConstraintLabel();
        this.relation_2_3.addMouseListener(mouseHandler);
        this.relation_2_3.setHorizontalAlignment(0);
        this.relation_2_3.setBorder(border);
        jPanel8.add(this.relation_2_3);
        jPanel8.add(Box.createHorizontalStrut(1));
        this.relation_5_6 = new ConstraintLabel();
        this.relation_5_6.addMouseListener(mouseHandler);
        this.relation_5_6.setHorizontalAlignment(0);
        this.relation_5_6.setBorder(border);
        jPanel8.add(this.relation_5_6);
        jPanel8.add(Box.createHorizontalStrut(1));
        this.relation_8_9 = new ConstraintLabel();
        this.relation_8_9.addMouseListener(mouseHandler);
        this.relation_8_9.setHorizontalAlignment(0);
        this.relation_8_9.setBorder(border);
        jPanel8.add(this.relation_8_9);
        jPanel8.add(Box.createHorizontalStrut(30));
        this.patternField_3 = new JTextField(10);
        this.patternField_3.setHorizontalAlignment(0);
        jPanel9.add(this.patternField_3);
        this.relation_3_6 = new ConstraintLabel();
        this.relation_3_6.setHorizontalAlignment(0);
        this.relation_3_6.setBorder(border);
        this.relation_3_6.addMouseListener(mouseHandler);
        jPanel9.add(this.relation_3_6);
        this.patternField_6 = new JTextField(10);
        this.patternField_6.setHorizontalAlignment(0);
        jPanel9.add(this.patternField_6);
        this.relation_6_9 = new ConstraintLabel();
        this.relation_6_9.setHorizontalAlignment(0);
        this.relation_6_9.setBorder(border);
        this.relation_6_9.addMouseListener(mouseHandler);
        jPanel9.add(this.relation_6_9);
        this.patternField_9 = new JTextField(10);
        this.patternField_9.setHorizontalAlignment(0);
        jPanel9.add(this.patternField_9);
        jPanel9.add(Box.createHorizontalStrut(120));
        Dimension dimension = new Dimension(200, 28);
        this.layer1Tiers = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.layer1Tiers.setBackground(this.backgroundColor);
        }
        this.layer1Tiers.setMaximumRowCount(20);
        this.layer1Tiers.setPreferredSize(dimension);
        this.layer2Tiers = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.layer2Tiers.setBackground(this.backgroundColor);
        }
        this.layer2Tiers.setMaximumRowCount(20);
        this.layer2Tiers.setPreferredSize(dimension);
        this.layer3Tiers = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.layer3Tiers.setBackground(this.backgroundColor);
        }
        this.layer3Tiers.setMaximumRowCount(20);
        this.layer3Tiers.setPreferredSize(dimension);
        if (searchMediator instanceof SearchAppletMediator) {
            this.fillTierConstraintsCombos();
        }
        jPanel10.add(this.layer1Tiers);
        jPanel10.add(Box.createVerticalStrut(32));
        jPanel10.add(this.layer2Tiers);
        jPanel10.add(Box.createVerticalStrut(32));
        jPanel10.add(this.layer3Tiers);
        jPanel10.add(Box.createHorizontalStrut(150));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        jPanel11.setBackground(this.backgroundColor);
        this.findButton = new JButton("Find");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.findButton.setBackground(this.backgroundColor);
        }
        this.findButton.addActionListener(this);
        jPanel11.add(Box.createHorizontalStrut(30));
        jPanel11.add(this.findButton);
        jPanel11.add(Box.createHorizontalGlue());
        jPanel11.add(Box.createHorizontalStrut(30));
        jPanel.add(jPanel11);
        jPanel.add(Box.createVerticalStrut(10));
        this.resultPanel = new SearchResultPanel(searchMediator, this.queryId);
        this.add((Component)this.resultPanel, "Center");
        this.horizontalRelations = new JPopupMenu();
        this.hAnnEqual = new JMenuItem("= N annotations");
        this.hAnnEqual.addActionListener(this);
        this.horizontalRelations.add(this.hAnnEqual);
        this.hAnnMore = new JMenuItem("> N annotations");
        this.hAnnMore.addActionListener(this);
        this.horizontalRelations.add(this.hAnnMore);
        this.hAnnLess = new JMenuItem("< N annotations");
        this.hAnnLess.addActionListener(this);
        this.horizontalRelations.add(this.hAnnLess);
        this.horizontalRelations.addSeparator();
        this.hMilEqual = new JMenuItem("= X milliseconds");
        this.hMilEqual.addActionListener(this);
        this.horizontalRelations.add(this.hMilEqual);
        this.hMilMore = new JMenuItem("> X milliseconds");
        this.hMilMore.addActionListener(this);
        this.horizontalRelations.add(this.hMilMore);
        this.hMilLess = new JMenuItem("< X milliseconds");
        this.hMilLess.addActionListener(this);
        this.horizontalRelations.add(this.hMilLess);
        this.horizontalRelations.addSeparator();
        this.hNoConstraint = new JMenuItem("No constraint");
        this.hNoConstraint.addActionListener(this);
        this.horizontalRelations.add(this.hNoConstraint);
        this.hClear = new JMenuItem("Clear");
        this.hClear.addActionListener(this);
        this.horizontalRelations.add(this.hClear);
        this.verticalRelations = new JPopupMenu();
        this.vFullyAligned = new JMenuItem("Fully aligned");
        this.vFullyAligned.addActionListener(this);
        this.verticalRelations.add(this.vFullyAligned);
        this.vOverlap = new JMenuItem("Overlap");
        this.vOverlap.addActionListener(this);
        this.verticalRelations.add(this.vOverlap);
        this.vLeftOverlap = new JMenuItem("Left overlap");
        this.vLeftOverlap.addActionListener(this);
        this.verticalRelations.add(this.vLeftOverlap);
        this.vRightOverlap = new JMenuItem("Right overlap");
        this.vRightOverlap.addActionListener(this);
        this.verticalRelations.add(this.vRightOverlap);
        this.vSurrounding = new JMenuItem("Surrounding");
        this.vSurrounding.addActionListener(this);
        this.verticalRelations.add(this.vSurrounding);
        this.vWithin = new JMenuItem("Within");
        this.vWithin.addActionListener(this);
        this.verticalRelations.add(this.vWithin);
        this.vNoOverlap = new JMenuItem("No overlap");
        this.vNoOverlap.addActionListener(this);
        this.verticalRelations.add(this.vNoOverlap);
        this.verticalRelations.addSeparator();
        this.vBeginBeginEqual = new JMenuItem("begin time - begin time = X milliseconds");
        this.vBeginBeginEqual.addActionListener(this);
        this.verticalRelations.add(this.vBeginBeginEqual);
        this.vBeginBeginLess = new JMenuItem("begin time - begin time < X milliseconds");
        this.vBeginBeginLess.addActionListener(this);
        this.verticalRelations.add(this.vBeginBeginLess);
        this.vBeginBeginMore = new JMenuItem("begin time - begin time > X milliseconds");
        this.vBeginBeginMore.addActionListener(this);
        this.verticalRelations.add(this.vBeginBeginMore);
        this.verticalRelations.addSeparator();
        this.vBeginEndEqual = new JMenuItem("begin time - end time = X milliseconds");
        this.vBeginEndEqual.addActionListener(this);
        this.verticalRelations.add(this.vBeginEndEqual);
        this.vBeginEndLess = new JMenuItem("begin time - end time < X milliseconds");
        this.vBeginEndLess.addActionListener(this);
        this.verticalRelations.add(this.vBeginEndLess);
        this.vBeginEndMore = new JMenuItem("begin time - end time > X milliseconds");
        this.vBeginEndMore.addActionListener(this);
        this.verticalRelations.add(this.vBeginEndMore);
        this.verticalRelations.addSeparator();
        this.vEndBeginEqual = new JMenuItem("end time - begin time = X milliseconds");
        this.vEndBeginEqual.addActionListener(this);
        this.verticalRelations.add(this.vEndBeginEqual);
        this.vEndBeginLess = new JMenuItem("end time - begin time < X milliseconds");
        this.vEndBeginLess.addActionListener(this);
        this.verticalRelations.add(this.vEndBeginLess);
        this.vEndBeginMore = new JMenuItem("end time - begin time > X milliseconds");
        this.vEndBeginMore.addActionListener(this);
        this.verticalRelations.add(this.vEndBeginMore);
        this.verticalRelations.addSeparator();
        this.vEndEndEqual = new JMenuItem("end time - end time = X milliseconds");
        this.vEndEndEqual.addActionListener(this);
        this.verticalRelations.add(this.vEndEndEqual);
        this.vEndEndLess = new JMenuItem("end time - end time < X milliseconds");
        this.vEndEndLess.addActionListener(this);
        this.verticalRelations.add(this.vEndEndLess);
        this.vEndEndMore = new JMenuItem("end time - end time > X milliseconds");
        this.vEndEndMore.addActionListener(this);
        this.verticalRelations.add(this.vEndEndMore);
        this.verticalRelations.addSeparator();
        this.vNoConstraint = new JMenuItem("No constraint");
        this.vNoConstraint.addActionListener(this);
        this.verticalRelations.add(this.vNoConstraint);
        this.vClear = new JMenuItem("Clear");
        this.vClear.addActionListener(this);
        this.verticalRelations.add(this.vClear);
        Vector<JTextField> vector = new Vector<JTextField>();
        vector.add(this.patternField_1);
        vector.add(this.patternField_2);
        vector.add(this.patternField_3);
        vector.add(this.patternField_4);
        vector.add(this.patternField_5);
        vector.add(this.patternField_6);
        vector.add(this.patternField_7);
        vector.add(this.patternField_8);
        vector.add(this.patternField_9);
        try {
            Method method = Container.class.getDeclaredMethod("setFocusTraversalPolicyProvider", Boolean.TYPE);
            if (method != null) {
                method.invoke((Object)this, new Boolean(true));
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot set traversal policy: " + exception.getClass().getName() + " - " + exception.getMessage());
        }
        this.setFocusTraversalPolicy(new MyOwnFocusTraversalPolicy(vector));
    }

    public void fillTierConstraintsCombos() {
        while (this.layer1Tiers == null || this.layer2Tiers == null || this.layer3Tiers == null) {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.layer1Tiers.removeAllItems();
        this.layer1Tiers.addItem(" All Tiers ");
        this.layer2Tiers.removeAllItems();
        this.layer2Tiers.addItem(" All Tiers ");
        this.layer3Tiers.removeAllItems();
        this.layer3Tiers.addItem(" All Tiers ");
        ArrayList arrayList = this.mediator.getTierTypes(this.queryId);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.layer1Tiers.addItem(" Tier Type: " + arrayList.get(i));
            this.layer2Tiers.addItem(" Tier Type: " + arrayList.get(i));
            this.layer3Tiers.addItem(" Tier Type: " + arrayList.get(i));
        }
        ArrayList arrayList2 = this.mediator.getParticipants(this.queryId);
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.layer1Tiers.addItem(" Participant: " + arrayList2.get(i));
            this.layer2Tiers.addItem(" Participant: " + arrayList2.get(i));
            this.layer3Tiers.addItem(" Participant: " + arrayList2.get(i));
        }
        ArrayList arrayList3 = this.mediator.getTierNames(this.queryId);
        for (int i = 0; i < arrayList3.size(); ++i) {
            this.layer1Tiers.addItem(" Tier Name: " + arrayList3.get(i));
            this.layer2Tiers.addItem(" Tier Name: " + arrayList3.get(i));
            this.layer3Tiers.addItem(" Tier Name: " + arrayList3.get(i));
        }
    }

    public void domainChanged() {
        this.resetPatterns();
        this.resetRelations();
        this.fillTierConstraintsCombos();
        this.validate();
    }

    public void queryStopped() {
    }

    public void setQuery(String string) {
        String[] stringArray = string.split("jqzxw");
        this.caseModeChooser.setSelectedItem(stringArray[1]);
        this.matchModeChooser.setSelectedItem(stringArray[2]);
        this.patternField_1.setText(stringArray[3]);
        this.patternField_2.setText(stringArray[4]);
        this.patternField_3.setText(stringArray[5]);
        this.patternField_4.setText(stringArray[6]);
        this.patternField_5.setText(stringArray[7]);
        this.patternField_6.setText(stringArray[8]);
        this.patternField_7.setText(stringArray[9]);
        this.patternField_8.setText(stringArray[10]);
        this.patternField_9.setText(stringArray[11]);
        this.relation_1_2.setText(stringArray[12]);
        this.relation_1_2.constraint = stringArray[13];
        this.relation_2_3.setText(stringArray[14]);
        this.relation_2_3.constraint = stringArray[15];
        this.relation_4_5.setText(stringArray[16]);
        this.relation_4_5.constraint = stringArray[17];
        this.relation_5_6.setText(stringArray[18]);
        this.relation_5_6.constraint = stringArray[19];
        this.relation_7_8.setText(stringArray[20]);
        this.relation_7_8.constraint = stringArray[21];
        this.relation_8_9.setText(stringArray[22]);
        this.relation_8_9.constraint = stringArray[23];
        this.relation_1_4.setText(stringArray[24]);
        this.relation_1_4.constraint = stringArray[25];
        this.relation_2_5.setText(stringArray[26]);
        this.relation_2_5.constraint = stringArray[27];
        this.relation_3_6.setText(stringArray[28]);
        this.relation_3_6.constraint = stringArray[29];
        this.relation_4_7.setText(stringArray[30]);
        this.relation_4_7.constraint = stringArray[31];
        this.relation_5_8.setText(stringArray[32]);
        this.relation_5_8.constraint = stringArray[33];
        this.relation_6_9.setText(stringArray[34]);
        this.relation_6_9.constraint = stringArray[35];
        this.layer1Tiers.setSelectedItem(stringArray[36]);
        this.layer2Tiers.setSelectedItem(stringArray[37]);
        this.layer3Tiers.setSelectedItem(stringArray[38]);
        String[] stringArray2 = stringArray[39].split(":");
        this.minimalDuration = Long.parseLong(stringArray2[0]);
        if (this.minimalDuration <= 0L) {
            this.minDurationButton.setText("Minimal Duration");
            this.minimalDuration = 0L;
        } else if (this.minimalDuration > 0L) {
            this.minDurationButton.setText("Minimal Duration: " + SearchUtil.HHMMSSmmmFormat(this.minimalDuration));
        }
        this.maximalDuration = Long.parseLong(stringArray2[1]);
        if (this.maximalDuration <= 0L) {
            this.maxDurationButton.setText("Maximal Duration");
            this.maximalDuration = 0L;
        } else if (this.maximalDuration > 0L) {
            this.maxDurationButton.setText("Maximal Duration: " + SearchUtil.HHMMSSmmmFormat(this.maximalDuration));
        }
        this.beginAfter = Long.parseLong(stringArray2[2]);
        if (this.beginAfter <= 0L) {
            this.beginAfterButton.setText("Begin After");
            this.beginAfter = 0L;
        } else if (this.beginAfter > 0L) {
            this.beginAfterButton.setText("Begin After: " + SearchUtil.HHMMSSmmmFormat(this.beginAfter));
        }
        this.endBefore = Long.parseLong(stringArray2[3]);
        if (this.endBefore <= 0L) {
            this.endBeforeButton.setText("End Before");
            this.endBefore = 0L;
        } else if (this.endBefore > 0L) {
            this.endBeforeButton.setText("End Before: " + SearchUtil.HHMMSSmmmFormat(this.endBefore));
        }
    }

    public String makeSaveableQuery() {
        return "jqzxw" + (String)this.caseModeChooser.getSelectedItem() + "jqzxw" + (String)this.matchModeChooser.getSelectedItem() + "jqzxw" + this.patternField_1.getText() + "jqzxw" + this.patternField_2.getText() + "jqzxw" + this.patternField_3.getText() + "jqzxw" + this.patternField_4.getText() + "jqzxw" + this.patternField_5.getText() + "jqzxw" + this.patternField_6.getText() + "jqzxw" + this.patternField_7.getText() + "jqzxw" + this.patternField_8.getText() + "jqzxw" + this.patternField_9.getText() + "jqzxw" + this.relation_1_2.getText() + "jqzxw" + this.relation_1_2.constraint + "jqzxw" + this.relation_2_3.getText() + "jqzxw" + this.relation_2_3.constraint + "jqzxw" + this.relation_4_5.getText() + "jqzxw" + this.relation_4_5.constraint + "jqzxw" + this.relation_5_6.getText() + "jqzxw" + this.relation_5_6.constraint + "jqzxw" + this.relation_7_8.getText() + "jqzxw" + this.relation_7_8.constraint + "jqzxw" + this.relation_8_9.getText() + "jqzxw" + this.relation_8_9.constraint + "jqzxw" + this.relation_1_4.getText() + "jqzxw" + this.relation_1_4.constraint + "jqzxw" + this.relation_2_5.getText() + "jqzxw" + this.relation_2_5.constraint + "jqzxw" + this.relation_3_6.getText() + "jqzxw" + this.relation_3_6.constraint + "jqzxw" + this.relation_4_7.getText() + "jqzxw" + this.relation_4_7.constraint + "jqzxw" + this.relation_5_8.getText() + "jqzxw" + this.relation_5_8.constraint + "jqzxw" + this.relation_6_9.getText() + "jqzxw" + this.relation_6_9.constraint + "jqzxw" + this.layer1Tiers.getSelectedItem() + "jqzxw" + this.layer2Tiers.getSelectedItem() + "jqzxw" + this.layer3Tiers.getSelectedItem() + "jqzxw" + this.minimalDuration + ":" + this.maximalDuration + ":" + this.beginAfter + ":" + this.endBefore;
    }

    private String encodeQuery() {
        String string = " Annotation'" + (String)this.caseModeChooser.getSelectedItem() + "'" + (String)this.matchModeChooser.getSelectedItem();
        String string2 = this.minimalDuration + "," + this.maximalDuration + "," + this.beginAfter + "," + this.endBefore + "," + "3, 3, 1, 1, 1" + "jqzxw";
        string2 = string2 + this.patternField_1.getText() + "jqzxw" + string + "jqzxw";
        string2 = string2 + this.relation_1_2.constraint + "jqzxw";
        string2 = string2 + this.relation_1_4.constraint + "jqzxw";
        string2 = string2 + this.patternField_2.getText() + "jqzxw" + string + "jqzxw";
        string2 = string2 + this.relation_2_3.constraint + "jqzxw";
        string2 = string2 + this.relation_2_5.constraint + "jqzxw";
        string2 = string2 + this.patternField_3.getText() + "jqzxw" + string + "jqzxw";
        string2 = string2 + "cns nonejqzxw";
        string2 = string2 + this.relation_3_6.constraint + "jqzxw";
        string2 = string2 + this.layer1Tiers.getSelectedItem() + "jqzxw";
        string2 = string2 + this.patternField_4.getText() + "jqzxw" + string + "jqzxw";
        string2 = string2 + this.relation_4_5.constraint + "jqzxw";
        string2 = string2 + this.relation_4_7.constraint + "jqzxw";
        string2 = string2 + this.patternField_5.getText() + "jqzxw" + string + "jqzxw";
        string2 = string2 + this.relation_5_6.constraint + "jqzxw";
        string2 = string2 + this.relation_5_8.constraint + "jqzxw";
        string2 = string2 + this.patternField_6.getText() + "jqzxw" + string + "jqzxw";
        string2 = string2 + "cns nonejqzxw";
        string2 = string2 + this.relation_6_9.constraint + "jqzxw";
        string2 = string2 + this.layer2Tiers.getSelectedItem() + "jqzxw";
        string2 = string2 + this.patternField_7.getText() + "jqzxw" + string + "jqzxw";
        string2 = string2 + this.relation_7_8.constraint + "jqzxw";
        string2 = string2 + "cns nonejqzxw";
        string2 = string2 + this.patternField_8.getText() + "jqzxw" + string + "jqzxw";
        string2 = string2 + this.relation_8_9.constraint + "jqzxw";
        string2 = string2 + "cns nonejqzxw";
        string2 = string2 + this.patternField_9.getText() + "jqzxw" + string + "jqzxw";
        string2 = string2 + "cns nonejqzxw";
        string2 = string2 + "cns nonejqzxw";
        string2 = string2 + this.layer3Tiers.getSelectedItem();
        return string2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.findButton) {
            if (this.checkQueryValidity()) {
                this.mediator.doQuery(this.encodeQuery(), this.queryId);
                this.resultPanel.startUpdating();
                this.historyPanel.remember(this.makeSaveableQuery());
                this.mediator.putPersistent("multipleTierHistory", this.historyPanel.getHistory());
            }
        } else if (object == this.clearButton) {
            this.resetPatterns();
            this.resetRelations();
            this.layer1Tiers.setSelectedIndex(0);
            this.layer2Tiers.setSelectedIndex(0);
            this.layer3Tiers.setSelectedIndex(0);
            this.minDurationButton.setText("Minimal Duration");
            this.minimalDuration = 0L;
            this.maxDurationButton.setText("Maximal Duration");
            this.maximalDuration = 0L;
            this.beginAfterButton.setText("Begin After");
            this.beginAfter = 0L;
            this.endBeforeButton.setText("End Before");
            this.endBefore = 0L;
            this.historyPanel.reset();
        } else if (object == this.minDurationButton) {
            String string = SearchUtil.HHMMSSmmmFormat(this.minimalDuration);
            String string2 = JOptionPane.showInputDialog(this, "<html> Enter a Minimal Duration for the complete pattern as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", string);
            if (string2 != null) {
                this.minimalDuration = SearchUtil.parseTimeString(string2);
                if (this.minimalDuration == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + string2, "Illegal number format", 0);
                    this.minimalDuration = 0L;
                } else if (this.minimalDuration <= 0L) {
                    this.minDurationButton.setText("Minimal Duration");
                    this.minimalDuration = 0L;
                } else if (this.maximalDuration != 0L && this.minimalDuration > this.maximalDuration) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than the Maximal Duration", "Impossible value", 0);
                    this.minimalDuration = 0L;
                } else if (this.beginAfter > 0L && this.endBefore > 0L && this.minimalDuration > this.beginAfter - this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than (begin after - end before)", "Impossible value", 0);
                    this.minimalDuration = 0L;
                } else if (this.minimalDuration > 0L) {
                    this.minDurationButton.setText("Minimal Duration: " + SearchUtil.HHMMSSmmmFormat(this.minimalDuration));
                }
            }
        } else if (object == this.maxDurationButton) {
            String string = SearchUtil.HHMMSSmmmFormat(this.maximalDuration);
            String string3 = JOptionPane.showInputDialog(this, "<html> Enter a Maximal Duration for the complete pattern as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", string);
            if (string3 != null) {
                this.maximalDuration = SearchUtil.parseTimeString(string3);
                if (this.maximalDuration == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + string3, "Illegal number format", 0);
                    this.maximalDuration = 0L;
                } else if (this.maximalDuration <= 0L) {
                    this.maxDurationButton.setText("Maximal Duration");
                    this.maximalDuration = 0L;
                } else if (this.maximalDuration < this.minimalDuration) {
                    JOptionPane.showMessageDialog(null, "The Maximal Duration must be bigger than the Minimal Duration", "Impossible value", 0);
                    this.maximalDuration = 0L;
                } else if (this.maximalDuration > 0L) {
                    this.maxDurationButton.setText("Maximal Duration: " + SearchUtil.HHMMSSmmmFormat(this.maximalDuration));
                }
            }
        } else if (object == this.beginAfterButton) {
            String string = SearchUtil.HHMMSSmmmFormat(this.beginAfter);
            String string4 = JOptionPane.showInputDialog(this, "<html> Enter a time after which the pattern must begin as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", string);
            if (string4 != null) {
                this.beginAfter = SearchUtil.parseTimeString(string4);
                if (this.beginAfter == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + string4, "Illegal number format", 0);
                    this.beginAfter = 0L;
                } else if (this.beginAfter <= 0L) {
                    this.beginAfterButton.setText("Begin After");
                    this.beginAfter = 0L;
                } else if (this.endBefore != 0L && this.beginAfter > this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Begin After time must be smaller than the End Before time", "Impossible value", 0);
                    this.beginAfter = 0L;
                } else if (this.minimalDuration > 0L && this.endBefore > 0L && this.minimalDuration > this.beginAfter - this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than (begin after - end before)", "Impossible value", 0);
                    this.beginAfter = 0L;
                } else if (this.beginAfter > 0L) {
                    this.beginAfterButton.setText("Begin After: " + SearchUtil.HHMMSSmmmFormat(this.beginAfter));
                }
            }
        } else if (object == this.endBeforeButton) {
            String string = SearchUtil.HHMMSSmmmFormat(this.endBefore);
            String string5 = JOptionPane.showInputDialog(this, "<html> Enter a time before which the pattern must end as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", string);
            if (string5 != null) {
                this.endBefore = SearchUtil.parseTimeString(string5);
                if (this.endBefore == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + string5, "Illegal number format", 0);
                    this.endBefore = 0L;
                } else if (this.endBefore <= 0L) {
                    this.endBeforeButton.setText("End Before");
                    this.endBefore = 0L;
                } else if (this.endBefore < this.beginAfter) {
                    JOptionPane.showMessageDialog(null, "The End Before time must be bigger than the Begin After time", "Impossible value", 0);
                    this.endBefore = 0L;
                } else if (this.minimalDuration > 0L && this.beginAfter > 0L && this.minimalDuration > this.beginAfter - this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than (begin after - end before)", "Impossible value", 0);
                    this.endBefore = 0L;
                } else if (this.endBefore > 0L) {
                    this.endBeforeButton.setText("End Before: " + SearchUtil.HHMMSSmmmFormat(this.endBefore));
                }
            }
        } else {
            if (object == this.hAnnEqual) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" = " + n + " " + "annotation ");
                    } else {
                        this.popupSource.setText(" = " + n + " " + "annotations ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns an=:" + n;
                }
            } else if (object == this.hAnnMore) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" > " + n + " " + "annotation ");
                    } else {
                        this.popupSource.setText(" > " + n + " " + "annotations ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns an>:" + n;
                }
            } else if (object == this.hAnnLess) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" < " + n + " " + "annotation ");
                    } else {
                        this.popupSource.setText(" < " + n + " " + "annotations ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns an<:" + n;
                }
            } else if (object == this.hMilEqual) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" = " + n + " " + "millisecond ");
                    } else {
                        this.popupSource.setText(" = " + n + " " + "milliseconds ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ms=:" + n;
                }
            } else if (object == this.hMilMore) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" > " + n + " " + "millisecond ");
                    } else {
                        this.popupSource.setText(" > " + n + " " + "milliseconds ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ms>:" + n;
                }
            } else if (object == this.hMilLess) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" < " + n + " " + "millisecond ");
                    } else {
                        this.popupSource.setText(" < " + n + " " + "milliseconds ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ms<:" + n;
                }
            } else if (object == this.hNoConstraint) {
                this.popupSource.setText(" " + ((JMenuItem)object).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns none";
            } else if (object == this.hClear) {
                this.popupSource.setText("");
                ((ConstraintLabel)this.popupSource).constraint = "cns none";
            } else if (object == this.vFullyAligned) {
                this.popupSource.setText(" " + ((JMenuItem)object).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns aligned";
            } else if (object == this.vOverlap) {
                this.popupSource.setText(" " + ((JMenuItem)object).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns overlap";
            } else if (object == this.vLeftOverlap) {
                this.popupSource.setText(" " + ((JMenuItem)object).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns l overlap";
            } else if (object == this.vRightOverlap) {
                this.popupSource.setText(" " + ((JMenuItem)object).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns r overlap";
            } else if (object == this.vNoOverlap) {
                this.popupSource.setText(" " + ((JMenuItem)object).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns no overlap";
            } else if (object == this.vBeginBeginEqual) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - begin time = " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" begin time - begin time = " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns bb=:" + n;
                }
            } else if (object == this.vBeginBeginLess) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - begin time < " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" begin time - begin time < " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns bb<:" + n;
                }
            } else if (object == this.vBeginBeginMore) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - begin time > " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" begin time - begin time > " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns bb>:" + n;
                }
            } else if (object == this.vBeginEndEqual) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - end time = " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" begin time - end time = " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns be=:" + n;
                }
            } else if (object == this.vBeginEndLess) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - end time < " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" begin time - end time < " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns be<:" + n;
                }
            } else if (object == this.vBeginEndMore) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - end time > " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" begin time - end time > " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns be>:" + n;
                }
            } else if (object == this.vEndBeginEqual) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - begin time = " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" end time - begin time = " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns eb=:" + n;
                }
            } else if (object == this.vEndBeginLess) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - begin time < " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" end time - begin time < " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns eb<:" + n;
                }
            } else if (object == this.vEndBeginMore) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - begin time > " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" end time - begin time > " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns eb>:" + n;
                }
            } else if (object == this.vEndEndEqual) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - end time = " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" end time - end time = " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ee=:" + n;
                }
            } else if (object == this.vEndEndLess) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - end time < " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" end time - end time < " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ee<:" + n;
                }
            } else if (object == this.vEndEndMore) {
                int n = this.getConstraintValue(((JMenuItem)object).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - end time > " + n + " " + "millisecond" + " ");
                    } else {
                        this.popupSource.setText(" end time - end time > " + n + " " + "milliseconds" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ee>:" + n;
                }
            } else if (object == this.vNoConstraint) {
                this.popupSource.setText(" " + ((JMenuItem)object).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns none";
            } else if (object == this.vClear) {
                this.popupSource.setText("");
                ((ConstraintLabel)this.popupSource).constraint = "cns none";
            }
            this.popupSource.requestFocus();
        }
        this.invalidate();
    }

    private boolean checkQueryValidity() {
        boolean bl = true;
        if (this.relation_1_2.getText().equals("XXXX")) {
            this.relation_1_2.setText("");
        }
        if (this.relation_2_3.getText().equals("XXXX")) {
            this.relation_2_3.setText("");
        }
        if (this.relation_1_4.getText().equals("XXXX")) {
            this.relation_1_4.setText("");
        }
        if (this.relation_2_5.getText().equals("XXXX")) {
            this.relation_2_5.setText("");
        }
        if (this.relation_3_6.getText().equals("XXXX")) {
            this.relation_3_6.setText("");
        }
        if (this.relation_4_5.getText().equals("XXXX")) {
            this.relation_4_5.setText("");
        }
        if (this.relation_5_6.getText().equals("XXXX")) {
            this.relation_5_6.setText("");
        }
        if (this.relation_4_7.getText().equals("XXXX")) {
            this.relation_4_7.setText("");
        }
        if (this.relation_5_8.getText().equals("XXXX")) {
            this.relation_5_8.setText("");
        }
        if (this.relation_6_9.getText().equals("XXXX")) {
            this.relation_6_9.setText("");
        }
        if (this.relation_7_8.getText().equals("XXXX")) {
            this.relation_7_8.setText("");
        }
        if (this.relation_8_9.getText().equals("XXXX")) {
            this.relation_8_9.setText("");
        }
        if (this.patternField_1.getText().equals("XXXX")) {
            this.patternField_1.setText("");
        }
        if (this.patternField_2.getText().equals("XXXX")) {
            this.patternField_2.setText("");
        }
        if (this.patternField_3.getText().equals("XXXX")) {
            this.patternField_3.setText("");
        }
        if (this.patternField_4.getText().equals("XXXX")) {
            this.patternField_4.setText("");
        }
        if (this.patternField_5.getText().equals("XXXX")) {
            this.patternField_5.setText("");
        }
        if (this.patternField_6.getText().equals("XXXX")) {
            this.patternField_6.setText("");
        }
        if (this.patternField_7.getText().equals("XXXX")) {
            this.patternField_7.setText("");
        }
        if (this.patternField_8.getText().equals("XXXX")) {
            this.patternField_8.setText("");
        }
        if (this.patternField_9.getText().equals("XXXX")) {
            this.patternField_9.setText("");
        }
        int n = 0;
        if (this.patternField_1.getText().trim().length() > 0) {
            ++n;
        }
        if (this.patternField_2.getText().trim().length() > 0) {
            ++n;
        }
        if (this.patternField_3.getText().trim().length() > 0) {
            ++n;
        }
        if (this.patternField_4.getText().trim().length() > 0) {
            ++n;
        }
        if (this.patternField_5.getText().trim().length() > 0) {
            ++n;
        }
        if (this.patternField_6.getText().trim().length() > 0) {
            ++n;
        }
        if (this.patternField_7.getText().trim().length() > 0) {
            ++n;
        }
        if (this.patternField_8.getText().trim().length() > 0) {
            ++n;
        }
        if (this.patternField_9.getText().trim().length() > 0) {
            ++n;
        }
        if (n > 1) {
            if (this.patternField_1.getText().trim().length() > 0 && this.patternField_2.getText().trim().length() == 0 && this.patternField_4.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.patternField_2.getText().trim().length() > 0 && this.patternField_1.getText().trim().length() == 0 && this.patternField_3.getText().trim().length() == 0 && this.patternField_5.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.patternField_3.getText().trim().length() > 0 && this.patternField_2.getText().trim().length() == 0 && this.patternField_6.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.patternField_4.getText().trim().length() > 0 && this.patternField_1.getText().trim().length() == 0 && this.patternField_5.getText().trim().length() == 0 && this.patternField_7.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.patternField_5.getText().trim().length() > 0 && this.patternField_2.getText().trim().length() == 0 && this.patternField_4.getText().trim().length() == 0 && this.patternField_6.getText().trim().length() == 0 && this.patternField_8.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.patternField_6.getText().trim().length() > 0 && this.patternField_5.getText().trim().length() == 0 && this.patternField_2.getText().trim().length() == 0 && this.patternField_9.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.patternField_7.getText().trim().length() > 0 && this.patternField_4.getText().trim().length() == 0 && this.patternField_8.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.patternField_8.getText().trim().length() > 0 && this.patternField_7.getText().trim().length() == 0 && this.patternField_5.getText().trim().length() == 0 && this.patternField_9.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.patternField_9.getText().trim().length() > 0 && this.patternField_8.getText().trim().length() == 0 && this.patternField_6.getText().trim().length() == 0) {
                bl = false;
            }
        }
        if (!bl) {
            JOptionPane.showMessageDialog(null, "Please make sure that all non empty patterns are connected with constraints", "Illegal query", 0);
            return bl;
        }
        if (n > 1) {
            if (this.patternField_1.getText().trim().equals("NOT()")) {
                this.patternField_1.requestFocus();
                bl = false;
            }
            if (this.patternField_2.getText().trim().equals("NOT()")) {
                this.patternField_2.requestFocus();
                bl = false;
            }
            if (this.patternField_3.getText().trim().equals("NOT()")) {
                this.patternField_3.requestFocus();
                bl = false;
            }
            if (this.patternField_4.getText().trim().equals("NOT()")) {
                this.patternField_4.requestFocus();
                bl = false;
            }
            if (this.patternField_5.getText().trim().equals("NOT()")) {
                this.patternField_5.requestFocus();
                bl = false;
            }
            if (this.patternField_6.getText().trim().equals("NOT()")) {
                this.patternField_6.requestFocus();
                bl = false;
            }
            if (this.patternField_7.getText().trim().equals("NOT()")) {
                this.patternField_7.requestFocus();
                bl = false;
            }
            if (this.patternField_8.getText().trim().equals("NOT()")) {
                this.patternField_8.requestFocus();
                bl = false;
            }
            if (this.patternField_9.getText().trim().equals("NOT()")) {
                this.patternField_9.requestFocus();
                bl = false;
            }
        }
        if (!bl) {
            JOptionPane.showMessageDialog(null, "A NOT() must have a value between ( and ) ", "Illegal NOT() pattern", 0);
            return bl;
        }
        if (this.relation_1_2.getText().trim().length() > 0) {
            if (this.patternField_1.getText().trim().length() == 0) {
                this.patternField_1.setText("XXXX");
                bl = false;
            }
            if (this.patternField_2.getText().trim().length() == 0) {
                this.patternField_2.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_2_3.getText().trim().length() > 0) {
            if (this.patternField_2.getText().trim().length() == 0) {
                this.patternField_2.setText("XXXX");
                bl = false;
            }
            if (this.patternField_3.getText().trim().length() == 0) {
                this.patternField_3.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_1_4.getText().trim().length() > 0) {
            if (this.patternField_1.getText().trim().length() == 0) {
                this.patternField_1.setText("XXXX");
                bl = false;
            }
            if (this.patternField_4.getText().trim().length() == 0) {
                this.patternField_4.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_2_5.getText().trim().length() > 0) {
            if (this.patternField_2.getText().trim().length() == 0) {
                this.patternField_2.setText("XXXX");
                bl = false;
            }
            if (this.patternField_5.getText().trim().length() == 0) {
                this.patternField_5.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_3_6.getText().trim().length() > 0) {
            if (this.patternField_3.getText().trim().length() == 0) {
                this.patternField_3.setText("XXXX");
                bl = false;
            }
            if (this.patternField_6.getText().trim().length() == 0) {
                this.patternField_6.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_4_5.getText().trim().length() > 0) {
            if (this.patternField_4.getText().trim().length() == 0) {
                this.patternField_4.setText("XXXX");
                bl = false;
            }
            if (this.patternField_5.getText().trim().length() == 0) {
                this.patternField_5.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_5_6.getText().trim().length() > 0) {
            if (this.patternField_5.getText().trim().length() == 0) {
                this.patternField_5.setText("XXXX");
                bl = false;
            }
            if (this.patternField_6.getText().trim().length() == 0) {
                this.patternField_6.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_4_7.getText().trim().length() > 0) {
            if (this.patternField_4.getText().trim().length() == 0) {
                this.patternField_4.setText("XXXX");
                bl = false;
            }
            if (this.patternField_7.getText().trim().length() == 0) {
                this.patternField_7.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_5_8.getText().trim().length() > 0) {
            if (this.patternField_5.getText().trim().length() == 0) {
                this.patternField_5.setText("XXXX");
                bl = false;
            }
            if (this.patternField_8.getText().trim().length() == 0) {
                this.patternField_8.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_6_9.getText().trim().length() > 0) {
            if (this.patternField_6.getText().trim().length() == 0) {
                this.patternField_6.setText("XXXX");
                bl = false;
            }
            if (this.patternField_9.getText().trim().length() == 0) {
                this.patternField_9.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_7_8.getText().trim().length() > 0) {
            if (this.patternField_7.getText().trim().length() == 0) {
                this.patternField_7.setText("XXXX");
                bl = false;
            }
            if (this.patternField_8.getText().trim().length() == 0) {
                this.patternField_8.setText("XXXX");
                bl = false;
            }
        }
        if (this.relation_8_9.getText().trim().length() > 0) {
            if (this.patternField_8.getText().trim().length() == 0) {
                this.patternField_8.setText("XXXX");
                bl = false;
            }
            if (this.patternField_9.getText().trim().length() == 0) {
                this.patternField_9.setText("XXXX");
                bl = false;
            }
        }
        if (!bl) {
            JOptionPane.showMessageDialog(null, "Please define the patterns marked with XXXX", "Illegal query", 0);
            return bl;
        }
        if (this.patternField_1.getText().trim().length() > 0) {
            if (this.patternField_2.getText().trim().length() > 0 && this.relation_1_2.getText().trim().length() == 0) {
                this.relation_1_2.setText("XXXX");
                bl = false;
            }
            if (this.patternField_4.getText().trim().length() > 0 && this.relation_1_4.getText().trim().length() == 0) {
                this.relation_1_4.setText("XXXX");
                bl = false;
            }
        }
        if (this.patternField_2.getText().trim().length() > 0) {
            if (this.patternField_3.getText().trim().length() > 0 && this.relation_2_3.getText().trim().length() == 0) {
                this.relation_2_3.setText("XXXX");
                bl = false;
            }
            if (this.patternField_5.getText().trim().length() > 0 && this.relation_2_5.getText().trim().length() == 0) {
                this.relation_2_5.setText("XXXX");
                bl = false;
            }
        }
        if (this.patternField_3.getText().trim().length() > 0 && this.patternField_6.getText().trim().length() > 0 && this.relation_3_6.getText().trim().length() == 0) {
            this.relation_3_6.setText("XXXX");
            bl = false;
        }
        if (this.patternField_4.getText().trim().length() > 0) {
            if (this.patternField_7.getText().trim().length() > 0 && this.relation_4_7.getText().trim().length() == 0) {
                this.relation_4_7.setText("XXXX");
                bl = false;
            }
            if (this.patternField_5.getText().trim().length() > 0 && this.relation_4_5.getText().trim().length() == 0) {
                this.relation_4_5.setText("XXXX");
                bl = false;
            }
        }
        if (this.patternField_5.getText().trim().length() > 0) {
            if (this.patternField_6.getText().trim().length() > 0 && this.relation_5_6.getText().trim().length() == 0) {
                this.relation_5_6.setText("XXXX");
                bl = false;
            }
            if (this.patternField_8.getText().trim().length() > 0 && this.relation_5_8.getText().trim().length() == 0) {
                this.relation_5_8.setText("XXXX");
                bl = false;
            }
        }
        if (this.patternField_6.getText().trim().length() > 0 && this.patternField_9.getText().trim().length() > 0 && this.relation_6_9.getText().trim().length() == 0) {
            this.relation_6_9.setText("XXXX");
            bl = false;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(null, "Please define the constraints marked with XXXX", "Not all constraints are defined", 0);
            return bl;
        }
        String string = (String)this.matchModeChooser.getSelectedItem();
        if (string.equals(" regular expression")) {
            if (!this.checkRegexp(this.patternField_1)) {
                this.patternField_1.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_2)) {
                this.patternField_2.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_3)) {
                this.patternField_3.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_4)) {
                this.patternField_4.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_5)) {
                this.patternField_5.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_6)) {
                this.patternField_6.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_7)) {
                this.patternField_7.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_8)) {
                this.patternField_8.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_9)) {
                this.patternField_9.requestFocus();
                return false;
            }
        }
        return true;
    }

    private boolean checkRegexp(JTextField jTextField) {
        String[] stringArray = new String[]{jTextField.getText()};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Pattern.compile(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Not a valid regular expression:\n\n     " + stringArray[i], "Error", 0);
                jTextField.requestFocus();
                return false;
            }
        }
        return true;
    }

    private boolean checkNGram(JTextField jTextField) {
        String string = jTextField.getText();
        if (string.trim().length() > 0) {
            String[] stringArray = string.split(" +");
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("prt " + stringArray[i]);
                if (stringArray[i].equals("#")) continue;
                bl = false;
            }
            if (bl) {
                JOptionPane.showMessageDialog(null, "An n-gram pattern must contain at least one character other than #", "Only wildcards in pattern", 0);
                return false;
            }
        }
        return true;
    }

    private void resetPatterns() {
        if (this.patternField_1 != null) {
            this.patternField_1.setText("");
            this.patternField_2.setText("");
            this.patternField_3.setText("");
            this.patternField_4.setText("");
            this.patternField_5.setText("");
            this.patternField_6.setText("");
            this.patternField_7.setText("");
            this.patternField_8.setText("");
            this.patternField_9.setText("");
        }
    }

    private void resetRelations() {
        if (this.relation_1_2 != null) {
            this.relation_1_2.setText("");
            this.relation_1_2.constraint = "cns none";
            this.relation_2_3.setText("");
            this.relation_2_3.constraint = "cns none";
            this.relation_1_4.setText("");
            this.relation_1_4.constraint = "cns none";
            this.relation_2_5.setText("");
            this.relation_2_5.constraint = "cns none";
            this.relation_3_6.setText("");
            this.relation_3_6.constraint = "cns none";
            this.relation_4_5.setText("");
            this.relation_4_5.constraint = "cns none";
            this.relation_5_6.setText("");
            this.relation_5_6.constraint = "cns none";
            this.relation_4_7.setText("");
            this.relation_4_7.constraint = "cns none";
            this.relation_5_8.setText("");
            this.relation_5_8.constraint = "cns none";
            this.relation_6_9.setText("");
            this.relation_6_9.constraint = "cns none";
            this.relation_7_8.setText("");
            this.relation_7_8.constraint = "cns none";
            this.relation_8_9.setText("");
            this.relation_8_9.constraint = "cns none";
        }
    }

    private int getConstraintValue(String string) {
        String string2 = "";
        String string3 = "";
        string3 = string.indexOf("milli") >= 0 ? "Please enter the time in milliseconds" : "Please enter the number of annotations";
        string2 = (String)JOptionPane.showInputDialog(null, string3, string, 1, null, null, "");
        int n = -1;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
                if (n < 0) {
                    JOptionPane.showMessageDialog(this, "A negative value is not allowed", string, 0);
                } else if (n == 0 && string.indexOf("<") >= 0) {
                    JOptionPane.showMessageDialog(this, "The value 0 is not allowed for this constraint", string, 0);
                    n = -1;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, string2 + " " + "is not a valid integer number", "Error", 0);
            }
        }
        return n;
    }

    private static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector order;

        public MyOwnFocusTraversalPolicy(Vector vector) {
            this.order = new Vector(vector.size());
            this.order.addAll(vector);
        }

        public Component getComponentAfter(Container container, Component component) {
            int n = (this.order.indexOf(component) + 1) % this.order.size();
            return (Component)this.order.get(n);
        }

        public Component getComponentBefore(Container container, Component component) {
            int n = this.order.indexOf(component) - 1;
            if (n < 0) {
                n = this.order.size() - 1;
            }
            return (Component)this.order.get(n);
        }

        public Component getDefaultComponent(Container container) {
            return (Component)this.order.get(0);
        }

        public Component getLastComponent(Container container) {
            return (Component)this.order.lastElement();
        }

        public Component getFirstComponent(Container container) {
            return (Component)this.order.get(0);
        }
    }

    private class ConstraintLabel
    extends JLabel {
        public String constraint = "cns none";

        public ConstraintLabel() {
            this.setOpaque(true);
            this.setBackground(Constants.CONSTRAINT_LABEL_COLOR);
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            if ((mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent)) && (object = mouseEvent.getSource()) instanceof JLabel) {
                MultipleLayerSearchPanel.this.popupSource = (JLabel)object;
                if (object == MultipleLayerSearchPanel.this.relation_1_4 || object == MultipleLayerSearchPanel.this.relation_4_7 || object == MultipleLayerSearchPanel.this.relation_2_5 || object == MultipleLayerSearchPanel.this.relation_5_8 || object == MultipleLayerSearchPanel.this.relation_3_6 || object == MultipleLayerSearchPanel.this.relation_6_9) {
                    MultipleLayerSearchPanel.this.verticalRelations.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    MultipleLayerSearchPanel.this.horizontalRelations.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                // empty if block
            }
        }
    }
}

