/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchQuery;
import mpi.annex.util.AnnexUtil;
import org.apache.log4j.Logger;

public class PostgresQuery
extends SearchQuery {
    private static Logger logger = Logger.getLogger((String)"ANNEX.PostgresQuery");
    private String url;
    private String usr;
    private String pwd;
    private ArrayList domainNodeIds;
    private ArrayList domainTiers;
    private ArrayList domainTiersSize;
    private ArrayList domainTiersNodeId;

    public PostgresQuery(String string, String string2, String string3) {
        this.url = string;
        this.usr = string2;
        this.pwd = string3;
        this.schemaName = "search";
        this.domainTiers = new ArrayList();
        this.domainTiersSize = new ArrayList();
        this.domainTiersNodeId = new ArrayList();
    }

    public void doQuery(ArrayList arrayList, String string) {
        this.domainNodeIds = arrayList;
        this.cancelQuery();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this.createLayers(string);
        this.keepExecuting = true;
        this.isExecuting = true;
        new Thread(new QueryExecutor()).start();
    }

    public void cancelQuery() {
        if (this.isExecuting) {
            this.keepExecuting = false;
            try {
                while (this.isExecuting) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isExecuting = false;
    }

    private String constructMainQueryPart() {
        String string = "";
        return string;
    }

    private String constructDomainQueryPart() {
        String string = "";
        for (int i = 0; i < this.nLayers; ++i) {
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                if (this.searchLayers[i].getPattern(j).length() <= 0) continue;
            }
        }
        return string;
    }

    protected String createQueryPatternPart(String string, String[] stringArray, Pattern pattern, boolean bl) {
        int n = string.length();
        String string2 = "";
        this.patternNeedsFullStatistics = false;
        if (stringArray[0].equals(" Annotation")) {
            if (stringArray[1].equals(" case sensitive")) {
                if (stringArray[2].equals(" exact match")) {
                    string2 = bl ? "annotation != '" + string + "'" : "annotation = '" + string + "'";
                } else if (stringArray[2].equals(" substring match")) {
                    if (bl) {
                        string2 = "annotation NOT LIKE '%" + this.escape(string) + "%' ESCAPE '\u00b1'";
                    } else {
                        string2 = "annotation LIKE '%" + this.escape(string) + "%' ESCAPE '\u00b1'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (stringArray[2].equals(" regular expression")) {
                    if (bl) {
                        string2 = "annotation !~ '" + this.escapeRegExp(string) + "'";
                    } else {
                        string2 = "annotation ~ '" + this.escapeRegExp(string) + "'";
                        this.patternNeedsFullStatistics = true;
                    }
                }
            } else if (stringArray[2].equals(" exact match")) {
                string2 = bl ? "annotation NOT ILIKE '" + string + "'" : "annotation ILIKE '" + string + "'";
            } else if (stringArray[2].equals(" substring match")) {
                if (bl) {
                    string2 = "annotation NOT ILIKE '%" + this.escape(string) + "%' ESCAPE '\u00b1'";
                } else {
                    string2 = "annotation ILIKE '%" + this.escape(string) + "%' ESCAPE '\u00b1'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (stringArray[2].equals(" regular expression")) {
                if (bl) {
                    string2 = "annotation !~* '" + this.escapeRegExp(string) + "'";
                } else {
                    string2 = "annotation ~* '" + this.escapeRegExp(string) + "'";
                    this.patternNeedsFullStatistics = true;
                }
            }
        } else if (stringArray[0].equals(" N-gram over annotations") || stringArray[0].equals(" N-gram within annotation")) {
            String string3 = this.getLongestNonWildcardPart(string);
            if (stringArray[2].equals(" regular expression")) {
                if (stringArray[0].equals(" N-gram within annotation")) {
                    if (string3.startsWith("^")) {
                        string3 = string3.substring(1);
                    }
                    if (string3.endsWith("$")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                }
                if (stringArray[1].equals(" case sensitive")) {
                    if (bl) {
                        string2 = "annotation !~ '" + this.escapeRegExp(string3) + "'";
                    } else {
                        string2 = "annotation ~ '" + this.escapeRegExp(string3) + "'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (bl) {
                    string2 = "annotation !~* '" + this.escapeRegExp(string3) + "'";
                } else {
                    string2 = "annotation ~* '" + this.escapeRegExp(string3) + "'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (stringArray[1].equals(" case sensitive")) {
                if (bl) {
                    string2 = "annotation NOT LIKE '%" + this.escape(string3) + "%' ESCAPE '\u00b1'";
                } else {
                    string2 = "annotation LIKE '%" + this.escape(string3) + "%' ESCAPE '\u00b1'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (bl) {
                string2 = "annotation NOT ILIKE '%" + this.escape(string3) + "%' ESCAPE '\u00b1'";
            } else {
                string2 = "annotation ILIKE '%" + this.escape(string3) + "%' ESCAPE '\u00b1'";
                this.patternNeedsFullStatistics = true;
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructTierDomain(ArrayList arrayList, ArrayList arrayList2) {
        Connection connection = null;
        try {
            Object object;
            connection = DriverManager.getConnection(this.url, this.usr, this.pwd);
            Statement statement = connection.createStatement(1004, 1007);
            this.domainTiers.clear();
            this.domainTiersSize.clear();
            this.domainTiersNodeId.clear();
            HashSet hashSet = new HashSet(arrayList);
            String string = "";
            if (!arrayList2.contains(" All Tiers ")) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    object = (String)arrayList2.get(i);
                    if (((String)object).startsWith(" Tier Name: ")) {
                        string = string + " tier_name = '" + ((String)object).substring(" Tier Name: ".length()) + "' OR";
                        continue;
                    }
                    if (((String)object).startsWith(" Tier Type: ")) {
                        string = string + " tier_type = '" + ((String)object).substring(" Tier Type: ".length()) + "' OR";
                        continue;
                    }
                    if (!((String)object).startsWith(" Participant: ")) continue;
                    string = string + " participant = '" + ((String)object).substring(" Participant: ".length()) + "' OR";
                }
                if (string.length() > 0) {
                    string = string.substring(0, string.length() - 2);
                    string = " WHERE ( " + string + ")";
                }
            }
            String string2 = "SELECT node_id, tier_id, n_annotations FROM search.tiers " + string + " ORDER BY node_id";
            object = statement.executeQuery(string2);
            while (object.next()) {
                String string3 = object.getString(1);
                if (!hashSet.contains(string3)) continue;
                this.domainTiers.add(new Integer(object.getInt(2)));
                this.domainTiersSize.add(new Integer(object.getInt(3)));
                this.domainTiersNodeId.add(string3);
            }
            logger.debug((Object)("#tiers in domain: " + this.domainTiers.size()));
            object.close();
        }
        catch (Exception exception) {
            logger.debug((Object)"setDomain", (Throwable)exception);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {
                logger.debug((Object)"setDomain, close connection", (Throwable)exception);
            }
        }
    }

    public ArrayList getViewerParametersFor(int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.url, this.usr, this.pwd);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = " + n);
            resultSet.next();
            Long l = new Long(resultSet.getLong(1));
            Long l2 = new Long(resultSet.getLong(2));
            int n3 = resultSet.getInt(3);
            resultSet = statement.executeQuery("SELECT tier_name, node_id FROM " + this.schemaName + ".tiers WHERE tier_id = " + n3);
            resultSet.next();
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            arrayList.add(string2);
            arrayList.add(string);
            arrayList.add(l);
            arrayList.add(l2);
        }
        catch (Exception exception) {
            try {
                connection.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getHits(int n, int n2, int n3) {
        ArrayList<SearchHit> arrayList = new ArrayList<SearchHit>();
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.url, this.usr, this.pwd);
            Statement statement = connection.createStatement(1004, 1007);
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            int[][] nArray = new int[this.nLayers][this.nPatternsPerLayer];
            int[] nArray2 = this.searchLayers[this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern(this.firstNonEmptyPatternIndex);
            int[] nArray3 = this.searchLayers[this.firstNonEmptyLayerIndex].getHitNumberForPattern(this.firstNonEmptyPatternIndex);
            int[] nArray4 = this.searchLayers[this.firstNonEmptyLayerIndex].getHitFileIds();
            for (int i = n; i < n2 && i < this.statistics.nHits && i < 10000; ++i) {
                Object object;
                int n4;
                int n5;
                SearchHit searchHit = new SearchHit();
                int n6 = nArray2[i];
                ResultSet resultSet = statement.executeQuery("SELECT ann_position, annotation, begin_time, end_time, ann_tier_id, aligned FROM " + this.schemaName + ".annotations WHERE ann_id = " + n6);
                resultSet.next();
                searchHit.positionInTier = resultSet.getInt(1);
                if (this.isSimpleQuery) {
                    searchHit.annotation = resultSet.getString(2);
                    searchHit.beginTime = resultSet.getLong(3);
                    searchHit.endTime = resultSet.getLong(4);
                } else {
                    for (n5 = 0; n5 < this.nLayers; ++n5) {
                        for (n4 = 0; n4 < this.nPatternsPerLayer; ++n4) {
                            object = this.searchLayers[n5].getHitAnnIdsForPattern(n4);
                            nArray[n5][n4] = object != null ? object[i] : -1;
                        }
                    }
                    Statement statement2 = connection.createStatement(1004, 1007);
                    SearchQuery.ComplexHitData complexHitData = this.constructComplexHitResultString(null, statement2, nArray, true);
                    searchHit.annotation = complexHitData.hitString;
                    searchHit.beginTime = complexHitData.beginTime;
                    searchHit.endTime = complexHitData.endTime;
                }
                n5 = resultSet.getInt(5);
                searchHit.aligned = resultSet.getBoolean(6);
                resultSet = statement.executeQuery("SELECT node_id, tier_name, tier_type, participant, n_annotations FROM " + this.schemaName + ".tiers WHERE tier_id = " + n5);
                resultSet.next();
                searchHit.transcriptionNodeId = resultSet.getString(1);
                searchHit.transcriptionName = AnnexUtil.getNamePathFor(searchHit.transcriptionNodeId);
                searchHit.tierName = resultSet.getString(2);
                searchHit.tierType = this.isSimpleQuery ? resultSet.getString(3) : "oadhohdpiouhdpiuhA;SUSey;O";
                searchHit.participant = resultSet.getString(4);
                n4 = resultSet.getInt(5);
                searchHit.hitNumberInAnnotation = nArray3[i];
                object = this.searchLayers[this.firstNonEmptyLayerIndex].getPattern(this.firstNonEmptyPatternIndex);
                boolean bl = this.searchLayers[this.firstNonEmptyLayerIndex].getPatternNOTMode(this.firstNonEmptyPatternIndex);
                Pattern pattern = this.searchLayers[this.firstNonEmptyLayerIndex].getRegExpPattern(this.firstNonEmptyPatternIndex);
                String[] stringArray = this.searchLayers[this.firstNonEmptyLayerIndex].getMode(this.firstNonEmptyPatternIndex);
                searchHit.hitPositionInAnnotation = this.getHitPosition(searchHit.annotation, searchHit.hitNumberInAnnotation, stringArray, (String)object, pattern, bl);
                searchHit.hitLength = this.getHitLength(searchHit.annotation, searchHit.hitNumberInAnnotation, stringArray, (String)object, pattern, bl);
                if (stringArray[0].equals(" N-gram over annotations")) {
                    int n7;
                    int n8 = n3 + this.nGramSizeLeftFromHit;
                    resultSet = statement.executeQuery("SELECT annotation, ann_position, begin_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + n5 + "AND ann_position < " + searchHit.positionInTier + "AND ann_position >= " + (searchHit.positionInTier - n8) + "ORDER BY ann_position DESC");
                    arrayList2.clear();
                    while (resultSet.next()) {
                        searchHit.leftContext.add(resultSet.getString(1));
                        arrayList2.add(new Long(resultSet.getLong(3)));
                    }
                    for (n7 = 0; n7 < this.nGramSizeLeftFromHit; ++n7) {
                        if (searchHit.leftContext.size() <= 0) continue;
                        String string = (String)searchHit.leftContext.get(0);
                        searchHit.annotation = string + " " + searchHit.annotation;
                        searchHit.beginTime = (Long)arrayList2.get(0);
                        searchHit.leftContext.remove(0);
                        arrayList2.remove(0);
                    }
                    n7 = n3 + this.nGramSizeRightFromHit;
                    resultSet = statement.executeQuery("SELECT annotation, ann_position, end_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + n5 + "AND ann_position > " + searchHit.positionInTier + "AND ann_position <= " + (searchHit.positionInTier + n7) + "ORDER BY ann_position");
                    int n9 = 0;
                    while (resultSet.next()) {
                        if (n9 < this.nGramSizeRightFromHit) {
                            searchHit.annotation = searchHit.annotation + " " + resultSet.getString(1);
                            searchHit.endTime = resultSet.getLong(3);
                        } else {
                            searchHit.rightContext.add(resultSet.getString(1));
                        }
                        ++n9;
                    }
                    searchHit.hitPositionInAnnotation = 0;
                    searchHit.hitLength = searchHit.annotation.length();
                    searchHit.positionInTier -= n8;
                    ++searchHit.positionInTier;
                } else {
                    resultSet = statement.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + n5 + "AND ann_position < " + searchHit.positionInTier + "AND ann_position >= " + (searchHit.positionInTier - n3) + "ORDER BY ann_position DESC");
                    while (resultSet.next()) {
                        searchHit.leftContext.add(resultSet.getString(1));
                    }
                    resultSet = statement.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + n5 + "AND ann_position > " + searchHit.positionInTier + "AND ann_position <= " + (searchHit.positionInTier + n3) + "ORDER BY ann_position");
                    while (resultSet.next()) {
                        searchHit.rightContext.add(resultSet.getString(1));
                    }
                    ++searchHit.positionInTier;
                }
                arrayList.add(searchHit);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)exception.toString());
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private String escape(String string) {
        String string2 = string.replaceAll("\u00b1", "\u00b1\u00b1");
        string2 = string2.replaceAll("%", "\u00b1%");
        string2 = string2.replaceAll("'", "\\\\'");
        string2 = string2.replaceAll("\"", "\u00b1\"");
        return string2.replaceAll("_", "\u00b1_");
    }

    private String escapeRegExp(String string) {
        return string.replaceAll("\\\\", "\\\\\\\\");
    }

    protected void clearPreparedStatements() {
        try {
            for (int i = 0; i < this.nLayers; ++i) {
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    this.preparedStatements[i][j].close();
                    this.preparedStatements[i][j] = null;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void xinvestigateComplexPattern(int n, int n2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            while (n < this.nLayers) {
                if (n2 + 1 < this.nPatternsPerLayer) {
                    ++n2;
                } else {
                    ++n;
                    n2 = 0;
                }
                if (n == this.nLayers) {
                    if (!this.patternHasValidDuration(-1L, -1L, connection)) {
                        return;
                    }
                    if (this.statistics.nHits < 10000) {
                        this.rememberHitData(this.statistics.nHits);
                    }
                    String string = this.constructComplexHitResultString((Connection)connection, (Statement)statement, (int[][])this.globalHitAnnId, (boolean)false).hitString.replaceAll("jqzxw", " ");
                    int n3 = this.globalHitAnnId[this.firstNonEmptyLayerIndex][this.firstNonEmptyPatternIndex];
                    int n4 = this.globalHitFileId[this.firstNonEmptyLayerIndex][this.firstNonEmptyPatternIndex];
                    this.updateFrequencyStatistics(string.replaceAll("qwynbbvs", "  #"), n3, n4, this.firstNonEmptyLayerIndex, this.firstNonEmptyPatternIndex);
                    ++this.statistics.nHits;
                    ++this.statistics.nAnnotationsWithHit;
                    return;
                }
                if (this.searchLayers[n].getPattern(n2).length() <= 0) continue;
            }
            String string = this.searchLayers[n].getPattern(n2);
            boolean bl = this.searchLayers[n].getPatternNOTMode(n2);
            Pattern pattern = this.searchLayers[n].getRegExpPattern(n2);
            String[] stringArray = this.searchLayers[n].getMode(n2);
            String string2 = "SELECT ann_id, ann_tier_id, annotation, ann_position, begin_time, end_time, aligned, ref_ann_id FROM " + this.schemaName + ".annotations WHERE ";
            string2 = string2 + this.createQueryPatternPart(string, stringArray, pattern, bl);
            string2 = string2 + this.createHorizontalConstraintPart(n, n2, statement);
            string2 = string2 + this.createVerticalConstraintPart(n, n2, statement);
            string2 = string2 + this.createTierConstraintPart(n, n2);
            string2 = string2 + this.createGlobalTimeConstraintPart();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                int n5 = resultSet.getInt(1);
                int n6 = resultSet.getInt(2);
                this.globalHitAnnId[n][n2] = n5;
                this.globalHitTierId[n][n2] = n6;
                this.globalHitBeginTime[n][n2] = resultSet.getLong(5);
                this.globalHitEndTime[n][n2] = resultSet.getLong(6);
                this.globalHitPosition[n][n2] = resultSet.getInt(4);
                this.investigateComplexPattern(n, n2, connection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (Exception exception) {
            logger.debug((Object)exception.toString());
        }
    }

    private class QueryExecutor
    implements Runnable {
        private Connection con;
        private String pattern;
        private boolean patternNOTMode;
        private Pattern regExpPattern;
        private String[] queryModes;
        private Statement statement;
        private PreparedStatement getHitsInTier;
        private ResultSet rs;
        private int fileIndex;
        private String previousNodeId;

        public QueryExecutor() {
            try {
                this.con = DriverManager.getConnection(PostgresQuery.this.url, PostgresQuery.this.usr, PostgresQuery.this.pwd);
                this.statement = this.con.createStatement();
                this.previousNodeId = "";
                if (PostgresQuery.this.firstNonEmptyPatternIndex >= 0) {
                    this.pattern = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPattern(PostgresQuery.this.firstNonEmptyPatternIndex);
                    this.patternNOTMode = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPatternNOTMode(PostgresQuery.this.firstNonEmptyPatternIndex);
                    this.regExpPattern = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getRegExpPattern(PostgresQuery.this.firstNonEmptyPatternIndex);
                    this.queryModes = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getMode(PostgresQuery.this.firstNonEmptyPatternIndex);
                }
                PostgresQuery.this.constructTierDomain(PostgresQuery.this.domainNodeIds, PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getTierConstraints());
                String string = "SELECT ann_id, annotation, begin_time, end_time, ann_position FROM " + PostgresQuery.this.schemaName + ".annotations WHERE ann_tier_id = ? AND ";
                string = string + PostgresQuery.this.createQueryPatternPart(this.pattern, this.queryModes, this.regExpPattern, this.patternNOTMode);
                string = string + PostgresQuery.this.createGlobalTimeConstraintPart();
                this.getHitsInTier = this.con.prepareStatement(string, 1004, 1007);
            }
            catch (Exception exception) {
                logger.debug((Object)"constructor query executor", (Throwable)exception);
                try {
                    this.con.close();
                }
                catch (Exception exception2) {
                    logger.debug((Object)"closing connection", (Throwable)exception2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.pattern == null) {
                PostgresQuery.this.statistics.progress = 1.0f;
                PostgresQuery.this.isExecuting = false;
            } else {
                try {
                    for (int i = 0; i < PostgresQuery.this.domainTiers.size(); ++i) {
                        int n = (Integer)PostgresQuery.this.domainTiers.get(i);
                        PostgresQuery.this.currentNodeId = (String)PostgresQuery.this.domainTiersNodeId.get(i);
                        if (!PostgresQuery.this.isSimpleQuery && !PostgresQuery.this.currentNodeId.equals(this.previousNodeId)) {
                            this.previousNodeId = PostgresQuery.this.currentNodeId;
                            PostgresQuery.this.setTierDomainForLayers(true, this.statement);
                            PostgresQuery.this.clearPreparedStatements();
                        }
                        this.getHitsInTier.setInt(1, n);
                        this.rs = this.getHitsInTier.executeQuery();
                        while (this.rs.next()) {
                            int n2 = this.rs.getInt(1);
                            String string = this.rs.getString(2);
                            if (PostgresQuery.this.isSimpleQuery) {
                                int n3;
                                if (this.queryModes[0].equals(" Annotation")) {
                                    long l;
                                    long l2 = this.rs.getLong(3);
                                    if (!PostgresQuery.this.patternHasValidDuration(l2, l = this.rs.getLong(4), this.con)) continue;
                                    PostgresQuery.this.updateFrequencyStatistics(string, n2, this.fileIndex, PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex);
                                    ++PostgresQuery.this.statistics.nAnnotationsWithHit;
                                    n3 = 1;
                                    if (PostgresQuery.this.patternNeedsFullStatistics) {
                                        n3 = PostgresQuery.this.countHitsInAnnotation(string, this.queryModes, this.pattern, this.regExpPattern, this.patternNOTMode);
                                    }
                                    for (int j = 0; j < n3; ++j) {
                                        if (PostgresQuery.this.statistics.nHits < 10000) {
                                            PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = n2;
                                            PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = j + 1;
                                            PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[PostgresQuery.this.statistics.nHits] = this.fileIndex;
                                        }
                                        ++PostgresQuery.this.statistics.nHits;
                                    }
                                } else {
                                    String[] stringArray;
                                    if (this.queryModes[0].equals(" N-gram over annotations")) {
                                        PostgresQuery.this.nGramSizeLeftFromHit = PostgresQuery.this.getLongestNonWildcardPartPosition(this.pattern);
                                        PostgresQuery.this.nGramSizeRightFromHit = PostgresQuery.this.getNGramLength(this.pattern) - PostgresQuery.this.nGramSizeLeftFromHit - 1;
                                    }
                                    if ((stringArray = PostgresQuery.this.constructNGrams(n2, this.statement, PostgresQuery.this.schemaName, this.pattern, this.queryModes)) != null) {
                                        boolean bl = false;
                                        boolean bl2 = true;
                                        int n4 = 1;
                                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                                            String string2 = stringArray[n3];
                                            if (!PostgresQuery.this.isNGramMatch(string2, this.pattern, this.queryModes)) continue;
                                            if (!bl) {
                                                string2 = string2.replace("jqzxw", " ");
                                                PostgresQuery.this.updateFrequencyStatistics(string2, n2, this.fileIndex, PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex);
                                                bl = true;
                                            }
                                            if (this.queryModes[0].equals(" N-gram over annotations") || bl2) {
                                                ++PostgresQuery.this.statistics.nAnnotationsWithHit;
                                                bl2 = false;
                                            }
                                            if (PostgresQuery.this.statistics.nHits < 10000) {
                                                PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = n2;
                                                PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = n4++;
                                                PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[PostgresQuery.this.statistics.nHits] = this.fileIndex;
                                            }
                                            ++PostgresQuery.this.statistics.nHits;
                                        }
                                    }
                                }
                            } else {
                                PostgresQuery.this.clearHitData(this.fileIndex);
                                PostgresQuery.this.globalHitAnnId[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = n2;
                                PostgresQuery.this.globalHitTierId[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = n;
                                PostgresQuery.this.globalHitBeginTime[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = this.rs.getLong(3);
                                PostgresQuery.this.globalHitEndTime[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = this.rs.getLong(4);
                                PostgresQuery.this.globalHitPosition[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = this.rs.getInt(5);
                                PostgresQuery.this.xinvestigateComplexPattern(PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex, this.con);
                            }
                            if (PostgresQuery.this.keepExecuting) continue;
                            break;
                        }
                        if (!PostgresQuery.this.keepExecuting) {
                        } else {
                            PostgresQuery.this.statistics.nAnnotationsSearched += ((Integer)PostgresQuery.this.domainTiersSize.get(i)).intValue();
                            PostgresQuery.this.statistics.progress = i == PostgresQuery.this.domainTiers.size() - 1 ? 1.0f : (float)i / (float)PostgresQuery.this.domainTiers.size();
                            if (PostgresQuery.this.keepExecuting) continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    logger.debug((Object)"exception during query execution", (Throwable)exception);
                }
                finally {
                    try {
                        this.con.close();
                        this.getHitsInTier.close();
                    }
                    catch (Exception exception) {
                        logger.debug((Object)"exception during finally part of query execution", (Throwable)exception);
                    }
                }
                PostgresQuery.this.isExecuting = false;
            }
        }
    }
}

