/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.SearchDomainPanel;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchMediator;
import mpi.annex.search.SearchPane;
import mpi.annex.search.SearchResultPanel;
import mpi.annex.search.SearchStatistics;

public class SearchAppletMediator
implements SearchMediator {
    private String domainId;
    private Applet applet;
    private HashMap bufferedHitsForQuery;
    private HashMap domainTypesForQuery;
    private SearchPane searchPane;
    private URL serverURL;
    private ArrayList domainInfo;
    private ArrayList searchModes;
    private ArrayList eafTierNames;
    private ArrayList eafTierTypes;
    private ArrayList eafParticipants;
    private ArrayList chatTierNames;
    private ArrayList chatTierTypes;
    private ArrayList chatParticipants;
    private ArrayList shoeboxTierNames;
    private ArrayList shoeboxTierTypes;
    private ArrayList shoeboxParticipants;
    private ArrayList plainTextTierNames;
    private ArrayList plainTextTierTypes;
    private ArrayList plainTextParticipants;
    private ArrayList htmlTextTierNames;
    private ArrayList htmlTextTierTypes;
    private ArrayList htmlTextParticipants;
    private ArrayList xmlTextTierNames;
    private ArrayList xmlTextTierTypes;
    private ArrayList xmlTextParticipants;

    public SearchAppletMediator(String string, String string2, Applet applet) {
        this.domainId = string2;
        this.applet = applet;
        String string3 = applet.getDocumentBase().toString();
        this.bufferedHitsForQuery = new HashMap();
        this.domainTypesForQuery = new HashMap();
        int n = string3.indexOf("search");
        string3 = string3.substring(0, n);
        try {
            this.serverURL = new URL(string3 + "searchServlet;jsessionid=" + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.serverURL = null;
        }
    }

    public JComponent getSearchComponent() {
        if (this.searchPane == null) {
            this.searchPane = new SearchPane(this);
            if (System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") >= 0) {
                try {
                    if (System.getProperty("java.runtime.version").indexOf("1.4") >= 0) {
                        System.out.println("java 1.4 on Windows, Setting Windows look and feel");
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    } else {
                        System.out.println("java 1.5 or later on Windows, Setting Metal look and feel");
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    }
                    SwingUtilities.updateComponentTreeUI(this.searchPane);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return this.searchPane;
    }

    public Color getBackgroundColor() {
        return new Color(255, 255, 242);
    }

    public ArrayList getDomainInfo() {
        return this.domainInfo;
    }

    public void init() {
        this.domainInfo = new ArrayList();
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println("dummy query id");
            printStream.println("initCMD");
            printStream.flush();
            printStream.close();
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            this.domainInfo.add(string);
            String string2 = bufferedReader.readLine();
            this.domainInfo.add(string2);
            String string3 = bufferedReader.readLine();
            this.domainInfo.add(string3);
            String string4 = bufferedReader.readLine();
            this.domainInfo.add(string4);
            String string5 = bufferedReader.readLine();
            this.domainInfo.add(string5);
            String string6 = bufferedReader.readLine();
            this.domainInfo.add(string6);
            String string7 = bufferedReader.readLine();
            this.domainInfo.add(string7);
            this.eafTierNames = this.readNLinesFromServlet(bufferedReader);
            this.eafTierTypes = this.readNLinesFromServlet(bufferedReader);
            this.eafParticipants = this.readNLinesFromServlet(bufferedReader);
            this.chatTierNames = this.readNLinesFromServlet(bufferedReader);
            this.chatTierTypes = this.readNLinesFromServlet(bufferedReader);
            this.chatParticipants = this.readNLinesFromServlet(bufferedReader);
            this.shoeboxTierNames = this.readNLinesFromServlet(bufferedReader);
            this.shoeboxTierTypes = this.readNLinesFromServlet(bufferedReader);
            this.shoeboxParticipants = this.readNLinesFromServlet(bufferedReader);
            this.plainTextTierNames = this.readNLinesFromServlet(bufferedReader);
            this.plainTextTierTypes = this.readNLinesFromServlet(bufferedReader);
            this.plainTextParticipants = this.readNLinesFromServlet(bufferedReader);
            this.xmlTextTierNames = this.readNLinesFromServlet(bufferedReader);
            this.xmlTextTierTypes = this.readNLinesFromServlet(bufferedReader);
            this.xmlTextParticipants = this.readNLinesFromServlet(bufferedReader);
            this.htmlTextTierNames = this.readNLinesFromServlet(bufferedReader);
            this.htmlTextTierTypes = this.readNLinesFromServlet(bufferedReader);
            this.htmlTextParticipants = this.readNLinesFromServlet(bufferedReader);
            this.searchModes = this.readNLinesFromServlet(bufferedReader);
            inputStream.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getSearchModes(String string) {
        return this.searchModes;
    }

    public String createQuery() {
        String string = "";
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println("dummy query id");
            printStream.println("createQueryCMD");
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            string = bufferedReader.readLine();
            this.bufferedHitsForQuery.put(string, new ArrayList());
            bufferedReader.close();
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public void setQueryDomain(String string, String string2) {
        this.domainTypesForQuery.put(string2, string);
    }

    public void doQuery(String string, String string2) {
        ArrayList arrayList = (ArrayList)this.bufferedHitsForQuery.get(string2);
        arrayList.clear();
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println(string2);
            printStream.println("doQueryCMD");
            printStream.println(this.domainTypesForQuery.get(string2));
            printStream.println(string);
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            bufferedReader.readLine();
            bufferedReader.close();
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getPatterns(String string) {
        return null;
    }

    public ArrayList getModes(String string) {
        return null;
    }

    public SearchStatistics getSearchStatistics(String string) {
        SearchStatistics searchStatistics = new SearchStatistics();
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println(string);
            printStream.println("getStatisticsCMD");
            printStream.flush();
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ArrayList arrayList = this.readNLinesFromServlet(bufferedReader);
            searchStatistics.nHits = Integer.parseInt((String)arrayList.get(0));
            searchStatistics.nAnnotationsWithHit = Integer.parseInt((String)arrayList.get(1));
            searchStatistics.nAnnotationsSearched = Integer.parseInt((String)arrayList.get(2));
            searchStatistics.progress = Float.parseFloat((String)arrayList.get(3));
            searchStatistics.nFrequencyInfoItems = Integer.parseInt((String)arrayList.get(4));
            bufferedReader.close();
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return searchStatistics;
    }

    public void showInViewer(Object object, String string) {
        if (object == null) {
            return;
        }
        if (object instanceof SearchHit) {
            this.showSearchHitInViewer((SearchHit)object);
        } else if (object instanceof FrequencyInfo) {
            this.showFrequencyHitInViewer((FrequencyInfo)object, string);
        }
    }

    public void showSearchHitInViewer(SearchHit searchHit) {
        try {
            String string = this.applet.getCodeBase() + "runLoader?nodeid=" + searchHit.transcriptionNodeId + "&time=" + searchHit.beginTime + "&duration=" + (searchHit.endTime - searchHit.beginTime) + "&tier=" + searchHit.tierName;
            string = string + "&viewType=timeline";
            string = string.replaceAll("#", "%23");
            string = string.replaceAll(" ", "%20");
            System.out.println("encoded: " + string);
            URL uRL = new URL(string);
            AppletContext appletContext = this.applet.getAppletContext();
            appletContext.showDocument(uRL, "_blank");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showFrequencyHitInViewer(FrequencyInfo frequencyInfo, String string) {
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println(string);
            printStream.println("getViewParameters");
            printStream.println(frequencyInfo.annId);
            printStream.flush();
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ArrayList arrayList = this.readNLinesFromServlet(bufferedReader);
            String string2 = (String)arrayList.get(0);
            String string3 = (String)arrayList.get(1);
            long l = Long.parseLong((String)arrayList.get(2));
            long l2 = Long.parseLong((String)arrayList.get(3));
            String string4 = this.applet.getCodeBase() + "runLoader?nodeid=" + string2 + "&time=" + l + "&duration=" + (l2 - l) + "&tier=" + string3;
            string4 = string4 + "&viewType=timeline";
            string4 = string4.replaceAll("#", "%23");
            string4 = string4.replaceAll(" ", "%20");
            System.out.println("encoded: " + string4);
            URL uRL = new URL(string4);
            AppletContext appletContext = this.applet.getAppletContext();
            appletContext.showDocument(uRL, "_blank");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showInCorpusStructure(Object object, String string) {
        if (object == null) {
            return;
        }
        if (object instanceof SearchHit) {
            this.showSearchHitInCorpusStructure((SearchHit)object);
        } else if (object instanceof FrequencyInfo) {
            this.showFrequencyhHitInCorpusStructure((FrequencyInfo)object, string);
        }
    }

    public void showSearchHitInCorpusStructure(SearchHit searchHit) {
        try {
            String string = this.applet.getCodeBase() + "?openpath=" + searchHit.transcriptionNodeId;
            string = string.replaceAll("annex", "imdi_browser");
            string = string.replaceAll("#", "%23");
            URL uRL = new URL(string);
            AppletContext appletContext = this.applet.getAppletContext();
            appletContext.showDocument(uRL, "_blank");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showFrequencyhHitInCorpusStructure(FrequencyInfo frequencyInfo, String string) {
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println(string);
            printStream.println("getViewParameters");
            printStream.println(frequencyInfo.annId);
            printStream.flush();
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ArrayList arrayList = this.readNLinesFromServlet(bufferedReader);
            String string2 = (String)arrayList.get(0);
            String string3 = (String)arrayList.get(1);
            long l = Long.parseLong((String)arrayList.get(2));
            long l2 = Long.parseLong((String)arrayList.get(3));
            String string4 = this.applet.getCodeBase() + "?openpath=" + string2;
            string4 = string4.replaceAll("annex", "imdi_browser");
            string4 = string4.replaceAll("#", "%23");
            URL uRL = new URL(string4);
            AppletContext appletContext = this.applet.getAppletContext();
            appletContext.showDocument(uRL, "_blank");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getHitsFromDatabase(int n, int n2, int n3, String string) {
        return this.readHitsFromServlet(n, n2, n3, string);
    }

    public List getHits(int n, int n2, int n3, String string) {
        ArrayList arrayList = (ArrayList)this.bufferedHitsForQuery.get(string);
        if (this.getSearchStatistics((String)string).nHits <= n) {
            return arrayList.subList(0, 0);
        }
        int n4 = arrayList.size();
        if (n2 > n4) {
            ArrayList arrayList2 = this.getHitsFromDatabase(n4, n2, n3, string);
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList.add(arrayList2.get(i));
            }
        }
        n2 = n2 < arrayList.size() ? n2 : arrayList.size();
        return arrayList.subList(n, n2);
    }

    public ArrayList getFrequencyInfo(int n, int n2, String string) {
        return this.readFrequencyInfoFromServlet(n, n2, string);
    }

    public void cancelQuery(String string) {
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println(string);
            printStream.println("cancelQueryCMD");
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            bufferedReader.readLine();
            bufferedReader.close();
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ArrayList readNLinesFromServlet(BufferedReader bufferedReader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n = Integer.parseInt(bufferedReader.readLine());
            for (int i = 0; i < n; ++i) {
                String string = bufferedReader.readLine();
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private ArrayList readHitsFromServlet(int n, int n2, int n3, String string) {
        ArrayList<SearchHit> arrayList = new ArrayList<SearchHit>();
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println(string);
            printStream.println("getHitsCMD");
            printStream.println(n);
            printStream.println(n2);
            printStream.println(n3);
            printStream.flush();
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int n4 = Integer.parseInt(bufferedReader.readLine());
            for (int i = 0; i < n4; ++i) {
                ArrayList arrayList2 = this.readNLinesFromServlet(bufferedReader);
                ArrayList arrayList3 = this.readNLinesFromServlet(bufferedReader);
                ArrayList arrayList4 = this.readNLinesFromServlet(bufferedReader);
                SearchHit searchHit = new SearchHit();
                searchHit.annotation = (String)arrayList2.get(0);
                searchHit.aligned = new Boolean((String)arrayList2.get(1));
                searchHit.beginTime = Long.parseLong((String)arrayList2.get(2));
                searchHit.endTime = Long.parseLong((String)arrayList2.get(3));
                searchHit.hitLength = Integer.parseInt((String)arrayList2.get(4));
                searchHit.hitNumberInAnnotation = Integer.parseInt((String)arrayList2.get(5));
                searchHit.hitPositionInAnnotation = Integer.parseInt((String)arrayList2.get(6));
                searchHit.positionInTier = Integer.parseInt((String)arrayList2.get(7));
                searchHit.tierName = (String)arrayList2.get(8);
                searchHit.tierType = (String)arrayList2.get(9);
                searchHit.participant = (String)arrayList2.get(10);
                searchHit.transcriptionNodeId = (String)arrayList2.get(11);
                searchHit.transcriptionName = (String)arrayList2.get(12);
                searchHit.leftContext = arrayList3;
                searchHit.rightContext = arrayList4;
                arrayList.add(searchHit);
            }
            printStream.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private ArrayList readFrequencyInfoFromServlet(int n, int n2, String string) {
        ArrayList<FrequencyInfo> arrayList = new ArrayList<FrequencyInfo>();
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println(string);
            printStream.println("getFreqInfo");
            printStream.println(n);
            printStream.println(n2);
            printStream.flush();
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int n3 = Integer.parseInt(bufferedReader.readLine());
            for (int i = 0; i < n3; ++i) {
                ArrayList arrayList2 = this.readNLinesFromServlet(bufferedReader);
                FrequencyInfo frequencyInfo = new FrequencyInfo();
                frequencyInfo.nOccurences = Integer.parseInt((String)arrayList2.get(0));
                frequencyInfo.annotation = (String)arrayList2.get(1);
                frequencyInfo.numberOfHits = Integer.parseInt((String)arrayList2.get(2));
                frequencyInfo.hitPositionInAnnotation = Integer.parseInt((String)arrayList2.get(3));
                frequencyInfo.hitLength = Integer.parseInt((String)arrayList2.get(4));
                frequencyInfo.annId = Integer.parseInt((String)arrayList2.get(5));
                frequencyInfo.fileIndex = Integer.parseInt((String)arrayList2.get(6));
                arrayList.add(frequencyInfo);
            }
            printStream.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList getTierNames(String string) {
        String string2 = (String)this.domainTypesForQuery.get(string);
        TreeSet treeSet = new TreeSet();
        if (string2 != null) {
            if (string2.toLowerCase().indexOf("eaf") >= 0) {
                treeSet.addAll(this.eafTierNames);
            }
            if (string2.toLowerCase().indexOf("chat") >= 0) {
                treeSet.addAll(this.chatTierNames);
            }
            if (string2.toLowerCase().indexOf("shoebox") >= 0) {
                treeSet.addAll(this.shoeboxTierNames);
            }
            if (string2.toLowerCase().indexOf("plaintext") >= 0) {
                treeSet.addAll(this.plainTextTierNames);
            }
            if (string2.toLowerCase().indexOf("xmltext") >= 0) {
                treeSet.addAll(this.xmlTextTierNames);
            }
            if (string2.toLowerCase().indexOf("htmltext") >= 0) {
                treeSet.addAll(this.htmlTextTierNames);
            }
        }
        return new ArrayList(treeSet);
    }

    public ArrayList getTierTypes(String string) {
        String string2 = (String)this.domainTypesForQuery.get(string);
        TreeSet treeSet = new TreeSet();
        if (string2 != null) {
            if (string2.toLowerCase().indexOf("eaf") >= 0) {
                treeSet.addAll(this.eafTierTypes);
            }
            if (string2.toLowerCase().indexOf("chat") >= 0) {
                treeSet.addAll(this.chatTierTypes);
            }
            if (string2.toLowerCase().indexOf("shoebox") >= 0) {
                treeSet.addAll(this.shoeboxTierTypes);
            }
            if (string2.toLowerCase().indexOf("plaintext") >= 0) {
                treeSet.addAll(this.plainTextTierTypes);
            }
            if (string2.toLowerCase().indexOf("xmltext") >= 0) {
                treeSet.addAll(this.xmlTextTierTypes);
            }
            if (string2.toLowerCase().indexOf("htmltext") >= 0) {
                treeSet.addAll(this.htmlTextTierTypes);
            }
        }
        return new ArrayList(treeSet);
    }

    public ArrayList getParticipants(String string) {
        String string2 = (String)this.domainTypesForQuery.get(string);
        TreeSet treeSet = new TreeSet();
        if (string2 != null) {
            if (string2.toLowerCase().indexOf("eaf") >= 0) {
                treeSet.addAll(this.eafParticipants);
            }
            if (string2.toLowerCase().indexOf("chat") >= 0) {
                treeSet.addAll(this.chatParticipants);
            }
            if (string2.toLowerCase().indexOf("shoebox") >= 0) {
                treeSet.addAll(this.shoeboxParticipants);
            }
            if (string2.toLowerCase().indexOf("plaintext") >= 0) {
                treeSet.addAll(this.plainTextParticipants);
            }
            if (string2.toLowerCase().indexOf("xmltext") >= 0) {
                treeSet.addAll(this.xmlTextParticipants);
            }
            if (string2.toLowerCase().indexOf("htmltext") >= 0) {
                treeSet.addAll(this.htmlTextParticipants);
            }
        }
        return new ArrayList(treeSet);
    }

    public void putPersistent(String string, String string2) {
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println("dummy queryId");
            printStream.println("putPersistentCMD");
            printStream.println(string);
            printStream.println(string2);
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            bufferedReader.readLine();
            bufferedReader.close();
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getPersistent(String string) {
        String string2 = null;
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println("dummy queryId");
            printStream.println("getPersistentMD");
            printStream.println(string);
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            string2 = bufferedReader.readLine();
            if (string2.equals("zywNULL STRINGqqx")) {
                string2 = null;
            }
            bufferedReader.close();
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public void deletePersistent(String string) {
        try {
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream(), true, "UTF-8");
            printStream.println(this.domainId);
            printStream.println("dummy queryId");
            printStream.println("deletePersistentCMD");
            printStream.println(string);
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            bufferedReader.readLine();
            bufferedReader.close();
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addDomainPanel(String string, SearchDomainPanel searchDomainPanel) {
    }

    public void addResultPanel(String string, SearchResultPanel searchResultPanel) {
    }

    public void checkForDomainErrors(String string) {
    }

    public int getDomainSize(String string) {
        return 0;
    }

    public float getDomainInitializationProgress(String string) {
        return 0.0f;
    }
}

