/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.HSQLDBQuery;
import mpi.annex.search.SearchApplication;
import mpi.annex.search.SearchDomainPanel;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchMediator;
import mpi.annex.search.SearchPane;
import mpi.annex.search.SearchResultPanel;
import mpi.annex.search.SearchStatistics;

public class SearchApplicationMediator
implements SearchMediator {
    private static int queryIdCounter;
    private HSQLDBQuery lastCreatedQuery;
    private SearchApplication application;
    private SearchPane searchPane;
    private HashMap queryForId;
    private HashMap domainPanelForId;
    private HashMap resultPanelForId;
    private HashMap bufferedHitsForQuery;
    private ArrayList initialDomain;
    private JPanel dummyPanel;

    public SearchApplicationMediator(SearchApplication searchApplication, ArrayList arrayList) {
        this.application = searchApplication;
        this.initialDomain = arrayList;
        this.queryForId = new HashMap();
        this.domainPanelForId = new HashMap();
        this.resultPanelForId = new HashMap();
        this.bufferedHitsForQuery = new HashMap();
        this.dummyPanel = new JPanel();
    }

    public void init() {
    }

    public JComponent getSearchComponent() {
        if (this.searchPane == null) {
            this.searchPane = new SearchPane(this);
        }
        return this.searchPane;
    }

    public String createQuery() {
        String string = Integer.toString(queryIdCounter++);
        HSQLDBQuery hSQLDBQuery = new HSQLDBQuery(string);
        if (this.lastCreatedQuery == null) {
            hSQLDBQuery.setDomain(this.initialDomain);
        } else {
            hSQLDBQuery.setDomain(this.lastCreatedQuery);
        }
        this.lastCreatedQuery = hSQLDBQuery;
        this.queryForId.put(string, hSQLDBQuery);
        this.bufferedHitsForQuery.put(string, new ArrayList());
        return string;
    }

    public void doQuery(String string, String string2) {
        if (this.queryRunning()) {
            JOptionPane.showMessageDialog(null, "A new query can not start while another query is running", "Running query on other panel", 2);
            return;
        }
        ArrayList arrayList = (ArrayList)this.bufferedHitsForQuery.get(string2);
        arrayList.clear();
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string2);
        hSQLDBQuery.doQuery(string);
    }

    public void cancelQuery(String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        hSQLDBQuery.cancelQuery();
    }

    public void showInViewer(Object object, String string) {
        if (object == null) {
            return;
        }
        if (object instanceof SearchHit) {
            this.showSearchHitInViewer((SearchHit)object);
        } else if (object instanceof FrequencyInfo) {
            this.showFrequencyHitInViewer((FrequencyInfo)object, string);
        }
    }

    public void showSearchHitInViewer(SearchHit searchHit) {
        String string = searchHit.transcriptionName;
        String string2 = searchHit.tierName;
        long l = searchHit.beginTime;
        long l2 = searchHit.endTime;
        this.application.showInViewer(string, string2, l, l2);
    }

    public void showFrequencyHitInViewer(FrequencyInfo frequencyInfo, String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        ArrayList arrayList = hSQLDBQuery.getViewerParametersFor(frequencyInfo.annId, frequencyInfo.fileIndex);
        String string2 = (String)arrayList.get(0);
        String string3 = (String)arrayList.get(1);
        long l = (Long)arrayList.get(2);
        long l2 = (Long)arrayList.get(3);
        this.application.showInViewer(string2, string3, l, l2);
    }

    public void showInCorpusStructure(Object object, String string) {
    }

    public SearchStatistics getSearchStatistics(String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        return hSQLDBQuery.getSearchStatistics();
    }

    public ArrayList getHitsFromDatabase(int n, int n2, int n3, String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        return hSQLDBQuery.getHits(n, n2, n3);
    }

    public List getHits(int n, int n2, int n3, String string) {
        ArrayList arrayList = (ArrayList)this.bufferedHitsForQuery.get(string);
        if (this.getSearchStatistics((String)string).nHits <= n) {
            return arrayList.subList(0, 0);
        }
        int n4 = arrayList.size();
        if (n2 > n4) {
            ArrayList arrayList2 = this.getHitsFromDatabase(n4, n2, n3, string);
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList.add(arrayList2.get(i));
            }
        }
        n2 = n2 < arrayList.size() ? n2 : arrayList.size();
        return arrayList.subList(n, n2);
    }

    public ArrayList getFrequencyInfo(int n, int n2, String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        return hSQLDBQuery.getFrequencyInfo(n, n2);
    }

    private boolean queryRunning() {
        boolean bl = false;
        Iterator iterator = this.queryForId.values().iterator();
        while (iterator.hasNext()) {
            HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)iterator.next();
            if (!hSQLDBQuery.isRunning()) continue;
            return true;
        }
        return bl;
    }

    public void addDomainPanel(String string, SearchDomainPanel searchDomainPanel) {
        this.domainPanelForId.put(string, searchDomainPanel);
    }

    public void addResultPanel(String string, SearchResultPanel searchResultPanel) {
        this.resultPanelForId.put(string, searchResultPanel);
    }

    public void setQueryDomain(String string, String string2) {
        if (this.queryRunning()) {
            JOptionPane.showMessageDialog(null, "The domain can not be changed while another query is running", "Running query on other panel", 2);
            return;
        }
        ArrayList arrayList = this.application.getDomain();
        if (arrayList != null) {
            HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string2);
            hSQLDBQuery.setDomain(arrayList);
            Iterator iterator = this.queryForId.keySet().iterator();
            while (iterator.hasNext()) {
                JPanel jPanel;
                String string3 = (String)iterator.next();
                HSQLDBQuery hSQLDBQuery2 = (HSQLDBQuery)this.queryForId.get(string3);
                if (hSQLDBQuery2 != hSQLDBQuery) {
                    hSQLDBQuery2.setDomain(hSQLDBQuery);
                    jPanel = (SearchDomainPanel)this.domainPanelForId.get(string3);
                    ((SearchDomainPanel)jPanel).newDomainFromOtherPanel();
                }
                jPanel = (SearchResultPanel)this.resultPanelForId.get(string3);
                ((SearchResultPanel)jPanel).clear();
            }
        }
    }

    public void checkForDomainErrors(String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        ArrayList arrayList = hSQLDBQuery.getProblemFiles();
        if (arrayList.size() > 0) {
            String string2 = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                string2 = string2 + ((File)arrayList.get(i)).getAbsolutePath() + "\n";
            }
            String string3 = "The following files could not be parsed and are therefore removed from the search domain:\n";
            JOptionPane.showMessageDialog(null, string3 + string2, "Not Searchable Files", 0);
        }
    }

    public float getDomainInitializationProgress(String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        return hSQLDBQuery.getDomainInitializationProgress();
    }

    public int getDomainSize(String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        return hSQLDBQuery.getDomain().size();
    }

    public ArrayList getSearchModes(String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        return hSQLDBQuery.getSearchModes();
    }

    public ArrayList getParticipants(String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        return hSQLDBQuery.getParticipants();
    }

    public ArrayList getTierNames(String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        return hSQLDBQuery.getTierNames();
    }

    public ArrayList getTierTypes(String string) {
        HSQLDBQuery hSQLDBQuery = (HSQLDBQuery)this.queryForId.get(string);
        return hSQLDBQuery.getTierTypes();
    }

    public Color getBackgroundColor() {
        return this.dummyPanel.getBackground();
    }

    public ArrayList getDomainInfo() {
        return null;
    }

    public void putPersistent(String string, String string2) {
        this.application.putPersistent(string, string2);
    }

    public String getPersistent(String string) {
        return this.application.getPersistent(string);
    }

    public void deletePersistent(String string) {
        this.application.deletePersistent(string);
    }
}

