/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.search.SearchCorpusDB;
import mpi.annex.util.AnnexUtil;
import mpi.corpusstructure.CorpusStructureDB;

public class SearchCorpusDB {
    private int TIER_ID;
    private int ANN_ID;
    private static int rollbacks;
    private static int missedRollbacks;
    private Connection con;
    private PreparedStatement stTier;
    private PreparedStatement stAnnotation;
    private ArrayList permissionDenied;
    private ArrayList notExisting;
    private ArrayList emptyTranscriptions;
    private ArrayList notParsable;
    private ArrayList dbProblem;

    public SearchCorpusDB(String string, String string2, String string3) throws Exception {
        this.con = DriverManager.getConnection(string, string2, string3);
        this.prepareStatements("search.annotations", "search.tiers");
    }

    public SearchCorpusDB(String string, String string2, String string3, boolean bl) throws Exception {
        this.con = DriverManager.getConnection(string, string2, string3);
    }

    public void close() {
        try {
            this.con.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void prepareStatements(String string, String string2) throws Exception {
        this.stAnnotation = this.con.prepareStatement("INSERT INTO " + string + " VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
        this.stTier = this.con.prepareStatement("INSERT INTO " + string2 + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");
    }

    private void ingest() {
        long l = this.start_stopwatch();
        AnnexUtil.debugLevel = 0;
        try {
            int n;
            Statement statement = this.con.createStatement();
            try {
                statement.executeUpdate("CREATE SCHEMA search");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE search.new_annotations CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE search.new_tiers CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE search.new_prog_data CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("CREATE TABLE search.new_tiers (tier_id INTEGER, tier_name TEXT, tier_type TEXT, default_locale TEXT, participant TEXT, n_annotations INTEGER, ref_tier_id INTEGER, transcription_type INTEGER, node_id TEXT)");
            statement.executeUpdate("CREATE TABLE search.new_annotations (ann_id INTEGER, annotation TEXT, ann_position INTEGER, begin_time BIGINT, end_time BIGINT, ref_ann_id INTEGER, aligned BOOLEAN, ann_tier_id INTEGER)");
            statement.executeUpdate("CREATE TABLE search.new_prog_data (label TEXT, tier_id INTEGER, ann_id INTEGER)");
            this.TIER_ID = 2;
            this.ANN_ID = 3;
            statement.executeUpdate("INSERT INTO search.new_prog_data VALUES ('indices', 0, 0)");
            this.prepareStatements("search.new_annotations", "search.new_tiers");
            this.permissionDenied = new ArrayList();
            this.notExisting = new ArrayList();
            this.notParsable = new ArrayList();
            this.emptyTranscriptions = new ArrayList();
            this.dbProblem = new ArrayList();
            rollbacks = 0;
            missedRollbacks = 0;
            long l2 = this.start_stopwatch();
            String string = "text/x-eaf+xml";
            Stats stats = this.process(string);
            this.stop_stopwatch(l2);
            l2 = this.start_stopwatch();
            string = "text/x-shoebox-text";
            Stats stats2 = this.process(string);
            this.stop_stopwatch(l2);
            l2 = this.start_stopwatch();
            string = "text/x-chat";
            Stats stats3 = this.process(string);
            this.stop_stopwatch(l2);
            l2 = this.start_stopwatch();
            string = "text/plain";
            Stats stats4 = this.process(string);
            this.stop_stopwatch(l2);
            l2 = this.start_stopwatch();
            string = "text/html";
            Stats stats5 = this.process(string);
            this.stop_stopwatch(l2);
            l2 = this.start_stopwatch();
            string = "text/xml";
            Stats stats6 = this.process(string);
            this.stop_stopwatch(l2);
            System.out.println("Ready parsing...");
            if (this.notExisting.size() > 0) {
                System.out.println("\n\nNot exisiting:\n");
            }
            for (n = 0; n < this.notExisting.size(); ++n) {
                System.out.println(this.notExisting.get(n));
            }
            if (this.permissionDenied.size() > 0) {
                System.out.println("\n\nPermission denied:\n");
            }
            for (n = 0; n < this.permissionDenied.size(); ++n) {
                System.out.println(this.permissionDenied.get(n));
            }
            if (this.emptyTranscriptions.size() > 0) {
                System.out.println("\n\nEmpty Transcriptions:\n");
            }
            for (n = 0; n < this.emptyTranscriptions.size(); ++n) {
                System.out.println(this.emptyTranscriptions.get(n));
            }
            if (this.notParsable.size() > 0) {
                System.out.println("\n\nNot parsable:\n");
            }
            for (n = 0; n < this.notParsable.size(); ++n) {
                System.out.println(this.notParsable.get(n));
            }
            if (this.dbProblem.size() > 0) {
                System.out.println("\n\nDatabase problem:\n");
            }
            for (n = 0; n < this.dbProblem.size(); ++n) {
                System.out.println(this.dbProblem.get(n));
            }
            System.out.println("\n\ncreating annotation id index....");
            l2 = this.start_stopwatch();
            statement.executeUpdate("CREATE INDEX new_ann_id_index ON search.new_annotations( ann_id )");
            this.stop_stopwatch(l2);
            System.out.println("creating annotation tier id index....");
            l2 = this.start_stopwatch();
            statement.executeUpdate("CREATE INDEX new_ann_tier_id_index ON search.new_annotations( ann_tier_id )");
            this.stop_stopwatch(l2);
            System.out.println("\ncreating node id index....");
            l2 = this.start_stopwatch();
            statement.executeUpdate("CREATE INDEX new_node_id_index ON search.new_tiers( node_id )");
            this.stop_stopwatch(l2);
            System.out.println("creating tier id index....");
            l2 = this.start_stopwatch();
            statement.executeUpdate("CREATE INDEX new_tier_id_index ON search.new_tiers( tier_id )");
            this.stop_stopwatch(l2);
            System.out.println("creating tier name index....");
            l2 = this.start_stopwatch();
            statement.executeUpdate("CREATE INDEX new_tier_name_index ON search.new_tiers( tier_name )");
            this.stop_stopwatch(l2);
            System.out.println("creating tier type index....");
            l2 = this.start_stopwatch();
            statement.executeUpdate("CREATE INDEX new_tier_type_index ON search.new_tiers( tier_type )");
            this.stop_stopwatch(l2);
            System.out.println("creating default locale index....");
            l2 = this.start_stopwatch();
            statement.executeUpdate("CREATE INDEX new_default_locale_index ON search.new_tiers( default_locale )");
            this.stop_stopwatch(l2);
            System.out.println("creating participant index....");
            l2 = this.start_stopwatch();
            statement.executeUpdate("CREATE INDEX new_participant_index ON search.new_tiers( participant )");
            this.stop_stopwatch(l2);
            System.out.println("creating transcription type index....");
            l2 = this.start_stopwatch();
            statement.executeUpdate("CREATE INDEX new_transcription_type_index ON search.new_tiers( transcription_type )");
            this.stop_stopwatch(l2);
            this.printStats(stats, "EAF");
            this.printStats(stats3, "CHAT");
            this.printStats(stats2, "SHOEBOX");
            this.printStats(stats4, "PLAIN TEXT");
            this.printStats(stats5, "HTML TEXT");
            this.printStats(stats6, "XML TEXT");
            System.out.println("Needed " + rollbacks + " rollbacks");
            System.out.println("Missed " + missedRollbacks + " rollbacks");
            if (missedRollbacks > 0) {
                System.out.println("DUE TO MISSED ROLLBACKS NO NEW DATABASE!!!!");
                System.out.println("The current search database is still usable");
                System.out.println("In the log info above the problematic rollbacks are marked with:");
                this.mentionRollbackProblem();
                System.out.println("The current search database is still usable");
                this.stop_stopwatch(l);
                System.exit(0);
            }
            System.out.println("\nReplacing tables...");
            l2 = this.start_stopwatch();
            try {
                statement.executeUpdate("DROP TABLE search.annotations CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP INDEX search.ann_id_index CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP INDEX search.ann_tier_id_index CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE search.tiers CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP INDEX search.node_id_index CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP INDEX search.tier_id_index CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP INDEX search.tier_name_index CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP INDEX search.tier_type_index CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP INDEX search.default_locale_index CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP INDEX search.participant_index CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP INDEX search.transcription_type_index CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE search.prog_data CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("ALTER TABLE search.new_annotations RENAME TO annotations");
            statement.executeUpdate("ALTER INDEX search.new_ann_id_index RENAME TO ann_id_index");
            statement.executeUpdate("ALTER INDEX search.new_ann_tier_id_index RENAME TO ann_tier_id_index");
            statement.executeUpdate("ALTER TABLE search.new_tiers RENAME TO tiers");
            statement.executeUpdate("ALTER INDEX search.new_node_id_index RENAME TO node_id_index");
            statement.executeUpdate("ALTER INDEX search.new_tier_id_index RENAME TO tier_id_index");
            statement.executeUpdate("ALTER INDEX search.new_tier_name_index RENAME TO tier_name_index");
            statement.executeUpdate("ALTER INDEX search.new_tier_type_index RENAME TO tier_type_index");
            statement.executeUpdate("ALTER INDEX search.new_default_locale_index RENAME TO default_locale_index");
            statement.executeUpdate("ALTER INDEX search.new_participant_index RENAME TO participant_index");
            statement.executeUpdate("ALTER INDEX search.new_transcription_type_index RENAME TO transcription_type_index");
            statement.executeUpdate("ALTER TABLE search.new_prog_data RENAME TO prog_data");
            this.stop_stopwatch(l2);
            System.out.print("\nReady!!, total ");
            this.stop_stopwatch(l);
            statement.close();
            this.con.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Stats process(String string) {
        CorpusStructureDB corpusStructureDB = AnnexUtil.getCorpusStructureDB();
        String[] stringArray = new String[1];
        String[] stringArray2 = null;
        String string2 = null;
        String string3 = corpusStructureDB.getRootNodeId();
        AnnexTranscription annexTranscription = null;
        Stats stats = new Stats(this, null);
        stringArray[0] = string;
        stringArray2 = corpusStructureDB.getDescendants(string3, 8, stringArray, string2, true);
        System.out.println(string + " processing " + stringArray2.length + " files:");
        int n = stringArray2.length / 100;
        if (n < 1) {
            n = 1;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (i % n == 0) {
                System.out.printf("%.2f ", Float.valueOf((float)i / (float)stringArray2.length));
            }
            ++stats.nFiles;
            String string4 = AnnexUtil.getFilePathFor(stringArray2[i]);
            File file = new File(string4);
            if (file.exists()) {
                ++stats.nExist;
                if (!file.canRead()) {
                    this.permissionDenied.add(string + "  pd  " + string4);
                    ++stats.nPermissionDenied;
                    continue;
                }
                if (file.length() > 10000000L) {
                    System.out.println("\nridiculous big file:");
                    System.out.println("\t" + file.getAbsolutePath() + "\n");
                    continue;
                }
                annexTranscription = null;
                try {
                    annexTranscription = new AnnexTranscription(stringArray2[i], file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (annexTranscription != null && annexTranscription.isValid()) {
                    Stats stats2 = this.ingest(annexTranscription, false);
                    if (stats2 != null) {
                        if (stats2.nEmpty > 0) {
                            ++stats.nEmpty;
                            this.emptyTranscriptions.add(string + "  em  " + string4);
                            continue;
                        }
                        stats.nTiers += stats2.nTiers;
                        stats.nAnnotations += stats2.nAnnotations;
                        stats.annotationsSize += stats2.annotationsSize;
                        continue;
                    }
                    this.dbProblem.add(string + "  db  " + string4);
                    System.out.println("Database problem with: " + string4);
                    ++stats.nDBProblems;
                    continue;
                }
                this.notParsable.add(string + "  np  " + string4);
                ++stats.nNotParsable;
                continue;
            }
            this.notExisting.add(string + "  ne  " + string4);
        }
        System.out.println();
        return stats;
    }

    public ResultSet executeSQLQuery(String string) throws Exception {
        Statement statement = this.con.createStatement(1004, 1007);
        return statement.executeQuery(string);
    }

    public PreparedStatement getPreparedStatement(String string) throws Exception {
        return this.con.prepareStatement(string);
    }

    private boolean isIngested(String string) throws Exception {
        ResultSet resultSet = this.executeSQLQuery("select node_id from search.tiers where node_id = " + string);
        return resultSet.next();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNode(String string) throws Exception {
        if (this.isIngested(string)) {
            throw new Exception("Already ingested first remove nodeID: " + string);
        }
        String string2 = AnnexUtil.getFilePathFor(string);
        File file = new File(string2);
        if (!file.exists()) throw new Exception("File does not exist for nodeID: " + string + " => " + string2);
        AnnexTranscription annexTranscription = null;
        annexTranscription = new AnnexTranscription(string, file);
        if (annexTranscription == null || !annexTranscription.isValid()) throw new Exception("Invalid transcription for nodeID: " + string + " => " + string2);
        Stats stats = this.ingest(annexTranscription, true);
        if (stats != null) return;
        throw new Exception("Database problem for nodeID: " + string + " => " + string2);
    }

    public void removeNode(String string) throws Exception {
        this.con.setAutoCommit(false);
        Statement statement = this.con.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT tier_id FROM search.tiers WHERE node_id = " + string);
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                statement.executeUpdate("DELETE FROM search.annotations WHERE ann_tier_id = " + n);
            }
            statement.executeUpdate("DELETE FROM search.tiers WHERE node_id = " + string);
            this.con.commit();
        }
        catch (Exception exception) {
            try {
                this.con.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    private Stats ingest(AnnexTranscription annexTranscription, boolean bl) {
        Stats stats = new Stats(this, null);
        HashMap<Serializable, Integer> hashMap = new HashMap<Serializable, Integer>();
        boolean bl2 = false;
        int n = annexTranscription.getTiers().size();
        if (n == 0) {
            ++stats.nEmpty;
            return stats;
        }
        String string = "search.new_prog_data";
        if (bl) {
            string = "search.prog_data";
        }
        try {
            int n2;
            int n3;
            AnnexTier annexTier;
            int n4;
            bl2 = this.con.getAutoCommit();
            this.con.setAutoCommit(false);
            Statement statement = this.con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string + " WHERE label = 'indices'");
            resultSet.next();
            int n5 = resultSet.getInt(this.TIER_ID);
            int n6 = resultSet.getInt(this.ANN_ID);
            stats.nTiers = n;
            for (n4 = 0; n4 < n; ++n4) {
                annexTier = (AnnexTier)annexTranscription.getTiers().get(n4);
                hashMap.put(annexTier, n5++);
                n3 = annexTier.annotations.size();
                stats.nAnnotations += (long)n3;
                for (n2 = 0; n2 < n3; ++n2) {
                    AnnexAnnotation annexAnnotation = (AnnexAnnotation)annexTier.annotations.get(n2);
                    hashMap.put(annexAnnotation, n6++);
                    stats.annotationsSize += (long)((String)annexAnnotation.value).length();
                }
            }
            resultSet = statement.executeQuery("SELECT * FROM " + string + " WHERE label = 'indices'");
            resultSet.next();
            n5 = resultSet.getInt(this.TIER_ID);
            n6 = resultSet.getInt(this.ANN_ID);
            for (n4 = 0; n4 < n; ++n4) {
                annexTier = (AnnexTier)annexTranscription.getTiers().get(n4);
                n3 = -1;
                if (annexTier.parentTier != null) {
                    n3 = (Integer)hashMap.get(annexTier.parentTier);
                }
                n2 = annexTier.annotations.size();
                this.stTier.setInt(1, n5);
                this.stTier.setString(2, annexTier.name);
                this.stTier.setString(3, annexTier.type);
                this.stTier.setString(4, annexTier.defaultLocale);
                this.stTier.setString(5, annexTier.participant);
                this.stTier.setInt(6, n2);
                this.stTier.setInt(7, n3);
                this.stTier.setInt(8, annexTranscription.getType());
                this.stTier.setString(9, annexTranscription.getNodeId());
                this.stTier.executeUpdate();
                for (int i = 0; i < n2; ++i) {
                    AnnexAnnotation annexAnnotation = (AnnexAnnotation)annexTier.annotations.get(i);
                    int n7 = -1;
                    if (annexAnnotation.refAnnotation != null) {
                        n7 = (Integer)hashMap.get(annexAnnotation.refAnnotation);
                    }
                    if (((String)annexAnnotation.value).length() > 2000) {
                        String string2 = AnnexUtil.getFilePathFor(annexTranscription.getNodeId());
                        System.out.println("Info: there is an annotation longer than 2000 characters in \n" + string2);
                    }
                    this.stAnnotation.setInt(1, n6++);
                    this.stAnnotation.setString(2, (String)annexAnnotation.value);
                    this.stAnnotation.setInt(3, i);
                    this.stAnnotation.setLong(4, annexAnnotation.beginTime);
                    this.stAnnotation.setLong(5, annexAnnotation.endTime);
                    this.stAnnotation.setInt(6, n7);
                    this.stAnnotation.setBoolean(7, annexAnnotation.isTimeAligned);
                    this.stAnnotation.setInt(8, n5);
                    this.stAnnotation.executeUpdate();
                }
                ++n5;
            }
            statement.executeUpdate("UPDATE " + string + " SET " + "tier_id = " + n5 + ", " + "ann_id = " + n6 + " WHERE label = 'indices'");
            this.con.commit();
            this.con.setAutoCommit(bl2);
        }
        catch (Exception exception) {
            System.out.println("\ningest-e: " + exception.toString());
            try {
                ++rollbacks;
                this.con.rollback();
                this.con.setAutoCommit(bl2);
            }
            catch (Exception exception2) {
                ++missedRollbacks;
                this.mentionRollbackProblem();
                System.out.println("\ningest-ex: " + exception2.toString());
            }
            return null;
        }
        return stats;
    }

    private void mentionRollbackProblem() {
        System.out.println("ROLLBACK PROBLEM");
    }

    private void printStats(Stats stats, String string) {
        float f = (float)stats.annotationsSize / (float)stats.nAnnotations;
        int n = stats.nExist - stats.nPermissionDenied - stats.nEmpty - stats.nNotParsable - stats.nDBProblems;
        System.out.println("Statistics for " + string + " files:\n");
        System.out.printf("#files: %d    existing: %d   ingested: %d\n", stats.nFiles, stats.nExist, n);
        System.out.printf("#permission denied: %d    empty: %d    not parsable: %d    database problem: %5d\n", stats.nPermissionDenied, stats.nEmpty, stats.nNotParsable, stats.nDBProblems);
        System.out.printf("#tiers: %d    #annotations: %d    Average annotation length: %.2f\n", stats.nTiers, stats.nAnnotations, Float.valueOf(f));
        System.out.println("\n");
    }

    private String escape(String string) {
        if (string == null) {
            return string;
        }
        return string.replaceAll("'", "''");
    }

    private long start_stopwatch() {
        return System.currentTimeMillis();
    }

    private void stop_stopwatch(long l) {
        long l2 = System.currentTimeMillis() - l;
        long l3 = l2 / 3600000L;
        long l4 = (l2 -= l3 * 3600000L) / 60000L;
        long l5 = (l2 -= l4 * 60000L) / 1000L;
        System.out.printf("duration: %02d:%02d:%02d.%03d\n\n", l3, l4, l5, l2 -= l5 * 1000L);
    }

    private static void usage() {
        System.out.println("\nUsage:");
        System.out.println("java -jar SearchDBIngester.jar corpusdb-server:port user password searchdb-server:port user password\n");
        System.out.println("Sample Usage:");
        System.out.println("java -jar SearchDBIngester.jar lux08:5432 webuser xxxx localhost:5432 albertr yyyy");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 6) {
            SearchCorpusDB.usage();
            System.exit(0);
        }
        AnnexUtil.corpusDbURL = "jdbc:postgresql://" + stringArray[0] + "/corpusstructure";
        AnnexUtil.corpusDbUser = stringArray[1];
        AnnexUtil.corpusDbPassword = stringArray[2];
        String string = "jdbc:postgresql://" + stringArray[3] + "/annex";
        String string2 = stringArray[4];
        String string3 = stringArray[5];
        try {
            SearchCorpusDB searchCorpusDB = new SearchCorpusDB(string, string2, string3, false);
            searchCorpusDB.ingest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SearchCorpusDB.usage();
        }
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

