/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import mpi.annex.search.Constants;
import mpi.annex.search.SearchAppletMediator;
import mpi.annex.search.SearchListener;
import mpi.annex.search.SearchMediator;

public class SearchDomainPanel
extends JPanel
implements ItemListener,
ActionListener,
Runnable {
    private SearchMediator mediator;
    private String queryId;
    private JPanel domainNamePanel;
    private JPanel domainTypePanel;
    private JLabel domainLabel;
    private JProgressBar progressBar;
    private Color backgroundColor;
    private JButton domainButton;
    private JLabel nEafLabel;
    private String domainTypes;
    private int nEaf;
    private int nChat;
    private int nShoebox;
    private int nPlainText;
    private int nXmlText;
    private int nHtmlText;
    private JCheckBox checkEaf;
    private JCheckBox checkChat;
    private JCheckBox checkShoebox;
    private JCheckBox checkText;
    private JCheckBox checkXml;
    private JCheckBox checkHtml;
    private ArrayList domainInfo;
    private SearchListener searchListener;

    public SearchDomainPanel(SearchMediator searchMediator, String string, SearchListener searchListener) {
        this.mediator = searchMediator;
        this.queryId = string;
        this.searchListener = searchListener;
        searchMediator.addDomainPanel(string, this);
        this.setLayout(new BoxLayout(this, 1));
        this.backgroundColor = searchMediator.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.add(Box.createVerticalStrut(5));
        this.domainNamePanel = new JPanel();
        this.domainNamePanel.setBackground(this.backgroundColor);
        this.domainNamePanel.setLayout(new BoxLayout(this.domainNamePanel, 0));
        this.domainNamePanel.add(Box.createHorizontalStrut(5));
        this.domainLabel = new JLabel("Domain: ");
        this.domainLabel.setFont(Constants.bigBoldFont);
        this.domainNamePanel.add(this.domainLabel);
        this.add(this.domainNamePanel);
        if (searchMediator instanceof SearchAppletMediator) {
            this.domainInfo = searchMediator.getDomainInfo();
            if (this.domainInfo == null) {
                JLabel jLabel = new JLabel("Initialisation error, no search possible");
                this.add(jLabel);
                return;
            }
            String string2 = (String)this.domainInfo.get(0);
            this.nEaf = Integer.parseInt((String)this.domainInfo.get(1));
            this.nChat = Integer.parseInt((String)this.domainInfo.get(2));
            this.nShoebox = Integer.parseInt((String)this.domainInfo.get(3));
            this.nPlainText = Integer.parseInt((String)this.domainInfo.get(4));
            this.nXmlText = Integer.parseInt((String)this.domainInfo.get(5));
            this.nHtmlText = Integer.parseInt((String)this.domainInfo.get(6));
            JLabel jLabel = new JLabel(string2);
            jLabel.setFont(Constants.italicFont);
            this.domainNamePanel.add(jLabel);
            this.domainNamePanel.add(Box.createHorizontalGlue());
            this.domainTypePanel = new JPanel();
            this.domainTypePanel.setBackground(this.backgroundColor);
            this.domainTypePanel.setLayout(new BoxLayout(this.domainTypePanel, 0));
            Component component = Box.createHorizontalStrut(this.getDomainLabelWidth());
            this.domainTypePanel.add(component);
            int n = this.nEaf + this.nChat + this.nShoebox + this.nPlainText + this.nXmlText + this.nHtmlText;
            if (n == 0) {
                JLabel jLabel2 = new JLabel("No data accessable for the current user, please login with another user name");
                this.domainTypePanel.add(jLabel2);
            } else {
                this.checkEaf = this.addTypeInfo(this.checkEaf, "EAF", this.nEaf);
                this.checkChat = this.addTypeInfo(this.checkChat, "Chat", this.nChat);
                this.checkShoebox = this.addTypeInfo(this.checkShoebox, "Shoebox", this.nShoebox);
                this.checkText = this.addTypeInfo(this.checkText, "Text", this.nPlainText);
                this.checkXml = this.addTypeInfo(this.checkXml, "XML", this.nXmlText);
                this.checkHtml = this.addTypeInfo(this.checkHtml, "HTML", this.nHtmlText);
                this.itemStateChanged(null);
            }
            this.domainTypePanel.add(Box.createHorizontalGlue());
            this.add(Box.createVerticalStrut(5));
            this.add(this.domainTypePanel);
        } else {
            this.nEafLabel = new JLabel();
            this.nEafLabel.setFont(Constants.normalFont);
            this.domainNamePanel.add(this.nEafLabel);
            this.domainNamePanel.add(Box.createHorizontalGlue());
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("Initializing");
            this.progressBar.setVisible(true);
            this.domainNamePanel.add(this.progressBar);
            this.domainNamePanel.add(Box.createHorizontalStrut(20));
            this.domainButton = new JButton("Define New Domain");
            this.domainButton.addActionListener(this);
            this.domainButton.setEnabled(false);
            this.domainNamePanel.add(this.domainButton);
            this.domainNamePanel.add(Box.createHorizontalStrut(30));
            new Thread(this).start();
        }
    }

    public void run() {
        while (this.mediator.getDomainInitializationProgress(this.queryId) < 1.0f) {
            int n = (int)(this.mediator.getDomainInitializationProgress(this.queryId) * (float)this.progressBar.getMaximum());
            this.progressBar.setValue(n);
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        this.nEafLabel.setText(this.mediator.getDomainSize(this.queryId) + " eaf files");
        this.domainButton.setEnabled(true);
        this.progressBar.setVisible(false);
        if (this.searchListener != null) {
            this.searchListener.domainChanged();
        }
        this.mediator.checkForDomainErrors(this.queryId);
        this.validate();
    }

    public void newDomainFromOtherPanel() {
        this.domainButton.setEnabled(false);
        this.progressBar.setVisible(true);
        new Thread(this).start();
    }

    private JCheckBox addTypeInfo(JCheckBox jCheckBox, String string, int n) {
        if (n > 0) {
            jCheckBox = new JCheckBox(string);
            jCheckBox.setBackground(this.backgroundColor);
            String string2 = Integer.toString(n) + "  ";
            JLabel jLabel = new JLabel(string2);
            jLabel.setFont(Constants.smallFont);
            jCheckBox.setSelected(true);
            jCheckBox.addItemListener(this);
            this.domainTypePanel.add(jCheckBox);
            this.domainTypePanel.add(jLabel);
            return jCheckBox;
        }
        return null;
    }

    public int getDomainLabelWidth() {
        return this.getStringWidth(this.domainLabel.getText(), this.domainLabel.getFont());
    }

    private int getStringWidth(String string, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        return (int)rectangle2D.getWidth();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.domainTypes = "";
        if (this.checkEaf != null && this.checkEaf.isSelected()) {
            this.domainTypes = this.domainTypes + "-eaf-";
        }
        if (this.checkChat != null && this.checkChat.isSelected()) {
            this.domainTypes = this.domainTypes + "-chat-";
        }
        if (this.checkShoebox != null && this.checkShoebox.isSelected()) {
            this.domainTypes = this.domainTypes + "-shoebox-";
        }
        if (this.checkText != null && this.checkText.isSelected()) {
            this.domainTypes = this.domainTypes + "-plaintext-";
        }
        if (this.checkXml != null && this.checkXml.isSelected()) {
            this.domainTypes = this.domainTypes + "-xmltext-";
        }
        if (this.checkHtml != null && this.checkHtml.isSelected()) {
            this.domainTypes = this.domainTypes + "-htmltext-";
        }
        this.mediator.setQueryDomain(this.domainTypes, this.queryId);
        if (itemEvent != null) {
            this.searchListener.domainChanged();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.domainButton) {
            this.mediator.setQueryDomain(this.domainTypes, this.queryId);
            this.domainButton.setEnabled(false);
            this.progressBar.setVisible(true);
            new Thread(this).start();
        }
    }
}

