/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.annex.search.Constants;
import mpi.annex.search.SearchListener;

public class SearchHistoryPanel
extends JPanel
implements ActionListener {
    private final String SPLITTER = "qzbxv";
    private SearchListener searchListener;
    private ArrayList history;
    int currentItem;
    private JButton historyPrevious;
    private JButton historyNext;
    private boolean persistentHistoryLoaded;

    public SearchHistoryPanel(SearchListener searchListener, Color color) {
        this.searchListener = searchListener;
        this.history = new ArrayList();
        this.currentItem = 0;
        this.setBackground(color);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        JLabel jLabel = new JLabel("Query History:");
        jLabel.setFont(Constants.bigBoldFont);
        this.add(jLabel);
        this.add(Box.createHorizontalStrut(10));
        this.historyPrevious = new JButton("<");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.historyPrevious.setBackground(color);
        }
        this.historyPrevious.addActionListener(this);
        this.add(this.historyPrevious);
        this.add(Box.createHorizontalStrut(5));
        this.historyNext = new JButton(">");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.historyNext.setBackground(color);
        }
        this.historyNext.addActionListener(this);
        this.add(this.historyNext);
        this.add(Box.createHorizontalGlue());
    }

    public void setHistory(String string) {
        if (string != null) {
            String[] stringArray = string.split("qzbxv");
            this.history.clear();
            for (int i = 0; i < stringArray.length; ++i) {
                this.history.add(stringArray[i]);
            }
            this.currentItem = -1;
        }
        this.persistentHistoryLoaded = true;
    }

    public void reset() {
        this.currentItem = -1;
    }

    public String getHistory() {
        if (this.history.size() == 0) {
            return "zywNULL STRINGqqx";
        }
        String string = "";
        for (int i = 0; i < this.history.size(); ++i) {
            string = string + "qzbxv" + (String)this.history.get(i);
        }
        return string.substring("qzbxv".length());
    }

    public void remember(String string) {
        if (this.history.size() == 0 || !string.equals((String)this.history.get(0))) {
            this.history.add(0, string);
            this.currentItem = 0;
            if (this.history.size() >= 20) {
                this.history.remove(this.history.size() - 1);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.historyPrevious) {
            if (this.currentItem + 1 < this.history.size()) {
                ++this.currentItem;
                this.searchListener.setQuery((String)this.history.get(this.currentItem));
            }
        } else if (this.currentItem > 0) {
            --this.currentItem;
            this.searchListener.setQuery((String)this.history.get(this.currentItem));
        }
    }
}

