/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.util.ArrayList;
import java.util.regex.Pattern;

public class SearchLayer {
    private boolean isEmpty = true;
    private ArrayList patterns = new ArrayList();
    private ArrayList patternsNOTMode = new ArrayList();
    private ArrayList regExpPatterns = new ArrayList();
    private ArrayList hModeInfo = new ArrayList();
    private ArrayList vModeInfo = new ArrayList();
    private ArrayList modes = new ArrayList();
    private ArrayList innerConstraints = new ArrayList();
    private ArrayList tierConstraints = new ArrayList();
    private ArrayList outerConstraints = new ArrayList();
    private ArrayList hitAnnIdsForPattern = new ArrayList();
    private ArrayList hitNumbersForPattern = new ArrayList();
    private int[] hitFileIds;
    private String tierIdsInLayerDomain = "";

    public void addPattern(String string, String string2, String string3, String string4) {
        boolean bl = false;
        while (SearchLayer.isNOTPattern(string)) {
            bl = !bl;
            string = SearchLayer.stripNOTPattern(string);
        }
        this.patternsNOTMode.add(new Boolean(bl));
        this.patterns.add(string);
        String[] stringArray = string2.split("'");
        this.modes.add(stringArray);
        if (string.length() > 0) {
            this.isEmpty = false;
            if (stringArray[2].equals(" regular expression")) {
                if (stringArray[1].equals(" case sensitive")) {
                    this.regExpPatterns.add(Pattern.compile(string));
                } else {
                    this.regExpPatterns.add(Pattern.compile(string.toLowerCase()));
                }
            } else {
                this.regExpPatterns.add(null);
            }
            this.hitAnnIdsForPattern.add(new int[10000]);
            this.hitNumbersForPattern.add(new int[10000]);
            if (this.hitFileIds == null) {
                this.hitFileIds = new int[10000];
            }
        } else {
            this.hitAnnIdsForPattern.add(null);
            this.hitNumbersForPattern.add(null);
            this.regExpPatterns.add(null);
        }
        this.innerConstraints.add(string3);
        this.outerConstraints.add(string4);
        this.hModeInfo.add(new int[2]);
        this.vModeInfo.add(new int[1]);
    }

    public void addTierConstraint(String string) {
        this.tierConstraints.add(string);
    }

    public int getNumberOfPatterns() {
        return this.patterns.size();
    }

    public String getPattern(int n) {
        return (String)this.patterns.get(n);
    }

    public boolean getPatternNOTMode(int n) {
        return (Boolean)this.patternsNOTMode.get(n);
    }

    public Pattern getRegExpPattern(int n) {
        return (Pattern)this.regExpPatterns.get(n);
    }

    public String[] getMode(int n) {
        return (String[])this.modes.get(n);
    }

    public String getInnerConstraint(int n) {
        return (String)this.innerConstraints.get(n);
    }

    public ArrayList getTierConstraints() {
        return this.tierConstraints;
    }

    public int[] getHModeInfo(int n) {
        return (int[])this.hModeInfo.get(n);
    }

    public int[] getVModeInfo(int n) {
        return (int[])this.vModeInfo.get(n);
    }

    public void setTierIdsInLayerDomain(String string) {
        this.tierIdsInLayerDomain = string;
    }

    public String getTierIdsInLayerDomain() {
        return this.tierIdsInLayerDomain;
    }

    public String getOuterConstraint(int n) {
        return (String)this.outerConstraints.get(n);
    }

    public int[] getHitAnnIdsForPattern(int n) {
        return (int[])this.hitAnnIdsForPattern.get(n);
    }

    public int[] getHitNumberForPattern(int n) {
        return (int[])this.hitNumbersForPattern.get(n);
    }

    public int[] getHitFileIds() {
        return this.hitFileIds;
    }

    public int getIndexOfFirstNonEmptyPattern() {
        for (int i = 0; i < this.patterns.size(); ++i) {
            if (((String)this.patterns.get(i)).length() <= 0) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public static boolean isNOTPattern(String string) {
        return string.trim().startsWith("NOT(") && string.trim().endsWith(")");
    }

    public static String stripNOTPattern(String string) {
        if (!SearchLayer.isNOTPattern(string)) {
            return string;
        }
        return string.trim().substring(4, string.length() - 1).trim();
    }

    public void display() {
        int n;
        System.out.println("\tPatterns and inner constraints: ");
        for (n = 0; n < this.patterns.size(); ++n) {
            String string = ((String[])this.modes.get(n))[0];
            String string2 = ((String[])this.modes.get(n))[1];
            String string3 = ((String[])this.modes.get(n))[2];
            System.out.println("\t\t|" + this.patterns.get(n) + "| as " + string + " " + string2 + " " + string3);
            System.out.println("\t\tinner: " + this.innerConstraints.get(n));
            System.out.println("\t\touter: " + this.outerConstraints.get(n));
        }
        System.out.println("\n\tTiers: ");
        for (n = 0; n < this.tierConstraints.size(); ++n) {
            System.out.println("\t\t" + this.tierConstraints.get(n));
        }
    }
}

