/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mpi.annex.search.Constants;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.SearchLayer;
import mpi.annex.search.SearchStatistics;

public abstract class SearchQuery {
    protected String schemaName;
    protected HashMap frequencyMap;
    protected TreeSet frequencyInfoTree;
    protected ArrayList orderedFrequencyInfo;
    protected SearchStatistics statistics;
    protected boolean patternNeedsFullStatistics;
    protected SearchLayer[] searchLayers;
    protected int nLayers;
    protected int nPatternsPerLayer;
    protected int firstNonEmptyLayerIndex;
    protected int firstNonEmptyPatternIndex;
    protected boolean isSimpleQuery;
    protected boolean isMultipleLayerQuery;
    protected boolean isExecuting;
    protected boolean keepExecuting;
    protected int nGramSizeLeftFromHit;
    protected int nGramSizeRightFromHit;
    protected int[][] globalHitAnnId;
    protected int[][] globalHitTierId;
    protected int[][] globalHitFileId;
    protected int[][] globalHitPosition;
    protected long[][] globalHitBeginTime;
    protected long[][] globalHitEndTime;
    protected PreparedStatement[][] preparedStatements;
    protected PreparedStatement prepStatComplexHitResultData;
    protected PreparedStatement prepStatCheckValidDuration;
    protected long minimalDuration;
    protected long maximalDuration;
    protected long beginAfter;
    protected long endBefore;
    protected String currentNodeId;
    protected String currentTranscriptionTierDomain;
    protected HashMap domainTierNames = new HashMap();
    protected HashMap domainTierTypes = new HashMap();
    protected HashMap domainTierParticipants = new HashMap();
    protected String fullTranscriptionTierDomain;
    protected boolean thereIsALayerWithAnEmptyTierDomain;

    public SearchQuery() {
        this.statistics = new SearchStatistics();
        this.frequencyMap = new HashMap();
    }

    public ArrayList getSearchModes() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Integer.toString(Constants.targetModes.length));
        for (n = 0; n < Constants.targetModes.length; ++n) {
            arrayList.add(Constants.targetModes[n]);
        }
        arrayList.add(Integer.toString(Constants.caseModes.length));
        for (n = 0; n < Constants.caseModes.length; ++n) {
            arrayList.add(Constants.caseModes[n]);
        }
        arrayList.add(Integer.toString(Constants.matchModes.length));
        for (n = 0; n < Constants.matchModes.length; ++n) {
            arrayList.add(Constants.matchModes[n]);
        }
        return arrayList;
    }

    public void createLayers(String string) {
        int n;
        int n2;
        String[] stringArray = string.split("jqzxw");
        this.firstNonEmptyLayerIndex = -1;
        this.firstNonEmptyPatternIndex = -1;
        int n3 = 0;
        String[] stringArray2 = stringArray[0].split(",");
        this.minimalDuration = Long.parseLong(stringArray2[0].trim());
        this.maximalDuration = Long.parseLong(stringArray2[1].trim());
        this.beginAfter = Long.parseLong(stringArray2[2].trim());
        this.endBefore = Long.parseLong(stringArray2[3].trim());
        this.nLayers = Integer.parseInt(stringArray2[4].trim());
        this.nPatternsPerLayer = Integer.parseInt(stringArray2[5].trim());
        this.searchLayers = new SearchLayer[this.nLayers];
        int n4 = 1;
        for (n2 = 0; n2 < this.nLayers; ++n2) {
            this.searchLayers[n2] = new SearchLayer();
            for (n = 0; n < this.nPatternsPerLayer; ++n) {
                String string2;
                if ((string2 = stringArray[n4++]).length() > 0) {
                    ++n3;
                }
                String string3 = stringArray[n4++];
                String string4 = stringArray[n4++];
                String string5 = stringArray[n4++];
                this.searchLayers[n2].addPattern(string2, string3, string4, string5);
                if (this.firstNonEmptyPatternIndex >= 0 || string2.length() <= 0) continue;
                this.firstNonEmptyLayerIndex = n2;
                this.firstNonEmptyPatternIndex = n;
            }
            n = Integer.parseInt(stringArray2[n2 + 6].trim());
            for (int i = 0; i < n; ++i) {
                this.searchLayers[n2].addTierConstraint(stringArray[n4++]);
            }
        }
        this.isSimpleQuery = n3 <= 1;
        n2 = 0;
        for (n = 0; n < this.nLayers; ++n) {
            if (this.searchLayers[n].isEmpty()) continue;
            ++n2;
        }
        this.isMultipleLayerQuery = n2 > 1;
        this.globalHitAnnId = new int[this.nLayers][this.nPatternsPerLayer];
        this.globalHitTierId = new int[this.nLayers][this.nPatternsPerLayer];
        this.globalHitFileId = new int[this.nLayers][this.nPatternsPerLayer];
        this.globalHitPosition = new int[this.nLayers][this.nPatternsPerLayer];
        this.globalHitBeginTime = new long[this.nLayers][this.nPatternsPerLayer];
        this.globalHitEndTime = new long[this.nLayers][this.nPatternsPerLayer];
        this.preparedStatements = new PreparedStatement[this.nLayers][this.nPatternsPerLayer];
        this.prepStatComplexHitResultData = null;
        this.prepStatCheckValidDuration = null;
    }

    private void displayLayerInfo() {
        System.out.println("nLayers: " + this.nLayers);
        for (int i = 0; i < this.nLayers; ++i) {
            System.out.println("\nLayer " + i);
            this.searchLayers[i].display();
        }
    }

    public boolean isRunning() {
        return this.isExecuting;
    }

    public SearchStatistics getSearchStatistics() {
        this.statistics.nFrequencyInfoItems = this.frequencyMap.size();
        return this.statistics;
    }

    protected void clearFrequencyStatistics() {
        this.frequencyMap.clear();
        this.frequencyInfoTree = null;
        this.orderedFrequencyInfo = null;
    }

    protected void updateFrequencyStatistics(String string, int n, int n2, int n3, int n4) {
        FrequencyInfo frequencyInfo = (FrequencyInfo)this.frequencyMap.get(string);
        if (frequencyInfo != null) {
            ++frequencyInfo.numberOfHits;
        } else if (this.frequencyMap.size() < 10000) {
            frequencyInfo = new FrequencyInfo();
            frequencyInfo.annId = n;
            frequencyInfo.fileIndex = n2;
            frequencyInfo.layerIndex = n3;
            frequencyInfo.patternIndex = n4;
            frequencyInfo.numberOfHits = 1;
            this.frequencyMap.put(string, frequencyInfo);
        }
    }

    public ArrayList getFrequencyInfo(int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.frequencyMap.size() >= 10000) {
            FrequencyInfo frequencyInfo = new FrequencyInfo();
            frequencyInfo.annotation = "No frequency statistics available, there were more than 10000 different hit patterns";
            frequencyInfo.numberOfHits = -1;
            arrayList.add(frequencyInfo);
        } else {
            String[] stringArray;
            Object object;
            if (this.orderedFrequencyInfo == null) {
                this.frequencyInfoTree = new TreeSet(new FreqInfoComparator());
                Iterator<Object> iterator = this.frequencyMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    stringArray = (String[])this.frequencyMap.get(object);
                    stringArray.annotation = object;
                    this.frequencyInfoTree.add(stringArray);
                }
                this.orderedFrequencyInfo = new ArrayList();
                iterator = this.frequencyInfoTree.iterator();
                while (iterator.hasNext()) {
                    this.orderedFrequencyInfo.add(0, iterator.next());
                }
            }
            for (int i = n; i < n2; ++i) {
                if (i >= this.orderedFrequencyInfo.size()) continue;
                object = (FrequencyInfo)this.orderedFrequencyInfo.get(i);
                ((FrequencyInfo)object).nOccurences = this.frequencyMap.size();
                if (((FrequencyInfo)object).hitPositionInAnnotation == 0 && ((FrequencyInfo)object).hitLength == 0) {
                    stringArray = this.searchLayers[((FrequencyInfo)object).layerIndex].getMode(((FrequencyInfo)object).patternIndex);
                    String string = this.searchLayers[((FrequencyInfo)object).layerIndex].getPattern(((FrequencyInfo)object).patternIndex);
                    boolean bl = this.searchLayers[((FrequencyInfo)object).layerIndex].getPatternNOTMode(((FrequencyInfo)object).patternIndex);
                    Pattern pattern = this.searchLayers[((FrequencyInfo)object).layerIndex].getRegExpPattern(((FrequencyInfo)object).patternIndex);
                    if (stringArray[0].equals(" Annotation") && this.isSimpleQuery) {
                        ((FrequencyInfo)object).hitPositionInAnnotation = this.getHitPosition(((FrequencyInfo)object).annotation, 1, stringArray, string, pattern, bl);
                        ((FrequencyInfo)object).hitLength = this.getHitLength(((FrequencyInfo)object).annotation, 1, stringArray, string, pattern, bl);
                    } else {
                        ((FrequencyInfo)object).hitPositionInAnnotation = 0;
                        ((FrequencyInfo)object).hitLength = 0;
                    }
                }
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    protected void investigateComplexPattern(int n, int n2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            while (n < this.nLayers) {
                if (n2 + 1 < this.nPatternsPerLayer) {
                    ++n2;
                } else {
                    ++n;
                    n2 = 0;
                }
                if (n == this.nLayers) {
                    if (!this.patternHasValidDuration(-1L, -1L, connection)) {
                        return;
                    }
                    if (this.statistics.nHits < 10000) {
                        this.rememberHitData(this.statistics.nHits);
                    }
                    String string = this.constructComplexHitResultString((Connection)connection, (Statement)statement, (int[][])this.globalHitAnnId, (boolean)false).hitString.replaceAll("jqzxw", " ");
                    int n3 = this.globalHitAnnId[this.firstNonEmptyLayerIndex][this.firstNonEmptyPatternIndex];
                    int n4 = this.globalHitFileId[this.firstNonEmptyLayerIndex][this.firstNonEmptyPatternIndex];
                    this.updateFrequencyStatistics(string.replaceAll("qwynbbvs", "  #"), n3, n4, this.firstNonEmptyLayerIndex, this.firstNonEmptyPatternIndex);
                    ++this.statistics.nHits;
                    ++this.statistics.nAnnotationsWithHit;
                    return;
                }
                if (this.searchLayers[n].getPattern(n2).length() <= 0) continue;
            }
            String string = this.searchLayers[n].getPattern(n2);
            boolean bl = this.searchLayers[n].getPatternNOTMode(n2);
            Pattern pattern = this.searchLayers[n].getRegExpPattern(n2);
            String[] stringArray = this.searchLayers[n].getMode(n2);
            String string2 = "SELECT ann_id, ann_tier_id, annotation, ann_position, begin_time, end_time, aligned, ref_ann_id FROM " + this.schemaName + ".annotations WHERE ";
            string2 = string2 + this.createQueryPatternPart(string, stringArray, pattern, bl);
            string2 = string2 + this.createHorizontalConstraintPart(n, n2, statement);
            string2 = string2 + this.createVerticalConstraintPart(n, n2, statement);
            string2 = string2 + this.createTierConstraintPart(n, n2);
            string2 = string2 + this.createGlobalTimeConstraintPart();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                int n5 = resultSet.getInt(1);
                int n6 = resultSet.getInt(2);
                this.globalHitAnnId[n][n2] = n5;
                this.globalHitTierId[n][n2] = n6;
                this.globalHitBeginTime[n][n2] = resultSet.getLong(5);
                this.globalHitEndTime[n][n2] = resultSet.getLong(6);
                this.globalHitPosition[n][n2] = resultSet.getInt(4);
                this.investigateComplexPattern(n, n2, connection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected abstract String createQueryPatternPart(String var1, String[] var2, Pattern var3, boolean var4);

    protected String createHorizontalConstraintPart(int n, int n2, Statement statement) {
        String string = "";
        try {
            if (n2 > 0 && this.globalHitAnnId[n][n2 - 1] != -1) {
                int n3 = this.globalHitPosition[n][n2 - 1];
                long l = this.globalHitEndTime[n][n2 - 1];
                String string2 = this.searchLayers[n].getInnerConstraint(n2 - 1);
                if (string2.equals("cns none")) {
                    string = " AND ann_position > " + n3;
                } else if (string2.startsWith("cns an=:")) {
                    String[] stringArray = string2.split(":");
                    int n4 = Integer.parseInt(stringArray[1]) + 1;
                    string = " AND ann_position = " + (n3 + n4);
                } else if (string2.startsWith("cns an<:")) {
                    String[] stringArray = string2.split(":");
                    int n5 = Integer.parseInt(stringArray[1]) + 1;
                    string = " AND ann_position < " + (n3 + n5) + " AND ann_position > " + n3;
                } else if (string2.startsWith("cns an>:")) {
                    String[] stringArray = string2.split(":");
                    int n6 = Integer.parseInt(stringArray[1]) + 1;
                    string = " AND ann_position > " + (n3 + n6);
                } else if (string2.startsWith("cns ms=:")) {
                    String[] stringArray = string2.split(":");
                    int n7 = Integer.parseInt(stringArray[1]);
                    string = " AND begin_time = " + (l + (long)n7);
                } else if (string2.startsWith("cns ms<:")) {
                    String[] stringArray = string2.split(":");
                    int n8 = Integer.parseInt(stringArray[1]);
                    string = " AND begin_time < " + (l + (long)n8) + " AND begin_time >= " + l;
                } else if (string2.startsWith("cns ms>:")) {
                    String[] stringArray = string2.split(":");
                    int n9 = Integer.parseInt(stringArray[1]);
                    string = " AND begin_time > " + (l + (long)n9);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    protected String createVerticalConstraintPart(int n, int n2, Statement statement) {
        String string = "";
        try {
            String string2;
            if (n > 0 && this.globalHitAnnId[n - 1][n2] != -1 && !(string2 = this.searchLayers[n - 1].getOuterConstraint(n2)).equals("cns none")) {
                long l = this.globalHitBeginTime[n - 1][n2];
                long l2 = this.globalHitEndTime[n - 1][n2];
                if (!string2.equals("cns none")) {
                    if (string2.equals("cns aligned")) {
                        string = " AND begin_time = " + l + " AND end_time = " + l2;
                    } else if (string2.equals("cns overlap")) {
                        string = " AND end_time >= " + l + " AND begin_time <= " + l2;
                    } else if (string2.equals("cns l overlap")) {
                        string = " AND begin_time <= " + l + " AND end_time >= " + l + " AND end_time <= " + l2;
                    } else if (string2.equals("cns r overlap")) {
                        string = " AND begin_time <= " + l2 + " AND end_time >= " + l2 + " AND begin_time >= " + l;
                    } else if (string2.equals("cns surrounding")) {
                        string = " AND begin_time <= " + l + " AND end_time >= " + l2;
                    } else if (string2.equals("cns within")) {
                        string = " AND begin_time >= " + l + " AND end_time <= " + l2;
                    } else if (string2.equals("cns no overlap")) {
                        string = " AND (end_time < " + l + " OR begin_time > " + l2 + ")";
                    } else if (string2.equals("cns bb=:")) {
                        String[] stringArray = string2.split(":");
                        int n3 = Integer.parseInt(stringArray[1]);
                        string = " AND begin_time = " + l + n3;
                    } else if (string2.equals("cns bb<:")) {
                        String[] stringArray = string2.split(":");
                        int n4 = Integer.parseInt(stringArray[1]);
                        string = " AND begin_time < " + l + n4;
                    } else if (string2.equals("cns bb>:")) {
                        String[] stringArray = string2.split(":");
                        int n5 = Integer.parseInt(stringArray[1]);
                        string = " AND begin_time > " + l + n5;
                    } else if (string2.equals("cns be=:")) {
                        String[] stringArray = string2.split(":");
                        int n6 = Integer.parseInt(stringArray[1]);
                        string = " AND begin_time = " + l2 + n6;
                    } else if (string2.equals("cns be<:")) {
                        String[] stringArray = string2.split(":");
                        int n7 = Integer.parseInt(stringArray[1]);
                        string = " AND begin_time < " + l2 + n7;
                    } else if (string2.equals("cns be>:")) {
                        String[] stringArray = string2.split(":");
                        int n8 = Integer.parseInt(stringArray[1]);
                        string = " AND begin_time > " + l2 + n8;
                    } else if (string2.equals("cns eb=:")) {
                        String[] stringArray = string2.split(":");
                        int n9 = Integer.parseInt(stringArray[1]);
                        string = " AND end_time = " + l + n9;
                    } else if (string2.equals("cns eb<:")) {
                        String[] stringArray = string2.split(":");
                        int n10 = Integer.parseInt(stringArray[1]);
                        string = " AND end_time < " + l + n10;
                    } else if (string2.equals("cns eb>:")) {
                        String[] stringArray = string2.split(":");
                        int n11 = Integer.parseInt(stringArray[1]);
                        string = " AND end_time > " + l + n11;
                    } else if (string2.equals("cns ee=:")) {
                        String[] stringArray = string2.split(":");
                        int n12 = Integer.parseInt(stringArray[1]);
                        string = " AND end_time = " + l2 + n12;
                    } else if (string2.equals("cns ee<:")) {
                        String[] stringArray = string2.split(":");
                        int n13 = Integer.parseInt(stringArray[1]);
                        string = " AND end_time < " + l2 + n13;
                    } else if (string2.equals("cns ee>:")) {
                        String[] stringArray = string2.split(":");
                        int n14 = Integer.parseInt(stringArray[1]);
                        string = " AND end_time > " + l2 + n14;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    protected String createTierConstraintPart(int n, int n2) {
        String string = "";
        if (n2 > 0 && this.globalHitTierId[n][n2 - 1] != -1) {
            string = " AND ann_tier_id = " + this.globalHitTierId[n][n2 - 1];
        } else {
            String string2 = this.searchLayers[n].getTierIdsInLayerDomain();
            if (string2 != null) {
                string = string + string2;
            }
            --n;
            while (n >= 0) {
                for (int i = 0; i < this.nPatternsPerLayer; ++i) {
                    int n3 = this.globalHitTierId[n][n2];
                    if (n3 == -1) continue;
                    string = string + " AND ann_tier_id != " + n3;
                    break;
                }
                --n;
            }
        }
        return string;
    }

    protected void setTierDomainForLayers(boolean bl, Statement statement) {
        try {
            Object object;
            String string;
            int n;
            this.fullTranscriptionTierDomain = "";
            this.thereIsALayerWithAnEmptyTierDomain = false;
            this.domainTierNames.clear();
            this.domainTierTypes.clear();
            this.domainTierParticipants.clear();
            String string2 = "SELECT tier_id, tier_name, tier_type, participant FROM " + this.schemaName + ".tiers WHERE node_id = '" + this.currentNodeId + "'";
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                n = resultSet.getInt(1);
                this.fullTranscriptionTierDomain = this.fullTranscriptionTierDomain + " OR ann_tier_id = " + n;
                String string3 = resultSet.getString(2);
                if (string3 != null) {
                    string3 = string3.trim();
                    this.domainTierNames.put(string3, " OR ann_tier_id = " + n);
                }
                if ((string = resultSet.getString(3)) != null) {
                    object = (String)this.domainTierTypes.get(string = string.trim());
                    if (object == null) {
                        this.domainTierTypes.put(string, " OR ann_tier_id = " + n);
                    } else {
                        this.domainTierTypes.put(string, (String)object + " OR ann_tier_id = " + n);
                    }
                }
                if ((object = resultSet.getString(4)) == null) continue;
                String string4 = (String)this.domainTierParticipants.get(object = ((String)object).trim());
                if (string4 == null) {
                    this.domainTierParticipants.put(object, " OR ann_tier_id = " + n);
                    continue;
                }
                this.domainTierParticipants.put(object, string4 + " OR ann_tier_id = " + n);
            }
            if (this.fullTranscriptionTierDomain.length() > 3) {
                this.fullTranscriptionTierDomain = bl ? " AND (" + this.fullTranscriptionTierDomain.substring(3) + " ) " : "";
            } else {
                this.fullTranscriptionTierDomain = null;
                this.thereIsALayerWithAnEmptyTierDomain = true;
            }
            n = 0;
            for (int i = 0; i < this.nLayers; ++i) {
                if (this.searchLayers[i].isEmpty()) continue;
                string = "";
                object = this.searchLayers[i].getTierConstraints();
                for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                    String string5 = (String)((ArrayList)object).get(j);
                    if (string5.startsWith(" All Tiers ")) {
                        n = 1;
                        break;
                    }
                    if (string5.startsWith(" Tier Name: ")) {
                        if (this.domainTierNames.get(string5 = string5.substring(" Tier Name: ".length())) == null) continue;
                        string = string + this.domainTierNames.get(string5);
                        continue;
                    }
                    if (string5.startsWith(" Tier Type: ")) {
                        if (this.domainTierTypes.get(string5 = string5.substring(" Tier Type: ".length())) == null) continue;
                        string = string + this.domainTierTypes.get(string5);
                        continue;
                    }
                    if (!string5.startsWith(" Participant: ") || this.domainTierParticipants.get(string5 = string5.substring(" Participant: ".length())) == null) continue;
                    string = string + this.domainTierParticipants.get(string5);
                }
                if (string == null) {
                    this.searchLayers[i].setTierIdsInLayerDomain(null);
                    this.thereIsALayerWithAnEmptyTierDomain = true;
                    continue;
                }
                if (n != 0) {
                    this.searchLayers[i].setTierIdsInLayerDomain(this.fullTranscriptionTierDomain);
                    continue;
                }
                if (string.length() > 3) {
                    this.searchLayers[i].setTierIdsInLayerDomain(" AND  (" + string.substring(3) + ")");
                    continue;
                }
                this.searchLayers[i].setTierIdsInLayerDomain(null);
                this.thereIsALayerWithAnEmptyTierDomain = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String xcreateQueryTierDomainPart(ArrayList arrayList) {
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (i > 0) {
                string = string + " OR ";
            }
            if (string2.startsWith(" All Tiers ")) {
                return null;
            }
            if (string2.startsWith(" Tier Name: ")) {
                string = string + " tier_name = '" + string2.substring(" Tier Name: ".length()) + "'";
                continue;
            }
            if (string2.startsWith(" Tier Type: ")) {
                string = string + " tier_type = '" + string2.substring(" Tier Type: ".length()) + "'";
                continue;
            }
            if (!string2.startsWith(" Participant: ")) continue;
            string = string + " participant = '" + string2.substring(" Participant: ".length()) + "'";
        }
        return string;
    }

    protected ComplexHitData constructComplexHitResultString(Connection connection, Statement statement, int[][] nArray, boolean bl) {
        String string = "";
        long l = Long.MAX_VALUE;
        long l2 = 0L;
        try {
            if (connection != null && this.prepStatComplexHitResultData == null) {
                String string2 = "SELECT annotation, ann_position, begin_time, end_time  FROM " + this.schemaName + ".annotations WHERE ann_id = ?";
                this.prepStatComplexHitResultData = connection.prepareStatement(string2, 1004, 1007);
            }
            for (int i = 0; i < this.nLayers; ++i) {
                string = string + "qwynbbvs" + (i + 1);
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    if (nArray[i][j] > 0) {
                        String string3;
                        ResultSet resultSet;
                        if (connection != null) {
                            this.prepStatComplexHitResultData.setInt(1, nArray[i][j]);
                            resultSet = this.prepStatComplexHitResultData.executeQuery();
                        } else {
                            string3 = "SELECT annotation, ann_position, begin_time, end_time  FROM " + this.schemaName + ".annotations WHERE ann_id = " + nArray[i][j];
                            resultSet = statement.executeQuery(string3);
                        }
                        resultSet.next();
                        string3 = resultSet.getString(1);
                        int n = resultSet.getInt(2);
                        long l3 = resultSet.getLong(3);
                        long l4 = resultSet.getLong(4);
                        string = string + "jqzxw|" + string3 + "|";
                        if (bl) {
                            string = string + "oskjdjrj" + n + "oskjdjrj" + l3 + "oskjdjrj" + l4;
                        }
                        if (l3 < l) {
                            l = l3;
                        }
                        if (l4 <= l2) continue;
                        l2 = l4;
                        continue;
                    }
                    string = string + "jqzxw||";
                    if (!bl) continue;
                    string = string + ":0:0:0";
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ComplexHitData complexHitData = new ComplexHitData();
        complexHitData.hitString = string;
        complexHitData.beginTime = l;
        complexHitData.endTime = l2;
        return complexHitData;
    }

    protected String[] constructNGramsWithinAnnotation(String string, String string2, String[] stringArray) {
        int n;
        String string3;
        Matcher matcher;
        String[] stringArray2 = null;
        String[] stringArray3 = string.split(" +");
        String string4 = this.getLongestNonWildcardPart(string2);
        boolean bl = false;
        while (SearchLayer.isNOTPattern(string4)) {
            bl = !bl;
            string4 = SearchLayer.stripNOTPattern(string4);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray[1].equals(" case sensitive")) {
            if (stringArray[2].equals(" exact match")) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    String string5;
                    if (bl == stringArray3[i].equals(string4) || (string5 = this.constructNGram(string2, stringArray3, i, stringArray)) == null) continue;
                    arrayList.add(string5);
                }
            } else if (stringArray[2].equals(" substring match")) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    String string6;
                    if (bl == stringArray3[i].indexOf(string4) >= 0 || (string6 = this.constructNGram(string2, stringArray3, i, stringArray)) == null) continue;
                    arrayList.add(string6);
                }
            } else if (stringArray[2].equals(" regular expression")) {
                Pattern pattern = Pattern.compile(string4);
                for (int i = 0; i < stringArray3.length; ++i) {
                    matcher = pattern.matcher(stringArray3[i]);
                    if (bl == matcher.find() || (string3 = this.constructNGram(string2, stringArray3, i, stringArray)) == null) continue;
                    arrayList.add(string3);
                }
            }
        } else if (stringArray[2].equals(" exact match")) {
            for (int i = 0; i < stringArray3.length; ++i) {
                String string7;
                if (bl == stringArray3[i].toLowerCase().equals(string4.toLowerCase()) || (string7 = this.constructNGram(string2, stringArray3, i, stringArray)) == null) continue;
                arrayList.add(string7);
            }
        } else if (stringArray[2].equals(" substring match")) {
            for (int i = 0; i < stringArray3.length; ++i) {
                String string8;
                if (bl == stringArray3[i].toLowerCase().indexOf(string4.toLowerCase()) >= 0 || (string8 = this.constructNGram(string2, stringArray3, i, stringArray)) == null) continue;
                arrayList.add(string8);
            }
        } else if (stringArray[2].equals(" regular expression")) {
            Pattern pattern = Pattern.compile(string4.toLowerCase());
            for (int i = 0; i < stringArray3.length; ++i) {
                matcher = pattern.matcher(stringArray3[i].toLowerCase());
                if (bl == matcher.find() || (string3 = this.constructNGram(string2, stringArray3, i, stringArray)) == null) continue;
                arrayList.add(string3);
            }
        }
        if ((n = arrayList.size()) > 0) {
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = ((String)arrayList.get(i)).trim();
            }
            return stringArray2;
        }
        return null;
    }

    protected String[] constructNGrams(int n, Statement statement, String string, String string2, String[] stringArray) {
        String[] stringArray2 = null;
        try {
            int n2;
            if (stringArray[0].equals(" N-gram within annotation")) {
                String string3 = "SELECT annotation FROM " + string + ".annotations WHERE ann_id = " + n;
                ResultSet resultSet = statement.executeQuery(string3);
                resultSet.next();
                String string4 = resultSet.getString(1);
                return this.constructNGramsWithinAnnotation(string4, string2, stringArray);
            }
            String string5 = "SELECT ann_position, ann_tier_id FROM " + string + ".annotations WHERE ann_id = " + n;
            ResultSet resultSet = statement.executeQuery(string5);
            resultSet.next();
            int n3 = resultSet.getInt(1);
            int n4 = resultSet.getInt(2);
            int n5 = n3 - this.getLongestNonWildcardPartPosition(string2);
            if (n5 < 0) {
                return null;
            }
            String string6 = "";
            int n6 = n5 + this.getNGramLength(string2);
            String string7 = "";
            for (n2 = n5; n2 < n6; ++n2) {
                string7 = string7 + ", " + n2;
            }
            string7 = string7.substring(2);
            string5 = "SELECT annotation, ann_position FROM " + string + ".annotations WHERE ann_tier_id = " + n4 + " AND ann_position IN (" + string7 + ") ORDER BY ann_position";
            resultSet = statement.executeQuery(string5);
            n2 = 0;
            while (resultSet.next()) {
                ++n2;
                string6 = string6 + resultSet.getString(1) + "jqzxw";
            }
            if (n2 != n6 - n5) {
                return null;
            }
            stringArray2 = new String[]{string6.trim()};
            return stringArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String constructNGram(String string, String[] stringArray, int n, String[] stringArray2) {
        int n2 = n - this.getLongestNonWildcardPartPosition(string);
        if (n2 < 0) {
            return null;
        }
        int n3 = n2 + this.getNGramLength(string);
        if (n3 > stringArray.length) {
            return null;
        }
        String string2 = "";
        for (int i = n2; i < n3; ++i) {
            string2 = stringArray2[0].equals(" N-gram over annotations") ? string2 + stringArray[i] + "jqzxw" : string2 + stringArray[i] + " ";
        }
        if (stringArray2[0].equals(" N-gram over annotations")) {
            return string2.substring(0, string2.length() - "jqzxw".length());
        }
        return string2.trim();
    }

    protected boolean isNGramMatch(String string, String string2, String[] stringArray) {
        String[] stringArray2;
        String[] stringArray3 = null;
        stringArray3 = stringArray[0].equals(" N-gram over annotations") ? string.split("jqzxw") : string.split(" +");
        if (stringArray3.length != (stringArray2 = string2.split(" +")).length) {
            return false;
        }
        for (int i = 0; i < stringArray3.length; ++i) {
            Pattern pattern;
            Matcher matcher;
            String string3 = stringArray2[i];
            if (string3.equals("#")) continue;
            boolean bl = false;
            while (SearchLayer.isNOTPattern(string3)) {
                bl = !bl;
                string3 = SearchLayer.stripNOTPattern(string3);
            }
            if (!(stringArray[1].equals(" case sensitive") ? (stringArray[2].equals(" exact match") ? bl == stringArray3[i].equals(string3) : (stringArray[2].equals(" substring match") ? bl == stringArray3[i].indexOf(string3) >= 0 : stringArray[2].equals(" regular expression") && bl == (matcher = (pattern = Pattern.compile(string3)).matcher(stringArray3[i])).find())) : (stringArray[2].equals(" exact match") ? bl == stringArray3[i].toLowerCase().equals(string3.toLowerCase()) : (stringArray[2].equals(" substring match") ? bl == stringArray3[i].toLowerCase().indexOf(string3.toLowerCase()) >= 0 : stringArray[2].equals(" regular expression") && bl == (matcher = (pattern = Pattern.compile(string3.toLowerCase())).matcher(stringArray3[i].toLowerCase())).find())))) continue;
            return false;
        }
        return true;
    }

    protected String getLongestNonWildcardPart(String string) {
        String[] stringArray = string.split(" +");
        int n = this.getLongestNonWildcardPartPosition(string);
        return stringArray[n];
    }

    protected int getLongestNonWildcardPartPosition(String string) {
        String string2;
        int n;
        String[] stringArray = string.split(" +");
        int n2 = -1;
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n];
            if (string2.equals("#") || SearchLayer.isNOTPattern(string2) || string2.length() <= n3) continue;
            n3 = string2.length();
            n2 = n;
        }
        if (n2 >= 0) {
            return n2;
        }
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n];
            if (string2.equals("#")) continue;
            return n;
        }
        return 0;
    }

    protected int getNGramLength(String string) {
        return string.split(" +").length;
    }

    protected int countHitsInAnnotation(String string, String[] stringArray, String string2, Pattern pattern, boolean bl) {
        int n = 0;
        int n2 = string2.length();
        if (bl) {
            n = 1;
        } else if (stringArray[0].equals(" Annotation")) {
            if (stringArray[1].equals(" case sensitive")) {
                if (stringArray[2].equals(" substring match")) {
                    int n3 = string.indexOf(string2);
                    while (n3 >= 0) {
                        ++n;
                        n3 = string.indexOf(string2, n3 + n2);
                    }
                } else if (stringArray[2].equals(" regular expression")) {
                    Matcher matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        ++n;
                        while (matcher.find()) {
                            ++n;
                        }
                    }
                } else {
                    n = 1;
                }
            } else if (stringArray[2].equals(" substring match")) {
                string2 = string2.toLowerCase();
                string = string.toLowerCase();
                int n4 = string.indexOf(string2);
                while (n4 >= 0) {
                    ++n;
                    n4 = string.indexOf(string2, n4 + n2);
                }
            } else if (stringArray[2].equals(" regular expression")) {
                Matcher matcher = pattern.matcher(string.toLowerCase());
                if (matcher.find()) {
                    ++n;
                    while (matcher.find()) {
                        ++n;
                    }
                }
            } else {
                n = 1;
            }
        } else {
            n = 1;
        }
        return n;
    }

    protected int getHitPosition(String string, int n, String[] stringArray, String string2, Pattern pattern, boolean bl) {
        if (stringArray[0].equals(" N-gram over annotations")) {
            string2 = this.getLongestNonWildcardPart(string2);
            pattern = stringArray[1].equals(" case sensitive") ? Pattern.compile(string2) : Pattern.compile(string2.toLowerCase());
        }
        int n2 = 0;
        int n3 = string2.length();
        if (!bl) {
            Matcher matcher;
            if (stringArray[0].equals(" N-gram within annotation")) {
                int n4 = n;
                String[] stringArray2 = this.constructNGramsWithinAnnotation(string, string2, stringArray);
                if (stringArray2 != null) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (!this.isNGramMatch(stringArray2[i], string2, stringArray) || --n4 > 0) continue;
                        String string3 = string.replaceAll(" +", " ");
                        n2 = string3.indexOf(stringArray2[i]);
                        int n5 = 0;
                        for (int j = 0; j < i; ++j) {
                            if (!stringArray2[i].equals(stringArray2[j])) continue;
                            ++n5;
                        }
                        while (n5 > 0) {
                            n2 = string3.indexOf(stringArray2[i], n2 + 1);
                            --n5;
                        }
                        break;
                    }
                }
            } else if (stringArray[1].equals(" case sensitive")) {
                Matcher matcher2;
                if (stringArray[2].equals(" exact match")) {
                    int n6 = string.indexOf(string2);
                    --n;
                    while (n > 0) {
                        n6 = string.indexOf(string2, n6 + n3);
                        --n;
                    }
                    n2 = n6;
                } else if (stringArray[2].equals(" substring match")) {
                    int n7 = string.indexOf(string2);
                    --n;
                    while (n > 0) {
                        n7 = string.indexOf(string2, n7 + n3);
                        --n;
                    }
                    n2 = n7;
                } else if (stringArray[2].equals(" regular expression") && (matcher2 = pattern.matcher(string)).find()) {
                    --n;
                    while (n > 0) {
                        matcher2.find();
                        --n;
                    }
                    n2 = matcher2.start();
                }
            } else if (stringArray[2].equals(" exact match") && stringArray[0].equals(" N-gram within annotation")) {
                string2 = string2.toLowerCase();
                string = string.toLowerCase();
                int n8 = string.indexOf(string2);
                --n;
                while (n > 0) {
                    n8 = string.indexOf(string2, n8 + n3);
                    --n;
                }
                n2 = n8;
            } else if (stringArray[2].equals(" substring match")) {
                string2 = string2.toLowerCase();
                string = string.toLowerCase();
                int n9 = string.indexOf(string2);
                --n;
                while (n > 0) {
                    n9 = string.indexOf(string2, n9 + n3);
                    --n;
                }
                n2 = n9;
            } else if (stringArray[2].equals(" regular expression") && (matcher = pattern.matcher(string.toLowerCase())).find()) {
                --n;
                while (n > 0) {
                    matcher.find();
                    --n;
                }
                n2 = matcher.start();
            }
        }
        return n2;
    }

    private int getTokenNumberForPosition(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            n2 = string.indexOf(32, n2) + 1;
            ++n3;
        }
        return n3;
    }

    protected int getHitLength(String string, int n, String[] stringArray, String string2, Pattern pattern, boolean bl) {
        if (stringArray[0].equals(" N-gram over annotations")) {
            string2 = this.getLongestNonWildcardPart(string2);
            pattern = stringArray[1].equals(" case sensitive") ? Pattern.compile(string2) : Pattern.compile(string2.toLowerCase());
        }
        int n2 = string2.length();
        if (bl) {
            n2 = string.length();
        } else if (stringArray[0].equals(" N-gram within annotation")) {
            String[] stringArray2 = this.constructNGramsWithinAnnotation(string, string2, stringArray);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!this.isNGramMatch(stringArray2[i], string2, stringArray) || --n > 0) continue;
                n2 = stringArray2[i].length();
                break;
            }
        } else if (stringArray[2].equals(" regular expression")) {
            Matcher matcher = null;
            matcher = stringArray[1].equals(" case sensitive") ? pattern.matcher(string) : pattern.matcher(string.toLowerCase());
            if (matcher.find()) {
                --n;
                while (n > 0) {
                    matcher.find();
                    --n;
                }
                n2 = matcher.end() - matcher.start();
            }
        }
        return n2;
    }

    protected String createGlobalTimeConstraintPart() {
        String string = "";
        if (this.beginAfter > 0L) {
            string = string + " AND begin_time > " + this.beginAfter;
        }
        if (this.endBefore > 0L) {
            string = string + " AND end_time < " + this.endBefore;
        }
        return string;
    }

    protected boolean patternHasValidDuration(long l, long l2, Connection connection) {
        if (this.minimalDuration <= 0L && this.maximalDuration <= 0L) {
            return true;
        }
        if (l < 0L || l2 < 0L) {
            l = Long.MAX_VALUE;
            l2 = 0L;
            try {
                if (this.prepStatCheckValidDuration == null) {
                    String string = "SELECT begin_time, end_time FROM " + this.schemaName + ".annotations WHERE ann_id = ?";
                    this.prepStatCheckValidDuration = connection.prepareStatement(string, 1004, 1007);
                }
                for (int i = 0; i < this.nLayers; ++i) {
                    for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                        long l3;
                        if (this.globalHitAnnId[i][j] == -1) continue;
                        this.prepStatCheckValidDuration.setInt(1, this.globalHitAnnId[i][j]);
                        ResultSet resultSet = this.prepStatCheckValidDuration.executeQuery();
                        resultSet.next();
                        long l4 = resultSet.getLong(1);
                        if (l4 < l) {
                            l = l4;
                        }
                        if ((l3 = resultSet.getLong(2)) <= l2) continue;
                        l2 = l3;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        long l5 = l2 - l;
        if (this.minimalDuration > 0L) {
            if (this.maximalDuration > 0L) {
                return l5 >= this.minimalDuration && l5 <= this.maximalDuration;
            }
            return l5 >= this.minimalDuration;
        }
        return l5 <= this.maximalDuration;
    }

    protected void clearHitData(int n) {
        try {
            for (int i = 0; i < this.nLayers; ++i) {
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    this.globalHitFileId[i][j] = n;
                    this.globalHitAnnId[i][j] = -1;
                    this.globalHitTierId[i][j] = -1;
                }
            }
            this.prepStatCheckValidDuration = null;
            this.prepStatCheckValidDuration = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void rememberHitData(int n) {
        for (int i = 0; i < this.nLayers; ++i) {
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                if (this.globalHitAnnId[i][j] == -1) continue;
                this.searchLayers[i].getHitAnnIdsForPattern((int)j)[n] = this.globalHitAnnId[i][j];
                this.searchLayers[i].getHitFileIds()[n] = this.globalHitFileId[i][j];
            }
        }
    }

    protected class ComplexHitData {
        String hitString;
        long beginTime;
        long endTime;

        protected ComplexHitData() {
        }
    }

    protected class FreqInfoComparator
    implements Comparator {
        protected FreqInfoComparator() {
        }

        public int compare(Object object, Object object2) {
            FrequencyInfo frequencyInfo = (FrequencyInfo)object;
            FrequencyInfo frequencyInfo2 = (FrequencyInfo)object2;
            if (frequencyInfo.numberOfHits < frequencyInfo2.numberOfHits) {
                return -1;
            }
            if (frequencyInfo.numberOfHits > frequencyInfo2.numberOfHits) {
                return 1;
            }
            if (frequencyInfo.annotation.compareTo(frequencyInfo2.annotation) < 0) {
                return -1;
            }
            return 1;
        }
    }
}

