/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import mpi.annex.search.Constants;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.SearchAppletMediator;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchMediator;
import mpi.annex.search.SearchStatistics;
import mpi.annex.search.SearchUtil;

public class SearchResultPanel
extends JPanel
implements ActionListener {
    private SearchMediator mediator;
    private String queryId;
    private Timer pollTimer;
    private MouseListener mouseListener;
    private Dimension dimension;
    private JButton cancelButton;
    private JButton nextButton;
    private JButton prevButton;
    private JProgressBar progressBar;
    private JLabel nHitsLabel;
    private JLabel nAnnotationsWithHitLabel;
    private JLabel nAnnotationsSearchedLabel;
    private JPopupMenu concordancePopup;
    private JPopupMenu frequencyPopup;
    private JMenuItem infoBalloonToggleMenuItem;
    private JMenuItem showHitMenuItem;
    private JMenuItem showHitInCorpusTreeMenuItem;
    private JMenuItem concordanceDisplayModeItem;
    private JMenuItem frequencyDisplayModeItem;
    private JMenuItem saveHitsMenuItem;
    private JMenuItem saveFrequencyInfoMenuItem;
    private JMenuItem showSampleHitMenuItem;
    private JMenuItem showFreqSampleHitInCorpusTreeMenuItem;
    private JPanel hitPanel;
    private final int MAX_VISIBLE_HITS_PER_SCREEN = 100;
    private final int HIT_DISPLAY_Y = 80;
    private int HIT_HEIGHT;
    private JLabel[] hitLabels;
    private JLabel[] prefixLabels;
    private JLabel[] postfixLabels;
    private JLabel[] hitLabelsLeftContext;
    private JLabel[] hitLabelsRightContext;
    private JLabel[] headerLabel;
    private JLabel hitNrLabel;
    private HashMap labelToHit;
    private int hitContextSize;
    private int firstVisibleHitIndex;
    private int lastVisibleHitIndex;
    private int nrOfVisibleHits;
    private int nHits;
    private int nHitsPrev;
    private int nAnnotationsWithHit;
    private int nAnnotationsSearched;
    private float progress;
    private File saveFile;
    private boolean saving;
    private File lastSavedFile;
    private Object activeHit;
    private DelayedNewLayout delayedNewLayout;
    private int resultMode;
    private int firstVisibleFrequencyInfoIndex;
    private int lastVisibleFrequencyInfoIndex;
    private int nFrequencyInfoItems;

    public SearchResultPanel(SearchMediator searchMediator, String string) {
        JComponent jComponent;
        Serializable serializable;
        int n;
        this.mediator = searchMediator;
        this.queryId = string;
        searchMediator.addResultPanel(string, this);
        this.setLayout(null);
        this.setBackground(searchMediator.getBackgroundColor());
        this.mouseListener = new MouseHandler();
        JLabel jLabel = new JLabel("#hits");
        jLabel.setFont(Constants.normalFont);
        jLabel.setBounds(25, 10, 200, 20);
        this.add(jLabel);
        this.nHitsLabel = new JLabel(":");
        this.nHitsLabel.setFont(Constants.monoFont);
        this.nHitsLabel.setBounds(200, 10, 200, 20);
        this.add(this.nHitsLabel);
        JLabel jLabel2 = new JLabel("#annotations with a hit");
        jLabel2.setFont(Constants.normalFont);
        jLabel2.setBounds(25, 30, 200, 20);
        this.add(jLabel2);
        this.nAnnotationsWithHitLabel = new JLabel(":");
        this.nAnnotationsWithHitLabel.setFont(Constants.monoFont);
        this.nAnnotationsWithHitLabel.setBounds(200, 30, 200, 20);
        this.add(this.nAnnotationsWithHitLabel);
        JLabel jLabel3 = new JLabel("#annotations investigated");
        jLabel3.setFont(Constants.normalFont);
        jLabel3.setBounds(25, 50, 200, 20);
        this.add(jLabel3);
        this.nAnnotationsSearchedLabel = new JLabel(":");
        this.nAnnotationsSearchedLabel.setFont(Constants.monoFont);
        this.nAnnotationsSearchedLabel.setBounds(200, 50, 200, 20);
        this.add(this.nAnnotationsSearchedLabel);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.progressBar.setBounds(360, 50, 150, 20);
        this.progressBar.setVisible(true);
        this.add(this.progressBar);
        this.cancelButton = new JButton("Cancel");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.cancelButton.setBackground(searchMediator.getBackgroundColor());
        }
        this.cancelButton.setBounds(520, 43, 90, 30);
        this.cancelButton.addActionListener(this);
        this.add(this.cancelButton);
        this.cancelButton.setVisible(false);
        this.hitPanel = new JPanel();
        this.hitPanel.setBackground(searchMediator.getBackgroundColor());
        this.hitPanel.setLayout(null);
        this.hitPanel.addMouseListener(this.mouseListener);
        this.add(this.hitPanel);
        this.prevButton = new JButton("<");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.prevButton.setBackground(searchMediator.getBackgroundColor());
        }
        this.prevButton.setBounds(0, 0, 0, 0);
        this.prevButton.addActionListener(this);
        this.prevButton.setVisible(false);
        this.hitPanel.add(this.prevButton);
        this.nextButton = new JButton(">");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.nextButton.setBackground(searchMediator.getBackgroundColor());
        }
        this.nextButton.setBounds(0, 0, 0, 0);
        this.nextButton.addActionListener(this);
        this.nextButton.setVisible(false);
        this.hitPanel.add(this.nextButton);
        this.labelToHit = new HashMap();
        this.hitLabels = new JLabel[100];
        this.hitLabelsLeftContext = new JLabel[100];
        this.hitLabelsRightContext = new JLabel[100];
        this.prefixLabels = new JLabel[100];
        this.postfixLabels = new JLabel[100];
        for (n = 0; n < 100; ++n) {
            serializable = new JLabel();
            ((JComponent)serializable).setFont(Constants.hitFont);
            ((JComponent)serializable).setVisible(true);
            ((Component)serializable).addMouseListener(this.mouseListener);
            this.hitPanel.add((Component)serializable);
            this.hitLabels[n] = serializable;
            JLabel jLabel4 = new JLabel();
            jLabel4.setFont(Constants.normalFont);
            jLabel4.setVisible(true);
            jLabel4.addMouseListener(this.mouseListener);
            this.hitPanel.add(jLabel4);
            this.prefixLabels[n] = jLabel4;
            jComponent = new JLabel();
            jComponent.setFont(Constants.normalFont);
            jComponent.setVisible(true);
            jComponent.addMouseListener(this.mouseListener);
            this.hitPanel.add(jComponent);
            this.postfixLabels[n] = jComponent;
            JLabel jLabel5 = new JLabel();
            jLabel5.setFont(Constants.italicFont);
            jLabel5.setVisible(true);
            jLabel5.addMouseListener(this.mouseListener);
            this.hitPanel.add(jLabel5);
            this.hitLabelsLeftContext[n] = jLabel5;
            JLabel jLabel6 = new JLabel();
            jLabel6.setFont(Constants.italicFont);
            jLabel6.setVisible(true);
            jLabel6.addMouseListener(this.mouseListener);
            this.hitPanel.add(jLabel6);
            this.hitLabelsRightContext[n] = jLabel6;
        }
        this.headerLabel = new JLabel[20];
        for (n = 0; n < this.headerLabel.length; ++n) {
            this.headerLabel[n] = new JLabel();
            this.headerLabel[n].setFont(Constants.bigBoldFont);
            this.headerLabel[n].setVisible(true);
            this.hitPanel.add(this.headerLabel[n]);
        }
        this.hitNrLabel = new JLabel();
        this.hitNrLabel.setFont(Constants.smallFont);
        this.hitNrLabel.setVisible(true);
        this.hitPanel.add(this.hitNrLabel);
        this.concordancePopup = new JPopupMenu();
        this.frequencyDisplayModeItem = new JMenuItem("  Show Frequency view");
        this.frequencyDisplayModeItem.addActionListener(this);
        this.concordancePopup.add(this.frequencyDisplayModeItem);
        this.concordancePopup.addSeparator();
        this.showHitMenuItem = new JMenuItem("  Show hit in transcription");
        this.showHitMenuItem.addActionListener(this);
        this.concordancePopup.add(this.showHitMenuItem);
        if (searchMediator instanceof SearchAppletMediator) {
            this.showHitInCorpusTreeMenuItem = new JMenuItem("  Show hit resource in corpus tree");
            this.showHitInCorpusTreeMenuItem.addActionListener(this);
            this.concordancePopup.add(this.showHitInCorpusTreeMenuItem);
        }
        this.infoBalloonToggleMenuItem = new JMenuItem("  Show info balloons");
        this.infoBalloonToggleMenuItem.addActionListener(this);
        this.concordancePopup.add(this.infoBalloonToggleMenuItem);
        this.hitContextSize = 3;
        JMenu jMenu = new JMenu("  Context Size");
        jMenu.setBackground(searchMediator.getBackgroundColor());
        serializable = new ButtonGroup();
        for (int i = 0; i <= 8; ++i) {
            jComponent = new JRadioButtonMenuItem(Integer.toString(i));
            if (i == this.hitContextSize) {
                ((AbstractButton)jComponent).setSelected(true);
            }
            ((ButtonGroup)serializable).add((AbstractButton)jComponent);
            jMenu.add((JMenuItem)jComponent);
            ((AbstractButton)jComponent).addActionListener(this);
        }
        this.concordancePopup.add(jMenu);
        this.concordancePopup.addSeparator();
        this.saveHitsMenuItem = new JMenuItem("  Save hits");
        this.saveHitsMenuItem.addActionListener(this);
        this.concordancePopup.add(this.saveHitsMenuItem);
        this.frequencyPopup = new JPopupMenu();
        this.concordanceDisplayModeItem = new JMenuItem("  Show Concordance view");
        this.concordanceDisplayModeItem.addActionListener(this);
        this.frequencyPopup.add(this.concordanceDisplayModeItem);
        this.frequencyPopup.addSeparator();
        this.showSampleHitMenuItem = new JMenuItem("  Show hit in transcription");
        this.showSampleHitMenuItem.addActionListener(this);
        this.frequencyPopup.add(this.showSampleHitMenuItem);
        if (searchMediator instanceof SearchAppletMediator) {
            this.showFreqSampleHitInCorpusTreeMenuItem = new JMenuItem("  Show hit resource in corpus tree");
            this.showFreqSampleHitInCorpusTreeMenuItem.addActionListener(this);
            this.frequencyPopup.add(this.showFreqSampleHitInCorpusTreeMenuItem);
        }
        this.frequencyPopup.addSeparator();
        this.saveFrequencyInfoMenuItem = new JMenuItem("  Save frequency info");
        this.saveFrequencyInfoMenuItem.addActionListener(this);
        this.frequencyPopup.add(this.saveFrequencyInfoMenuItem);
        this.resultMode = 0;
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(1000000);
        ToolTipManager.sharedInstance().setEnabled(false);
        this.addComponentListener(new ComponentHandler());
        this.dimension = new Dimension(690, 300);
        this.setSize(this.dimension);
    }

    public void clear() {
        this.nHits = 0;
        this.nHitsPrev = 0;
        this.firstVisibleHitIndex = 0;
        this.hitNrLabel.setBounds(0, 0, 0, 0);
        this.prevButton.setVisible(false);
        this.nextButton.setVisible(false);
        this.saveHitsMenuItem.setEnabled(false);
        this.resultMode = 0;
        this.updateStatistics();
        this.newLayout();
    }

    public void startUpdating() {
        if (this.pollTimer != null) {
            this.pollTimer.stop();
        }
        this.nHits = 0;
        this.nHitsPrev = 0;
        this.firstVisibleHitIndex = 0;
        this.firstVisibleFrequencyInfoIndex = 0;
        this.hitNrLabel.setBounds(0, 0, 0, 0);
        this.prevButton.setVisible(false);
        this.nextButton.setVisible(false);
        this.saveHitsMenuItem.setEnabled(false);
        this.resultMode = 0;
        this.frequencyDisplayModeItem.setEnabled(false);
        this.updateStatistics();
        this.newLayout();
        this.pollTimer = new Timer(500, this);
        this.pollTimer.start();
        this.cancelButton.setVisible(true);
        this.progressBar.setValue(0);
        this.progressBar.setString("Progress");
    }

    public void stopUpdating() {
        this.pollTimer.stop();
        this.cancelButton.setVisible(false);
        this.frequencyDisplayModeItem.setEnabled(true);
        this.saveFrequencyInfoMenuItem.setEnabled(true);
        this.newLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButtonMenuItem) {
            try {
                this.hitContextSize = Integer.parseInt(actionEvent.getActionCommand());
                this.newLayout();
            }
            catch (Exception exception) {}
        } else if (object == this.concordanceDisplayModeItem) {
            this.resultMode = 0;
            this.newLayout();
        } else if (object == this.frequencyDisplayModeItem) {
            this.resultMode = 1;
            ToolTipManager.sharedInstance().setEnabled(false);
            this.infoBalloonToggleMenuItem.setText("  Show info balloons");
            this.newLayout();
        } else if (object == this.infoBalloonToggleMenuItem) {
            if (this.infoBalloonToggleMenuItem.getText().equals("  Show info balloons")) {
                ToolTipManager.sharedInstance().setEnabled(true);
                this.infoBalloonToggleMenuItem.setText("  Hide info balloons");
            } else {
                ToolTipManager.sharedInstance().setEnabled(false);
                this.infoBalloonToggleMenuItem.setText("  Show info balloons");
            }
        } else if (object == this.showHitInCorpusTreeMenuItem || object == this.showFreqSampleHitInCorpusTreeMenuItem) {
            if (this.activeHit != null) {
                this.mediator.showInCorpusStructure(this.activeHit, this.queryId);
            }
        } else if (object == this.showHitMenuItem || object == this.showSampleHitMenuItem) {
            if (this.activeHit != null) {
                this.mediator.showInViewer(this.activeHit, this.queryId);
            }
        } else if (object == this.cancelButton) {
            if (this.saving) {
                this.saving = false;
                this.stopUpdating();
                JOptionPane.showMessageDialog(null, "Stopped saving hits", "Save Hits", 1);
                return;
            }
            this.mediator.cancelQuery(this.queryId);
            this.stopUpdating();
            if (this.nHits > 0) {
                this.saveHitsMenuItem.setEnabled(true);
            }
            this.updateStatistics();
            this.progressBar.setString("Canceled");
        } else if (object == this.saveHitsMenuItem) {
            if (this.saving) {
                JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", "Save Hits", 1);
                return;
            }
            JFileChooser jFileChooser = new JFileChooser(this.lastSavedFile);
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                this.saveFile = jFileChooser.getSelectedFile();
                if (this.saveFile.exists() && (n = JOptionPane.showConfirmDialog(null, this.saveFile.getName() + " already exists, overwrite?", "Save Hits", 0)) != 0) {
                    return;
                }
                this.cancelButton.setVisible(true);
                this.saving = true;
                this.lastSavedFile = this.saveFile;
                new Thread(new HitSaver()).start();
                this.pollTimer = new Timer(500, this);
                this.pollTimer.start();
            }
        } else if (object == this.saveFrequencyInfoMenuItem) {
            if (this.saving) {
                JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", "Save Hits", 1);
                return;
            }
            JFileChooser jFileChooser = new JFileChooser(this.lastSavedFile);
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                this.saveFile = jFileChooser.getSelectedFile();
                if (this.saveFile.exists() && (n = JOptionPane.showConfirmDialog(null, this.saveFile.getName() + " already exists, overwrite?", "Save Frequency Info", 0)) != 0) {
                    return;
                }
                this.cancelButton.setVisible(true);
                this.saving = true;
                this.lastSavedFile = this.saveFile;
                new Thread(new FrequencyInfoSaver()).start();
                this.pollTimer = new Timer(500, this);
                this.pollTimer.start();
            }
        } else if (object == this.prevButton) {
            if (this.saving) {
                return;
            }
            if (this.resultMode == 0) {
                this.firstVisibleHitIndex -= this.nrOfVisibleHits;
            } else if (this.resultMode == 1) {
                this.firstVisibleFrequencyInfoIndex -= this.nrOfVisibleHits;
            }
            this.newLayout();
        } else if (object == this.nextButton) {
            if (this.saving) {
                return;
            }
            if (this.resultMode == 0) {
                this.firstVisibleHitIndex += this.nrOfVisibleHits;
            } else if (this.resultMode == 1) {
                this.firstVisibleFrequencyInfoIndex += this.nrOfVisibleHits;
            }
            this.newLayout();
        } else if (object == this.pollTimer) {
            if (this.saving) {
                int n = (int)(this.progress * (float)this.progressBar.getMaximum());
                this.progressBar.setValue(n);
                return;
            }
            this.updateStatistics();
            if (this.progress >= 1.0f) {
                this.stopUpdating();
                this.progressBar.setString("Ready");
                if (this.nHits > 0) {
                    this.saveHitsMenuItem.setEnabled(true);
                }
            }
            if (this.nHits > this.lastVisibleHitIndex) {
                this.nextButton.setVisible(true);
            }
            if (this.nHits > this.nHitsPrev) {
                if (this.lastVisibleHitIndex > this.nHitsPrev) {
                    this.newLayout();
                }
                this.nHitsPrev = this.nHits;
            }
        }
    }

    private void updateStatistics() {
        SearchStatistics searchStatistics = this.mediator.getSearchStatistics(this.queryId);
        this.progress = searchStatistics.progress;
        this.nHits = searchStatistics.nHits;
        this.nAnnotationsWithHit = searchStatistics.nAnnotationsWithHit;
        this.nAnnotationsSearched = searchStatistics.nAnnotationsSearched;
        this.nFrequencyInfoItems = searchStatistics.nFrequencyInfoItems;
        int n = searchStatistics.nAnnotationsSearched > this.nHits ? searchStatistics.nAnnotationsSearched : this.nHits;
        int n2 = (int)(0.1 + Math.log(n) / Math.log(10.0)) + 2;
        if (n2 < 2) {
            n2 = 2;
        }
        String string = ": %" + n2 + "d";
        this.nHitsLabel.setText(": " + this.formatInt(this.nHits, n2));
        this.nAnnotationsWithHitLabel.setText(": " + this.formatInt(searchStatistics.nAnnotationsWithHit, n2));
        this.nAnnotationsSearchedLabel.setText(": " + this.formatInt(searchStatistics.nAnnotationsSearched, n2));
        int n3 = (int)(this.progress * (float)this.progressBar.getMaximum());
        this.progressBar.setValue(n3);
        if (this.progress == 0.0f) {
            this.progressBar.setString("");
        } else if (this.progress == 1.0f) {
            this.progressBar.setString("READY");
        }
        this.newLayout();
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }

    private String formatInt(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = n2 - string.length();
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                string = " " + string;
            }
        }
        return string;
    }

    private void newLayout() {
        if (this.resultMode == 0) {
            this.newConcordanceLayout();
        } else if (this.resultMode == 1) {
            this.newFrequencyLayout();
        }
        this.validate();
    }

    private void newFrequencyLayout() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        int n;
        this.hitPanel.setBounds(10, 80, this.getWidth() - 20, this.getHeight() - 80);
        int n2 = this.hitPanel.getWidth() / 2;
        this.prevButton.setBounds(n2 - 55, 0, 50, 23);
        this.nextButton.setBounds(n2 + 5, 0, 50, 23);
        int n3 = 60;
        this.HIT_HEIGHT = this.getStringHeight("knoep", Constants.hitFont) + 5;
        this.labelToHit.clear();
        SearchStatistics searchStatistics = this.mediator.getSearchStatistics(this.queryId);
        this.hitNrLabel.setText("");
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - n3) / this.HIT_HEIGHT - 1;
        this.lastVisibleFrequencyInfoIndex = this.firstVisibleFrequencyInfoIndex + this.nrOfVisibleHits;
        if (this.firstVisibleFrequencyInfoIndex <= 0) {
            this.firstVisibleFrequencyInfoIndex = 0;
            this.prevButton.setVisible(false);
            this.prevButton.setEnabled(false);
        } else {
            this.prevButton.setVisible(true);
            this.prevButton.setEnabled(true);
        }
        if (this.nFrequencyInfoItems <= this.lastVisibleFrequencyInfoIndex) {
            this.nextButton.setVisible(false);
        } else {
            this.nextButton.setVisible(true);
        }
        ArrayList arrayList = this.mediator.getFrequencyInfo(this.firstVisibleFrequencyInfoIndex, this.lastVisibleFrequencyInfoIndex, this.queryId);
        FrequencyInfo frequencyInfo = null;
        if (arrayList.size() > 0) {
            frequencyInfo = (FrequencyInfo)arrayList.get(0);
        }
        if (frequencyInfo != null && frequencyInfo.numberOfHits < 0) {
            for (int i = 0; i < this.nrOfVisibleHits + 1 + 1; ++i) {
                JLabel jLabel6 = this.hitLabels[i];
                JLabel jLabel7 = this.prefixLabels[i];
                JLabel jLabel8 = this.postfixLabels[i];
                JLabel jLabel9 = this.hitLabelsLeftContext[i];
                JLabel jLabel10 = this.hitLabelsRightContext[i];
                jLabel6.setText("");
                jLabel6.setBounds(0, 0, 0, 0);
                jLabel7.setText("");
                jLabel7.setBounds(0, 0, 0, 0);
                jLabel8.setText("");
                jLabel8.setBounds(0, 0, 0, 0);
                jLabel9.setText("");
                jLabel9.setBounds(0, 0, 0, 0);
                jLabel10.setText("");
                jLabel10.setBounds(0, 0, 0, 0);
            }
            this.headerLabel[0].setText("");
            this.headerLabel[1].setText("");
            this.headerLabel[2].setText("");
            this.saveFrequencyInfoMenuItem.setEnabled(false);
            this.hitLabels[0].setText(frequencyInfo.annotation);
            this.hitLabels[0].setBounds(50, 100, 1000, this.HIT_HEIGHT);
            this.nextButton.setVisible(false);
            return;
        }
        this.headerLabel[0].setText("Annotation");
        int n4 = this.getStringWidth(this.headerLabel[0].getText(), this.headerLabel[0].getFont());
        this.headerLabel[0].setBounds(n2 / 2 - n4 / 2, 55, n4 + 20, this.HIT_HEIGHT);
        this.headerLabel[1].setText("Percentage");
        int n5 = this.getStringWidth(this.headerLabel[1].getText(), this.headerLabel[1].getFont());
        this.headerLabel[1].setBounds(n2 - n5 / 2, 55, n5 + 20, this.HIT_HEIGHT);
        this.headerLabel[2].setText("Count");
        int n6 = this.getStringWidth(this.headerLabel[2].getText(), this.headerLabel[2].getFont());
        this.headerLabel[2].setBounds(n2 * 3 / 2 + 10 - n6, 55, n6 + 20, this.HIT_HEIGHT);
        for (n = 0; n < this.nrOfVisibleHits; ++n) {
            jLabel5 = this.hitLabels[n];
            jLabel4 = this.prefixLabels[n];
            jLabel3 = this.postfixLabels[n];
            jLabel2 = this.hitLabelsLeftContext[n];
            jLabel = this.hitLabelsRightContext[n];
            if (n < arrayList.size()) {
                int n7;
                String string;
                int n8;
                Object object;
                int n9;
                int n10;
                String string2;
                this.hitNrLabel.setText("frequency " + (this.firstVisibleFrequencyInfoIndex + 1) + " - " + (this.firstVisibleFrequencyInfoIndex + n + 1) + " of " + frequencyInfo.nOccurences);
                int n11 = this.getStringWidth(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
                int n12 = this.getStringHeight(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
                this.hitNrLabel.setBounds(n2 - n11 / 2, 30, n11, n12);
                frequencyInfo = (FrequencyInfo)arrayList.get(n);
                this.labelToHit.put(jLabel5, frequencyInfo);
                this.labelToHit.put(jLabel4, frequencyInfo);
                this.labelToHit.put(jLabel3, frequencyInfo);
                this.labelToHit.put(jLabel2, frequencyInfo);
                this.labelToHit.put(jLabel, frequencyInfo);
                if (frequencyInfo.hitLength == 0) {
                    jLabel5.setBounds(0, 0, 0, 0);
                    string2 = frequencyInfo.annotation;
                    jLabel4.setText(string2);
                    n10 = this.getStringWidth(jLabel4.getText(), jLabel4.getFont());
                    n9 = n2 / 2 - n10 / 2;
                    jLabel4.setBounds(n9, n3 + (n + 1) * this.HIT_HEIGHT, n2 - n9 - 30, this.HIT_HEIGHT);
                    jLabel3.setBounds(0, 0, 0, 0);
                } else {
                    string2 = frequencyInfo.annotation.substring(frequencyInfo.hitPositionInAnnotation, frequencyInfo.hitPositionInAnnotation + frequencyInfo.hitLength);
                    jLabel5.setText(string2);
                    n10 = this.getStringWidth(jLabel5.getText(), jLabel5.getFont());
                    n9 = n2 / 2 - n10 / 2;
                    jLabel5.setBounds(n9, n3 + (n + 1) * this.HIT_HEIGHT, n2 - n9 - 30, this.HIT_HEIGHT);
                    object = frequencyInfo.annotation.substring(0, frequencyInfo.hitPositionInAnnotation);
                    jLabel4.setText((String)object);
                    int n13 = this.getStringWidth(jLabel4.getText(), jLabel4.getFont());
                    n8 = n9 - n13;
                    jLabel4.setBounds(n8, n3 + (n + 1) * this.HIT_HEIGHT, n13, this.HIT_HEIGHT);
                    string = frequencyInfo.annotation.substring(frequencyInfo.hitPositionInAnnotation + frequencyInfo.hitLength);
                    jLabel3.setText(string);
                    n7 = this.getStringWidth(jLabel3.getText(), jLabel3.getFont());
                    int n14 = n9 + n10;
                    jLabel3.setBounds(n14, n3 + (n + 1) * this.HIT_HEIGHT, n2 - n14 - 30, this.HIT_HEIGHT);
                }
                double d = 100.0 * (double)frequencyInfo.numberOfHits / (double)searchStatistics.nAnnotationsWithHit;
                String string3 = "##0.00";
                object = new DecimalFormat(string3);
                String string4 = ((NumberFormat)object).format(d) + "%";
                n8 = this.getStringWidth(string4, jLabel2.getFont());
                jLabel2.setText(string4);
                jLabel2.setBounds(n2 + 20 - n8, n3 + (n + 1) * this.HIT_HEIGHT, n8, this.HIT_HEIGHT);
                string = Integer.toString(frequencyInfo.numberOfHits);
                n7 = this.getStringWidth(string, jLabel.getFont());
                jLabel.setText(string);
                jLabel.setBounds(n2 * 3 / 2 - n7, n3 + (n + 1) * this.HIT_HEIGHT, n7, this.HIT_HEIGHT);
                continue;
            }
            jLabel5.setText("");
            jLabel5.setBounds(0, 0, 0, 0);
            jLabel4.setText("");
            jLabel4.setBounds(0, 0, 0, 0);
            jLabel3.setText("");
            jLabel3.setBounds(0, 0, 0, 0);
            jLabel2.setText("");
            jLabel2.setBounds(0, 0, 0, 0);
            jLabel.setText("");
            jLabel.setBounds(0, 0, 0, 0);
        }
        for (n = this.nrOfVisibleHits; n < this.nrOfVisibleHits + 1 + 1; ++n) {
            if (n < 0) continue;
            jLabel5 = this.hitLabels[n];
            jLabel4 = this.prefixLabels[n];
            jLabel3 = this.postfixLabels[n];
            jLabel2 = this.hitLabelsLeftContext[n];
            jLabel = this.hitLabelsRightContext[n];
            jLabel5.setText("");
            jLabel5.setBounds(0, 0, 0, 0);
            jLabel4.setText("");
            jLabel4.setBounds(0, 0, 0, 0);
            jLabel3.setText("");
            jLabel3.setBounds(0, 0, 0, 0);
            jLabel2.setText("");
            jLabel2.setBounds(0, 0, 0, 0);
            jLabel.setText("");
            jLabel.setBounds(0, 0, 0, 0);
        }
    }

    private void newConcordanceLayout() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        int n;
        this.hitPanel.setBounds(10, 80, this.getWidth() - 20, this.getHeight() - 80);
        int n2 = this.hitPanel.getWidth() / 2;
        this.prevButton.setBounds(n2 - 55, 0, 50, 23);
        this.nextButton.setBounds(n2 + 5, 0, 50, 23);
        int n3 = 30;
        if (this.infoBalloonToggleMenuItem.getText().equals("  Show info balloons")) {
            ToolTipManager.sharedInstance().setEnabled(false);
        } else {
            ToolTipManager.sharedInstance().setEnabled(true);
        }
        for (int i = 0; i < this.headerLabel.length; ++i) {
            this.headerLabel[i].setBounds(0, 0, 0, 0);
        }
        this.HIT_HEIGHT = this.getStringHeight("knoep", Constants.hitFont) + 5;
        this.labelToHit.clear();
        this.hitNrLabel.setText("");
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - n3) / this.HIT_HEIGHT - 1;
        this.lastVisibleHitIndex = this.firstVisibleHitIndex + this.nrOfVisibleHits;
        if (this.firstVisibleHitIndex <= 0) {
            this.firstVisibleHitIndex = 0;
            this.prevButton.setVisible(false);
            this.prevButton.setEnabled(false);
        } else {
            this.prevButton.setVisible(true);
            this.prevButton.setEnabled(true);
        }
        if (this.nHits <= this.lastVisibleHitIndex) {
            this.nextButton.setVisible(false);
        } else {
            this.nextButton.setVisible(true);
        }
        List list = this.mediator.getHits(this.firstVisibleHitIndex, this.lastVisibleHitIndex, 8, this.queryId);
        for (n = 0; n < this.nrOfVisibleHits; ++n) {
            jLabel5 = this.hitLabels[n];
            jLabel4 = this.prefixLabels[n];
            jLabel3 = this.postfixLabels[n];
            jLabel2 = this.hitLabelsLeftContext[n];
            jLabel = this.hitLabelsRightContext[n];
            if (n < list.size()) {
                int n4;
                int n5;
                String string;
                int n6;
                Object object;
                int n7;
                String string2;
                String string3;
                this.hitNrLabel.setText("hit " + (this.firstVisibleHitIndex + 1) + " - " + (this.firstVisibleHitIndex + n + 1) + " of " + this.nHits);
                int n8 = this.getStringWidth(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
                int n9 = this.getStringHeight(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
                this.hitNrLabel.setBounds(n2 - n8 / 2, 30, n8, n9);
                SearchHit searchHit = (SearchHit)list.get(n);
                this.labelToHit.put(jLabel5, searchHit);
                this.labelToHit.put(jLabel4, searchHit);
                this.labelToHit.put(jLabel3, searchHit);
                this.labelToHit.put(jLabel2, searchHit);
                this.labelToHit.put(jLabel, searchHit);
                if (searchHit.tierType.equals("oadhohdpiouhdpiuhA;SUSey;O")) {
                    string3 = "";
                    string2 = "";
                    String[] stringArray = searchHit.annotation.trim().split("qwynbbvs");
                    for (int i = 1; i < stringArray.length; ++i) {
                        String[] stringArray2 = stringArray[i].trim().split("jqzxw");
                        string3 = string3 + " #" + stringArray2[0] + " ";
                        for (n7 = 1; n7 < stringArray2.length; ++n7) {
                            String string4 = stringArray2[n7];
                            if (string4.charAt(1) != '|') {
                                object = string4.split("oskjdjrj");
                                String string5 = object[0].substring(1, object[0].length() - 1);
                                if (string5.length() > 15) {
                                    string5 = string5.substring(0, 15) + "...";
                                }
                                n6 = Integer.parseInt(object[1]) + 1;
                                String string6 = n6 + "";
                                while (string6.length() < 4) {
                                    string6 = "0" + string6;
                                }
                                long l = Long.parseLong(object[2]);
                                long l2 = Long.parseLong(object[3]);
                                String string7 = SearchUtil.HHMMSSmmmFormat(l);
                                string = SearchUtil.HHMMSSmmmFormat(l2);
                                String string8 = SearchUtil.HHMMSSmmmFormat(l2 - l);
                                string3 = string3 + object[0] + " ";
                                string2 = string2 + "<tr><td>" + string5 + "</td><td>" + "&nbsp;&nbsp;Position: " + string6 + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Time: " + string7 + "&nbsp;-&nbsp;" + string + "&nbsp;&nbsp;&nbsp;duration: " + string8 + "</td></tr>";
                                continue;
                            }
                            string3 = string3 + "|| ";
                        }
                    }
                    jLabel5.setFont(Constants.normalFont);
                    jLabel5.setText(string3);
                    String string9 = "<html><table border=\"0\"><tr><td> Transcription: </td><td>&nbsp;&nbsp;" + searchHit.transcriptionName + "</td></tr>" + string2 + "</table></html>";
                    jLabel5.setToolTipText(string9);
                    int n10 = this.getStringWidth(jLabel5.getText(), jLabel5.getFont());
                    n7 = n2 - n10 / 2;
                    jLabel5.setBounds(n7, n3 + (n + 1) * this.HIT_HEIGHT, n10, this.HIT_HEIGHT);
                    jLabel4.setText("");
                    jLabel4.setBounds(0, 0, 0, 0);
                    jLabel3.setText("");
                    jLabel3.setBounds(0, 0, 0, 0);
                    jLabel2.setText("");
                    jLabel2.setBounds(0, 0, 0, 0);
                    jLabel.setText("");
                    jLabel.setBounds(0, 0, 0, 0);
                    continue;
                }
                string3 = searchHit.annotation.substring(searchHit.hitPositionInAnnotation, searchHit.hitPositionInAnnotation + searchHit.hitLength);
                jLabel5.setFont(Constants.hitFont);
                jLabel5.setText(string3);
                string2 = "<html><table border=\"0\"><tr><td> Transcription: </td><td>" + searchHit.transcriptionName + "</td></tr>" + "<tr><td> Tier name: </td><td>" + searchHit.tierName + "</td></tr>" + "<tr><td> Tier type: </td><td>" + searchHit.tierType + "</td></tr>" + "<tr><td> Participant: </td><td>" + searchHit.participant + "</td></tr>" + "<tr><td> Position in tier: </td><td>" + searchHit.positionInTier + "</td></tr>";
                string2 = searchHit.aligned ? string2 + "<tr><td> begin time: </td><td>" + SearchUtil.HHMMSSmmmFormat(searchHit.beginTime) + "</td></tr>" + "<tr><td> end time: </td><td>" + SearchUtil.HHMMSSmmmFormat(searchHit.endTime) + "</td></tr>" + "<tr><td> duration: </td><td>" + SearchUtil.HHMMSSmmmFormat(searchHit.endTime - searchHit.beginTime) + "</td></tr>" : string2 + "<tr><td> alignment: </td><td> not aligned </td></tr>";
                string2 = string2 + "</table></html>";
                jLabel5.setToolTipText(string2);
                int n11 = this.getStringWidth(jLabel5.getText(), jLabel5.getFont());
                int n12 = n2 - n11 / 2;
                jLabel5.setBounds(n12, n3 + (n + 1) * this.HIT_HEIGHT, n11, this.HIT_HEIGHT);
                String string10 = searchHit.annotation.substring(0, searchHit.hitPositionInAnnotation);
                jLabel4.setText(string10);
                n7 = this.getStringWidth(jLabel4.getText(), jLabel4.getFont());
                int n13 = n12 - n7;
                jLabel4.setBounds(n13, n3 + (n + 1) * this.HIT_HEIGHT, n7, this.HIT_HEIGHT);
                jLabel4.setToolTipText(string2);
                object = searchHit.annotation.substring(searchHit.hitPositionInAnnotation + searchHit.hitLength);
                jLabel3.setText((String)object);
                int n14 = this.getStringWidth(jLabel3.getText(), jLabel3.getFont());
                n6 = n12 + n11;
                jLabel3.setBounds(n6, n3 + (n + 1) * this.HIT_HEIGHT, n14, this.HIT_HEIGHT);
                jLabel3.setToolTipText(string2);
                int n15 = n7 + n11 + n14;
                int n16 = n13;
                String string11 = "";
                int n17 = this.hitContextSize <= searchHit.leftContext.size() ? this.hitContextSize : searchHit.leftContext.size();
                for (n5 = 0; n5 < n17; ++n5) {
                    string11 = (String)searchHit.leftContext.get(n5) + "  " + string11;
                }
                jLabel2.setText(string11);
                n5 = this.getStringWidth(jLabel2.getText(), jLabel2.getFont());
                int n18 = n16 - n5;
                jLabel2.setBounds(n18, n3 + (n + 1) * this.HIT_HEIGHT, n5, this.HIT_HEIGHT);
                string = "";
                int n19 = this.hitContextSize <= searchHit.rightContext.size() ? this.hitContextSize : searchHit.rightContext.size();
                for (n4 = 0; n4 < n19; ++n4) {
                    string = string + "  " + (String)searchHit.rightContext.get(n4);
                }
                jLabel.setText(string);
                n4 = this.getStringWidth(jLabel.getText(), jLabel.getFont());
                jLabel.setBounds(n16 + n15, n3 + (n + 1) * this.HIT_HEIGHT, n4, this.HIT_HEIGHT);
                continue;
            }
            jLabel5.setText("");
            jLabel5.setBounds(0, 0, 0, 0);
            jLabel4.setText("");
            jLabel4.setBounds(0, 0, 0, 0);
            jLabel3.setText("");
            jLabel3.setBounds(0, 0, 0, 0);
            jLabel2.setText("");
            jLabel2.setBounds(0, 0, 0, 0);
            jLabel.setText("");
            jLabel.setBounds(0, 0, 0, 0);
        }
        for (n = this.nrOfVisibleHits; n < this.nrOfVisibleHits + 1 + 1; ++n) {
            if (n < 0) continue;
            jLabel5 = this.hitLabels[n];
            jLabel4 = this.prefixLabels[n];
            jLabel3 = this.postfixLabels[n];
            jLabel2 = this.hitLabelsLeftContext[n];
            jLabel = this.hitLabelsRightContext[n];
            jLabel5.setText("");
            jLabel5.setBounds(0, 0, 0, 0);
            jLabel4.setText("");
            jLabel4.setBounds(0, 0, 0, 0);
            jLabel3.setText("");
            jLabel3.setBounds(0, 0, 0, 0);
            jLabel2.setText("");
            jLabel2.setBounds(0, 0, 0, 0);
            jLabel.setText("");
            jLabel.setBounds(0, 0, 0, 0);
        }
    }

    private int getStringWidth(String string, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        return (int)rectangle2D.getWidth();
    }

    private int getStringHeight(String string, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        return (int)rectangle2D.getHeight();
    }

    private class FrequencyInfoSaver
    implements Runnable {
        private FrequencyInfoSaver() {
        }

        public void run() {
            try {
                int n;
                SearchStatistics searchStatistics = SearchResultPanel.this.mediator.getSearchStatistics(SearchResultPanel.this.queryId);
                FileOutputStream fileOutputStream = new FileOutputStream(SearchResultPanel.this.saveFile);
                fileOutputStream.write(239);
                fileOutputStream.write(187);
                fileOutputStream.write(191);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                int n2 = 100;
                int n3 = SearchResultPanel.this.nFrequencyInfoItems;
                SearchResultPanel.this.progressBar.setString("Saving");
                String string = "\t";
                String string2 = "";
                for (n = 0; n < 1; ++n) {
                    string2 = string2 + string + " ";
                }
                bufferedWriter.write("\"Annotation\"" + string + "\"Percentage\"" + string + "\"Count\"");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                for (n = 0; n < SearchResultPanel.this.nFrequencyInfoItems && SearchResultPanel.this.saving; n += n2) {
                    SearchResultPanel.this.progress = (float)n / (float)n3;
                    ArrayList arrayList = SearchResultPanel.this.mediator.getFrequencyInfo(n, n + n2 - 1, SearchResultPanel.this.queryId);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        FrequencyInfo frequencyInfo = (FrequencyInfo)arrayList.get(i);
                        double d = 100.0 * (double)frequencyInfo.numberOfHits / (double)searchStatistics.nAnnotationsWithHit;
                        String string3 = "##0.00";
                        DecimalFormat decimalFormat = new DecimalFormat(string3);
                        String string4 = decimalFormat.format(d);
                        bufferedWriter.write("\"" + frequencyInfo.annotation.replaceAll("\"", "\"\"") + "\"" + string);
                        bufferedWriter.write(string4 + string);
                        bufferedWriter.write(frequencyInfo.numberOfHits + "");
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.flush();
                }
                bufferedWriter.close();
                SearchResultPanel.this.pollTimer.stop();
                SearchResultPanel.this.progressBar.setValue(0);
                SearchResultPanel.this.progressBar.setString("");
                SearchResultPanel.this.cancelButton.setVisible(false);
                if (SearchResultPanel.this.saving) {
                    JOptionPane.showMessageDialog(null, "Ready saving frequency info", "Save Frequency Info", 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(null, iOException.toString(), "Save Frequency Info", 0);
            }
            SearchResultPanel.this.saving = false;
        }
    }

    private class HitSaver
    implements Runnable {
        private HitSaver() {
        }

        public void run() {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(SearchResultPanel.this.saveFile);
                fileOutputStream.write(239);
                fileOutputStream.write(187);
                fileOutputStream.write(191);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                int n = 10;
                int n2 = SearchResultPanel.this.nHits < 10000 ? SearchResultPanel.this.nHits : 10000;
                SearchResultPanel.this.progressBar.setString("Saving");
                String string = "\t";
                ArrayList arrayList = SearchResultPanel.this.mediator.getHitsFromDatabase(0, 1, SearchResultPanel.this.hitContextSize, SearchResultPanel.this.queryId);
                SearchHit searchHit = (SearchHit)arrayList.get(0);
                if (searchHit.tierType.equals("oadhohdpiouhdpiuhA;SUSey;O")) {
                    int n3;
                    int n4;
                    String string2 = "";
                    String[] stringArray = searchHit.annotation.trim().split("qwynbbvs");
                    String[] stringArray2 = null;
                    for (n4 = 1; n4 < stringArray.length; ++n4) {
                        stringArray2 = stringArray[n4].trim().split("jqzxw");
                        for (n3 = 1; n3 < stringArray2.length; ++n3) {
                            String string3 = stringArray2[n3];
                            if (string3.charAt(1) == '|') continue;
                            string2 = string2 + "\"Annotation" + n4 + "-" + n3 + "\"" + string + "\"Position\"" + string + "\"Begin Time\"" + string + "\"End Time\"" + string;
                        }
                    }
                    string2 = string2 + "\"TranscriptionName\"";
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    for (n4 = 0; n4 < SearchResultPanel.this.nHits && SearchResultPanel.this.saving; n4 += n) {
                        SearchResultPanel.this.progress = (float)n4 / (float)n2;
                        arrayList = SearchResultPanel.this.mediator.getHitsFromDatabase(n4, n4 + n, SearchResultPanel.this.hitContextSize, SearchResultPanel.this.queryId);
                        for (n3 = 0; n3 < arrayList.size(); ++n3) {
                            searchHit = (SearchHit)arrayList.get(n3);
                            stringArray = searchHit.annotation.trim().split("qwynbbvs");
                            for (int i = 1; i < stringArray.length; ++i) {
                                stringArray2 = stringArray[i].trim().split("jqzxw");
                                for (int j = 1; j < stringArray2.length; ++j) {
                                    String string4 = stringArray2[j];
                                    if (string4.charAt(1) == '|') continue;
                                    String[] stringArray3 = string4.split("oskjdjrj");
                                    String string5 = stringArray3[0].substring(1, stringArray3[0].length() - 1);
                                    int n5 = Integer.parseInt(stringArray3[1]);
                                    long l = Long.parseLong(stringArray3[2]);
                                    long l2 = Long.parseLong(stringArray3[3]);
                                    bufferedWriter.write(string5 + string);
                                    bufferedWriter.write(n5 + string);
                                    bufferedWriter.write(l + string);
                                    bufferedWriter.write(l2 + string);
                                }
                            }
                            bufferedWriter.write(searchHit.transcriptionName);
                            bufferedWriter.newLine();
                        }
                    }
                } else {
                    bufferedWriter.write("\"Annotation\"" + string + "\"HitPositionInAnnotation\"" + string + "\"HitLength\"" + string + "\"HitNumberInAnnotation\"" + string + "\"AnnotationBeginTime\"" + string + "\"AnnotationEndTime\"" + string + "\"HitPositionInTier\"" + string + "\"TierName\"" + string + "\"TierType\"" + string + "\"LeftContext\"" + string + "\"RightContext\"" + string + "\"TranscriptionName\"");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    for (int i = 0; i < SearchResultPanel.this.nHits && SearchResultPanel.this.saving; i += n) {
                        SearchResultPanel.this.progress = (float)i / (float)n2;
                        arrayList = SearchResultPanel.this.mediator.getHitsFromDatabase(i, i + n, SearchResultPanel.this.hitContextSize, SearchResultPanel.this.queryId);
                        for (int j = 0; j < arrayList.size(); ++j) {
                            int n6;
                            String string6;
                            searchHit = (SearchHit)arrayList.get(j);
                            bufferedWriter.write("\"" + searchHit.annotation.replaceAll("\"", "\"\"") + "\"" + string);
                            bufferedWriter.write(searchHit.hitPositionInAnnotation + 1 + string);
                            bufferedWriter.write(searchHit.hitLength + string);
                            bufferedWriter.write(searchHit.hitNumberInAnnotation + string);
                            bufferedWriter.write(searchHit.beginTime + string);
                            bufferedWriter.write(searchHit.endTime + string);
                            bufferedWriter.write(searchHit.positionInTier + string);
                            bufferedWriter.write("\"" + searchHit.tierName.replaceAll("\"", "\"\"") + "\"" + string);
                            bufferedWriter.write("\"" + searchHit.tierType.replaceAll("\"", "\"\"") + "\"" + string);
                            if (searchHit.leftContext.size() > 0) {
                                string6 = (String)searchHit.leftContext.get(0);
                                for (n6 = 1; n6 < searchHit.leftContext.size(); ++n6) {
                                    string6 = (String)searchHit.leftContext.get(n6) + "  " + string6;
                                }
                                bufferedWriter.write("\"" + string6.replaceAll("\"", "\"\"") + "\"" + string);
                            } else {
                                bufferedWriter.write("\"\"" + string);
                            }
                            if (searchHit.rightContext.size() > 0) {
                                string6 = (String)searchHit.rightContext.get(0);
                                for (n6 = 1; n6 < searchHit.rightContext.size(); ++n6) {
                                    string6 = string6 + "  " + (String)searchHit.rightContext.get(n6);
                                }
                                bufferedWriter.write("\"" + string6.replaceAll("\"", "\"\"") + "\"" + string);
                            } else {
                                bufferedWriter.write("\"\"" + string);
                            }
                            bufferedWriter.write(searchHit.transcriptionName);
                            bufferedWriter.newLine();
                        }
                    }
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                SearchResultPanel.this.pollTimer.stop();
                SearchResultPanel.this.progressBar.setValue(0);
                SearchResultPanel.this.progressBar.setString("");
                SearchResultPanel.this.cancelButton.setVisible(false);
                if (SearchResultPanel.this.saving) {
                    JOptionPane.showMessageDialog(null, "Ready saving hits", "Save Hits", 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(null, iOException.toString(), "Save Hits", 0);
            }
            SearchResultPanel.this.saving = false;
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (SearchResultPanel.this.resultMode == 0) {
                    SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(mouseEvent.getSource());
                    if (SearchResultPanel.this.activeHit != null) {
                        SearchResultPanel.this.showHitMenuItem.setEnabled(true);
                        if (SearchResultPanel.this.showHitInCorpusTreeMenuItem != null) {
                            SearchResultPanel.this.showHitInCorpusTreeMenuItem.setEnabled(true);
                        }
                    } else {
                        SearchResultPanel.this.showHitMenuItem.setEnabled(false);
                        if (SearchResultPanel.this.showHitInCorpusTreeMenuItem != null) {
                            SearchResultPanel.this.showHitInCorpusTreeMenuItem.setEnabled(false);
                        }
                    }
                    SearchResultPanel.this.concordancePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (SearchResultPanel.this.resultMode == 1) {
                    SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(mouseEvent.getSource());
                    SearchResultPanel.this.frequencyPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(mouseEvent.getSource());
                if (SearchResultPanel.this.activeHit != null) {
                    SearchResultPanel.this.mediator.showInViewer(SearchResultPanel.this.activeHit, SearchResultPanel.this.queryId);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (SearchResultPanel.this.infoBalloonToggleMenuItem.getText().equals("  Show info balloons")) {
                ToolTipManager.sharedInstance().setEnabled(false);
            } else {
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        }
    }

    private class DelayedNewLayout
    extends Thread {
        private DelayedNewLayout() {
        }

        public void run() {
            try {
                DelayedNewLayout.sleep(200L);
                SearchResultPanel.this.newLayout();
                SearchResultPanel.this.validate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            SearchResultPanel.this.dimension = new Dimension(SearchResultPanel.this.getWidth(), SearchResultPanel.this.getHeight());
            if (SearchResultPanel.this.delayedNewLayout != null) {
                SearchResultPanel.this.delayedNewLayout.interrupt();
            }
            SearchResultPanel.this.delayedNewLayout = new DelayedNewLayout();
            SearchResultPanel.this.delayedNewLayout.start();
        }
    }
}

