/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.PostgresQuery;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchStatistics;
import mpi.annex.util.AnnexUtil;
import mpi.corpusstructure.CorpusStructureDB;
import org.apache.log4j.Logger;

public class SearchServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger((String)"ANNEX.SearchServlet");
    private static int queryIdCounter;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletRequest.setCharacterEncoding("UTF-8");
        httpServletResponse.setCharacterEncoding("UTF-8");
        HttpSession httpSession = httpServletRequest.getSession();
        BufferedReader bufferedReader = httpServletRequest.getReader();
        String string = bufferedReader.readLine();
        String string2 = bufferedReader.readLine();
        String string3 = bufferedReader.readLine();
        if (!string3.equals("getStatisticsCMD")) {
            // empty if block
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (string3.equals("initCMD")) {
            this.initSearch(httpServletRequest, httpServletResponse, string);
        } else if (string3.equals("putPersistentCMD")) {
            String string4 = bufferedReader.readLine();
            String string5 = bufferedReader.readLine();
            String string6 = (String)httpSession.getAttribute("userid");
            logger.debug((Object)("key: " + string4));
            logger.debug((Object)("value part: " + string5.substring(0, 40)));
            logger.debug((Object)("value size: " + string5.length()));
        } else if (string3.equals("getPersistentMD")) {
            String string7 = bufferedReader.readLine();
            String string8 = (String)httpSession.getAttribute("userid");
            printWriter.println("zywNULL STRINGqqx");
        } else if (string3.equals("deletePersistentCMD")) {
            String string9 = bufferedReader.readLine();
            String string10 = (String)httpSession.getAttribute("userid");
        } else if (string3.equals("createQueryCMD")) {
            string2 = Integer.toString(queryIdCounter++);
            try {
                PostgresQuery postgresQuery = AnnexUtil.getSearchClient().createQuery();
                this.setSessionAttribute(httpSession, string2, string, postgresQuery);
            }
            catch (Exception exception) {
                logger.error((Object)"error while creating query object", (Throwable)exception);
            }
            printWriter.println(string2);
        } else if (string3.equals("getHitsCMD")) {
            int n = Integer.parseInt(bufferedReader.readLine());
            int n2 = Integer.parseInt(bufferedReader.readLine());
            int n3 = Integer.parseInt(bufferedReader.readLine());
            PostgresQuery postgresQuery = (PostgresQuery)this.getSessionAttribute(httpServletRequest.getSession(), string2, string);
            ArrayList arrayList = postgresQuery.getHits(n, n2, n3);
            printWriter.println(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                this.sendHit((SearchHit)arrayList.get(i), printWriter);
            }
        } else if (string3.equals("getFreqInfo")) {
            int n = Integer.parseInt(bufferedReader.readLine());
            int n4 = Integer.parseInt(bufferedReader.readLine());
            PostgresQuery postgresQuery = (PostgresQuery)this.getSessionAttribute(httpServletRequest.getSession(), string2, string);
            ArrayList arrayList = postgresQuery.getFrequencyInfo(n, n4);
            printWriter.println(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                this.sendFrequencyInfo((FrequencyInfo)arrayList.get(i), printWriter);
            }
        } else if (string3.equals("getViewParameters")) {
            int n = Integer.parseInt(bufferedReader.readLine());
            PostgresQuery postgresQuery = (PostgresQuery)this.getSessionAttribute(httpServletRequest.getSession(), string2, string);
            ArrayList arrayList = postgresQuery.getViewerParametersFor(n, 0);
            printWriter.println(4);
            printWriter.println((String)arrayList.get(0));
            printWriter.println((String)arrayList.get(1));
            printWriter.println((Long)arrayList.get(2));
            printWriter.println((Long)arrayList.get(3));
        } else if (string3.equals("getStatisticsCMD")) {
            PostgresQuery postgresQuery = (PostgresQuery)this.getSessionAttribute(httpServletRequest.getSession(), string2, string);
            SearchStatistics searchStatistics = postgresQuery.getSearchStatistics();
            printWriter.println(5);
            printWriter.println(searchStatistics.nHits);
            printWriter.println(searchStatistics.nAnnotationsWithHit);
            printWriter.println(searchStatistics.nAnnotationsSearched);
            printWriter.println(searchStatistics.progress);
            printWriter.println(searchStatistics.nFrequencyInfoItems);
        } else if (string3.equals("doQueryCMD")) {
            PostgresQuery postgresQuery = (PostgresQuery)this.getSessionAttribute(httpServletRequest.getSession(), string2, string);
            String string11 = bufferedReader.readLine();
            ArrayList arrayList = new ArrayList();
            if (string11.toLowerCase().indexOf("eaf") >= 0) {
                arrayList.addAll((ArrayList)this.getSessionAttribute(httpSession, "eafNodes", string));
            }
            if (string11.toLowerCase().indexOf("chat") >= 0) {
                arrayList.addAll((ArrayList)this.getSessionAttribute(httpSession, "chatNodes", string));
            }
            if (string11.toLowerCase().indexOf("shoebox") >= 0) {
                arrayList.addAll((ArrayList)this.getSessionAttribute(httpSession, "shoeboxNodes", string));
            }
            if (string11.toLowerCase().indexOf("plaintext") >= 0) {
                arrayList.addAll((ArrayList)this.getSessionAttribute(httpSession, "plainTextNodes", string));
            }
            if (string11.toLowerCase().indexOf("xmltext") >= 0) {
                arrayList.addAll((ArrayList)this.getSessionAttribute(httpSession, "xmlTextNodes", string));
            }
            if (string11.toLowerCase().indexOf("htmltext") >= 0) {
                arrayList.addAll((ArrayList)this.getSessionAttribute(httpSession, "htmlTextNodes", string));
            }
            String string12 = bufferedReader.readLine();
            postgresQuery.doQuery(arrayList, string12);
            printWriter.println(0);
        } else if (string3.equals("cancelQueryCMD")) {
            PostgresQuery postgresQuery = (PostgresQuery)this.getSessionAttribute(httpServletRequest.getSession(), string2, string);
            postgresQuery.cancelQuery();
            printWriter.println(0);
        }
        printWriter.flush();
        printWriter.close();
        bufferedReader.close();
    }

    private void sendHit(SearchHit searchHit, PrintWriter printWriter) {
        int n;
        printWriter.println(13);
        printWriter.println(searchHit.annotation.replaceAll("\n", "").replaceAll("\r", ""));
        printWriter.println(searchHit.aligned);
        printWriter.println(searchHit.beginTime);
        printWriter.println(searchHit.endTime);
        printWriter.println(searchHit.hitLength);
        printWriter.println(searchHit.hitNumberInAnnotation);
        printWriter.println(searchHit.hitPositionInAnnotation);
        printWriter.println(searchHit.positionInTier);
        printWriter.println(searchHit.tierName);
        printWriter.println(searchHit.tierType);
        printWriter.println(searchHit.participant);
        printWriter.println(searchHit.transcriptionNodeId);
        printWriter.println(searchHit.transcriptionName);
        printWriter.println(searchHit.leftContext.size());
        for (n = 0; n < searchHit.leftContext.size(); ++n) {
            printWriter.println(((String)searchHit.leftContext.get(n)).replaceAll("\n", "").replaceAll("\r", ""));
        }
        printWriter.println(searchHit.rightContext.size());
        for (n = 0; n < searchHit.rightContext.size(); ++n) {
            printWriter.println(((String)searchHit.rightContext.get(n)).replaceAll("\n", "").replaceAll("\r", ""));
        }
    }

    private void sendFrequencyInfo(FrequencyInfo frequencyInfo, PrintWriter printWriter) {
        printWriter.println(7);
        printWriter.println(frequencyInfo.nOccurences);
        printWriter.println(frequencyInfo.annotation.replaceAll("\n", "").replaceAll("\r", ""));
        printWriter.println(frequencyInfo.numberOfHits);
        printWriter.println(frequencyInfo.hitPositionInAnnotation);
        printWriter.println(frequencyInfo.hitLength);
        printWriter.println(frequencyInfo.annId);
        printWriter.println(frequencyInfo.fileIndex);
    }

    private void initSearch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        try {
            Object object;
            HttpSession httpSession = httpServletRequest.getSession();
            String string2 = (String)httpSession.getAttribute("userid");
            logger.debug((Object)("got userid: " + string2));
            httpServletResponse.setContentType("text/plain");
            PrintWriter printWriter = httpServletResponse.getWriter();
            ArrayList arrayList = (ArrayList)this.getSessionAttribute(httpSession, "domainTopNodes", string);
            String string3 = "";
            int n = 7;
            for (int i = 0; i < arrayList.size() && i < n; ++i) {
                object = AnnexUtil.getNameFor((String)arrayList.get(i));
                string3 = string3 + ", " + (String)object;
            }
            string3 = string3.substring(2);
            if (arrayList.size() > n) {
                string3 = string3 + ", ...";
            }
            printWriter.println(string3);
            ArrayList arrayList2 = this.getUserDomain(arrayList, string2);
            this.setSessionAttribute(httpSession, "domainNodes", string, arrayList2);
            object = this.keepIndexedNodes(arrayList2, 0);
            this.setSessionAttribute(httpSession, "eafNodes", string, object);
            ArrayList arrayList3 = this.keepIndexedNodes(arrayList2, 1);
            this.setSessionAttribute(httpSession, "chatNodes", string, arrayList3);
            ArrayList arrayList4 = this.keepIndexedNodes(arrayList2, 2);
            this.setSessionAttribute(httpSession, "shoeboxNodes", string, arrayList4);
            ArrayList arrayList5 = this.keepIndexedNodes(arrayList2, 3);
            this.setSessionAttribute(httpSession, "plainTextNodes", string, arrayList5);
            ArrayList arrayList6 = this.keepIndexedNodes(arrayList2, 5);
            this.setSessionAttribute(httpSession, "xmlTextNodes", string, arrayList6);
            ArrayList arrayList7 = this.keepIndexedNodes(arrayList2, 4);
            this.setSessionAttribute(httpSession, "htmlTextNodes", string, arrayList7);
            printWriter.println(((ArrayList)object).size());
            printWriter.println(arrayList3.size());
            printWriter.println(arrayList4.size());
            printWriter.println(arrayList5.size());
            printWriter.println(arrayList6.size());
            printWriter.println(arrayList7.size());
            ResultSet resultSet = AnnexUtil.getSearchClient().executeSQLQuery("select node_id, tier_name, tier_type, participant from search.tiers");
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            HashSet hashSet3 = new HashSet();
            this.getNameAndTypeInfoFor(resultSet, (ArrayList)object, hashSet, hashSet2, hashSet3);
            this.sendLinesToApplet(new ArrayList(hashSet), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet2), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet3), printWriter);
            HashSet hashSet4 = new HashSet();
            HashSet hashSet5 = new HashSet();
            HashSet hashSet6 = new HashSet();
            this.getNameAndTypeInfoFor(resultSet, arrayList3, hashSet4, hashSet5, hashSet6);
            this.sendLinesToApplet(new ArrayList(hashSet4), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet5), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet6), printWriter);
            HashSet hashSet7 = new HashSet();
            HashSet hashSet8 = new HashSet();
            HashSet hashSet9 = new HashSet();
            this.getNameAndTypeInfoFor(resultSet, arrayList4, hashSet7, hashSet8, hashSet9);
            this.sendLinesToApplet(new ArrayList(hashSet7), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet8), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet9), printWriter);
            HashSet hashSet10 = new HashSet();
            HashSet hashSet11 = new HashSet();
            HashSet hashSet12 = new HashSet();
            this.getNameAndTypeInfoFor(resultSet, arrayList5, hashSet10, hashSet11, hashSet12);
            this.sendLinesToApplet(new ArrayList(hashSet10), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet11), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet12), printWriter);
            HashSet hashSet13 = new HashSet();
            HashSet hashSet14 = new HashSet();
            HashSet hashSet15 = new HashSet();
            this.getNameAndTypeInfoFor(resultSet, arrayList6, hashSet13, hashSet14, hashSet15);
            this.sendLinesToApplet(new ArrayList(hashSet13), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet14), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet15), printWriter);
            HashSet hashSet16 = new HashSet();
            HashSet hashSet17 = new HashSet();
            HashSet hashSet18 = new HashSet();
            this.getNameAndTypeInfoFor(resultSet, arrayList7, hashSet16, hashSet17, hashSet18);
            this.sendLinesToApplet(new ArrayList(hashSet16), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet17), printWriter);
            this.sendLinesToApplet(new ArrayList(hashSet18), printWriter);
            PostgresQuery postgresQuery = AnnexUtil.getSearchClient().createQuery();
            this.setSessionAttribute(httpSession, "query", string, postgresQuery);
            ArrayList arrayList8 = postgresQuery.getSearchModes();
            this.sendLinesToApplet(arrayList8, printWriter);
            resultSet.close();
            logger.debug((Object)"closing applet communication after init");
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            logger.error((Object)"initSearch", (Throwable)exception);
        }
    }

    private void sendLinesToApplet(ArrayList arrayList, PrintWriter printWriter) {
        printWriter.println(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            string = string.replaceAll("\n", "").replaceAll("\r", "");
            printWriter.println(string);
        }
        printWriter.flush();
    }

    private ArrayList getUserDomain(ArrayList arrayList, String string) {
        String[] stringArray = new String[]{"text/x-eaf+xml", "text/x-chat", "text/x-shoebox-text", "text/plain", "text/xml", "text/html"};
        CorpusStructureDB corpusStructureDB = AnnexUtil.getCorpusStructureDB();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (corpusStructureDB.getNode(string2).getNodeType() == 8) {
                if (!AnnexUtil.hasAccessTo(string, string2)) continue;
                arrayList2.add(string2);
                continue;
            }
            String[] stringArray2 = corpusStructureDB.getDescendants(string2, 8, stringArray, string, false);
            for (int j = 0; j < stringArray2.length; ++j) {
                arrayList2.add(stringArray2[j]);
            }
        }
        return arrayList2;
    }

    private ArrayList keepIndexedNodes(ArrayList arrayList, int n) {
        ArrayList arrayList2 = new ArrayList();
        try {
            HashSet<String> hashSet = new HashSet<String>();
            String string = "select node_id from search.tiers where transcription_type = " + n;
            ResultSet resultSet = AnnexUtil.getSearchClient().executeSQLQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                hashSet.add(string2);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashSet.contains(arrayList.get(i))) continue;
                arrayList2.add(arrayList.get(i));
            }
        }
        catch (Exception exception) {
            logger.error((Object)"keepIndexedNodes", (Throwable)exception);
        }
        return arrayList2;
    }

    private void getNameAndTypeInfoFor(ResultSet resultSet, ArrayList arrayList, HashSet hashSet, HashSet hashSet2, HashSet hashSet3) {
        HashSet hashSet4 = new HashSet(arrayList);
        hashSet.clear();
        hashSet2.clear();
        hashSet3.clear();
        if (resultSet == null) {
            return;
        }
        try {
            boolean bl = false;
            resultSet.beforeFirst();
            while (resultSet.next()) {
                String string;
                String string2;
                String string3 = resultSet.getString(1);
                if (!hashSet4.contains(string3)) continue;
                String string4 = resultSet.getString(2);
                if (string4 != null && string4.length() > 0) {
                    hashSet.add(string4);
                }
                if ((string2 = resultSet.getString(3)) != null && string2.length() > 0) {
                    hashSet2.add(string2);
                }
                if ((string = resultSet.getString(4)) == null || string.length() <= 0) continue;
                hashSet3.add(string);
            }
            if (hashSet.size() > 200) {
                hashSet.clear();
            }
            if (hashSet2.size() > 200) {
                hashSet2.clear();
            }
            if (hashSet3.size() > 200) {
                hashSet3.clear();
            }
        }
        catch (Exception exception) {
            logger.error((Object)"getNameAndTypeInfoFor", (Throwable)exception);
        }
    }

    private void setSessionAttribute(HttpSession httpSession, String string, String string2, Object object) {
        httpSession.setAttribute(string + string2, object);
    }

    private Object getSessionAttribute(HttpSession httpSession, String string, String string2) {
        return httpSession.getAttribute(string + string2);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

