/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.text.DecimalFormat;

public class SearchUtil {
    public static final long ILLEGAL_TIME_FLAG = 98373696L;
    private static final DecimalFormat twoDigits = new DecimalFormat("00");
    private static final DecimalFormat threeFracs = new DecimalFormat("00.000");

    public static String HHMMSSmmmFormat(long l) {
        float f = (float)l / 1000.0f;
        int n = (int)Math.floor(f / 3600.0f);
        int n2 = (int)Math.floor((f - (float)(3600 * n)) / 60.0f);
        float f2 = f - (float)(3600 * n) - (float)(60 * n2);
        return twoDigits.format(n) + ":" + twoDigits.format(n2) + ":" + threeFracs.format(f2);
    }

    public static long parseTimeString(String string) {
        try {
            int n = string.indexOf(":");
            int n2 = string.indexOf(".");
            if (n < 0 && n2 < 0) {
                return Long.parseLong(string.trim());
            }
            String[] stringArray = string.trim().split(":");
            if (stringArray.length != 3) {
                return 98373696L;
            }
            String[] stringArray2 = stringArray[2].split("\\.");
            if (stringArray2.length != 2) {
                return 98373696L;
            }
            while (stringArray2[1].length() < 3) {
                stringArray2[1] = stringArray2[1] + "0";
            }
            long l = 3600000 * Integer.parseInt(stringArray[0].trim());
            l += (long)(60000 * Integer.parseInt(stringArray[1].trim()));
            l += (long)(1000 * Integer.parseInt(stringArray2[0].trim()));
            return l += (long)Integer.parseInt(stringArray2[1].trim());
        }
        catch (Exception exception) {
            return 98373696L;
        }
    }
}

