/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.annex.search.SearchDomainPanel;
import mpi.annex.search.SearchListener;
import mpi.annex.search.SearchMediator;
import mpi.annex.search.SearchResultPanel;

public class SimpleSearchPanel
extends JPanel
implements SearchListener,
ActionListener {
    private SearchMediator mediator;
    private String queryId;
    private SearchDomainPanel domainPanel;
    private SearchResultPanel resultPanel;
    private JButton findButton;
    private JTextField queryField;
    private boolean initialising;

    public SimpleSearchPanel(SearchMediator searchMediator) {
        this.mediator = searchMediator;
        this.initialising = true;
        this.queryId = searchMediator.createQuery();
        Color color = searchMediator.getBackgroundColor();
        this.setBackground(color);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(color);
        this.domainPanel = new SearchDomainPanel(searchMediator, this.queryId, this);
        jPanel.add(this.domainPanel);
        jPanel.add(Box.createVerticalStrut(15));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(color);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalStrut(50));
        this.findButton = new JButton("Find");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.findButton.setBackground(color);
        }
        this.findButton.addActionListener(this);
        jPanel2.add(this.findButton);
        jPanel2.add(Box.createHorizontalStrut(10));
        this.queryField = new JTextField("", 50);
        this.queryField.addActionListener(this);
        this.queryField.requestFocus();
        jPanel2.add(this.queryField);
        jPanel2.add(Box.createHorizontalStrut(50));
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        this.add((Component)jPanel, "North");
        this.resultPanel = new SearchResultPanel(searchMediator, this.queryId);
        this.add((Component)this.resultPanel, "Center");
        this.queryField.requestFocus();
    }

    public void queryStopped() {
        this.queryField.requestFocus();
    }

    public void domainChanged() {
    }

    private String encodeQuery() {
        String string = " Annotation' case insensitive' substring match";
        String string2 = "0, 0, 0, 0, 1, 1, 1jqzxw";
        string2 = string2 + this.queryField.getText() + "jqzxw" + string + "jqzxw" + "" + "jqzxw" + "" + "jqzxw";
        string2 = string2 + " All Tiers ";
        return string2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.queryField.getText().length() != 0 && !this.queryField.getText().equals("Error, empty query string")) {
            this.mediator.doQuery(this.encodeQuery(), this.queryId);
            this.resultPanel.startUpdating();
        } else {
            this.queryField.requestFocus();
            this.queryField.setText("Error, empty query string");
            this.queryField.setSelectionStart(0);
            this.queryField.setSelectionEnd(100);
        }
    }

    public void setQuery(String string) {
    }
}

