/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.annex.search.Constants;
import mpi.annex.search.SearchAppletMediator;
import mpi.annex.search.SearchDomainPanel;
import mpi.annex.search.SearchHistoryPanel;
import mpi.annex.search.SearchListener;
import mpi.annex.search.SearchMediator;
import mpi.annex.search.SearchResultPanel;

public class SingleLayerSearchPanel
extends JPanel
implements SearchListener,
ActionListener,
ItemListener {
    private SearchMediator mediator;
    private String queryId;
    private Color backgroundColor;
    private String domainTypes;
    private String[] targetModes;
    private String[] caseModes;
    private String[] matchModes;
    private JComboBox targetModeChooser;
    private JComboBox caseModeChooser;
    private JComboBox matchModeChooser;
    private JComboBox tierConstraintsChooser;
    private JButton findButton;
    private JTextField queryField;
    private SearchResultPanel resultPanel;
    private SearchHistoryPanel historyPanel;

    public SingleLayerSearchPanel(SearchMediator searchMediator) {
        int n;
        int n2;
        this.mediator = searchMediator;
        this.backgroundColor = searchMediator.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.queryId = searchMediator.createQuery();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(this.backgroundColor);
        SearchDomainPanel searchDomainPanel = new SearchDomainPanel(searchMediator, this.queryId, this);
        jPanel.add(searchDomainPanel);
        jPanel.add(Box.createVerticalStrut(20));
        this.historyPanel = new SearchHistoryPanel(this, this.backgroundColor);
        this.historyPanel.setHistory(searchMediator.getPersistent("singleTierHistory"));
        jPanel.add(this.historyPanel);
        jPanel.add(Box.createVerticalStrut(15));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.backgroundColor);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JLabel jLabel = new JLabel("Mode:");
        jLabel.setFont(Constants.bigBoldFont);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(10));
        ArrayList arrayList = searchMediator.getSearchModes(this.queryId);
        int n3 = 0;
        int n4 = Integer.parseInt((String)arrayList.get(n3));
        this.targetModes = new String[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            this.targetModes[n2] = (String)arrayList.get(++n3);
        }
        this.targetModeChooser = new JComboBox<String>(this.targetModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.targetModeChooser.setBackground(this.backgroundColor);
        }
        this.targetModeChooser.addItemListener(this);
        jPanel2.add(this.targetModeChooser);
        jPanel2.add(Box.createHorizontalStrut(5));
        n2 = Integer.parseInt((String)arrayList.get(++n3));
        this.caseModes = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.caseModes[n] = (String)arrayList.get(++n3);
        }
        this.caseModeChooser = new JComboBox<String>(this.caseModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.caseModeChooser.setBackground(this.backgroundColor);
        }
        this.caseModeChooser.addItemListener(this);
        jPanel2.add(this.caseModeChooser);
        jPanel2.add(Box.createHorizontalStrut(5));
        n = Integer.parseInt((String)arrayList.get(++n3));
        this.matchModes = new String[n];
        for (int i = 0; i < n; ++i) {
            this.matchModes[i] = (String)arrayList.get(++n3);
        }
        this.matchModeChooser = new JComboBox<String>(this.matchModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.matchModeChooser.setBackground(this.backgroundColor);
        }
        this.matchModeChooser.addItemListener(this);
        jPanel2.add(this.matchModeChooser);
        jPanel2.add(Box.createHorizontalStrut(30));
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(15));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(this.backgroundColor);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalStrut(50));
        this.findButton = new JButton("Find");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.findButton.setBackground(this.backgroundColor);
        }
        this.findButton.addActionListener(this);
        jPanel3.add(this.findButton);
        jPanel3.add(Box.createHorizontalStrut(10));
        this.queryField = new JTextField();
        this.queryField.addActionListener(this);
        this.queryField.requestFocus();
        jPanel3.add(this.queryField);
        jPanel3.add(Box.createHorizontalStrut(10));
        Dimension dimension = new Dimension(250, 25);
        this.tierConstraintsChooser = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.tierConstraintsChooser.setBackground(this.backgroundColor);
        }
        this.tierConstraintsChooser.setPreferredSize(dimension);
        this.tierConstraintsChooser.setMaximumRowCount(20);
        if (searchMediator instanceof SearchAppletMediator) {
            this.fillTierConstraintsCombo();
        }
        jPanel3.add(this.tierConstraintsChooser);
        jPanel3.add(Box.createHorizontalStrut(30));
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(15));
        this.add((Component)jPanel, "North");
        this.resultPanel = new SearchResultPanel(searchMediator, this.queryId);
        this.add((Component)this.resultPanel, "Center");
        this.queryField.requestFocus();
    }

    public void fillTierConstraintsCombo() {
        while (this.tierConstraintsChooser == null) {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.tierConstraintsChooser.removeAllItems();
        this.tierConstraintsChooser.addItem(" All Tiers ");
        ArrayList arrayList = this.mediator.getTierTypes(this.queryId);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.tierConstraintsChooser.addItem(" Tier Type: " + arrayList.get(i));
        }
        ArrayList arrayList2 = this.mediator.getParticipants(this.queryId);
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.tierConstraintsChooser.addItem(" Participant: " + arrayList2.get(i));
        }
        ArrayList arrayList3 = this.mediator.getTierNames(this.queryId);
        for (int i = 0; i < arrayList3.size(); ++i) {
            this.tierConstraintsChooser.addItem(" Tier Name: " + arrayList3.get(i));
        }
    }

    public void domainChanged() {
        this.fillTierConstraintsCombo();
        this.validate();
    }

    public void queryStopped() {
        this.queryField.requestFocus();
    }

    private String makeSaveableQuery() {
        return (String)this.targetModeChooser.getSelectedItem() + "jqzxw" + (String)this.caseModeChooser.getSelectedItem() + "jqzxw" + (String)this.matchModeChooser.getSelectedItem() + "jqzxw" + this.queryField.getText() + "jqzxw" + (String)this.tierConstraintsChooser.getSelectedItem();
    }

    public void setQuery(String string) {
        String[] stringArray = string.split("jqzxw");
        this.targetModeChooser.setSelectedItem(stringArray[0]);
        this.caseModeChooser.setSelectedItem(stringArray[1]);
        this.matchModeChooser.setSelectedItem(stringArray[2]);
        this.queryField.setText(stringArray[3]);
        this.tierConstraintsChooser.setSelectedItem(stringArray[4]);
    }

    private String encodeQuery() {
        String string = (String)this.targetModeChooser.getSelectedItem() + "'" + (String)this.caseModeChooser.getSelectedItem() + "'" + (String)this.matchModeChooser.getSelectedItem();
        String string2 = "0, 0, 0, 0, 1, 1, 1jqzxw";
        string2 = string2 + this.queryField.getText().trim() + "jqzxw" + string + "jqzxw" + "cns none" + "jqzxw" + "cns none" + "jqzxw";
        string2 = string2 + this.tierConstraintsChooser.getSelectedItem();
        return string2;
    }

    private boolean checkQueryValidity() {
        int n;
        Object object;
        String string = (String)this.targetModeChooser.getSelectedItem();
        String string2 = this.queryField.getText().trim();
        if (!string.equals(" Annotation")) {
            object = string2.split(" +");
            boolean bl = true;
            for (n = 0; n < ((Object)object).length; ++n) {
                if (!((String)object[n]).equals("#")) {
                    bl = false;
                }
                if (!((String)object[n]).equals("NOT()")) continue;
                JOptionPane.showMessageDialog(null, "A NOT() must have a value between ( and ) ", "Illegal NOT() pattern", 0);
                this.queryField.requestFocus();
                return false;
            }
            if (bl) {
                JOptionPane.showMessageDialog(null, "An n-gram pattern must contain at least one character other than #", "Only wildcards in pattern", 0);
                this.queryField.requestFocus();
                return false;
            }
        }
        if (((String)(object = (String)this.matchModeChooser.getSelectedItem())).equals(" regular expression")) {
            String[] stringArray = new String[]{string2};
            if (((String)this.targetModeChooser.getSelectedItem()).toLowerCase().indexOf("gram") >= 0) {
                stringArray = string2.split(" ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                try {
                    Pattern.compile(stringArray[n]);
                    continue;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Not a valid regular expression:\n\n     " + stringArray[n], "Error", 0);
                    this.queryField.requestFocus();
                    return false;
                }
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.findButton || object == this.queryField) {
            if (this.queryField.getText().length() != 0 && !this.queryField.getText().equals("Error, empty query string") && !this.queryField.getText().startsWith("Not a valid regular expression")) {
                if (this.checkQueryValidity()) {
                    this.mediator.doQuery(this.encodeQuery(), this.queryId);
                    this.resultPanel.startUpdating();
                    this.historyPanel.remember(this.makeSaveableQuery());
                    this.mediator.putPersistent("singleTierHistory", this.historyPanel.getHistory());
                }
            } else {
                this.queryField.requestFocus();
                this.queryField.setText("Error, empty query string");
                this.queryField.setSelectionStart(0);
                this.queryField.setSelectionEnd(100);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.queryField.requestFocus();
    }
}

