/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.util;

import java.io.PrintStream;
import java.util.ArrayList;
import mpi.annex.search.SearchClient;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class AnnexUtil {
    private static Logger logger = Logger.getLogger((String)"ANNEX.Util");
    public static String corpusDbURL;
    public static String corpusDbUser;
    public static String corpusDbPassword;
    public static String searchDbURL;
    public static String searchDbUser;
    public static String searchDbPassword;
    public static String searchServerPort;
    public static String syntaxViewerURL;
    public static String workspaceDbURL;
    public static String workspaceDbUser;
    public static String workspaceDbPassword;
    public static String anonymizerHost;
    public static String anonymizerPort;
    public static String streamingURL;
    private static CorpusStructureDB csdb;
    private static ArchiveObjectsDB aodb;
    private static SearchClient searchClient;
    public static int debugLevel;

    public static String getCorpusDbURL() {
        if (corpusDbURL == null) {
            return "jdbc:postgresql://lux08.mpi.nl:5432/corpusstructure";
        }
        return corpusDbURL;
    }

    public static void setCorpusDbURL(String string) {
        corpusDbURL = string;
    }

    public static String getCorpusDbUser() {
        if (corpusDbUser == null) {
            return "webuser";
        }
        return corpusDbUser;
    }

    public static void setCorpusDbUser(String string) {
        corpusDbUser = string;
    }

    public static String getCorpusDbPassword() {
        if (corpusDbPassword == null) {
            // empty if block
        }
        return corpusDbPassword;
    }

    public static void setCorpusDbPassword(String string) {
        corpusDbPassword = string;
    }

    public static String getSearchDbURL() {
        if (searchDbURL == null) {
            return "jdbc:postgresql://lux08.mpi.nl:5432/annex";
        }
        return searchDbURL;
    }

    public static String getSearchDbUser() {
        if (searchDbUser == null) {
            // empty if block
        }
        return searchDbUser;
    }

    public static String getSearchDbPassword() {
        if (searchDbPassword == null) {
            // empty if block
        }
        return searchDbPassword;
    }

    public static void setSearchDbURL(String string) {
        searchDbURL = string;
    }

    public static int getSearchServerPort() {
        if (searchServerPort == null) {
            return 2000;
        }
        try {
            return Integer.parseInt(searchServerPort);
        }
        catch (NumberFormatException numberFormatException) {
            return 2000;
        }
    }

    public static void setSearchServerPort(String string) {
        searchServerPort = string;
    }

    public static String getSyntaxViewerURL() {
        return syntaxViewerURL;
    }

    public static String getWorkspaceDbURL() {
        return workspaceDbURL;
    }

    public static String getWorkspaceDbUser() {
        if (workspaceDbUser == null) {
            workspaceDbUser = "webuser";
        }
        return workspaceDbUser;
    }

    public static String getWorkspaceDbPassword() {
        if (workspaceDbPassword == null) {
            // empty if block
        }
        return workspaceDbPassword;
    }

    public static String getAnonymizerHost() {
        if (anonymizerHost == null) {
            return "sun2.mpi.nl";
        }
        return anonymizerHost;
    }

    public static String getAnonymizerPort() {
        if (anonymizerPort == null) {
            return "7777";
        }
        return anonymizerPort;
    }

    public static String getStringURL() {
        if (streamingURL == null) {
            return "rtsp://sun2.mpi.nl/";
        }
        return streamingURL;
    }

    public static boolean hasAccessTo(String string, String string2) {
        System.out.println("user=[" + string + "] nodeId=[" + string2 + "]");
        boolean bl = AnnexUtil.getArchiveObjectsDB().getObjectAccessInfo(string2).hasReadAccess(string);
        return bl;
    }

    public static InputSource getInputSourceFor(String string) {
        OurURL ourURL = AnnexUtil.getArchiveObjectsDB().getObjectURL(string, 1);
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(ourURL.openStream());
            String string2 = ourURL.toString();
            int n = string2.lastIndexOf("/");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            inputSource.setSystemId(string2 + "/");
        }
        catch (Exception exception) {
            logger.error((Object)exception.toString());
        }
        return inputSource;
    }

    public static OurURL getURLFor(String string) {
        OurURL ourURL = AnnexUtil.getArchiveObjectsDB().getObjectURL(string, 1);
        return ourURL;
    }

    public static String getFilePathFor(String string) {
        if (string == null) {
            return null;
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            return AnnexUtil.getFilePathForWindows(string);
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
            return AnnexUtil.getFilePathForMac(string);
        }
        return AnnexUtil.getFilePathForUnix(string);
    }

    public static String getFilePathForUnix(String string) {
        if (string == null) {
            return null;
        }
        OurURL ourURL = AnnexUtil.getArchiveObjectsDB().getObjectURL(string, 1);
        return ourURL.getPath();
    }

    public static String getFilePathForMac(String string) {
        if (string == null) {
            return null;
        }
        OurURL ourURL = AnnexUtil.getArchiveObjectsDB().getObjectURL(string, 1);
        return ourURL.getPath();
    }

    public static String getFilePathForWindows(String string) {
        if (string == null) {
            return null;
        }
        OurURL ourURL = AnnexUtil.getArchiveObjectsDB().getObjectURL(string, 2);
        return ourURL.getPath();
    }

    public static String getHTTPURL(String string) {
        if (string == null) {
            return null;
        }
        OurURL ourURL = AnnexUtil.getArchiveObjectsDB().getObjectURL(string, 3);
        return ourURL.getPath();
    }

    public static ArrayList getPossibleMediaFor(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (AnnexUtil.getTypeFor(string) == -1) {
            return arrayList;
        }
        try {
            String[] stringArray = AnnexUtil.getCorpusStructureDB().getParentNodes(string);
            if (stringArray == null) {
                return arrayList;
            }
            String[] stringArray2 = AnnexUtil.getCorpusStructureDB().getDescendants(stringArray[0], 16, (String)null);
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(AnnexUtil.getCorpusStructureDB().getNode(stringArray2[i]).getName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static ArrayList getPossibleTigers(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = AnnexUtil.getCorpusStructureDB().getParentNodes(string);
            if (stringArray == null) {
                return arrayList;
            }
            System.out.println("pNodeid=" + stringArray[0]);
            String[] stringArray2 = AnnexUtil.getCorpusStructureDB().getDescendants(stringArray[0], -1, "*/x-cgn-tig+xml");
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static int getTypeFor(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = AnnexUtil.getCorpusStructureDB().getNode(string).getFormat();
        if (string2.equals("text/x-eaf+xml")) {
            return 0;
        }
        if (string2.equals("text/x-chat")) {
            return 1;
        }
        if (string2.equals("text/x-shoebox-text")) {
            return 2;
        }
        if (string2.equals("text/plain")) {
            return 3;
        }
        if (string2.equals("text/xml")) {
            return 5;
        }
        if (string2.equals("text/html")) {
            return 4;
        }
        return -1;
    }

    public static String getNameFor(String string) {
        if (string == null) {
            return null;
        }
        try {
            return AnnexUtil.getCorpusStructureDB().getNode(string).getName();
        }
        catch (Exception exception) {
            logger.error((Object)exception.toString());
            return "UNKNOWN";
        }
    }

    public static String getNamePathFor(String string) {
        if (string == null) {
            return null;
        }
        return AnnexUtil.getCorpusStructureDB().getNamePath(string);
    }

    public static String getFilePathForOld(String string) {
        OurURL ourURL = AnnexUtil.getArchiveObjectsDB().getObjectURL(string, 1);
        String string2 = ourURL.toString();
        string2.replace('\\', '/');
        int n = string2.indexOf(58) + 1;
        while (string2.charAt(n) == '/') {
            ++n;
        }
        string2 = "/" + string2.substring(n);
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            string2 = "\\\\Corpora\\Corpora" + string2.substring(13);
        } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
            // empty if block
        }
        return string2;
    }

    public static SearchClient getSearchClient() throws Exception {
        if (searchClient == null) {
            String string = AnnexUtil.getSearchDbURL();
            String string2 = AnnexUtil.getSearchDbUser();
            String string3 = AnnexUtil.getSearchDbPassword();
            searchClient = new SearchClient(string, string2, string3);
        }
        return searchClient;
    }

    private static void initCorpusStructureDBImpl() {
        if (csdb == null || aodb == null) {
            String string = AnnexUtil.getCorpusDbURL();
            String string2 = AnnexUtil.getCorpusDbUser();
            String string3 = AnnexUtil.getCorpusDbPassword();
            try {
                CorpusStructureDBImpl corpusStructureDBImpl = new CorpusStructureDBImpl(string, false, string2, string3);
                csdb = corpusStructureDBImpl;
                aodb = corpusStructureDBImpl;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static CorpusStructureDB getCorpusStructureDB() {
        if (csdb == null) {
            AnnexUtil.initCorpusStructureDBImpl();
        }
        return csdb;
    }

    public static ArchiveObjectsDB getArchiveObjectsDB() {
        if (aodb == null) {
            AnnexUtil.initCorpusStructureDBImpl();
        }
        return aodb;
    }

    public static void closeCorpusStructureDBImpl() {
        if (csdb != null) {
            csdb.close();
            csdb = null;
        }
        if (aodb != null) {
            aodb.close();
            aodb = null;
        }
    }

    public static void log(String string, int n, String string2) {
        if (debugLevel > n) {
            System.out.println(n + " " + string + ": " + string2);
        }
    }

    public static void log(Object object, int n, String string) {
        if (debugLevel > n) {
            System.out.println(n + " " + object.getClass().getName() + ": " + string);
        }
    }

    public static void log(Object object, int n, Exception exception) {
        if (debugLevel > n) {
            System.out.println(n + " " + object.getClass().getName() + ": ");
            exception.printStackTrace(new PrintStream(System.out));
        }
    }

    public static String HTMLEncode(String string) {
        String string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("'", "&#39;");
        string2 = string2.replaceAll("\"", "&quot;");
        return string2;
    }

    static {
        debugLevel = -1;
    }
}

