/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.view.HTML;
import mpi.annex.view.HTMLImageMap;
import mpi.annex.view.IMArea;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.viewer.TimeRuler;
import mpi.eudico.client.util.TimeFormatter;

public class AnnexHTMLTimeLineViewer {
    private String ID;
    private Graphics2D big2d;
    private BufferedImage bi;
    private int imageWidth;
    private int imageHeight;
    private TimeRuler ruler;
    private int rulerHeight;
    private Font font;
    private FontMetrics metrics;
    private int msPerPixel = 10;
    public final int DEFAULT_MS_PER_PIXEL = 10;
    static final int PIXELS_FOR_SECOND = 100;
    private int resolution;
    private long intervalBeginTime;
    private long intervalEndTime;
    private long selectionBeginTime;
    private long selectionEndTime;
    private int selectionBeginPos;
    private int selectionEndPos;
    private AlphaComposite alpha04;
    private AlphaComposite alpha07;
    protected int pixelsForTierHeight;
    protected int pixelsForTierHeightMargin;
    private HTMLImageMap im;
    private int tagIndex = 0;
    private int h;
    private int w;
    private int x;
    private int y;
    private File f;
    private String markedTag = "";
    private int nameWidth = 80;

    public AnnexHTMLTimeLineViewer(int n, int n2) {
        this.imageWidth = n;
        this.imageHeight = n2;
        this.bi = new BufferedImage(n, n2, 1);
        this.big2d = this.bi.createGraphics();
        this.font = Constants.DEFAULTFONT;
        this.big2d.setFont(this.font);
        this.metrics = this.big2d.getFontMetrics(this.font);
        this.alpha04 = AlphaComposite.getInstance(3, 0.4f);
        this.alpha07 = AlphaComposite.getInstance(3, 0.7f);
        this.pixelsForTierHeight = this.font.getSize() * 3;
        this.pixelsForTierHeightMargin = 2;
        this.im = new HTMLImageMap("timelinemap");
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    public void setImageSize(int n, int n2) {
        this.imageWidth = n;
        this.imageHeight = n2;
        if (this.bi != null) {
            this.bi = null;
        }
        this.bi = new BufferedImage(n, n2, 1);
        this.big2d = this.bi.createGraphics();
    }

    public HTMLImageMap getIM() {
        return this.im;
    }

    public void setTimeSpan(long l, long l2) {
        this.intervalBeginTime = l;
        this.intervalEndTime = l2;
        double d = (double)(l2 - l) / (double)(this.imageWidth - this.nameWidth);
        this.msPerPixel = (int)Math.ceil(d);
        if (this.msPerPixel == 0) {
            this.msPerPixel = 1;
        }
        this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.big2d.fillRect(0, 0, this.imageWidth, this.imageHeight);
    }

    public int getMsPerPixel() {
        return this.msPerPixel;
    }

    public int getNameWidth() {
        return this.nameWidth;
    }

    public int getXOffset() {
        return this.timeToPixels(this.intervalBeginTime) - this.nameWidth;
    }

    public long getIntervalBeginTime() {
        return this.intervalBeginTime;
    }

    public void markTag(String string) {
        this.markedTag = string;
    }

    public void draw() {
        this.ruler = new TimeRuler(this.font, TimeFormatter.toString((long)0L));
        this.rulerHeight = this.ruler.getHeight();
        this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
        this.big2d.translate(-(this.intervalBeginTime / (long)this.msPerPixel) + (long)this.nameWidth, 0.0);
        int n = (int)(this.intervalBeginTime / (long)this.msPerPixel);
        this.big2d.setClip(n, 0, this.imageWidth, this.imageHeight);
        this.ruler.paint(this.big2d, this.intervalBeginTime, this.imageWidth - this.nameWidth, (float)this.msPerPixel, 1);
        this.big2d.setClip(null);
        this.y = this.rulerHeight;
        this.x = this.nameWidth;
        this.w = 0;
        this.h = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
    }

    public File save(String string) {
        try {
            this.f = new File(string);
            ImageIO.write((RenderedImage)this.bi, "png", this.f);
            return this.f;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public File toFile(String string, String string2) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            HTML.prt(fileOutputStream, "<html><head><link rel=\"stylesheet\" type=\"text/css\" ");
            HTML.prt(fileOutputStream, "href=\"tblstyle.css\"><script src=\"common.js\">");
            HTML.prtln(fileOutputStream, "</script></head><body>");
            HTML.prtln(fileOutputStream, "<img src=\"" + string2 + "\">");
            HTML.prtln(fileOutputStream, "</body>");
            fileOutputStream.close();
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void removeFile() {
        this.f.delete();
    }

    public void paintSelection(long l, long l2) {
        this.selectionBeginTime = l;
        this.selectionEndTime = l2;
        int n = this.timeToPixels(l);
        int n2 = this.timeToPixels(l2);
        Color color = new Color(204, 204, 255);
        this.big2d.setColor(color);
        this.big2d.setComposite(this.alpha04);
        this.big2d.fillRect(n, 0, n2 - n, this.rulerHeight);
        this.big2d.setComposite(AlphaComposite.Src);
        this.big2d.fillRect(n, this.rulerHeight, n2 - n, this.imageHeight - this.rulerHeight);
    }

    private int timeToPixels(long l) {
        return (int)((double)l / (double)this.msPerPixel);
    }

    public void paintTag(AnnexTier annexTier) {
        this.paintTagOffset(annexTier, 0);
    }

    public void paintTagOffset(AnnexTier annexTier, int n) {
        String string = "?";
        string = annexTier.name;
        ArrayList arrayList = annexTier.annotations;
        this.big2d.setColor(new Color(0, 0, 0));
        int n2 = (int)(this.intervalBeginTime / (long)this.msPerPixel);
        this.big2d.setClip(n2 - this.nameWidth, 0, this.nameWidth, this.imageHeight);
        this.big2d.drawString(string, -this.nameWidth + 4 + n2, this.y + this.pixelsForTierHeightMargin + 20);
        this.big2d.setClip(null);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            AnnexAnnotation annexAnnotation = (AnnexAnnotation)arrayList.get(i);
            if (annexAnnotation == null) {
                System.out.println("paintTagOffset(): null AA?");
                continue;
            }
            long l = annexAnnotation.beginTime;
            long l2 = annexAnnotation.endTime;
            if (l2 < this.intervalBeginTime) continue;
            if (l > this.intervalEndTime) break;
            this.x = this.timeToPixels(l);
            this.w = this.timeToPixels(l2) - this.x;
            int n3 = this.timeToPixels(this.intervalBeginTime) - this.nameWidth;
            this.big2d.setClip(n2, 0, this.imageWidth, this.imageHeight);
            this.paintTag(this.big2d, annexAnnotation, this.x, this.y + this.pixelsForTierHeightMargin, this.w, this.h);
            this.big2d.setClip(null);
            IMArea iMArea = new IMArea("rect");
            iMArea.setHref("#");
            String string2 = string.replaceAll("'", "_").replaceAll(" ", "_");
            String string3 = string2 + l + l2 + "0";
            boolean bl = false;
            if (string3.equals(this.markedTag)) {
                bl = true;
            }
            if (!annexAnnotation.isTimeAligned) {
                object = annexAnnotation.refAnnotation;
                while (object != null && !((AnnexAnnotation)object).isTimeAligned) {
                    object = ((AnnexAnnotation)object).refAnnotation;
                }
                if (object != null) {
                    l = ((AnnexAnnotation)object).beginTime;
                    l2 = ((AnnexAnnotation)object).endTime;
                }
            }
            object = "timelineClick(event,'" + string3 + "'," + l + "," + l2 + ")";
            this.x = this.timeToPixels(l);
            this.w = this.timeToPixels(l2) - this.x;
            iMArea.setHCode(string3);
            iMArea.setOnClick((String)object);
            iMArea.addCoordinate(this.x - n3);
            iMArea.addCoordinate(this.y + n);
            iMArea.addCoordinate(this.x + this.w - n3);
            iMArea.addCoordinate(this.y + this.h + n);
            this.im.addArea(iMArea);
        }
        this.y += this.pixelsForTierHeight;
    }

    private void paintTag(Graphics2D graphics2D, AnnexAnnotation annexAnnotation, int n, int n2, int n3, int n4) {
        if (annexAnnotation.isTimeAligned) {
            graphics2D.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            graphics2D.drawLine(n, n2 + (annexAnnotation.isTimeAligned ? 0 : n4 / 4), n, n2 + (annexAnnotation.isTimeAligned ? n4 : n4 * 3 / 4));
            graphics2D.drawLine(n, n2 + n4 / 2, n + n3, n2 + n4 / 2);
            graphics2D.drawLine(n + n3, n2 + (annexAnnotation.isTimeAligned ? 0 : n4 / 4), n + n3, n2 + (annexAnnotation.isTimeAligned ? n4 : n4 * 3 / 4));
        } else {
            graphics2D.setColor(Constants.SHAREDCOLOR1);
            graphics2D.drawLine(n, n2 + n4 / 4, n, n2 + n4 * 3 / 4);
            graphics2D.drawLine(n, n2 + n4 / 2, n + n3, n2 + n4 / 2);
            graphics2D.drawLine(n + n3, n2 + n4 / 4, n + n3, n2 + n4 * 3 / 4);
        }
        graphics2D.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
        int n5 = this.timeToPixels(annexAnnotation.endTime) - n;
        String string = this.truncateString((String)annexAnnotation.value, n5, this.metrics);
        graphics2D.drawString(string, (float)(n + 4), (float)(n2 + (n4 / 2 - 1)));
    }

    private String truncateString(String string, int n, FontMetrics fontMetrics) {
        int n2;
        String string2 = string.replace('\n', ' ');
        if (fontMetrics != null && (n2 = fontMetrics.stringWidth(string2)) > n - 4) {
            int n3 = 0;
            String string3 = "";
            int n4 = string2.length();
            while (n3 < n4 && fontMetrics.stringWidth(string3) <= n - 4) {
                string3 = string3 + string2.charAt(n3++);
            }
            string2 = !string3.equals("") ? string3.substring(0, string3.length() - 1) : string3;
        }
        return string2;
    }
}

