/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.view.FrameData;
import mpi.annex.view.SessionData;
import mpi.annex.view.Util;
import org.apache.log4j.Logger;

public class AnnoMod
extends HttpServlet {
    private String webDir;
    private SessionData sd = null;
    private static Logger logger = Logger.getLogger((String)"ANNEX.AnnoMod");

    public void init() {
        this.webDir = this.getServletContext().getRealPath("/") + "/";
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        AnnexTranscription annexTranscription;
        logger.info((Object)"AnnoMod started.");
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        String string = httpSession.getId();
        String string2 = httpServletRequest.getParameter("key");
        HashMap hashMap = (HashMap)httpSession.getAttribute("sessions");
        SessionData sessionData = (SessionData)hashMap.get(string2);
        if (sessionData == null || sessionData.isInvalid()) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        String string3 = httpServletRequest.getParameter("frame");
        if (string3 != null) {
            logger.info((Object)("Frame=" + string3));
        } else {
            string3 = "DF";
        }
        FrameData frameData = sessionData.getFrame(string3);
        if (frameData == null) {
            frameData = new FrameData(string3);
            sessionData.setFrame(string3, frameData);
        }
        int n = 10;
        while (sessionData.getLocked()) {
            logger.info((Object)" Waiting for lock.");
            if (--n == 0) {
                logger.info((Object)" Time out waiting for lock.");
                sessionData.setLocked(false);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                sessionData.setLocked(false);
            }
        }
        sessionData.setLocked(true);
        String string4 = httpServletRequest.getParameter("tlSelH");
        if (string4 != null) {
            // empty if block
        }
        if ((annexTranscription = sessionData.getAnnexTranscription()) != null) {
            String string5 = httpServletRequest.getParameter("tieridx");
            if (string5 == null) {
                string5 = "0";
            }
            int n2 = 0;
            n2 = new Integer(string5);
            logger.info((Object)("tieridx = " + n2));
            String string6 = httpServletRequest.getParameter("tier");
            if (string6 == null && (string6 = frameData.getVisibleTier(0)) == null) {
                logger.error((Object)"No tiername!");
            }
            logger.info((Object)("tiername = " + string6));
            String string7 = httpServletRequest.getParameter("annotationidx");
            if (string7 == null) {
                string7 = "0";
            }
            int n3 = 0;
            n3 = new Integer(string7);
            logger.info((Object)("annotationidx = " + n3));
            String string8 = httpServletRequest.getParameter("newanno");
            if (string8 == null) {
                logger.error((Object)"No new anno!");
            }
            logger.info((Object)("new_anno = " + string8));
            AnnexTier annexTier = Util.getTierImplByName(string6, annexTranscription);
            ArrayList arrayList = annexTier.annotations;
            AnnexAnnotation annexAnnotation = (AnnexAnnotation)arrayList.get(n3);
            annexAnnotation.value = string8;
        }
        sessionData.setLocked(false);
        logger.info((Object)"AnnoMod finished.");
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }
}

