/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import mpi.annex.view.DBInterface;
import mpi.annex.view.UserData;
import mpi.util.DBConnection;
import org.apache.log4j.Logger;

public class DBI
implements DBInterface {
    private static Logger logger = Logger.getLogger((String)"ANNEX.DBI");
    private static String sql_insert = "INSERT INTO users (id,kv) VALUES (?,?);";
    private static String sql_update = "UPDATE users SET kv=? where id=?";
    private static String sql_select = "SELECT * FROM users";
    private static String sql_tstamp = "UPDATE users SET lastaccess=NOW() where id=?";
    private static String url = "java:comp/env/jdbc/ANNEXUSERDB";
    private static Connection con = null;
    private static DBConnection dbcon = null;
    private String db_username = "webuser";
    private String db_password = "start1a";

    public DBI() {
        logger.info((Object)"Setting up connexion.");
        try {
            dbcon = new DBConnection("java:comp/env/jdbc/ANNEXUSERDB", this.db_username, this.db_password, "");
            con = dbcon.getConnection();
            logger.info((Object)"New DBI.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error((Object)"No DB available.");
            con = null;
        }
    }

    public void setUsernamePassword(String string, String string2) {
        this.db_username = string;
        this.db_password = string2;
    }

    public Connection getConnection() {
        return con;
    }

    public void open() {
        try {
            if (con == null) {
                dbcon = new DBConnection("java:comp/env/jdbc/ANNEXUSERDB", this.db_username, this.db_password, "");
                con = dbcon.getConnection();
                logger.info((Object)"Opened DB connexion.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error((Object)"No DB available.");
        }
    }

    public void close() {
        try {
            if (con != null) {
                con.close();
                logger.error((Object)"Closed DB connexion");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void store(String string, UserData userData) {
        if (string == "" || string == null) {
            string = "ANONYMOUS";
        }
        if (con != null) {
            this.sql_updatequery(string, userData);
            logger.info((Object)"Userdata stored.");
        } else {
            logger.error((Object)"con was null.");
        }
    }

    public void update(String string, UserData userData) {
        if (string == "" || string == null) {
            string = "ANONYMOUS";
        }
        if (con != null) {
            this.sql_updatequery(string, userData);
            logger.info((Object)"Userdata updated.");
        } else {
            logger.error((Object)"con was null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserData retrieve(String string) {
        if (string == "") {
            string = "ANONYMOUS";
        }
        UserData userData = null;
        logger.info((Object)("Retrieve: " + string));
        if (con == null) {
            logger.error((Object)"con was null. Returning default UserData.");
            userData = new UserData(string);
            return userData;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM users where id='" + string + "'");
            boolean bl = false;
            while (resultSet.next()) {
                bl = true;
                userData = new UserData(string);
                userData.fromString(resultSet.getString("kv"));
                logger.info((Object)resultSet.getString("lastaccess"));
            }
            if (bl) {
                logger.info((Object)"User retrieved.");
                this.sql_simplequery(sql_tstamp, string);
            } else {
                logger.info((Object)"User not found.");
                userData = new UserData(string);
                logger.info((Object)("Userdata (" + string + ") created."));
                this.sql_insertquery(string, userData);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            logger.info((Object)"Release.");
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    resultSet = null;
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    statement = null;
                }
            }
        }
        if (userData == null) {
            userData = new UserData(string);
        }
        return userData;
    }

    private void sql_simplequery(String string, String string2) {
        if (string2 == "" || string2 == null) {
            string2 = "ANONYMOUS";
        }
        try {
            PreparedStatement preparedStatement = con.prepareStatement(sql_tstamp);
            preparedStatement.setString(1, string2);
            int n = preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void sql_updatequery(String string, UserData userData) {
        if (string == "" || string == null) {
            string = "ANONYMOUS";
        }
        try {
            PreparedStatement preparedStatement = con.prepareStatement(sql_update);
            preparedStatement.setString(2, string);
            preparedStatement.setString(1, userData.toString());
            int n = preparedStatement.executeUpdate();
            preparedStatement.close();
            this.sql_simplequery(sql_tstamp, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void sql_insertquery(String string, UserData userData) {
        if (string == "" || string == null) {
            string = "ANONYMOUS";
        }
        try {
            PreparedStatement preparedStatement = con.prepareStatement(sql_insert);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, userData.toString());
            int n = preparedStatement.executeUpdate();
            preparedStatement.close();
            this.sql_simplequery(sql_tstamp, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dropTable() {
        Statement statement = null;
        String string = "DROP TABLE users";
        try {
            statement = con.createStatement();
            int n = statement.executeUpdate(string);
            statement.close();
            logger.info((Object)"DROP TABLE executed.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void createTable() {
        Statement statement = null;
        String string = "users";
        String string2 = "CREATE TABLE " + string + " (idx serial NOT NULL, id varchar(32), firstaccess timestamp default now(), lastaccess timestamp, kv text)";
        try {
            statement = con.createStatement();
            int n = statement.executeUpdate(string2);
            statement.close();
            string2 = "grant all on " + string + " to annex";
            statement = con.createStatement();
            n = statement.executeUpdate(string2);
            statement.close();
            string2 = "grant all on " + string + "_idx_seq to annex";
            statement = con.createStatement();
            n = statement.executeUpdate(string2);
            statement.close();
            string2 = "alter table " + string + " owner to webuser";
            statement = con.createStatement();
            n = statement.executeUpdate(string2);
            statement.close();
            logger.info((Object)"CREATE TABLE executed.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

