/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.view.FrameData;
import mpi.annex.view.SessionData;
import mpi.annex.view.Util;
import mpi.eudico.client.util.TimeFormatter;
import org.apache.log4j.Logger;

public class GenerateCSV
extends HttpServlet {
    private String webDir;
    private SessionData sd = null;
    private char sepChar = (char)44;
    private char quote = (char)34;
    private static Logger logger = Logger.getLogger((String)"ANNEX.GenerateCSV");

    public void init() {
        this.webDir = this.getServletContext().getRealPath("/") + "/";
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string;
        FrameData frameData;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        String string2 = httpSession.getId();
        String string3 = httpServletRequest.getParameter("key");
        HashMap hashMap = (HashMap)httpSession.getAttribute("sessions");
        SessionData sessionData = (SessionData)hashMap.get(string3);
        if (sessionData == null || sessionData.isInvalid()) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        String string4 = httpServletRequest.getParameter("type");
        if (string4 == null) {
            string4 = "CSV";
        }
        String string5 = "DF";
        String string6 = httpServletRequest.getParameter("frame");
        if (string6 != null) {
            logger.info((Object)("Frame=" + string6));
            string5 = string6;
        }
        if ((frameData = sessionData.getFrame(string5)) == null) {
            frameData = new FrameData(string5);
            sessionData.setFrame(string5, frameData);
        }
        if ((string = frameData.getVisibleTier(0)) == "") {
            return;
        }
        AnnexTranscription annexTranscription = sessionData.getAnnexTranscription();
        if (annexTranscription == null) {
            return;
        }
        AnnexTier annexTier = Util.getTierImplByName(string, annexTranscription);
        if (annexTier == null) {
            return;
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (string4 == "CSV") {
            httpServletResponse.setContentType("text/csv; charset=UTF-8");
            httpServletResponse.setHeader("Content-Disposition", "filename=" + string + ".txt");
            ArrayList arrayList = annexTier.annotations;
            if (arrayList == null) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                AnnexAnnotation annexAnnotation = (AnnexAnnotation)arrayList.get(i);
                String string7 = (String)annexAnnotation.value;
                string7 = string7.replaceAll("\"", "\"\"");
                String string8 = TimeFormatter.toString((long)annexAnnotation.beginTime);
                String string9 = TimeFormatter.toString((long)annexAnnotation.endTime);
                String string10 = this.quote + string7 + this.quote + this.sepChar + string8 + this.sepChar + string9 + this.sepChar;
                servletOutputStream.write(string10.getBytes("UTF-8"));
                string10 = "" + annexAnnotation.beginTime + this.sepChar;
                servletOutputStream.write(string10.getBytes("UTF-8"));
                string10 = "" + annexAnnotation.endTime + "\n";
                servletOutputStream.write(string10.getBytes("UTF-8"));
            }
        } else if (string4 == "Word") {
            // empty if block
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }
}

