/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.util.AnnexUtil;
import mpi.annex.view.AnnexHTMLTimeLineViewer;
import mpi.annex.view.FrameData;
import mpi.annex.view.HTMLRow;
import mpi.annex.view.HTMLSignalViewer;
import mpi.annex.view.HTMLTable;
import mpi.annex.view.IMArea;
import mpi.annex.view.SessionData;
import mpi.annex.view.UserData;
import mpi.annex.view.Util;
import mpi.eudico.client.util.TimeFormatter;
import org.apache.log4j.Logger;

public class GenerateIFHTML
extends HttpServlet {
    private String webDir;
    private SessionData sd = null;
    private static Logger logger = Logger.getLogger((String)"ANNEX.GenerateIFHTML");

    public void init() {
        this.webDir = this.getServletContext().getRealPath("/") + "/";
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        int n;
        Object object;
        Object object2;
        String string;
        Object object3;
        int n2;
        int n3;
        String string2;
        UserData userData;
        FrameData frameData;
        HashMap hashMap;
        SessionData sessionData;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        String string3 = httpSession.getId();
        String string4 = httpServletRequest.getParameter("key");
        if (string4 == null) {
            // empty if block
        }
        if ((sessionData = (SessionData)(hashMap = (HashMap)httpSession.getAttribute("sessions")).get(string4)) == null || sessionData.isInvalid()) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        int n4 = 0;
        if (httpSession.getAttribute("wsidx") != null) {
            n4 = (Integer)httpSession.getAttribute("wsidx");
        }
        int n5 = 10;
        while (sessionData.getLocked()) {
            logger.info((Object)" Waiting for lock.");
            if (--n5 == 0) {
                logger.info((Object)" Time out waiting for lock.");
                sessionData.setLocked(false);
                continue;
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                sessionData.setLocked(false);
            }
        }
        logger.info((Object)"GenerateIFHTML started.");
        AnnexTranscription annexTranscription = sessionData.getAnnexTranscription();
        if (annexTranscription == null) {
            logger.error((Object)"GenerateIFHTML called with null AT.");
            return;
        }
        sessionData.setLocked(true);
        boolean bl = false;
        String string5 = httpServletRequest.getParameter("nojs");
        if (string5 != null) {
            bl = true;
        }
        boolean bl2 = false;
        string5 = httpServletRequest.getParameter("popup");
        if (string5 != null) {
            bl2 = true;
        }
        String string6 = "DF";
        string5 = httpServletRequest.getParameter("frame");
        if (string5 != null) {
            logger.info((Object)("Frame=" + string5));
            string6 = string5;
        }
        String string7 = "text";
        string5 = httpServletRequest.getParameter("edit");
        if (string5 != null) {
            string7 = "text";
        }
        Object object4 = "";
        string5 = httpServletRequest.getParameter("sentenceid");
        if (string5 != null) {
            object4 = string5;
        }
        if ((frameData = sessionData.getFrame(string6)) == null) {
            frameData = new FrameData(string6);
            sessionData.setFrame(string6, frameData);
        }
        if ((string5 = httpServletRequest.getParameter("tlStart")) != null) {
            frameData.setTlStart(new Long(string5));
        }
        if ((string5 = httpServletRequest.getParameter("tlEnd")) != null) {
            frameData.setTlEnd(new Long(string5));
        }
        if ((string5 = httpServletRequest.getParameter("tlGoto")) != null) {
            frameData.setTlGoto(new Long(string5));
        }
        if ((string5 = httpServletRequest.getParameter("tlWidth")) != null) {
            frameData.setTlWidth(new Integer(string5));
        }
        if ((string5 = httpServletRequest.getParameter("tlCmd")) != null) {
            frameData.setTlCmd(string5);
        } else {
            frameData.setTlCmd("init");
        }
        string5 = httpServletRequest.getParameter("showgridtimes");
        if (string5 != null) {
            frameData.setShowGridTimes(string5.equals("1"));
        }
        if ((string5 = httpServletRequest.getParameter("annoid")) != null) {
            logger.info((Object)("Annoid: " + string5));
            frameData.setAnnoid(string5);
        }
        if ((userData = sessionData.getUserData()) == null) {
            logger.error((Object)"UserData is null.");
        }
        if ((string2 = httpServletRequest.getParameter("type")) == null) {
            string2 = frameData.getType();
        }
        string2.toLowerCase();
        if (string2.equals("empty") && string6.equals("MDF") && httpServletRequest.getParameter("tieridx") != null) {
            string2 = "text";
        }
        frameData.setType(string2);
        String string8 = httpServletRequest.getParameter("fontsize");
        if (string8 == null) {
            if (string6.equals("MDF")) {
                frameData.setCssFontSize("12");
            }
            string8 = frameData.getCssFontSize();
        }
        frameData.setCssFontSize(string8);
        String string9 = httpServletRequest.getParameter("tieridx");
        if (string9 == null) {
            string9 = "0";
        }
        int n6 = 0;
        n6 = new Integer(string9);
        String string10 = httpServletRequest.getParameter("tier");
        if (string10 == null && (string10 = frameData.getVisibleTier(0)) == null) {
            logger.error((Object)"No tiername!");
            sessionData.setLocked(false);
            return;
        }
        frameData.setVisibleTier(n6, string10);
        AnnexTier annexTier = Util.getTierImplByName(string10, annexTranscription);
        String string11 = httpServletRequest.getParameter("reset");
        if (string11 != null) {
            for (n3 = 1; n3 < frameData.getMaxVisibleTiers(); ++n3) {
                frameData.setVisibleTier(n3, "NONE");
            }
        }
        n3 = 0;
        for (int i = 0; i < frameData.getMaxVisibleTiers(); ++i) {
            if (frameData.getVisibleTier(i).equals("NONE")) continue;
            ++n3;
        }
        frameData.setVisibleTiers(n3);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setHeader("Expires", "0");
        servletOutputStream.println("<html><head>");
        int n7 = 100;
        if (frameData.getVisibleTiers() > 0) {
            n7 = 100 / frameData.getVisibleTiers();
        }
        if (!bl2) {
            n2 = 6;
            object3 = new String[][]{{"00px;", frameData.getCssFontSize() + "px;"}, {"_bkgsel_;", userData.getKV("bkgsel")}, {"_bkgovr_;", userData.getKV("bkgovr")}, {"_bkgcol_;", userData.getKV("bkgcol")}, {"_borcol_;", userData.getKV("borcol")}, {"_ctwdth_;", n7 + "%;"}};
            string = this.webDir + "if_style" + sessionData.getStyleSheet();
            servletOutputStream.println("<style type=\"text/css\">");
            servletOutputStream.println("<!--");
            try {
                object2 = new BufferedReader(new FileReader(string));
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    for (n = 0; n < n2; ++n) {
                        object = ((String)object).replaceAll(object3[n][0], (String)object3[n][1]);
                    }
                    servletOutputStream.println((String)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            servletOutputStream.println("-->");
            servletOutputStream.println("</style>");
        } else {
            servletOutputStream.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"if_style_popup.css\"/>");
        }
        if (!bl2) {
            servletOutputStream.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"ConventionsLana.css\"/>");
        }
        if (!bl) {
            servletOutputStream.println("<script src=\"aajx.js\" type=\"text/javascript\"></script>");
            servletOutputStream.println(" <script type=\"text/javascript\" src=\"/ds/dojo/dojo.js\"></script>");
            servletOutputStream.println("<script type=\"text/javascript\">dojo.require(\"dojo.event.*\");dojo.require(\"dojo.html.layout\");dojo.require(\"dojo.json\");</script>");
            servletOutputStream.println(" <script type=\"text/javascript\" src=\"mootools.v1.11.js\"></script>");
            servletOutputStream.println("<script src=\"if_common.js\" type=\"text/javascript\"></script>");
            servletOutputStream.println("<script type=\"text/javascript\" src=\"wz_jsgraphics.js\"></script>");
            if (string7 != null) {
                servletOutputStream.println("<script type=\"text/javascript\" src=\"edit.js\"></script>");
                servletOutputStream.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"edit" + sessionData.getStyleSheet() + "\"/>");
            }
        }
        if (string6.equals("MDF")) {
            servletOutputStream.println("<script src=\"subframe.js\" type=\"text/javascript\"></script>");
        }
        servletOutputStream.println("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
        servletOutputStream.println("<!--\n Generated by GenerateIFHTML.java\n-->");
        servletOutputStream.println("<script type=\"text/javascript\">");
        servletOutputStream.println("<!--");
        servletOutputStream.println("var mediaType = \"" + sessionData.getMediaType() + "\";");
        servletOutputStream.println("var visibleTiers = " + frameData.selectedTiers.size() + ";");
        servletOutputStream.println("var key = \"" + string4 + "\";");
        servletOutputStream.println("var jsessionid = \"" + sessionData.getJSessionID() + "\";");
        servletOutputStream.println("var mediaConnect = " + frameData.getMediaConnect() + ";");
        servletOutputStream.println("var multiTiers = [];");
        for (n2 = 0; n2 < frameData.getMaxVisibleTiers(); ++n2) {
            servletOutputStream.println("multiTiers[" + n2 + "] = \"" + frameData.getVisibleTier(n2) + "\";");
        }
        servletOutputStream.println("var hasVirtualTime = \"" + annexTranscription.hasVirtualTime() + "\";");
        servletOutputStream.println("//-->");
        servletOutputStream.println("</script>");
        servletOutputStream.println("</head>");
        if (string6.equals("MDF")) {
            servletOutputStream.println("<body>");
        } else {
            servletOutputStream.println("<body onload=\"initialize();\" >");
        }
        if (string2.equals("grid")) {
            n2 = frameData.getVisibleTiers();
            object3 = new ArrayList();
            for (int i = 0; i < n2; ++i) {
                annexTier = Util.getTierImplByName(frameData.getVisibleTier(i), annexTranscription);
                ((ArrayList)object3).add(i, annexTier);
            }
            ArrayList arrayList = this.generateArrayList((ArrayList)object3);
            object2 = "key=" + URLEncoder.encode(string4) + "&nodeid=" + URLEncoder.encode(sessionData.getNodeID());
            object = this.generateSuperGrid((ArrayList)object3, arrayList, frameData.getShowGridTimes(), (String)object2, sessionData.getNodeID());
            ((HTMLTable)object).output((OutputStream)servletOutputStream);
            if (!bl2) {
                servletOutputStream.println("<script type=\"text/javascript\">");
                servletOutputStream.println("<!--");
                servletOutputStream.println("var grfxType = \"grid\";");
                servletOutputStream.println("var browser = \"" + sessionData.getUaType() + "\";");
                servletOutputStream.println("var nodeID = \"" + sessionData.getNodeID() + "\";");
                servletOutputStream.println("var textTransSize = " + arrayList.size() + ";");
                servletOutputStream.println("var textTrans = [];");
                for (n = 0; n < arrayList.size(); ++n) {
                    SuperAnnotation superAnnotation = (SuperAnnotation)arrayList.get(n);
                    String string12 = "" + superAnnotation.aa.beginTime;
                    String string13 = "" + superAnnotation.aa.endTime;
                    String string14 = "0";
                    String string15 = superAnnotation.aa.id;
                    if (string15 == null) {
                        string15 = "none";
                    }
                    String string16 = ((AnnexTier)((ArrayList)object3).get((int)superAnnotation.tierIdx)).name;
                    String string17 = this.makeAdditID(superAnnotation.aa, sessionData.getNodeID(), string16);
                    if (n < arrayList.size() - 1) {
                        SuperAnnotation superAnnotation2 = (SuperAnnotation)arrayList.get(n + 1);
                        string14 = "" + superAnnotation2.aa.beginTime;
                    }
                    servletOutputStream.println("textTrans[" + n + "] = \"" + string12 + "," + string13 + "," + string14 + "," + this.makeSelectionHash(string16, n, superAnnotation.aa, 0) + "," + string15 + "," + string17 + "\";");
                }
                servletOutputStream.println("//-->");
                servletOutputStream.println("</script>");
            }
        } else if (string2.equals("timeline") || string2.equals("waveform") || string2.equals("combined")) {
            Object object5;
            Object object6;
            Object object7;
            String string18 = frameData.getTlCmd();
            long l = frameData.getTlStart();
            long l2 = frameData.getTlEnd();
            if (string18.equals("half")) {
                long l3 = (l2 - l) / 4L;
                l += l3;
                l2 -= l3;
            } else if (string18.equals("dbl")) {
                long l4 = (l2 - l) / 2L;
                if (string2.equals("waveform") && l4 > 30000L) {
                    l4 = 30000L;
                }
                if ((l -= l4) < 0L) {
                    l4 -= l;
                    l = 0L;
                }
                l2 += l4;
            } else if (string18.equals("left")) {
                long l5 = (l2 - l) / 2L;
                if (l - l5 < 0L) {
                    l5 = l;
                }
                l -= l5;
                l2 -= l5;
            } else if (string18.equals("right")) {
                long l6 = (l2 - l) / 2L;
                l += l6;
                l2 += l6;
            } else if (string18.equals("begin")) {
                long l7 = l2 - l;
                l = 0L;
                l2 = l7;
            } else if (string18.equals("end")) {
                long l8 = l2 - l;
                l2 = this.getTransEndTime(annexTranscription) + 1000L;
                l = l2 - l8;
                if (l < 0L) {
                    l = 0L;
                }
            } else if (string18.equals("reset")) {
                l = 0L;
                l2 = this.getTransEndTime(annexTranscription) + 1000L;
                if (string2.equals("waveform") && l2 > 60000L) {
                    l2 = 60000L;
                }
            } else if (string18.equals("1m")) {
                long l9 = 30000L;
                l = frameData.getTlGoto() - l9;
                if (l < 0L) {
                    l9 -= l;
                    l = 0L;
                }
                l2 = frameData.getTlGoto() + l9;
            } else if (string18.equals("10s")) {
                long l10 = 5000L;
                l = frameData.getTlGoto() - l10;
                if (l < 0L) {
                    l10 -= l;
                    l = 0L;
                }
                l2 = frameData.getTlGoto() + l10;
            } else if (string18.equals("goto")) {
                long l11 = l2 - l;
                long l12 = l11 * 2L / 10L;
                long l13 = l11 - l12;
                l = frameData.getTlGoto() - l12;
                if (l < 0L) {
                    l11 -= l;
                    l = 0L;
                }
                l2 = frameData.getTlGoto() + l13;
                if (frameData.selectedTiers.size() == 0) {
                    ArrayList arrayList = annexTranscription.getTiers();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object7 = (AnnexTier)arrayList.get(i);
                        String string19 = ((AnnexTier)object7).name;
                        frameData.selectedTiers.add(object7);
                    }
                }
            } else if (string18.equals("gotosel")) {
                logger.info((Object)"gotosel");
                n = 1;
                if (httpServletRequest.getParameter("nozoom") != null) {
                    n = 0;
                }
                logger.info((Object)("fd.getQtSelB(): " + frameData.getQtSelB()));
                logger.info((Object)("fd.getQtSelE(): " + frameData.getQtSelE()));
                long l14 = frameData.getQtSelE() - frameData.getQtSelB();
                logger.info((Object)("Selection: " + l14));
                if (l14 > 0L) {
                    logger.info((Object)("Adjust:" + (l14 /= 4L)));
                    l = frameData.getQtSelB() - l14;
                    if (l < 0L) {
                        l = 0L;
                    }
                    l2 = frameData.getQtSelE() + l14;
                }
                if (frameData.selectedTiers.size() == 0) {
                    object6 = annexTranscription.getTiers();
                    for (int i = 0; i < ((ArrayList)object6).size(); ++i) {
                        AnnexTier annexTier2 = (AnnexTier)((ArrayList)object6).get(i);
                        String string20 = annexTier2.name;
                        frameData.selectedTiers.add(annexTier2);
                    }
                }
            } else if (string18.equals("draw")) {
                AnnexTier annexTier3 = Util.getTierImplByName(string10, annexTranscription);
                if (frameData.selectedTiers.size() > 1) {
                    frameData.selectedTiers.remove(annexTier3);
                }
            } else if (string18.equals("init")) {
                if (frameData.selectedTiers.size() == 0) {
                    ArrayList arrayList = annexTranscription.getTiers();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        AnnexTier annexTier4 = (AnnexTier)arrayList.get(i);
                        object6 = annexTier4.name;
                        frameData.selectedTiers.add(annexTier4);
                    }
                }
                if ((string5 = httpServletRequest.getParameter("time")) != null) {
                    l = new Integer(string5).intValue();
                    frameData.setTlStart(l);
                    logger.info((Object)("TIME=" + string5));
                }
            } else if (string18.equals("move")) {
                AnnexTier annexTier5;
                int n8;
                n = 0;
                string5 = httpServletRequest.getParameter("pos");
                if (string5 != null) {
                    n = new Integer(string5);
                }
                if ((n8 = frameData.selectedTiers.indexOf(annexTier5 = Util.getTierImplByName(string10, annexTranscription))) == -1) {
                    frameData.selectedTiers.add(annexTier5);
                    n8 = frameData.selectedTiers.indexOf(annexTier5);
                }
                if (n != n8 && n8 >= 0 && n < frameData.selectedTiers.size()) {
                    AnnexTier annexTier6;
                    int n9;
                    object6 = frameData.selectedTiers;
                    Vector<AnnexTier> vector = new Vector<AnnexTier>(20);
                    int n10 = 0;
                    for (n9 = 0; n9 < ((Vector)object6).size(); ++n9) {
                        annexTier6 = (AnnexTier)((Vector)object6).get(n9);
                        object7 = annexTier6.name;
                        if (n9 == n8) continue;
                        vector.insertElementAt(annexTier6, n10);
                        if (n9 == n) {
                            ++n10;
                            vector.insertElementAt(annexTier5, n);
                        }
                        ++n10;
                    }
                    ((Vector)object6).clear();
                    for (n9 = 0; n9 < vector.size(); ++n9) {
                        annexTier6 = (AnnexTier)vector.get(n9);
                        object7 = annexTier6.name;
                        ((Vector)object6).add(n9, annexTier6);
                    }
                }
            }
            if (l2 - l < 100L) {
                l2 = l + 100L;
            } else if (string2.equals("waveform") && l2 - l > 30000L) {
                l2 = l + 30000L;
            }
            int n11 = frameData.getTlWidth();
            int n12 = 0;
            logger.info((Object)("tlWidth=" + n11 + " tlCmd=" + string18));
            logger.info((Object)("tlStart=" + l + " tlEnd=" + l2));
            logger.info((Object)("tlGoto=" + frameData.getTlGoto()));
            long l15 = System.currentTimeMillis();
            String string21 = "grfx_" + string4 + "." + l15 + ".png";
            File file = sessionData.getPNGFile();
            AnnexHTMLTimeLineViewer annexHTMLTimeLineViewer = null;
            HTMLSignalViewer hTMLSignalViewer = sessionData.getHtmlSV();
            long l16 = System.currentTimeMillis();
            if (string2.equals("timeline")) {
                n12 = frameData.selectedTiers.size() * 36 + 22;
                if (annexHTMLTimeLineViewer == null) {
                    annexHTMLTimeLineViewer = new AnnexHTMLTimeLineViewer(n11, n12);
                } else {
                    annexHTMLTimeLineViewer.setImageSize(n11, n12);
                }
                annexHTMLTimeLineViewer.setTimeSpan(l, l2);
                annexHTMLTimeLineViewer.draw();
            } else if (string2.equals("waveform")) {
                n12 = 200;
                if (hTMLSignalViewer == null) {
                    hTMLSignalViewer = new HTMLSignalViewer(n11, n12);
                    String string22 = sessionData.getAudioFile();
                    if (string22 != null) {
                        hTMLSignalViewer.setMedia(string22);
                    }
                    sessionData.setHtmlSV(hTMLSignalViewer);
                } else {
                    hTMLSignalViewer.setImageSize(n11, 200);
                }
                hTMLSignalViewer.setTimeSpan(l, l2);
                hTMLSignalViewer.draw();
            } else if (string2.equals("combined")) {
                int n13 = frameData.selectedTiers.size() * 36 + 22;
                if (annexHTMLTimeLineViewer == null) {
                    annexHTMLTimeLineViewer = new AnnexHTMLTimeLineViewer(n11, n13);
                } else {
                    annexHTMLTimeLineViewer.setImageSize(n11, n13);
                }
                int n14 = 100;
                if (hTMLSignalViewer == null) {
                    hTMLSignalViewer = new HTMLSignalViewer(n11, n14);
                    String string23 = sessionData.getAudioFile();
                    if (string23 != null) {
                        hTMLSignalViewer.setMedia(string23);
                    }
                    sessionData.setHtmlSV(hTMLSignalViewer);
                } else {
                    hTMLSignalViewer.setImageSize(n11, n14);
                }
                annexHTMLTimeLineViewer.setTimeSpan(l, l2);
                annexHTMLTimeLineViewer.draw();
                this.generateTimelinePNG(annexHTMLTimeLineViewer, frameData.selectedTiers, 80);
                hTMLSignalViewer.setTimeSpan(l, l2, 80);
                hTMLSignalViewer.draw();
                n12 = frameData.selectedTiers.size() * 36 + 22 - 20 + 100;
                file = this.combined(annexHTMLTimeLineViewer.getBufferedImage(), hTMLSignalViewer.getBufferedImage(), this.webDir + string21);
            }
            long l17 = System.currentTimeMillis();
            if (string2.equals("timeline")) {
                this.generateTimelinePNG(annexHTMLTimeLineViewer, frameData.selectedTiers, 0);
                file = annexHTMLTimeLineViewer.save(this.webDir + string21);
            }
            int n15 = 10;
            servletOutputStream.println("<div id=\"myCanvas\">");
            if (string2.equals("timeline")) {
                servletOutputStream.println("<img style=\"margin-top:" + n15 + "px;\" src=\"" + string21 + "\"" + annexHTMLTimeLineViewer.getIM().ref() + ">");
                object5 = new IMArea("rect");
                ((IMArea)object5).setHref("#");
                ((IMArea)object5).setOnmousedown("dragStart(event,this)");
                ((IMArea)object5).addCoordinate(0);
                ((IMArea)object5).addCoordinate(0);
                ((IMArea)object5).addCoordinate(n11);
                ((IMArea)object5).addCoordinate(n12);
                annexHTMLTimeLineViewer.getIM().addArea((IMArea)object5);
                annexHTMLTimeLineViewer.getIM().output((OutputStream)servletOutputStream);
            } else if (string2.equals("waveform")) {
                file = hTMLSignalViewer.save(this.webDir + string21);
                servletOutputStream.println("<img onmousedown=\"dragStart(event,this)\" style=\"margin-top:" + n15 + "px;\" st=\"" + l + "\" et=\"" + l2 + "\" src=\"" + string21 + "\">");
            } else if (string2.equals("combined")) {
                servletOutputStream.println("<img style=\"margin-top:" + n15 + "px;\" src=\"" + string21 + "\"" + annexHTMLTimeLineViewer.getIM().ref() + ">");
                object5 = new IMArea("rect");
                ((IMArea)object5).setHref("#");
                ((IMArea)object5).setOnmousedown("dragStart(event,this)");
                ((IMArea)object5).addCoordinate(0);
                ((IMArea)object5).addCoordinate(0);
                ((IMArea)object5).addCoordinate(n11);
                ((IMArea)object5).addCoordinate(n12);
                annexHTMLTimeLineViewer.getIM().addArea((IMArea)object5);
                annexHTMLTimeLineViewer.getIM().output((OutputStream)servletOutputStream);
            }
            sessionData.setPNGFile(file);
            sessionData.addPng(file);
            servletOutputStream.println("</div>");
            servletOutputStream.println("<div id=\"myCHCanvas\"></div>");
            servletOutputStream.println("<script type=\"text/javascript\">");
            servletOutputStream.println("<!--");
            servletOutputStream.println("var cc = new jsGraphics(\"myCHCanvas\");");
            servletOutputStream.println("var jg = new jsGraphics(\"myCanvas\");");
            servletOutputStream.println("var tlHeight = " + n12 + ";");
            servletOutputStream.println("var grfxTop = " + n15 + ";");
            servletOutputStream.println("var browser = \"" + sessionData.getUaType() + "\";");
            if (string2.equals("timeline") || string2.equals("combined")) {
                servletOutputStream.println("var msPerPixel = " + annexHTMLTimeLineViewer.getMsPerPixel() + ";");
                servletOutputStream.println("var nameWidth = " + annexHTMLTimeLineViewer.getNameWidth() + ";");
                servletOutputStream.println("var xOffset = " + annexHTMLTimeLineViewer.getXOffset() + ";");
                servletOutputStream.println("var intervalBeginTime = " + annexHTMLTimeLineViewer.getIntervalBeginTime() + ";");
                servletOutputStream.println("var intervalEndTime = " + l2 + ";");
                servletOutputStream.println("var grfxType = \"" + string2 + "\";");
                servletOutputStream.println("var selectedTiers = " + frameData.selectedTiers.size() + ";");
                servletOutputStream.println("var maxSelectedTiers = " + annexTranscription.getTiers().size() + ";");
                object5 = frameData.selectedTiers;
                servletOutputStream.println("var displayedTiers = [];");
                for (int i = 0; i < ((Vector)object5).size(); ++i) {
                    AnnexTier annexTier7 = (AnnexTier)((Vector)object5).get(i);
                    String string24 = annexTier7.name;
                    servletOutputStream.println("displayedTiers[" + i + "] = \"" + string24 + "\";");
                }
                Vector vector = annexHTMLTimeLineViewer.getIM().getAreas();
                servletOutputStream.println("var coords = {};");
                for (int i = 0; i < vector.size(); ++i) {
                    servletOutputStream.print("coords[\"" + ((IMArea)vector.elementAt(i)).getHCode() + "\"] = ");
                    servletOutputStream.println("\"" + ((IMArea)vector.elementAt(i)).getCoordinates() + "\";");
                }
            } else if (string2.equals("waveform")) {
                servletOutputStream.println("var msPerPixel = " + hTMLSignalViewer.getMsPerPixel() + ";");
                servletOutputStream.println("var nameWidth = " + hTMLSignalViewer.getNameWidth() + ";");
                servletOutputStream.println("var xOffset = " + hTMLSignalViewer.getXOffset() + ";");
                servletOutputStream.println("var intervalBeginTime = " + hTMLSignalViewer.getIntervalBeginTime() + ";");
                servletOutputStream.println("var grfxType = \"waveform\";");
                object5 = frameData.selectedTiers;
                servletOutputStream.println("var displayedTiers = [];");
                for (int i = 0; i < ((Vector)object5).size(); ++i) {
                    AnnexTier annexTier8 = (AnnexTier)((Vector)object5).get(i);
                    String string25 = annexTier8.name;
                    servletOutputStream.println("displayedTiers[" + i + "] = \"" + string25 + "\";");
                }
            }
            servletOutputStream.println("//-->");
            servletOutputStream.println("</script>");
            long l18 = System.currentTimeMillis();
            logger.info((Object)("Times: " + (l17 - l16) + " " + (l18 - l16)));
            frameData.setTlStart(l);
            frameData.setTlEnd(l2);
            frameData.setTlCmd(string18);
        } else if (string2.equals("text")) {
            n2 = frameData.getVisibleTiers();
            int n16 = frameData.getTlWidth() - 20;
            if (n2 > 0) {
                n16 = (frameData.getTlWidth() - n2 * 10 - 10) / n2;
            }
            n16 -= 20;
            if (string6.equals("MDF")) {
                n16 = 480;
                if (n2 == 0 && frameData.getVisibleTier(0) != "NONE") {
                    n2 = 1;
                }
            }
            for (int i = 0; i < n2; ++i) {
                String string26;
                String string27;
                String string28;
                String string29;
                AnnexAnnotation annexAnnotation;
                int n17;
                servletOutputStream.println("<div style=\"width:" + n16 + "px;\" class=\"textFrame\" id=\"textFrame" + i + "\">");
                annexTier = Util.getTierImplByName(frameData.getVisibleTier(i), annexTranscription);
                if (annexTier == null) continue;
                object2 = annexTier.annotations;
                for (n17 = 0; n17 < ((ArrayList)object2).size(); ++n17) {
                    annexAnnotation = (AnnexAnnotation)((ArrayList)object2).get(n17);
                    string29 = Util.HTMLEncode((String)annexAnnotation.value);
                    if (sessionData.getNodeID() == null) {
                        sessionData.setNodeID("local");
                    }
                    string28 = "key=" + URLEncoder.encode(string4) + "&nodeid=" + URLEncoder.encode(sessionData.getNodeID()) + "&tiername=" + URLEncoder.encode(frameData.getVisibleTier(i)) + "&annotationidx=" + n17;
                    if (string6.equals("MDF")) {
                        servletOutputStream.println("<span select=\"" + this.makeSelectionID(frameData.getVisibleTier(i), n17, annexAnnotation) + "\" id=\"" + this.makeSelectionHash(frameData.getVisibleTier(i), n17, annexAnnotation, i) + "\"  onmouseover=\"textTagMOver(this)\" onmouseout=\"textTagMOut(this)\" onclick=\"textTagClick(event,this);redrawTL();return false\" class=\"textTag\">" + string29 + "</span>");
                        continue;
                    }
                    string27 = annexAnnotation.id;
                    if (string27 == null) {
                        string27 = "none";
                    }
                    string26 = this.makeAdditID(annexAnnotation, sessionData.getNodeID(), frameData.getVisibleTier(i));
                    servletOutputStream.println("<span select=\"" + this.makeSelectionID(frameData.getVisibleTier(i), n17, annexAnnotation) + "\" eid='" + annexAnnotation.id + "' id=\"" + this.makeSelectionHash(frameData.getVisibleTier(i), n17, annexAnnotation, i) + "\" oncontextmenu=\"createEditBox(" + "'frame'" + ",'" + this.makeSelectionHash(frameData.getVisibleTier(i), n17, annexAnnotation, i) + "','" + string28 + "');return false;\" onmouseover=\"textTagMOver(this,'" + annexAnnotation.id + "')\" onmouseout=\"textTagMOut(this)\" onclick=\"textTagClick(event,this);createWebnote(event,'" + string26 + "');return false\" class=\"textTag\">" + string29 + "</span>");
                }
                servletOutputStream.println("<script type=\"text/javascript\">");
                servletOutputStream.println("<!--");
                servletOutputStream.println("var grfxType = \"text\";");
                servletOutputStream.println("var nodeID = \"" + sessionData.getNodeID() + "\";");
                servletOutputStream.println("var wsidx = \"" + n4 + "\";");
                servletOutputStream.println("var browser = \"" + sessionData.getUaType() + "\";");
                servletOutputStream.println("var textTransSize = " + ((ArrayList)object2).size() + ";");
                servletOutputStream.println("var textTrans = [];");
                for (n17 = 0; n17 < ((ArrayList)object2).size(); ++n17) {
                    annexAnnotation = (AnnexAnnotation)((ArrayList)object2).get(n17);
                    string29 = "" + annexAnnotation.beginTime;
                    string28 = "" + annexAnnotation.endTime;
                    string27 = "0";
                    string26 = annexAnnotation.id;
                    if (string26 == null) {
                        string26 = "none";
                    }
                    String string30 = this.makeAdditID(annexAnnotation, sessionData.getNodeID(), frameData.getVisibleTier(i));
                    if (n17 < ((ArrayList)object2).size() - 1) {
                        AnnexAnnotation annexAnnotation2 = (AnnexAnnotation)((ArrayList)object2).get(n17 + 1);
                        string27 = "" + annexAnnotation2.beginTime;
                    }
                    servletOutputStream.println("textTrans[" + n17 + "] = \"" + string29 + "," + string28 + "," + string27 + "," + this.makeSelectionHash(frameData.getVisibleTier(i), n17, annexAnnotation, i) + "," + string26 + "," + string30 + "\";");
                }
                servletOutputStream.println("//-->");
                servletOutputStream.println("</script>");
                servletOutputStream.println("</div>");
            }
        } else if (string2.equals("init")) {
            logger.info((Object)"INIT");
            servletOutputStream.println("<script type=\"text/javascript\">");
            servletOutputStream.println("<!--");
            servletOutputStream.println("var grfxType = \"init\";");
            servletOutputStream.println("var browser = \"" + sessionData.getUaType() + "\";");
            servletOutputStream.println("//-->");
            servletOutputStream.println("</script>");
            if (string6.equals("DF")) {
                servletOutputStream.println("<br><br><span class=\"notice\">Please wait while the page is loading...</span>");
            }
        } else if (string2.equals("syntaxtree")) {
            logger.info((Object)"SyntaxTree");
            servletOutputStream.println("<script type=\"text/javascript\">");
            servletOutputStream.println("<!--");
            servletOutputStream.println("var grfxType = \"syntaxtree\";");
            servletOutputStream.println("var browser = \"" + sessionData.getUaType() + "\";");
            servletOutputStream.println("//-->");
            servletOutputStream.println("</script>");
            servletOutputStream.println("<!-- Syntax viewer -->");
            String string31 = sessionData.getTigerPn();
            object3 = sessionData.getTigerSi();
            string31 = string31.replace("#", "%23");
            if (((String)object4).equals("")) {
                object4 = object3;
            }
            sessionData.setTigerSi((String)object4);
            string = AnnexUtil.getSyntaxViewerURL();
            if (string != null) {
                servletOutputStream.println("<img src=\"" + string + "?nodeid=" + string31 + "&sentenceId=" + (String)object4 + "&type=png\" />");
            }
        } else if (string2.equals("empty")) {
            // empty if block
        }
        servletOutputStream.println("</body></html>");
        sessionData.setLocked(false);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public long getTierEndTime(AnnexTier annexTier) {
        ArrayList arrayList = annexTier.annotations;
        if (arrayList == null) {
            return 0L;
        }
        AnnexAnnotation annexAnnotation = (AnnexAnnotation)arrayList.get(arrayList.size() - 1);
        return annexAnnotation.endTime;
    }

    public long getTransEndTime(AnnexTranscription annexTranscription) {
        long l = 0L;
        ArrayList arrayList = annexTranscription.getTiers();
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnexTier annexTier = (AnnexTier)arrayList.get(i);
            long l2 = this.getTierEndTime(annexTier);
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public void generateTimelinePNG(AnnexHTMLTimeLineViewer annexHTMLTimeLineViewer, Vector vector, int n) {
        try {
            for (int i = 0; i < vector.size(); ++i) {
                AnnexTier annexTier = (AnnexTier)vector.get(i);
                if (annexTier == null) continue;
                annexHTMLTimeLineViewer.paintTagOffset(annexTier, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String makeSelectionID(String string, int n, AnnexAnnotation annexAnnotation) {
        String string2 = "" + annexAnnotation.beginTime;
        String string3 = "" + annexAnnotation.endTime;
        return n + "," + string2 + "," + string3;
    }

    public String makeSelectionHash(String string, int n, AnnexAnnotation annexAnnotation, int n2) {
        String string2 = "" + annexAnnotation.beginTime;
        String string3 = "" + annexAnnotation.endTime;
        String string4 = "";
        if (string != null) {
            string4 = string.replaceAll("'", "_").replaceAll(" ", "_");
        }
        return string4 + string2 + string3 + n2;
    }

    public String makeAdditID(AnnexAnnotation annexAnnotation, String string, String string2) {
        String string3 = annexAnnotation.id + "&tier=" + string2 + "&time=" + annexAnnotation.beginTime + "&duration=" + (annexAnnotation.endTime - annexAnnotation.beginTime);
        String string4 = URLEncoder.encode(string + "_" + string3);
        return string4;
    }

    public ArrayList generateArrayList(ArrayList arrayList) {
        Object object;
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (AnnexTier)arrayList.get(i);
            if (object != null) {
                ArrayList arrayList3 = ((AnnexTier)object).annotations;
                ArrayList<SuperAnnotation> arrayList4 = new ArrayList<SuperAnnotation>(arrayList3.size());
                for (int j = 0; j < arrayList3.size(); ++j) {
                    SuperAnnotation superAnnotation = new SuperAnnotation();
                    superAnnotation.aa = (AnnexAnnotation)arrayList3.get(j);
                    superAnnotation.tierIdx = i;
                    arrayList4.add(j, superAnnotation);
                }
                arrayList2.add(i, arrayList4);
                continue;
            }
            arrayList2.add(i, new ArrayList(0));
        }
        ArrayList arrayList5 = (ArrayList)arrayList2.get(0);
        object = new AnnoComp();
        for (int i = 1; i < arrayList.size(); ++i) {
            arrayList5 = GenerateIFHTML.combine(arrayList5, (ArrayList)arrayList2.get(i), (Comparator)object, false);
        }
        return arrayList5;
    }

    public HTMLTable generateSuperGrid(ArrayList arrayList, ArrayList arrayList2, boolean bl, String string, String string2) {
        int n;
        HTMLTable hTMLTable = null;
        hTMLTable = bl ? new HTMLTable(arrayList.size() + 2) : new HTMLTable(arrayList.size());
        hTMLTable.setTableClass("tier");
        for (n = 0; n < arrayList.size(); ++n) {
            hTMLTable.setColumnClass(n, "cellText");
        }
        if (bl) {
            hTMLTable.setColumnClass(arrayList.size(), "cellTime");
            hTMLTable.setColumnClass(arrayList.size() + 1, "cellTime");
        }
        n = arrayList.size();
        boolean bl2 = false;
        boolean bl3 = true;
        HTMLRow hTMLRow = null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SuperAnnotation superAnnotation = (SuperAnnotation)arrayList2.get(i);
            if (bl3) {
                hTMLRow = hTMLTable.newRow();
            }
            String string3 = Util.HTMLEncode((String)superAnnotation.aa.value);
            hTMLRow.setElementAt(superAnnotation.tierIdx, string3);
            String string4 = ((AnnexTier)arrayList.get((int)superAnnotation.tierIdx)).name;
            String string5 = string + "&tiername=" + URLEncoder.encode(string4) + "&annotationidx=" + i;
            hTMLRow.addAttributeAt(superAnnotation.tierIdx, "oncontextmenu=\"createEditBox('frame','" + this.makeSelectionHash(string4, i, superAnnotation.aa, superAnnotation.tierIdx) + ",0" + "','" + string5 + "');return false;\"");
            hTMLRow.addAttributeAt(superAnnotation.tierIdx, "select=\"" + this.makeSelectionID(string4, i, superAnnotation.aa) + "\"");
            hTMLRow.addAttributeAt(superAnnotation.tierIdx, "id=\"" + this.makeSelectionHash(string4, i, superAnnotation.aa, superAnnotation.tierIdx) + ",0\"");
            String string6 = superAnnotation.aa.id;
            if (string6 == null) {
                string6 = "none";
            }
            hTMLRow.addAttributeAt(superAnnotation.tierIdx, "eid=\"" + string6 + "\"");
            String string7 = this.makeAdditID(superAnnotation.aa, string2, string4);
            hTMLRow.addAttributeAt(superAnnotation.tierIdx, "onclick=\"gridTagClick(event,this);createWebnote(event,'" + string7 + "');return false;\"");
            hTMLRow.addAttributeAt(superAnnotation.tierIdx, "style=\"cursor:pointer;\"");
            if (bl) {
                hTMLRow.setElementAt(n, TimeFormatter.toString((long)superAnnotation.aa.beginTime));
                hTMLRow.setElementAt(n + 1, TimeFormatter.toString((long)superAnnotation.aa.endTime));
            }
            if (i >= arrayList2.size() - 1) continue;
            SuperAnnotation superAnnotation2 = (SuperAnnotation)arrayList2.get(i + 1);
            bl3 = superAnnotation.aa.beginTime != superAnnotation2.aa.beginTime;
        }
        return hTMLTable;
    }

    public static ArrayList combine(ArrayList arrayList, ArrayList arrayList2, Comparator comparator, boolean bl) {
        int n;
        if (!bl) {
            Collections.sort(arrayList, comparator);
            Collections.sort(arrayList2, comparator);
        }
        int n2 = arrayList.size();
        int n3 = arrayList2.size();
        ArrayList arrayList3 = new ArrayList(n2 + n3);
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2 && n5 < n3) {
            Object e;
            Object e2 = arrayList.get(n4);
            int n6 = comparator.compare(e2, e = arrayList2.get(n5));
            if (n6 <= 0) {
                arrayList3.add(e2);
                ++n4;
                continue;
            }
            arrayList3.add(e);
            ++n5;
        }
        for (n = n4; n < n2; ++n) {
            arrayList3.add(arrayList.get(n));
        }
        for (n = n5; n < n3; ++n) {
            arrayList3.add(arrayList2.get(n));
        }
        return arrayList3;
    }

    public File combined(BufferedImage bufferedImage, BufferedImage bufferedImage2, String string) {
        Color color = new Color(230, 230, 230);
        int n = 20;
        int n2 = 80;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = bufferedImage2.getWidth();
        int n6 = bufferedImage2.getHeight();
        int n7 = n4 + n6 - n;
        int n8 = n3;
        BufferedImage bufferedImage3 = new BufferedImage(n8, n7, 1);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n8, n7);
        graphics2D.drawImage(bufferedImage, null, 0, n6 - n);
        graphics2D.drawImage(bufferedImage2, null, n2, 0);
        try {
            File file = new File(string);
            ImageIO.write((RenderedImage)bufferedImage3, "png", file);
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public class AnnoComp
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (((SuperAnnotation)object).aa.beginTime < ((SuperAnnotation)object2).aa.beginTime) {
                return -1;
            }
            if (((SuperAnnotation)object).aa.beginTime == ((SuperAnnotation)object2).aa.beginTime) {
                return 0;
            }
            return 1;
        }
    }

    public class SuperAnnotation {
        public AnnexAnnotation aa;
        public int tierIdx;
    }
}

