/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.OutputStream;
import mpi.annex.view.HTML;
import mpi.annex.view.HTMLTable;

public class HTMLRow {
    private int numElements;
    private Object[] elements;
    private String[] attributes;

    public HTMLRow(int n) {
        this.numElements = n;
        this.elements = new Object[n];
        this.attributes = new String[n];
    }

    public HTMLRow(int n, String[] stringArray) {
        this.numElements = n;
        this.elements = new Object[n];
        this.attributes = new String[n];
        for (int i = 0; i < n; ++i) {
            this.attributes[i] = "class=\"" + stringArray[i] + "\"";
        }
    }

    public Object elementAt(int n) {
        return this.elements[n];
    }

    public void setElementAt(int n, Object object) {
        this.elements[n] = object;
    }

    public void setAttributeAt(int n, String string) {
        this.attributes[n] = string;
    }

    public void addAttributeAt(int n, String string) {
        int n2 = n;
        this.attributes[n2] = this.attributes[n2] + " " + string;
    }

    public String getAttributeAt(int n) {
        return this.attributes[n];
    }

    public void output(OutputStream outputStream) {
        try {
            HTML.prt(outputStream, "<tr>");
            for (int i = 0; i < this.numElements; ++i) {
                HTML.prt(outputStream, "<td");
                if (this.attributes[i] != null) {
                    HTML.prt(outputStream, " " + this.attributes[i]);
                }
                HTML.prt(outputStream, ">");
                if (this.elementAt(i) instanceof HTMLTable) {
                    ((HTMLTable)this.elementAt(i)).output(outputStream);
                } else if (this.elementAt(i) == null) {
                    HTML.prt(outputStream, "&nbsp;");
                } else {
                    HTML.prt(outputStream, (String)this.elementAt(i));
                }
                HTML.prt(outputStream, "</td>");
            }
            HTML.prt(outputStream, "</tr>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<tr>");
        for (int i = 0; i < this.numElements; ++i) {
            stringBuffer.append("<td");
            if (this.attributes[i] != null) {
                stringBuffer.append(" " + this.attributes[i]);
            }
            stringBuffer.append(">");
            if (!(this.elementAt(i) instanceof HTMLTable)) {
                if (this.elementAt(i) == null) {
                    stringBuffer.append("&nbsp;");
                } else {
                    stringBuffer.append((String)this.elementAt(i));
                }
            }
            stringBuffer.append("</td>");
        }
        stringBuffer.append("</tr>");
        return stringBuffer.toString();
    }
}

