/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.viewer.TimeRuler;
import mpi.eudico.client.annotator.viewer.TimeScaleBasedViewer;
import mpi.eudico.client.annotator.viewer.WavePart;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.util.TimeFormatter;
import mpi.eudico.client.util.WAVCuePoint;
import mpi.eudico.client.util.WAVSampler;

public class HTMLSignalViewer
extends TimeScaleBasedViewer {
    public static final int MONO = 0;
    public static final int STEREO_SEPARATE = 1;
    public static final int STEREO_MERGED = 2;
    public static final int STEREO_BLENDED = 3;
    static final int PIXELS_FOR_SECOND = 100;
    private int channelMode;
    private final int GAP = 4;
    private int rulerHeight;
    private BufferedImage bi;
    private Graphics2D big2d;
    private AlphaComposite alpha04;
    private AlphaComposite alpha07;
    private WavePart currentPart;
    private final int SCREEN_BUFFER = 1;
    private WAVSampler samp;
    public final int DEFAULT_MS_PER_PIXEL = 10;
    private int msPerPixel;
    private int samplesPerPixel;
    private int resolution;
    private TimeRuler ruler;
    private int maxAmplitude;
    private int imageWidth;
    private int imageHeight;
    private long crossHairTime;
    private int crossHairPos;
    private long intervalBeginTime;
    private long intervalEndTime;
    private long dragStartTime;
    private long selectionBeginTime;
    private long selectionEndTime;
    private int selectionBeginPos;
    private int selectionEndPos;
    private Point dragStartPoint;
    private Point dragEndPoint;
    public final int SCROLL_OFFSET = 16;
    private boolean timeScaleConnected;
    private boolean panMode;
    private final Object paintlock = new Object();
    private long mediaOffset;
    private String mediaFilePath;
    boolean stopScrolling = true;
    boolean allowConnecting = false;
    private Color selectionColor = Constants.SELECTIONCOLOR;

    public HTMLSignalViewer() {
        this.initViewer();
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    public HTMLSignalViewer(int n, int n2) {
        this.initViewer();
        this.imageWidth = n;
        this.imageHeight = n2;
        double d = (double)(this.intervalEndTime - this.intervalBeginTime) / (double)n;
        int n3 = (int)Math.ceil(d);
        if (n3 == 0) {
            n3 = 1;
        }
        this.setLocalTimeScaleMsPerPixel(n3);
        this.bi = new BufferedImage(n, n2, 1);
        this.big2d = this.bi.createGraphics();
        this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.big2d.fillRect(0, 0, n, n2);
        this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
    }

    public void setImageSize(int n, int n2) {
        this.imageWidth = n;
        this.imageHeight = n2;
        double d = (double)(this.intervalEndTime - this.intervalBeginTime) / (double)n;
        int n3 = (int)Math.ceil(d);
        if (n3 == 0) {
            n3 = 1;
        }
        this.setLocalTimeScaleMsPerPixel(n3);
        this.bi = new BufferedImage(n, n2, 1);
        this.big2d = this.bi.createGraphics();
        this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.big2d.fillRect(0, 0, n, n2);
        this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
    }

    private void initViewer() {
        this.ruler = new TimeRuler(Constants.DEFAULTFONT, TimeFormatter.toString((long)0L));
        this.rulerHeight = this.ruler.getHeight();
        this.channelMode = 2;
        this.msPerPixel = 10;
        this.samplesPerPixel = this.msPerPixel * 44100 / 1000;
        this.resolution = 100;
        this.maxAmplitude = Short.MAX_VALUE;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.crossHairTime = 0L;
        this.crossHairPos = 0;
        this.intervalBeginTime = 0L;
        this.intervalEndTime = 0L;
        this.dragStartTime = 0L;
        this.selectionBeginTime = 0L;
        this.selectionEndTime = 0L;
        this.selectionBeginPos = 0;
        this.selectionEndPos = 0;
        this.alpha04 = AlphaComposite.getInstance(3, 0.4f);
        this.alpha07 = AlphaComposite.getInstance(3, 0.7f);
        this.currentPart = new WavePart(1);
        this.timeScaleConnected = false;
        this.mediaOffset = 0L;
    }

    public void setTimeSpan(long l, long l2) {
        this.intervalBeginTime = l;
        this.intervalEndTime = l2;
        int n = (int)(l2 - l) / this.imageWidth;
        if (n == 0) {
            n = 1;
        }
        this.setLocalTimeScaleMsPerPixel(n);
        this.setIntervalBeginTime(l);
        this.setMediaTime(l);
        this.loadData(l, l2, this.imageWidth);
        this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.big2d.fillRect(0, 0, this.imageWidth, this.imageHeight);
    }

    public void setTimeSpan(long l, long l2, int n) {
        this.intervalBeginTime = l;
        this.intervalEndTime = l2;
        double d = (double)(l2 - l) / (double)(this.imageWidth - n);
        int n2 = (int)Math.ceil(d);
        if (n2 == 0) {
            n2 = 1;
        }
        this.setLocalTimeScaleMsPerPixel(n2);
        this.setIntervalBeginTime(l);
        this.setMediaTime(l);
        this.loadData(l, l2, this.imageWidth);
        this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.big2d.fillRect(0, 0, this.imageWidth, this.imageHeight);
    }

    public void setMedia(String string) {
        if (!string.endsWith("wav")) {
            int n = string.lastIndexOf(46);
            string = n > 0 ? string.substring(0, n) + ".wav" : string + ".wav";
        }
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        this.mediaFilePath = string;
        this.initLoad(string);
        this.paintBuffer();
    }

    public long getSignalDuration() {
        return (long)this.samp.getDuration();
    }

    public int getNameWidth() {
        return 0;
    }

    private int timeToPixels(long l) {
        return (int)l / this.msPerPixel;
    }

    public int getXOffset() {
        return this.timeToPixels(this.intervalBeginTime);
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    private void initLoad(String string) {
        try {
            this.samp = new WAVSampler(string);
        }
        catch (IOException iOException) {
            System.out.println("Failed to create a WAVSampler");
        }
        if (this.samp != null) {
            this.samplesPerPixel = this.msPerPixel * this.samp.getSampleFrequency() / 1000;
            this.maxAmplitude = Math.max(this.samp.getPossibleMaxSample(), Math.abs(this.samp.getPossibleMinSample()));
            if (this.samp.getWavHeader().getNumberOfChannels() == 1) {
                this.channelMode = 0;
            } else if (this.samp.getWavHeader().getNumberOfChannels() == 2) {
                this.channelMode = 1;
            }
        }
        int n = 2000;
        this.loadData(0L, this.msPerPixel, n);
    }

    private boolean loadData(long l, long l2, int n) {
        if (this.samp == null) {
            return false;
        }
        if ((float)(l += this.mediaOffset) > this.samp.getDuration() || l > (l2 += this.mediaOffset) || l2 < 0L) {
            return false;
        }
        long l3 = l2 > (long)this.samp.getDuration() ? (long)this.samp.getDuration() : l2;
        long l4 = l < this.mediaOffset ? this.mediaOffset : l;
        long l5 = l4 / (long)this.msPerPixel;
        long l6 = l3 / (long)this.msPerPixel;
        int n2 = (int)(l6 - l5) + 1;
        int n3 = n2 > n ? n2 : n;
        double d = l4 * (long)this.samp.getSampleFrequency() / 1000L;
        this.samp.seekSample((long)d);
        int n4 = 0;
        int n5 = (int)l5;
        switch (this.channelMode) {
            case 0: 
            case 2: {
                this.currentPart.reset();
                this.currentPart.setInterval(l4, l3, n5, n3, n2);
                n4 = this.samp.readInterval(n2 * this.samplesPerPixel, 1);
                int n6 = 0;
                for (int i = n5; n6 < n4 - this.samplesPerPixel && i < n5 + n3; n6 += this.samplesPerPixel, ++i) {
                    int n7 = 0;
                    int n8 = 0;
                    for (int j = 0; j < this.samplesPerPixel; ++j) {
                        int n9 = this.samp.getFirstChannelArray()[n6 + j];
                        if (n9 < n7) {
                            n7 = n9;
                            continue;
                        }
                        if (n9 <= n8) continue;
                        n8 = n9;
                    }
                    this.currentPart.addLineToFirstChannel(i, -n8, -n7);
                }
                break;
            }
            case 1: 
            case 3: {
                this.currentPart.reset();
                this.currentPart.setInterval(l4, l3, n5, n3, n2);
                n4 = this.samp.readInterval(n2 * this.samplesPerPixel, 2);
                int n10 = 0;
                for (int i = n5; n10 < n4 - this.samplesPerPixel && i < n5 + n3; n10 += this.samplesPerPixel, ++i) {
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    for (int j = 0; j < this.samplesPerPixel; ++j) {
                        int n15 = this.samp.getFirstChannelArray()[n10 + j];
                        if (n15 < n11) {
                            n11 = n15;
                        } else if (n15 > n12) {
                            n12 = n15;
                        }
                        int n16 = this.samp.getSecondChannelArray()[n10 + j];
                        if (n16 < n13) {
                            n13 = n16;
                            continue;
                        }
                        if (n16 <= n14) continue;
                        n14 = n16;
                    }
                    this.currentPart.addLineToFirstChannel(i, -n12, -n11);
                    this.currentPart.addLineToRightChannel(i, -n14, -n13);
                }
                break;
            }
        }
        return true;
    }

    public void draw() {
        this.paintBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBuffer() {
        if (this.intervalEndTime == 0L) {
            this.intervalEndTime = this.intervalBeginTime + (long)(this.imageWidth * this.msPerPixel);
        }
        Object object = this.paintlock;
        synchronized (object) {
            int n;
            int n2;
            if (this.bi == null || this.bi.getWidth() < this.imageWidth || this.bi.getHeight() < this.imageHeight) {
                this.bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
                this.big2d = this.bi.createGraphics();
            }
            if (!this.currentPart.contains(this.intervalBeginTime, this.intervalEndTime)) {
                n2 = this.loadData(this.intervalBeginTime, this.intervalBeginTime + (long)(1 * this.imageWidth * this.msPerPixel), this.imageWidth);
            }
            int n3 = (int)(this.intervalBeginTime / (long)this.msPerPixel);
            int n4 = (int)((this.intervalBeginTime + this.mediaOffset) / (long)this.msPerPixel);
            int n5 = (int)((this.intervalEndTime + this.mediaOffset) / (long)this.msPerPixel);
            AffineTransform affineTransform = new AffineTransform();
            this.big2d.setComposite(AlphaComposite.Src);
            this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
            this.big2d.fillRect(0, 0, this.imageWidth, this.imageHeight);
            if (this.intervalEndTime > this.getMediaDuration()) {
                n = this.xAt(this.getMediaDuration());
                this.big2d.setColor(UIManager.getColor("Panel.background"));
                this.big2d.fillRect(n, 0, this.imageWidth - n, this.bi.getHeight());
            }
            this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            this.big2d.translate((double)(-n3), 0.0);
            this.ruler.paint(this.big2d, this.intervalBeginTime, this.imageWidth, (float)this.msPerPixel, 1);
            this.big2d.translate((double)(n3 - n4), 0.0);
            switch (this.channelMode) {
                case 0: 
                case 2: {
                    n2 = this.imageHeight - this.rulerHeight;
                    n = this.rulerHeight + Math.round((float)n2 / 2.0f);
                    this.big2d.translate(0.0, (double)n);
                    this.big2d.drawLine(n4, 0, n5, 0);
                    affineTransform.setToScale(1.0, (float)n2 / (float)this.maxAmplitude / 2.0f);
                    this.currentPart.paintLeftChannel(this.big2d, affineTransform);
                    this.big2d.translate(0.0, (double)(-n));
                    break;
                }
                case 1: {
                    n2 = (this.imageHeight - this.rulerHeight - 4) / 2;
                    int n6 = this.rulerHeight + (int)Math.ceil((float)n2 / 2.0f);
                    int n7 = this.imageHeight - (int)Math.ceil((float)n2 / 2.0f);
                    this.big2d.setColor(Constants.SIGNALCHANNELCOLOR);
                    this.big2d.fillRect(n4, this.rulerHeight, this.imageWidth + 2, n2);
                    this.big2d.fillRect(n4, this.imageHeight - n2, this.imageWidth + 2, n2);
                    this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                    this.big2d.translate(0.0, (double)n6);
                    this.big2d.drawLine(n4, 0, n5, 0);
                    affineTransform.setToScale(1.0, (float)n2 / (float)this.maxAmplitude / 2.0f);
                    this.currentPart.paintLeftChannel(this.big2d, affineTransform);
                    this.big2d.translate(0.0, (double)(n7 - n6));
                    this.big2d.drawLine(n4, 0, n5, 0);
                    this.currentPart.paintRightChannel(this.big2d, affineTransform);
                    this.big2d.translate(0.0, (double)(-n7));
                    break;
                }
                case 3: {
                    n2 = this.imageHeight - this.rulerHeight;
                    int n8 = this.rulerHeight + Math.round((float)n2 / 2.0f);
                    this.big2d.translate(0.0, (double)n8);
                    this.big2d.drawLine(n4, 0, n5, 0);
                    affineTransform.setToScale(1.0, (float)n2 / (float)this.maxAmplitude / 2.0f);
                    this.big2d.setColor(Constants.SIGNALSTEREOBLENDEDCOLOR1);
                    this.currentPart.paintLeftChannel(this.big2d, affineTransform);
                    this.big2d.setColor(Constants.SIGNALSTEREOBLENDEDCOLOR2);
                    this.big2d.setComposite(this.alpha04);
                    this.currentPart.paintRightChannel(this.big2d, affineTransform);
                    this.big2d.setComposite(AlphaComposite.Src);
                    this.big2d.translate(0.0, (double)(-n8));
                    break;
                }
            }
            this.drawCuePoints(this.big2d);
            this.big2d.setTransform(new AffineTransform());
        }
    }

    private void drawCuePoints(Graphics2D graphics2D) {
        if (this.samp == null) {
            return;
        }
        WAVCuePoint[] wAVCuePointArray = this.samp.getWavHeader().getCuePoints();
        if (wAVCuePointArray.length > 0) {
            this.big2d.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{4.0f}, 0.0f));
            this.big2d.setColor(Color.darkGray);
            for (int i = 0; i < wAVCuePointArray.length; ++i) {
                int n = (int)this.samp.getTimeAtSample((long)wAVCuePointArray[i].getSampleOffset());
                int n2 = n / this.msPerPixel;
                if (this.intervalBeginTime > (long)n || (long)n >= this.intervalEndTime) continue;
                this.big2d.drawLine(n2, this.rulerHeight, n2, this.imageHeight);
                String string = wAVCuePointArray[i].getLabel();
                String string2 = wAVCuePointArray[i].getNote();
                if (string != null && string2 != null) {
                    string = string + " : ";
                }
                this.big2d.drawString((string != null ? string : new Integer(i).toString()) + (string2 != null ? string2 : ""), n2 + 1, this.imageHeight - 1);
            }
            this.big2d.setStroke(new BasicStroke());
        }
    }

    public void drawKANWEG() {
        int n = this.getHeight();
        if (this.bi != null) {
            this.big2d.drawImage((Image)this.bi, 0, 0, (ImageObserver)((Object)this));
        }
        if (this.selectionBeginPos != this.selectionEndPos) {
            this.big2d.setColor(this.selectionColor);
            this.big2d.setComposite(this.alpha04);
            this.big2d.fillRect(this.selectionBeginPos, 0, this.selectionEndPos - this.selectionBeginPos, this.rulerHeight);
            this.big2d.setComposite(this.alpha07);
            this.big2d.fillRect(this.selectionBeginPos, this.rulerHeight, this.selectionEndPos - this.selectionBeginPos, n - this.rulerHeight);
            this.big2d.setComposite(AlphaComposite.Src);
        }
        this.big2d.setColor(Constants.CROSSHAIRCOLOR);
        this.big2d.drawLine(this.crossHairPos, 0, this.crossHairPos, n);
    }

    public void paintSelection(long l, long l2) {
        this.selectionBeginTime = l;
        this.selectionEndTime = l2;
        int n = this.xAt(l);
        int n2 = this.xAt(l2);
        this.big2d.setColor(this.selectionColor);
        this.big2d.setComposite(this.alpha04);
        this.big2d.fillRect(n, 0, n2 - n, this.rulerHeight);
        this.big2d.setComposite(this.alpha07);
        this.big2d.fillRect(n, this.rulerHeight, n2 - n, this.imageHeight - this.rulerHeight);
        this.big2d.setComposite(AlphaComposite.Src);
    }

    public void paintPosition(long l) {
        int n = this.xAt(l);
        this.big2d.setColor(Constants.CROSSHAIRCOLOR);
        this.big2d.drawLine(n, this.rulerHeight, n, this.imageHeight);
    }

    public void updateTimeScale() {
        if (this.getGlobalTimeScaleIntervalBeginTime() != this.intervalBeginTime) {
            this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
        }
    }

    public void setMsPerPixel(int n) {
        this.setLocalTimeScaleMsPerPixel(n);
    }

    private void setLocalTimeScaleMsPerPixel(int n) {
        if (this.msPerPixel == n) {
            return;
        }
        this.msPerPixel = n >= 1 ? n : 1;
        this.resolution = (int)(1000.0f / (float)this.msPerPixel);
        long l = this.getMediaTime();
        int n2 = this.crossHairPos;
        int n3 = (int)(l / (long)this.msPerPixel);
        int n4 = (int)(l / (long)(this.imageWidth * this.msPerPixel));
        int n5 = n3 - n4 * this.imageWidth;
        int n6 = n2 - n5;
        this.intervalBeginTime = (n4 * this.imageWidth - n6) * this.msPerPixel;
        if (this.intervalBeginTime < 0L) {
            this.intervalBeginTime = 0L;
        }
        this.intervalEndTime = this.intervalBeginTime + (long)(this.imageWidth * this.msPerPixel);
        this.crossHairPos = this.xAt(l);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        if (this.samp != null) {
            this.samplesPerPixel = this.msPerPixel * this.samp.getSampleFrequency() / 1000;
        }
        this.currentPart.setStartTime(0L);
        this.currentPart.setStopTime(0L);
        this.paintBuffer();
        int n7 = (int)(100.0f * (10.0f / (float)this.msPerPixel));
        if (n7 <= 0) {
            n7 = 100;
        }
    }

    public int getMsPerPixel() {
        return this.msPerPixel;
    }

    public void setResolution(int n) {
        this.resolution = n;
        int n2 = (int)(1000.0f / (float)n);
        this.setMsPerPixel(n2);
    }

    public void setResolutionFactor(float f) {
        int n = (int)(100.0f * f);
        this.setResolution(n);
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getChannelMode() {
        return this.channelMode;
    }

    public void setChannelMode(int n) {
        if (n == this.channelMode) {
            return;
        }
        if (n <= 0 || n > 3) {
            this.channelMode = 0;
        } else {
            if (this.samp != null && this.samp.getWavHeader().getNumberOfChannels() != 2) {
                return;
            }
            this.channelMode = n;
        }
        this.paintBuffer();
    }

    public int xAt(long l) {
        return (int)(l - this.intervalBeginTime) / this.msPerPixel;
    }

    public long timeAt(int n) {
        return this.intervalBeginTime + (long)(n * this.msPerPixel);
    }

    public long getIntervalBeginTime() {
        return this.intervalBeginTime;
    }

    public long getIntervalEndTime() {
        return this.intervalEndTime;
    }

    public void setIntervalBeginTime(long l) {
        this.setLocalTimeScaleIntervalBeginTime(l);
    }

    private void recalculateInterval(long l) {
        long l2;
        long l3;
        if (l < this.intervalBeginTime) {
            l3 = l - (long)(16 * this.msPerPixel);
            if (l3 < 0L) {
                l3 = 0L;
            }
            l2 = l3 + (long)(this.imageWidth * this.msPerPixel);
        } else {
            l2 = l + (long)(16 * this.msPerPixel);
            l3 = l2 - (long)(this.imageWidth * this.msPerPixel);
            if (l3 < 0L) {
                l3 = 0L;
                l2 = l3 + (long)(this.imageWidth * this.msPerPixel);
            }
        }
        if (l3 == this.getSelectionBeginTime() && l3 > (long)(16 * this.msPerPixel)) {
            l2 = (l3 -= (long)(16 * this.msPerPixel)) + (long)(this.imageWidth * this.msPerPixel);
        }
        if (l2 == this.getSelectionEndTime() && (l3 = (l2 += (long)(16 * this.msPerPixel)) - (long)(this.imageWidth * this.msPerPixel)) < 0L) {
            l3 = 0L;
            l2 = l3 + (long)(this.imageWidth * this.msPerPixel);
        }
        this.setLocalTimeScaleIntervalBeginTime(l3);
    }

    private void setLocalTimeScaleIntervalBeginTime(long l) {
        if (l == this.intervalBeginTime) {
            return;
        }
        this.intervalBeginTime = l;
        this.intervalEndTime = this.intervalBeginTime + (long)(this.imageWidth * this.msPerPixel);
        this.crossHairPos = this.xAt(this.crossHairTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.paintBuffer();
    }

    public void setOffset(long l) {
        if (l != this.mediaOffset) {
            this.mediaOffset = l;
            this.currentPart.setStartTime(0L);
            this.currentPart.setStopTime(0L);
            this.paintBuffer();
        }
    }

    public void updateSelection() {
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.repaint();
    }

    public int getLeftMargin() {
        return 0;
    }

    public int getRightMargin() {
        return 0;
    }

    private void printMem(String string) {
        System.out.println(string);
        Runtime runtime = Runtime.getRuntime();
        System.out.println("Total memory: " + runtime.totalMemory() / 1024L + " Kb");
        System.out.println("Free memory: " + runtime.freeMemory() / 1024L + " Kb");
    }

    public void finalize() {
        if (this.samp != null) {
            this.samp.close();
        }
    }

    synchronized void scroll(int n) {
        long l = this.intervalBeginTime + (long)(n * this.msPerPixel);
        if (n > 0) {
            this.setIntervalBeginTime(l);
            this.selectionEndTime = this.getSelectionEndTime() + (long)(n * this.msPerPixel);
            if (this.samp != null && (float)this.selectionEndTime > this.samp.getDuration()) {
                this.selectionEndTime = (long)this.samp.getDuration();
            }
            this.setMediaTime(this.selectionEndTime);
            this.setSelection(this.getSelectionBeginTime(), this.selectionEndTime);
        } else {
            if (l < 0L) {
                l = 0L;
            }
            this.setIntervalBeginTime(l);
            this.selectionBeginTime = this.getSelectionBeginTime() + (long)(n * this.msPerPixel);
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            this.setMediaTime(this.selectionBeginTime);
            this.setSelection(this.selectionBeginTime, this.getSelectionEndTime());
        }
    }

    public File save(String string) {
        try {
            File file = new File(string);
            ImageIO.write((RenderedImage)this.bi, "png", file);
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    void stopScroll() {
        this.stopScrolling = true;
    }

    public void updateLocale() {
    }

    public void updateActiveAnnotation() {
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
    }

    public void martTag(String string) {
    }
}

