/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import mpi.annex.view.HTML;
import mpi.annex.view.HTMLRow;

public class HTMLTable {
    private int numColumns;
    private int numRows;
    private Vector rows;
    private String[] columnClasses;
    private String[] columnHeaders;
    private String[] columnHClasses;
    private boolean hasHeaders;
    private String tableClass;
    private String attributes;
    private String id;

    public HTMLTable(int n) {
        this.numColumns = n;
        this.numRows = 0;
        this.rows = new Vector(10);
        this.columnClasses = new String[n];
        this.columnHeaders = new String[n];
        this.columnHClasses = new String[n];
        for (int i = 0; i < n; ++i) {
            this.columnClasses[i] = "column" + i;
            this.columnHeaders[i] = "&nbsp;";
            this.columnHClasses[i] = "column" + i;
        }
        this.hasHeaders = false;
        this.tableClass = "";
        this.attributes = "";
        this.id = "";
    }

    public void setTableClass(String string) {
        this.tableClass = string;
    }

    public void setColumnClass(int n, String string) {
        this.columnClasses[n] = string;
        this.columnHClasses[n] = string;
    }

    public void setColumnHeader(int n, String string) {
        this.columnHeaders[n] = string;
        this.hasHeaders = true;
    }

    public void addRow(HTMLRow hTMLRow) {
        this.rows.add(this.numRows, hTMLRow);
        ++this.numRows;
    }

    public HTMLRow newRow() {
        HTMLRow hTMLRow = new HTMLRow(this.numColumns, this.columnClasses);
        this.addRow(hTMLRow);
        return hTMLRow;
    }

    public void addAttribute(String string) {
        this.attributes = this.attributes + string + " ";
    }

    public void setID(String string) {
        this.id = "id=\"" + string + "\"";
    }

    public void output_preamble(OutputStream outputStream) {
        try {
            HTML.prt(outputStream, "<table class=\"" + this.tableClass + "\" ");
            if (this.id.length() > 0) {
                HTML.prt(outputStream, this.id + " ");
            }
            if (this.attributes.length() > 0) {
                HTML.prt(outputStream, this.attributes);
            }
            HTML.prt(outputStream, ">");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void output_postamble(OutputStream outputStream) {
        try {
            HTML.prtln(outputStream, "</table>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void output_header(OutputStream outputStream) {
        try {
            if (this.hasHeaders) {
                HTML.prt(outputStream, "<thead>");
                HTML.prt(outputStream, "<tr>");
                for (int i = 0; i < this.numColumns; ++i) {
                    HTML.prt(outputStream, "<th class=\"" + this.columnHClasses[i] + "\">");
                    HTML.prt(outputStream, this.columnHeaders[i]);
                    HTML.prt(outputStream, "</th>");
                }
                HTML.prtln(outputStream, "</tr></thead>");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void output(OutputStream outputStream) {
        try {
            int n;
            HTML.prt(outputStream, "<table class=\"" + this.tableClass + "\" ");
            if (this.id.length() > 0) {
                HTML.prt(outputStream, this.id + " ");
            }
            if (this.attributes.length() > 0) {
                HTML.prt(outputStream, this.attributes);
            }
            HTML.prt(outputStream, ">");
            if (this.hasHeaders) {
                HTML.prt(outputStream, "<thead>");
                HTML.prt(outputStream, "<tr>");
                for (n = 0; n < this.numColumns; ++n) {
                    HTML.prt(outputStream, "<th class=\"" + this.columnHClasses[n] + "\">");
                    HTML.prt(outputStream, this.columnHeaders[n]);
                    HTML.prt(outputStream, "</th>");
                }
                HTML.prtln(outputStream, "</tr></thead>");
            }
            if (this.hasHeaders) {
                HTML.prt(outputStream, "<tfoot>");
                HTML.prt(outputStream, "<tr>");
                for (n = 0; n < this.numColumns; ++n) {
                    HTML.prt(outputStream, "<th class=\"" + this.columnHClasses[n] + "\">");
                    HTML.prt(outputStream, this.columnHeaders[n]);
                    HTML.prt(outputStream, "</th>");
                }
                HTML.prtln(outputStream, "</tr></tfoot>");
            }
            HTML.prtln(outputStream, "<tbody>");
            for (n = 0; n < this.numRows; ++n) {
                HTML.prt(outputStream, ((HTMLRow)this.rows.elementAt(n)).toString());
                HTML.prtln(outputStream, "");
            }
            HTML.prtln(outputStream, "</tbody>");
            HTML.prtln(outputStream, "</table>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public File toFile(String string) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            HTML.prt(fileOutputStream, "<html><head><link rel=\"stylesheet\" type=\"text/css\" ");
            HTML.prt(fileOutputStream, "href=\"tblstyle.css\"><script src=\"tblcommon.js\">");
            HTML.prtln(fileOutputStream, "</script></head><body>");
            this.output(fileOutputStream);
            HTML.prtln(fileOutputStream, "</body>");
            fileOutputStream.close();
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

