/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.data.AnnexMediaDescriptor;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.view.SessionData;
import org.apache.log4j.Logger;

public class Initialize
extends HttpServlet {
    private String webDir;
    private SessionData sd;
    private static Logger logger = Logger.getLogger((String)"ANNEX.Initialize");

    public void init() {
        this.webDir = this.getServletContext().getRealPath("/") + "/";
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        RequestDispatcher requestDispatcher;
        Object object;
        Object object2;
        SessionData sessionData;
        HashMap hashMap;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            httpServletResponse.sendRedirect("login.jsp");
            return;
        }
        String string = httpServletRequest.getParameter("key");
        if (string == null) {
            string = "0";
        }
        if ((hashMap = (HashMap)httpSession.getAttribute("sessions")) == null) {
            logger.error((Object)"sessions is null.");
        }
        if ((sessionData = (SessionData)hashMap.get(string)) == null || sessionData.isInvalid()) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        if (sessionData.getAnnexTranscription() == null) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        logger.info((Object)"Initialize started.");
        String string2 = httpServletRequest.getHeader("User-Agent");
        sessionData.setStyleSheet("_moz.css");
        sessionData.setUaType("mozilla");
        if (string2 != null) {
            logger.info((Object)string2);
            object2 = string2.split(" ");
            if (object2[0].substring(0, 7).equals("Mozilla")) {
                sessionData.setStyleSheet("_moz.css");
                sessionData.setUaType("mozilla");
            }
            if (((String)(object = object2[((String[])object2).length - 1])).length() > 6 && ((String)object).substring(0, 7).equals("Firefox")) {
                logger.info((Object)"firefox");
                sessionData.setUaType("firefox");
            }
            if (((String)object).indexOf("Safari") > -1) {
                logger.info((Object)"safari");
                sessionData.setUaType("safari");
            }
            if (object2[1].equals("(compatible;") && object2[2].equals("MSIE")) {
                sessionData.setStyleSheet("_ie.css");
                sessionData.setUaType("msie");
            }
            if (string2.indexOf("Windows") > -1) {
                logger.info((Object)"Windows OS detected.");
                sessionData.setOSName("windows");
            }
            if (string2.indexOf("Linux") > -1) {
                logger.info((Object)"Linux OS detected.");
                sessionData.setOSName("linux");
            }
            if (string2.indexOf("Macintosh") > -1) {
                logger.info((Object)"Apple OS detected.");
                sessionData.setOSName("apple");
            }
        } else {
            logger.info((Object)"No browser detected.");
            sessionData.setStyleSheet("_moz.css");
            sessionData.setUaType("mozilla");
        }
        object2 = (String)httpSession.getAttribute("userid");
        object = sessionData.getUserData();
        String string3 = httpServletRequest.getRemoteAddr();
        sessionData.setIPNumber(string3);
        logger.info((Object)("Request from: " + string3));
        AnnexTranscription annexTranscription = sessionData.getAnnexTranscription();
        if (annexTranscription == null) {
            logger.error((Object)"Initialize called with null AT.");
            return;
        }
        if (sessionData.getFilepath() != null) {
            if (sessionData.getMediapath() != null) {
                sessionData.setMediaType("local");
                sessionData.setMediaURL("file:///" + sessionData.getMediapath());
                sessionData.setMessage("file");
            } else {
                sessionData.setMediaType("none");
            }
            RequestDispatcher requestDispatcher2 = this.getServletContext().getNamedDispatcher("ShowTier");
            if (requestDispatcher2 != null) {
                requestDispatcher2.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendError(500);
            }
            return;
        }
        AnnexMediaDescriptor annexMediaDescriptor = annexTranscription.getMasterMedia();
        String string4 = null;
        if (annexMediaDescriptor == null) {
            requestDispatcher = this.getServletContext().getNamedDispatcher("MediaChooser");
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendError(500);
            }
        } else {
            logger.info((Object)("getMasterMedia=" + annexMediaDescriptor.fileName));
            string4 = annexMediaDescriptor.fileName;
            sessionData.setMediaFilename(string4);
            requestDispatcher = this.getServletContext().getNamedDispatcher("MediaLoader");
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendError(500);
            }
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        requestDispatcher = httpServletResponse.getOutputStream();
        requestDispatcher.print("<html><head></head>");
        requestDispatcher.println("<body>");
        requestDispatcher.print("Error, could not continue.");
        requestDispatcher.println("</body></html>");
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }
}

