/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.util.AnnexUtil;
import mpi.annex.view.SessionData;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.util.MimeType;
import org.apache.log4j.Logger;

public class MediaChooser
extends HttpServlet {
    private SessionData sd;
    private static Logger logger = Logger.getLogger((String)"ANNEX.MediaChooser");
    private static String audioTypeExtension = "m4a";

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            httpServletResponse.sendRedirect("login.jsp");
            return;
        }
        String string2 = httpSession.getId();
        String string3 = httpServletRequest.getParameter("key");
        HashMap hashMap = (HashMap)httpSession.getAttribute("sessions");
        SessionData sessionData = (SessionData)hashMap.get(string3);
        if (sessionData == null || sessionData.isInvalid()) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        if (sessionData.getAnnexTranscription() == null) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        logger.info((Object)"MediaChooser started.");
        String string4 = httpServletRequest.getParameter("media");
        String string5 = httpServletRequest.getParameter("nodeid");
        if (string5 == null) {
            string5 = sessionData.getNodeID();
        }
        ArrayList arrayList = AnnexUtil.getPossibleMediaFor(string5);
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string6 = (String)arrayList.get(i);
            string = MimeType.getMimeTypeStringFromExtension((String)string6);
            logger.info((Object)("Media: " + string6 + ", " + string));
            if (!string6.endsWith(audioTypeExtension)) continue;
            ++n;
        }
        if (arrayList.size() == 0) {
            logger.info((Object)"ERROR: no useful/possible media returned.");
            sessionData.setAudioFile("none");
            RequestDispatcher requestDispatcher = this.getServletContext().getNamedDispatcher("ShowTier");
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendError(500);
            }
            return;
        }
        if (n == 0) {
            sessionData.setMediaType("none");
            RequestDispatcher requestDispatcher = this.getServletContext().getNamedDispatcher("MediaLoader");
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendError(500);
            }
            return;
        }
        CorpusStructureDB corpusStructureDB = AnnexUtil.getCorpusStructureDB();
        if (string4 != null) {
            int n2 = new Integer(string4);
            if (n2 == 0) {
                sessionData.setMediaType("none");
                sessionData.setMessage("");
                sessionData.setMediaURL("");
                sessionData.setMediaFilename("");
            } else {
                string = (String)arrayList.get(--n2);
                String string7 = MimeType.getMimeTypeStringFromExtension((String)string);
                logger.info((Object)("Taking: " + string + " " + string7));
                String string8 = corpusStructureDB.resolveNameInAnnotationContext(string5, string, null);
                String string9 = AnnexUtil.getFilePathFor(string8);
                AnnexUtil.closeCorpusStructureDBImpl();
                sessionData.setMediaType("local");
                if (sessionData.getOSName().equals("unix")) {
                    string9 = "file:///" + AnnexUtil.getFilePathForUnix(string8);
                } else if (sessionData.getOSName().equals("windows")) {
                    string9 = "file:///" + AnnexUtil.getFilePathForWindows(string8);
                }
                sessionData.setMediaURL(string9);
                sessionData.setMediaFilename(string);
                sessionData.setMessage("(" + string + ")");
            }
            string = this.getServletContext().getNamedDispatcher("MediaLoader");
            if (string != null) {
                string.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendError(500);
            }
            return;
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        servletOutputStream.println("<html><head>");
        servletOutputStream.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"ConventionsLana.css\"/>");
        servletOutputStream.println("</head>");
        servletOutputStream.println("<body>");
        servletOutputStream.println("<form action='runMediaChooser' method='post'>");
        if (arrayList.size() != 0) {
            servletOutputStream.println("Choose one of the following media files to display.");
            servletOutputStream.println("<br>");
            servletOutputStream.println("<br><input checked id=\"rb0\" value=\"0\" type=\"radio\" name=\"media\">No media</input>");
            int n3 = 1;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string10 = (String)arrayList.get(i);
                String string11 = MimeType.getMimeTypeStringFromExtension((String)string10);
                if (string10.endsWith(audioTypeExtension)) {
                    logger.info((Object)("Possible " + i + ": " + string10 + " " + string11));
                    String string12 = corpusStructureDB.resolveNameInAnnotationContext(string5, string10, null);
                    String string13 = AnnexUtil.getFilePathFor(string12);
                    String string14 = "rb" + n3;
                    servletOutputStream.println("<br><input id=\"" + string14 + "\" value=\"" + n3 + "\" type=\"radio\" name=\"media\">" + string10 + "</input>");
                }
                ++n3;
            }
            sessionData.setMessage("unspecified media");
            servletOutputStream.println("<input type=\"hidden\" name=\"key\" value=\"" + string3 + "\">\n");
            servletOutputStream.println("<input type=\"submit\" value=\"Continue\">\n");
            servletOutputStream.println("<br><br>");
        }
        servletOutputStream.println("</body></html>");
    }
}

