/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.data.AnnexMediaDescriptor;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.util.AnnexUtil;
import mpi.annex.view.SessionData;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.StreamingPreparation;
import mpi.util.MimeType;
import org.apache.log4j.Logger;

public class MediaLoader
extends HttpServlet {
    private String webDir;
    private SessionData sd;
    private static Logger logger = Logger.getLogger((String)"ANNEX.MediaLoader");
    private String dbname;
    private String user;
    private String passwd;
    private String anonymizerHost;
    private int anonymizerPort;
    private String streamingURL;
    private String audioType = "audio/x-wav";
    private String playLocalMedia = "no";

    public void init() {
        this.webDir = this.getServletContext().getRealPath("/") + "/";
        this.dbname = AnnexUtil.corpusDbURL;
        this.user = AnnexUtil.corpusDbUser;
        this.passwd = AnnexUtil.corpusDbPassword;
        this.anonymizerHost = AnnexUtil.anonymizerHost;
        logger.info((Object)("anonymizerHost = " + this.anonymizerHost));
        this.anonymizerPort = new Integer(AnnexUtil.anonymizerPort);
        logger.info((Object)("anonymizerPort = " + this.anonymizerPort));
        this.streamingURL = AnnexUtil.streamingURL;
        logger.info((Object)("streamingURL = " + this.streamingURL));
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        String string2;
        CorpusStructureDB corpusStructureDB;
        AnnexTranscription annexTranscription;
        SessionData sessionData;
        block32: {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession == null) {
                httpServletResponse.sendRedirect("login.jsp");
                return;
            }
            String string3 = httpSession.getId();
            String string4 = httpServletRequest.getParameter("key");
            HashMap hashMap = (HashMap)httpSession.getAttribute("sessions");
            sessionData = (SessionData)hashMap.get(string4);
            if (sessionData == null || sessionData.isInvalid()) {
                httpServletResponse.sendRedirect("invalid.html");
                return;
            }
            if (sessionData.getAnnexTranscription() == null) {
                httpServletResponse.sendRedirect("invalid.html");
                return;
            }
            logger.info((Object)"MediaLoader started.");
            annexTranscription = sessionData.getAnnexTranscription();
            if (annexTranscription == null) {
                logger.error((Object)"Initialize called with null AT.");
                return;
            }
            corpusStructureDB = AnnexUtil.getCorpusStructureDB();
            string2 = sessionData.getMediaFilename();
            string = sessionData.getNodeID();
            if (string2 != null) {
                logger.info((Object)("getMasterMedia=" + string2));
                logger.info((Object)("nodeID=" + string));
                try {
                    object4 = corpusStructureDB.resolveNameInAnnotationContext(string, string2, null);
                    logger.info((Object)("media_id:" + (String)object4));
                    if (object4 == null) {
                        logger.info((Object)"Trying with .mp4");
                        object3 = annexTranscription.getAllMasterMedia();
                        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                            object2 = (AnnexMediaDescriptor)((ArrayList)object3).get(i);
                            logger.info((Object)(((AnnexMediaDescriptor)object2).fileName + "/" + ((AnnexMediaDescriptor)object2).mimeType));
                        }
                        object = (AnnexMediaDescriptor)((ArrayList)object3).get(0);
                        string2 = ((AnnexMediaDescriptor)object).fileName.substring(0, ((AnnexMediaDescriptor)object).fileName.length() - 3) + "mp4";
                        object4 = corpusStructureDB.resolveNameInAnnotationContext(string, string2, null);
                        logger.info((Object)("media_id:" + (String)object4));
                    }
                    if (object4 == null) {
                        logger.info((Object)"Trying with .wav");
                        object3 = annexTranscription.getAllMasterMedia();
                        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                            object2 = (AnnexMediaDescriptor)((ArrayList)object3).get(i);
                            logger.info((Object)(((AnnexMediaDescriptor)object2).fileName + "/" + ((AnnexMediaDescriptor)object2).mimeType));
                        }
                        object = (AnnexMediaDescriptor)((ArrayList)object3).get(0);
                        string2 = ((AnnexMediaDescriptor)object).fileName.substring(0, ((AnnexMediaDescriptor)object).fileName.length() - 3) + "wav";
                        object4 = corpusStructureDB.resolveNameInAnnotationContext(string, string2, null);
                        logger.info((Object)("media_id:" + (String)object4));
                    }
                    if ((object3 = AnnexUtil.getFilePathFor((String)object4)) == null) {
                        sessionData.setMediaType("none");
                    } else {
                        object = new File((String)object3);
                        if (!((File)object).exists()) {
                            System.out.println("fp does not exist.");
                            sessionData.setMediaType("none");
                        } else {
                            if (this.playLocalMedia == "yes") {
                                sessionData.setMediaType("local");
                                if (sessionData.getOSName().equals("unix")) {
                                    object3 = "file:///" + AnnexUtil.getFilePathForUnix((String)object4);
                                } else if (sessionData.getOSName().equals("windows")) {
                                    object3 = "file:///" + AnnexUtil.getFilePathForWindows((String)object4);
                                }
                            }
                            logger.info((Object)("Browser fp: " + (String)object3));
                            sessionData.setMediaURL((String)object3);
                        }
                    }
                    if (corpusStructureDB == null) break block32;
                    logger.info((Object)"Determining streaming link.");
                    object = new StreamingPreparation(this.dbname, this.user, this.passwd, this.anonymizerHost, this.anonymizerPort);
                    sessionData.setSP((StreamingPreparation)object);
                    if (string.equals("") || string == null) break block32;
                    object2 = object.getStreamingLinkString((String)object4);
                    String string5 = httpServletRequest.getParameter("mp4");
                    if (string5 != null) {
                        object2 = string5;
                    }
                    if (object2 != null) {
                        sessionData.setStreamingLinkID((String)object2);
                        object2 = this.streamingURL + (String)object2;
                        logger.info((Object)("getStreamingLink: " + (String)object2));
                        sessionData.setMediaType("streaming");
                        sessionData.setSMediaURL((String)object2);
                        sessionData.setMediaURL("data/stub.mpg");
                        break block32;
                    }
                    logger.info((Object)"No streaming link returned.");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                logger.info((Object)"getMasterMedia returned null.");
            }
        }
        object4 = annexTranscription.getMasterAudio();
        if (object4 != null) {
            logger.info((Object)("getMasterAudio: " + ((AnnexMediaDescriptor)object4).fileName + ", " + ((AnnexMediaDescriptor)object4).mimeType + ", " + ((AnnexMediaDescriptor)object4).offset));
            object3 = corpusStructureDB.resolveNameInAnnotationContext(string, ((AnnexMediaDescriptor)object4).fileName, null);
            if (object3 != null) {
                object = AnnexUtil.getFilePathFor((String)object3);
                object2 = new File((String)object);
                if (!((File)object2).exists()) {
                    System.out.println("MasterAudio fp does not exist.");
                    sessionData.setAudioFile("none");
                } else {
                    sessionData.setAudioFile((String)object);
                }
                logger.info((Object)("AUDIO: " + sessionData.getAudioFile()));
            }
        } else {
            logger.info((Object)"getMasterAudio returned null.");
            if (string2 != null) {
                object3 = MimeType.getMimeTypeStringFromExtension((String)string2);
                if (((String)object3).equals(this.audioType)) {
                    logger.info((Object)("Using: " + string2));
                    object = corpusStructureDB.resolveNameInAnnotationContext(string, string2, null);
                    object2 = AnnexUtil.getFilePathFor((String)object);
                    logger.info((Object)("fp(wav): " + (String)object2));
                    sessionData.setAudioFile((String)object2);
                    sessionData.setMediaType("none");
                }
            } else {
                sessionData.setMediaType("none");
            }
        }
        if (sessionData.getOSName() == "linux") {
            sessionData.setMediaType("none");
        }
        AnnexUtil.closeCorpusStructureDBImpl();
        object3 = this.getServletContext().getNamedDispatcher("ShowTier");
        if (object3 != null) {
            object3.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        object = httpServletResponse.getOutputStream();
        object.print("<html><head></head>");
        object.println("<body>");
        object.print("Error, could not continue to runShowTier.");
        object.println("</body></html>");
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }
}

