/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import mpi.annex.view.SessionData;
import mpi.corpusstructure.StreamingPreparation;
import org.apache.log4j.Logger;

public class SessionChecker
implements HttpSessionListener {
    private String webDir;
    private HashMap sessions;
    private static int activeSessions = 0;
    private static Logger logger = Logger.getLogger((String)"ANNEX.SessionChecker");

    public SessionChecker() {
        System.out.println("SessionChecker();");
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        logger.info((Object)"sessionCreated called.");
        HttpSession httpSession = httpSessionEvent.getSession();
        this.sessions = new HashMap();
        httpSession.setAttribute("sessions", (Object)this.sessions);
        String string = httpSession.getId();
        logger.info((Object)("sessionCreated: " + string));
        logger.info((Object)("Session #" + ++activeSessions));
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        if (httpSession == null) {
            logger.error((Object)"Session was null.");
            return;
        }
        String string = httpSession.getId();
        for (Object k : this.sessions.keySet()) {
            logger.info((Object)("Deleting session: " + k));
            SessionData sessionData = (SessionData)this.sessions.get(k);
            StreamingPreparation streamingPreparation = sessionData.getSP();
            String string2 = sessionData.getStreamingLinkID();
            if (string2 != null && streamingPreparation != null) {
                logger.info((Object)("Deleting streamingLink: " + string2));
                StreamingPreparation.deleteStreamingLink((String)string2);
            }
            ArrayList arrayList = sessionData.getPngs();
            for (File file : arrayList) {
                logger.info((Object)("Delete " + file.getAbsolutePath()));
                file.delete();
            }
            sessionData.invalidate();
            File file = (File)httpSession.getAttribute("timelinePNG");
            if (file == null || !file.exists()) continue;
            file.delete();
        }
        httpSession.removeAttribute("sessions");
        logger.info((Object)("Session " + string + " destroyed."));
        --activeSessions;
    }
}

