/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.view.FrameData;
import mpi.annex.view.HTMLRow;
import mpi.annex.view.HTMLTable;
import mpi.annex.view.SessionData;

public class Television
extends HttpServlet {
    private String webDir;
    private SessionData sd = null;

    public void init() {
        this.webDir = this.getServletContext().getRealPath("/") + "/";
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        int n;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        String string = httpSession.getId();
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        String string2 = httpServletRequest.getParameter("key");
        HashMap hashMap = (HashMap)httpSession.getAttribute("sessions");
        SessionData sessionData = (SessionData)hashMap.get(string2);
        if (sessionData == null || sessionData.isInvalid()) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        String string3 = httpServletRequest.getParameter("frame");
        if (string3 == null) {
            string3 = "DF";
        }
        FrameData frameData = sessionData.getFrame(string3);
        if (frameData == null) {
            frameData = new FrameData(string3);
            sessionData.setFrame(string3, frameData);
        }
        AnnexTranscription annexTranscription = sessionData.getAnnexTranscription();
        String string4 = httpServletRequest.getParameter("tieridx");
        if (string4 == null) {
            string4 = "0";
        }
        if (frameData.getVisibleTier(0).equals("NONE")) {
            // empty if block
        }
        servletOutputStream.print("<head>\n");
        servletOutputStream.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"ConventionsLana.css\"/>");
        servletOutputStream.print("<link rel=\"stylesheet\" ");
        servletOutputStream.println("type=\"text/css\" href=\"tv_style.css\" />");
        servletOutputStream.println("<script src=\"tv_common.js\" type=\"text/javascript\"></script>");
        servletOutputStream.println("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
        servletOutputStream.println("<script type=\"text/javascript\">");
        servletOutputStream.println("<!--");
        servletOutputStream.println("var mediaType = \"" + sessionData.getMediaType() + "\";");
        servletOutputStream.println("var multiTiers = [];");
        for (int i = 0; i < frameData.getMaxVisibleTiers(); ++i) {
            servletOutputStream.println("multiTiers[" + i + "] = \"" + frameData.getVisibleTier(i) + "\";");
        }
        servletOutputStream.println("//-->");
        servletOutputStream.println("</script>");
        servletOutputStream.println("</head><html>\n");
        servletOutputStream.println("<body onload=\"initialize('none')\" >");
        String string5 = sessionData.getMediaURL();
        String string6 = sessionData.getSMediaURL();
        ArrayList arrayList = annexTranscription.getTiers();
        for (n = 0; n < 5; ++n) {
            servletOutputStream.println("<div id=\"Subtitle" + n + "\" class=\"SubtitleOFF\">");
            servletOutputStream.println("<span class=\"SubtitleName\"></span>");
            servletOutputStream.println("<span id=\"SubtitleContents" + n + "\" class=\"SubtitleContents\"></span>");
            servletOutputStream.println("</div>");
        }
        for (n = 0; n < arrayList.size(); ++n) {
            AnnexTier annexTier = (AnnexTier)arrayList.get(n);
            HTMLTable hTMLTable = this.tierToTable(annexTier, n);
            hTMLTable.output((OutputStream)servletOutputStream);
        }
        servletOutputStream.println("</body></html>");
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public HTMLTable tierToTable(AnnexTier annexTier, int n) {
        HTMLTable hTMLTable = new HTMLTable(1);
        hTMLTable.setTableClass("tier");
        hTMLTable.setColumnClass(0, "cellText");
        try {
            hTMLTable.setID(annexTier.name);
            hTMLTable.addAttribute("idx=\"" + n + "\"");
            ArrayList arrayList = annexTier.annotations;
            for (int i = 0; i < arrayList.size(); ++i) {
                AnnexAnnotation annexAnnotation = (AnnexAnnotation)arrayList.get(i);
                HTMLRow hTMLRow = hTMLTable.newRow();
                hTMLRow.addAttributeAt(0, "id=\"col" + n + i + "\"");
                hTMLRow.addAttributeAt(0, "an=\"" + annexAnnotation.value + "\"");
                String string = "" + annexAnnotation.beginTime;
                String string2 = "" + annexAnnotation.endTime;
                hTMLRow.addAttributeAt(0, "et=\"" + string2 + "\"");
                hTMLRow.addAttributeAt(0, "bt=\"" + string + "\"");
                if (i >= arrayList.size() - 1) continue;
                AnnexAnnotation annexAnnotation2 = (AnnexAnnotation)arrayList.get(i + 1);
                String string3 = "" + annexAnnotation2.beginTime;
                hTMLRow.addAttributeAt(0, "btn=\"" + string3 + "\"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hTMLTable;
    }
}

