/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.view.FrameData;
import mpi.annex.view.SessionData;
import mpi.annex.view.Util;
import org.apache.log4j.Logger;

public class VarTrans
extends HttpServlet {
    private String webDir;
    private SessionData sd = null;
    private static Logger logger = Logger.getLogger((String)"ANNEX.VarTrans");

    public void init() {
        this.webDir = this.getServletContext().getRealPath("/") + "/";
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        AnnexTranscription annexTranscription;
        logger.info((Object)"VarTrans started.");
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        String string = httpSession.getId();
        String string2 = httpServletRequest.getParameter("key");
        HashMap hashMap = (HashMap)httpSession.getAttribute("sessions");
        SessionData sessionData = (SessionData)hashMap.get(string2);
        if (sessionData == null || sessionData.isInvalid()) {
            httpServletResponse.sendRedirect("invalid.html");
            return;
        }
        String string3 = httpServletRequest.getParameter("frame");
        if (string3 != null) {
            logger.info((Object)("Frame=" + string3));
        } else {
            string3 = "DF";
        }
        FrameData frameData = sessionData.getFrame(string3);
        if (frameData == null) {
            frameData = new FrameData(string3);
            sessionData.setFrame(string3, frameData);
        }
        int n = 10;
        while (sessionData.getLocked()) {
            logger.info((Object)" Waiting for lock.");
            if (--n == 0) {
                logger.info((Object)" Time out waiting for lock.");
                sessionData.setLocked(false);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                sessionData.setLocked(false);
            }
        }
        sessionData.setLocked(true);
        logger.info((Object)" Lock acquired.");
        String string4 = httpServletRequest.getParameter("tlSelH");
        if (string4 != null) {
            frameData.setTlSelH(string4);
        }
        if ((string4 = httpServletRequest.getParameter("tlSelB")) != null) {
            frameData.setTlSelB(string4);
        }
        if ((string4 = httpServletRequest.getParameter("tlSelE")) != null) {
            frameData.setTlSelE(string4);
        }
        if ((string4 = httpServletRequest.getParameter("qtSelB")) != null) {
            frameData.setQtSelB(new Long(string4));
        }
        if ((string4 = httpServletRequest.getParameter("qtSelE")) != null) {
            frameData.setQtSelE(new Long(string4));
        }
        if ((string4 = httpServletRequest.getParameter("tlWidth")) != null) {
            frameData.setTlWidth(new Integer(string4));
        }
        if ((string4 = httpServletRequest.getParameter("tlHeight")) != null) {
            frameData.setTlHeight(new Integer(string4));
        }
        if ((string4 = httpServletRequest.getParameter("annoid")) != null) {
            frameData.setAnnoid(string4);
        }
        if ((annexTranscription = sessionData.getAnnexTranscription()) != null) {
            String string5 = httpServletRequest.getParameter("tieridx");
            if (string5 == null) {
                string5 = "0";
            }
            int n2 = 0;
            n2 = new Integer(string5);
            String string6 = httpServletRequest.getParameter("tier");
            if (string6 == null && (string6 = frameData.getVisibleTier(0)) == null) {
                logger.error((Object)"No tiername!");
            }
            frameData.setVisibleTier(n2, string6);
            AnnexTier annexTier = Util.getTierImplByName(string6, annexTranscription);
            int n3 = 0;
            for (int i = 0; i < frameData.getMaxVisibleTiers(); ++i) {
                if (frameData.getVisibleTier(i).equals("NONE")) continue;
                ++n3;
            }
            frameData.setVisibleTiers(n3);
            string4 = httpServletRequest.getParameter("annoid");
            if (string4 != null) {
                ArrayList arrayList = annexTranscription.getTiers();
                for (int i = 0; i < arrayList.size(); ++i) {
                    ArrayList arrayList2;
                    AnnexTier annexTier2 = (AnnexTier)arrayList.get(i);
                    if (annexTier2 == null || (arrayList2 = annexTier2.annotations) == null) continue;
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        AnnexAnnotation annexAnnotation = (AnnexAnnotation)arrayList2.get(j);
                        if (annexAnnotation == null || annexAnnotation.id == null || !annexAnnotation.id.equals(string4)) continue;
                        logger.info((Object)("Found annoid: " + annexTier2.name + "/" + string4));
                        logger.info((Object)("bt=" + annexAnnotation.beginTime));
                        frameData.setTlSelB("" + annexAnnotation.beginTime);
                        frameData.setTlSelE("" + annexAnnotation.endTime);
                    }
                }
            }
        }
        sessionData.setLocked(false);
        logger.info((Object)"VarTrans finished.");
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }
}

