/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.workspace;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import mpi.annex.workspace.AnnexWSItem;
import org.apache.log4j.Logger;

public class AnnexWorkspace
implements Serializable {
    private String ID = "NO_ID";
    private static Logger logger = Logger.getLogger((String)"ANNEX.Workspace");
    public ArrayList wsItems;
    public String fontName = "SansSerif.plain";
    public int fontSize = 12;
    public String userid = "";

    public AnnexWorkspace(String string) {
        this.ID = string;
        this.userid = string;
        this.wsItems = new ArrayList();
        logger.info((Object)("AnnexWorkspace (" + string + ") initialised."));
    }

    public synchronized void addWSItem(AnnexWSItem annexWSItem) {
        this.wsItems.add(annexWSItem);
    }

    public synchronized void delWSItem(AnnexWSItem annexWSItem) {
        if (!this.wsItems.remove(annexWSItem)) {
            logger.info((Object)"Removed failed.");
        }
    }

    public synchronized void clear() {
        this.wsItems.clear();
    }

    public ArrayList getWSItems() {
        return this.wsItems;
    }

    public String getUserID() {
        return this.userid;
    }

    public AnnexWSItem containsWSItem(String string) {
        for (int i = 0; i < this.wsItems.size(); ++i) {
            AnnexWSItem annexWSItem = (AnnexWSItem)this.wsItems.get(i);
            if (!annexWSItem.getURID().equals(string)) continue;
            return annexWSItem;
        }
        return null;
    }

    public static AnnexWorkspace load(String string) {
        AnnexWorkspace annexWorkspace = new AnnexWorkspace(string);
        try {
            FileInputStream fileInputStream = new FileInputStream("ws_" + string + ".ser");
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            annexWorkspace = (AnnexWorkspace)objectInputStream.readObject();
            logger.info((Object)("Loaded AWS for " + string));
        }
        catch (IOException iOException) {
            logger.info((Object)("File not found (ws_" + string + ".ser)."));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return annexWorkspace;
    }

    public static void save(AnnexWorkspace annexWorkspace, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("ws_" + string + ".ser");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(annexWorkspace);
            logger.info((Object)("Saved AWS for " + string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

