/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.workspace;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.util.AnnexUtil;
import mpi.annex.workspace.AnnexWSItem;
import mpi.annex.workspace.AnnexWorkspace;
import mpi.util.DBConnection;
import org.apache.log4j.Logger;

public class WSDBI {
    private static Logger logger = Logger.getLogger((String)"ANNEX.WSDBI");
    private static Connection con = null;
    private static DBConnection dbcon = null;
    private String url = "";
    private String db_username = "";
    private String db_password = "";
    private String pg_database = "annex";
    private String pg_schema = "ws";
    private String pg_table = "annexws";
    private static String sql_insert = "INSERT INTO users (id,kv) VALUES (?,?);";
    private static String sql_update = "UPDATE users SET kv=? where id=?";
    private static String sql_select = "SELECT * FROM users";
    private static String sql_tstamp = "UPDATE users SET lastaccess=NOW() where id=?";
    private static boolean busy = false;

    public WSDBI() {
        String string = "select idx from " + this.pg_schema + "." + this.pg_table + " limit 1";
        this.url = AnnexUtil.getWorkspaceDbURL();
        con = null;
        if (this.url != null) {
            logger.info((Object)"Setting up connexion.");
            try {
                this.db_username = AnnexUtil.getWorkspaceDbUser();
                this.db_password = AnnexUtil.getWorkspaceDbPassword();
                dbcon = new DBConnection(this.url, this.db_username, this.db_password, "");
                con = dbcon.getConnection();
                logger.info((Object)"New WSDBI.");
                try {
                    PreparedStatement preparedStatement = con.prepareStatement(string);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"No DB, creating");
                    this.createTableInternal();
                }
            }
            catch (Exception exception) {
                if (exception.getMessage() != null) {
                    logger.error((Object)exception.getMessage());
                } else {
                    exception.printStackTrace();
                }
                logger.error((Object)"No WSDB available.");
                con = null;
            }
        }
    }

    public Connection getConnection() {
        return con;
    }

    public boolean open() {
        if (this.url == null) {
            return false;
        }
        boolean bl = false;
        try {
            if (con == null) {
                dbcon = new DBConnection(this.url, this.db_username, this.db_password, "");
                con = dbcon.getConnection();
                logger.info((Object)"Opened WSDB connexion.");
            } else {
                logger.info((Object)"Connexion already open.");
            }
            if (con != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                logger.error((Object)exception.getMessage());
            } else {
                exception.printStackTrace();
            }
            logger.error((Object)"No WSDB available.");
            bl = false;
        }
        return bl;
    }

    public void close() {
        if (this.url == null) {
            return;
        }
        try {
            if (con != null) {
                con.close();
                con = null;
                logger.info((Object)"Closed WSDB connexion");
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error closing WSDB.");
        }
    }

    public void dropTable() {
        Statement statement = null;
        String string = "DROP TABLE " + this.pg_schema + "." + this.pg_table;
        try {
            this.open();
            statement = con.createStatement();
            int n = statement.executeUpdate(string);
            statement.close();
            logger.info((Object)"DROP TABLE executed.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.close();
    }

    public void createTableInternal() {
        String string = "CREATE TABLE ws.annexws (";
        string = string + "idx        serial,";
        string = string + "uid        varchar(32),";
        string = string + "atrans     bytea,";
        string = string + "urid       varchar(32),";
        string = string + "wsidx      int,";
        string = string + "type       int,";
        string = string + "version    int,";
        string = string + "dt_created timestamp,";
        string = string + "dt_lastmod timestamp,";
        string = string + "comment    text,";
        string = string + "notes      text,";
        string = string + "filename   text,";
        string = string + "scr_info   varchar(64)";
        string = string + ");";
        try {
            Statement statement = con.createStatement();
            try {
                statement.executeUpdate("CREATE SCHEMA ws");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE ws.annexws CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate(string);
            logger.info((Object)"CREATE TABLE executed.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void createTable() {
        String string = "CREATE TABLE ws.annexws (";
        string = string + "idx        serial,";
        string = string + "uid        varchar(32),";
        string = string + "atrans     bytea,";
        string = string + "urid       varchar(32),";
        string = string + "wsidx      int,";
        string = string + "type       int,";
        string = string + "version    int,";
        string = string + "dt_created timestamp,";
        string = string + "dt_lastmod timestamp,";
        string = string + "comment    text,";
        string = string + "notes      text,";
        string = string + "filename   text,";
        string = string + "scr_info   varchar(64)";
        string = string + ");";
        try {
            this.open();
            Statement statement = con.createStatement();
            try {
                statement.executeUpdate("CREATE SCHEMA ws");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE ws.annexws CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate(string);
            logger.info((Object)"CREATE TABLE executed.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.close();
    }

    public void deleteWS(String string) {
        if (this.url == null) {
            return;
        }
        this.deleteWS(string, 0);
    }

    public void deleteWS(String string, int n) {
        if (this.url == null) {
            return;
        }
        String string2 = "DELETE FROM " + this.pg_schema + "." + this.pg_table + " WHERE uid = ? AND wsidx = ?";
        logger.info((Object)string2);
        try {
            this.open();
            PreparedStatement preparedStatement = con.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.close();
        }
        catch (Exception exception) {
            logger.error((Object)"deleteWS error");
            exception.printStackTrace();
        }
    }

    public void addItem(AnnexWSItem annexWSItem, String string) {
        if (this.url == null) {
            return;
        }
        this.addItem(annexWSItem, string, 0);
    }

    public void addItem(AnnexWSItem annexWSItem, String string, int n) {
        if (this.url == null) {
            return;
        }
        if (annexWSItem == null) {
            logger.info((Object)"Not adding null item.");
            return;
        }
        String string2 = " (uid,atrans,urid,wsidx,type,version,dt_created,dt_lastmod,comment,notes,filename,scr_info) ";
        String string3 = " (?,?,?,?,?,?,?,?,?,?,?,?) ";
        String string4 = "INSERT INTO " + this.pg_schema + "." + this.pg_table;
        string4 = string4 + string2 + " VALUES " + string3;
        logger.info((Object)string4);
        String string5 = annexWSItem.getURID();
        int n2 = annexWSItem.getType();
        int n3 = 0;
        String string6 = annexWSItem.getComment();
        String string7 = annexWSItem.getNotes();
        Calendar calendar = annexWSItem.getAdded();
        Calendar calendar2 = annexWSItem.getLastModified();
        File file = annexWSItem.getFile();
        String string8 = annexWSItem.getScrInfo();
        AnnexTranscription annexTranscription = annexWSItem.getAnnexTranscription();
        this.waitUntilFree();
        this.setLock(true);
        if (this.open()) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(annexTranscription);
                objectOutputStream.flush();
                objectOutputStream.close();
                String string9 = "";
                if (file != null) {
                    string9 = file.getPath();
                }
                PreparedStatement preparedStatement = con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setBytes(2, byteArrayOutputStream.toByteArray());
                preparedStatement.setString(3, string5);
                preparedStatement.setInt(4, n);
                preparedStatement.setInt(5, n2);
                preparedStatement.setInt(6, n3);
                preparedStatement.setTimestamp(7, new Timestamp(calendar.getTimeInMillis()));
                preparedStatement.setTimestamp(8, new Timestamp(calendar2.getTimeInMillis()));
                preparedStatement.setString(9, string6);
                preparedStatement.setString(10, string7);
                preparedStatement.setString(11, string9);
                preparedStatement.setString(12, string8);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (Exception exception) {
                logger.error((Object)"addItem error");
                exception.printStackTrace();
            }
        } else {
            logger.error((Object)"Could not open DB.");
        }
        this.setLock(false);
        this.close();
    }

    public void updateItem(AnnexWSItem annexWSItem, String string) {
        this.updateItem(annexWSItem, string, 0);
    }

    public void updateItem(AnnexWSItem annexWSItem, String string, int n) {
        if (this.url == null) {
            return;
        }
        if (annexWSItem == null) {
            logger.info((Object)"Not updating null item.");
            return;
        }
        String string2 = annexWSItem.getURID();
        String string3 = "UPDATE " + this.pg_schema + "." + this.pg_table + " SET ";
        string3 = string3 + "atrans = ?";
        string3 = string3 + ",type = ?";
        string3 = string3 + ",dt_created = ?";
        string3 = string3 + ",dt_lastmod = ?";
        string3 = string3 + ",comment = ?";
        string3 = string3 + ",notes = ?";
        string3 = string3 + ",filename = ?";
        string3 = string3 + ",wsidx = ?";
        string3 = string3 + ",scr_info = ?";
        string3 = string3 + "WHERE uid = '" + string + "' AND urid = '" + string2 + "'";
        int n2 = annexWSItem.getType();
        String string4 = annexWSItem.getComment();
        String string5 = annexWSItem.getNotes();
        Calendar calendar = annexWSItem.getAdded();
        Calendar calendar2 = annexWSItem.getLastModified();
        File file = annexWSItem.getFile();
        String string6 = annexWSItem.getScrInfo();
        AnnexTranscription annexTranscription = annexWSItem.getAnnexTranscription();
        this.waitUntilFree();
        this.setLock(true);
        if (this.open()) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(annexTranscription);
                objectOutputStream.flush();
                objectOutputStream.close();
                String string7 = "";
                if (file != null) {
                    string7 = file.getPath();
                }
                PreparedStatement preparedStatement = con.prepareStatement(string3);
                preparedStatement.setBytes(1, byteArrayOutputStream.toByteArray());
                preparedStatement.setInt(2, n2);
                preparedStatement.setTimestamp(3, new Timestamp(calendar.getTimeInMillis()));
                preparedStatement.setTimestamp(4, new Timestamp(calendar2.getTimeInMillis()));
                preparedStatement.setString(5, string4);
                preparedStatement.setString(6, string5);
                preparedStatement.setString(7, string7);
                preparedStatement.setInt(8, n);
                preparedStatement.setString(9, string6);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (Exception exception) {
                logger.error((Object)"updateItem error");
                exception.printStackTrace();
            }
            this.close();
        } else {
            logger.error((Object)"Could not open DB.");
        }
        this.setLock(false);
    }

    public void RSToWSItem(ResultSet resultSet, AnnexWSItem annexWSItem, boolean bl) {
        try {
            Object object;
            Object object2;
            annexWSItem.setType(-1);
            if (bl) {
                object2 = resultSet.getBinaryStream("atrans");
                object = new ObjectInputStream((InputStream)object2);
                AnnexTranscription annexTranscription = (AnnexTranscription)((ObjectInputStream)object).readObject();
                annexWSItem.setAnnexTranscription(annexTranscription);
            }
            annexWSItem.setURID(resultSet.getString("urid"));
            annexWSItem.setNodeID(null);
            annexWSItem.setVersion(resultSet.getInt("version"));
            object2 = resultSet.getTimestamp("dt_created");
            object = resultSet.getTimestamp("dt_lastmod");
            annexWSItem.setAddedInMillis(((Timestamp)object2).getTime());
            annexWSItem.setLastModifiedInMillis(((Timestamp)object).getTime());
            annexWSItem.setComment(resultSet.getString("comment"));
            annexWSItem.setNotes(resultSet.getString("notes"));
            annexWSItem.setFile(new File(resultSet.getString("filename")));
            annexWSItem.setScrInfo(resultSet.getString("scr_info"));
            annexWSItem.setType(resultSet.getInt("type"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveWS(AnnexWorkspace annexWorkspace, String string) {
        this.saveWS(annexWorkspace, string, 0);
    }

    public void saveWS(AnnexWorkspace annexWorkspace, String string, int n) {
        if (this.url == null) {
            return;
        }
        if (annexWorkspace == null) {
            return;
        }
        ArrayList arrayList = annexWorkspace.getWSItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnexWSItem annexWSItem = (AnnexWSItem)arrayList.get(i);
            this.updateItem(annexWSItem, string, n);
        }
    }

    public AnnexWorkspace loadWS(String string) {
        return this.loadWS(string, 0);
    }

    public AnnexWorkspace loadWS(String string, int n) {
        String string2 = " uid,urid,wsidx,type,version,dt_created,dt_lastmod,comment,notes, filename, scr_info ";
        String string3 = "SELECT" + string2 + "FROM " + this.pg_schema + "." + this.pg_table;
        string3 = string3 + " WHERE uid = '" + string + "'";
        string3 = string3 + " AND wsidx = " + n;
        string3 = string3 + " ORDER BY dt_created";
        logger.info((Object)string3);
        AnnexWorkspace annexWorkspace = new AnnexWorkspace(string);
        if (this.url == null) {
            return annexWorkspace;
        }
        this.waitUntilFree();
        this.setLock(true);
        if (this.open()) {
            try {
                PreparedStatement preparedStatement = con.prepareStatement(string3);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        String string4 = resultSet.getString("urid");
                        logger.info((Object)string4);
                        AnnexWSItem annexWSItem = new AnnexWSItem(string4);
                        this.RSToWSItem(resultSet, annexWSItem, false);
                        annexWorkspace.addWSItem(annexWSItem);
                    }
                    resultSet.close();
                }
                preparedStatement.close();
            }
            catch (Exception exception) {
                logger.error((Object)"loadWS error");
                exception.printStackTrace();
            }
            this.close();
        } else {
            logger.error((Object)"Could not open DB.");
        }
        this.setLock(false);
        return annexWorkspace;
    }

    public AnnexWSItem loadWSItem(String string, String string2) {
        return this.loadWSItem(string, string2, 0);
    }

    public AnnexWSItem loadWSItem(String string, String string2, int n) {
        if (this.url == null) {
            return null;
        }
        String string3 = " urid,atrans,wsidx,type,version,dt_created,dt_lastmod,comment,notes,filename,scr_info ";
        String string4 = "SELECT" + string3 + "FROM " + this.pg_schema + "." + this.pg_table;
        string4 = string4 + " WHERE uid = '" + string + "' AND urid='" + string2 + "'";
        string4 = string4 + " AND wsidx = " + n;
        logger.info((Object)string4);
        AnnexWSItem annexWSItem = null;
        this.waitUntilFree();
        this.setLock(true);
        if (this.open()) {
            try {
                PreparedStatement preparedStatement = con.prepareStatement(string4);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    if (resultSet.next()) {
                        annexWSItem = new AnnexWSItem(string2);
                        this.RSToWSItem(resultSet, annexWSItem, true);
                    }
                    resultSet.close();
                }
                preparedStatement.close();
            }
            catch (Exception exception) {
                logger.error((Object)"loadWSItem error");
                exception.printStackTrace();
            }
            this.close();
        } else {
            logger.error((Object)"Could not open DB.");
        }
        this.setLock(false);
        return annexWSItem;
    }

    public ArrayList getWSList(String string) {
        String string2 = "SELECT DISTINCT wsidx FROM " + this.pg_schema + "." + this.pg_table;
        string2 = string2 + " WHERE uid = '" + string + "'";
        string2 = string2 + " ORDER BY wsidx";
        logger.info((Object)string2);
        this.waitUntilFree();
        this.setLock(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.open()) {
            try {
                PreparedStatement preparedStatement = con.prepareStatement(string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        int n = resultSet.getInt("wsidx");
                        arrayList.add(n);
                    }
                }
            }
            catch (Exception exception) {
                logger.error((Object)"getWSList error");
                exception.printStackTrace();
            }
            this.close();
        }
        this.setLock(false);
        return arrayList;
    }

    public boolean containsUrid(String string, String string2) {
        return this.containsUrid(string, string2, 0);
    }

    public boolean containsUrid(String string, String string2, int n) {
        if (this.url == null) {
            return false;
        }
        String string3 = " urid ";
        String string4 = "SELECT" + string3 + "FROM " + this.pg_schema + "." + this.pg_table;
        string4 = string4 + " WHERE uid = '" + string + "' AND urid='" + string2 + "'";
        string4 = string4 + " AND wsidx = " + n;
        logger.info((Object)string4);
        this.waitUntilFree();
        this.setLock(true);
        boolean bl = false;
        if (this.open()) {
            try {
                PreparedStatement preparedStatement = con.prepareStatement(string4);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    String string5;
                    if (resultSet.next() && string2.equals(string5 = resultSet.getString("urid"))) {
                        bl = true;
                    }
                    resultSet.close();
                }
                preparedStatement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.close();
        } else {
            logger.error((Object)"Could not open DB.");
        }
        this.setLock(false);
        return bl;
    }

    public void deleteWSItem(String string, String string2) {
        this.deleteWSItem(string, string2, 0);
    }

    public void deleteWSItem(String string, String string2, int n) {
        if (this.url == null) {
            return;
        }
        String string3 = "DELETE FROM " + this.pg_schema + "." + this.pg_table;
        string3 = string3 + " WHERE uid = '" + string + "' AND urid='" + string2 + "' AND wsidx = " + n;
        logger.info((Object)string3);
        this.waitUntilFree();
        this.setLock(true);
        if (this.open()) {
            try {
                Statement statement = null;
                statement = con.createStatement();
                int n2 = statement.executeUpdate(string3);
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.close();
        } else {
            logger.error((Object)"Could not open DB.");
        }
        this.setLock(false);
    }

    private void waitUntilFree() {
        while (busy) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.info((Object)"waitUntilFree()");
        }
        this.setLock(true);
    }

    private void setLock(boolean bl) {
        busy = bl;
    }

    public String showWS() {
        String string = " uid,atrans,urid,wsidx,type,version,dt_created,dt_lastmod,comment,notes, filename ";
        String string2 = "SELECT" + string + "FROM " + this.pg_schema + "." + this.pg_table;
        string2 = string2 + " ORDER BY dt_created";
        logger.info((Object)string2);
        this.waitUntilFree();
        this.setLock(true);
        String string3 = "";
        if (this.open()) {
            try {
                PreparedStatement preparedStatement = con.prepareStatement(string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        String string4 = resultSet.getString("urid");
                        logger.info((Object)string4);
                        string3 = string3 + resultSet.getString("urid") + resultSet.getString("uid");
                        string3 = string3 + "<br>";
                    }
                    resultSet.close();
                }
                preparedStatement.close();
            }
            catch (Exception exception) {
                logger.error((Object)"showWS error");
                exception.printStackTrace();
            }
            this.close();
        } else {
            logger.error((Object)"Could not open DB.");
        }
        this.setLock(false);
        return string3;
    }
}

