/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import com.ibm.media.bean.multiplayer.GrayFilter;
import com.ibm.media.bean.multiplayer.ImageLabel;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.net.URL;

public class ImageButton
extends ImageLabel {
    protected static final int defaultBorderWidth = 4;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    private char[] text;
    private boolean txtButton = false;
    private boolean mouseIsDown = false;
    String actionCommand;
    transient ActionListener actionListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    private int darkness = -5263441;
    private Image grayImage = null;

    public ImageButton() {
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(Image image) {
        super(image);
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(String string) {
        super(string);
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(String string, boolean bl, int n2, int n3) {
        this.width = n2;
        this.height = n3;
        if (bl) {
            int n4 = string.length();
            this.text = new char[n4];
            string.getChars(0, n4, this.text, 0);
            this.txtButton = bl;
        }
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(URL uRL) {
        super(uRL);
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(URL uRL, String string) {
        super(uRL, string);
        this.enableEvents(144L);
        this.setBorders();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.debug("[addActionListener]: " + actionListener);
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    private void createGrayImage(Graphics graphics) {
        GrayFilter grayFilter = new GrayFilter(this.darkness);
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getImage().getSource(), grayFilter);
        this.grayImage = this.createImage(filteredImageSource);
        int n2 = this.getBorder();
        if (this.hasExplicitSize()) {
            this.prepareImage(this.grayImage, this.getWidth() - 2 * n2, this.getHeight() - 2 * n2, this);
        } else {
            this.prepareImage(this.grayImage, this);
        }
        super.paint(graphics);
    }

    public void drawBorder(boolean bl) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.getBorderColor());
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        int n6 = this.getBorder();
        int n7 = 0;
        while (n7 < n6) {
            graphics.draw3DRect(n2, n3, n4, n5, bl);
            ++n2;
            ++n3;
            n4 -= 2;
            n5 -= 2;
            ++n7;
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public int getDarkness() {
        return this.darkness;
    }

    public Image getGrayImage() {
        return this.grayImage;
    }

    public void paint(Graphics graphics) {
        if (!this.doneLoading) {
            this.waitForImage(true);
        } else if (!this.txtButton) {
            if (this.explicitSize) {
                graphics.drawImage(this.image, this.border, this.border, this.width - 2 * this.border, this.height - 2 * this.border, this);
            } else {
                graphics.drawImage(this.image, this.border, this.border, this);
            }
            this.drawRect(graphics, 0, 0, this.width - 1, this.height - 1, this.border, this.borderColor);
            if (this.grayImage == null) {
                this.createGrayImage(graphics);
            }
        } else {
            int n2 = this.text.length * 9 / 2;
            graphics.drawChars(this.text, 0, this.text.length, this.width / 2 - n2, this.height / 2 + 5);
        }
        this.drawBorder(true);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        this.debug("Action Event occurred.");
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        this.debug("[processEvent]: " + aWTEvent);
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof MouseEvent) {
            this.processMouseEvent((MouseEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 502) {
            this.mouseIsDown = false;
            this.paint(this.getGraphics());
            this.processEvent(new ActionEvent(this, 1001, this.actionCommand));
        } else if (mouseEvent.getID() == 501) {
            this.mouseIsDown = true;
            Graphics graphics = this.getGraphics();
            int n2 = this.getBorder();
            if (!this.txtButton) {
                if (this.hasExplicitSize()) {
                    graphics.drawImage(this.getGrayImage(), n2, n2, this.getWidth() - 2 * n2, this.getHeight() - 2 * n2, this);
                } else {
                    graphics.drawImage(this.getGrayImage(), n2, n2, this);
                }
            }
            this.drawBorder(false);
        } else if (mouseEvent.getID() == 505 && this.mouseIsDown) {
            this.paint(this.getGraphics());
        }
        super.processMouseEvent(mouseEvent);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    private void setBorders() {
        this.setBorder(4);
        this.setBorderColor(defaultBorderColor);
    }

    public void setDarkness(int n2) {
        this.darkness = n2;
    }

    public void setGrayImage(Image image) {
        this.grayImage = image;
    }

    protected void setText(String string) {
        if (this.txtButton) {
            this.text = new char[string.length()];
            string.getChars(0, string.length(), this.text, 0);
            this.paint(this.getGraphics());
            this.validate();
        }
    }

    public void waitForImage(boolean bl) {
        if (this.txtButton) {
            this.resize(this.width, this.height);
            this.doneLoading = true;
            return;
        }
        super.waitForImage(bl);
    }
}

