/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.sun.media.JMFSecurityManager;
import com.sun.media.util.DynamicPlugIn;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class ACMCodec
implements Codec,
DynamicPlugIn {
    private Vector supportedInputFormats = null;
    private Vector supportedOutputFormats = null;
    private AudioFormat[] inputFormats = null;
    private AudioFormat[] outputFormats = null;
    private AudioFormat inputFormat = null;
    private AudioFormat outputFormat = null;
    private long nativeHandle;

    static {
        JMFSecurityManager.loadLibrary("jmacm");
    }

    private native boolean ACMProcess(long var1, byte[] var3, int var4, int var5, Buffer var6, byte[] var7, int var8, Buffer var9);

    public void close() {
        this.closeACMStream(this.nativeHandle);
    }

    private native void closeACMStream(long var1);

    private native void fillSupportedInputFormats();

    private native void fillSupportedOutputFormats(AudioFormat var1);

    public Format[] getBaseInputFormats() {
        Format[] formatArray = new Format[]{new AudioFormat(null)};
        return formatArray;
    }

    public Format[] getBaseOutputFormats() {
        return this.getBaseInputFormats();
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Control[0];
    }

    private native int getDestinationBufferSize(long var1, int var3);

    public String getName() {
        return "ACM Wrapper Codec";
    }

    public Format[] getSupportedInputFormats() {
        if (this.inputFormats != null) {
            return this.inputFormats;
        }
        this.supportedInputFormats = new Vector();
        this.fillSupportedInputFormats();
        int n2 = this.supportedInputFormats.size();
        this.inputFormats = new AudioFormat[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.inputFormats[n3] = (AudioFormat)this.supportedInputFormats.elementAt(n3);
            ++n3;
        }
        return this.inputFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            this.outputFormats = new AudioFormat[1];
            this.outputFormats[0] = new AudioFormat(null);
            return this.outputFormats;
        }
        if (!(format instanceof AudioFormat)) {
            this.outputFormats = new AudioFormat[0];
            return this.outputFormats;
        }
        this.supportedOutputFormats = new Vector();
        this.fillSupportedOutputFormats((AudioFormat)format);
        int n2 = this.supportedOutputFormats.size();
        this.outputFormats = new AudioFormat[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.outputFormats[n3] = (AudioFormat)this.supportedOutputFormats.elementAt(n3);
            ++n3;
        }
        return this.outputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.nativeHandle = this.openACMStream(this.inputFormat, this.outputFormat);
        if (this.nativeHandle == 0L) {
            throw new ResourceUnavailableException("ACM stream coun't been opened");
        }
    }

    private native long openACMStream(AudioFormat var1, AudioFormat var2);

    public int process(Buffer buffer, Buffer buffer2) {
        if (buffer.isEOM()) {
            buffer2.setLength(0);
            buffer2.setEOM(true);
            return 0;
        }
        int n2 = buffer.getOffset();
        int n3 = this.getDestinationBufferSize(this.nativeHandle, buffer.getLength());
        if (buffer2.getData() == null || n3 > ((byte[])buffer2.getData()).length) {
            byte[] byArray = new byte[n3];
            buffer2.setData(byArray);
        }
        buffer2.setLength(n3);
        buffer2.setOffset(0);
        buffer2.setFormat(this.outputFormat);
        if (!this.ACMProcess(this.nativeHandle, (byte[])buffer.getData(), buffer.getOffset(), buffer.getLength(), buffer, (byte[])buffer2.getData(), buffer2.getLength(), buffer2)) {
            return 1;
        }
        if (n2 != buffer.getOffset()) {
            return 2;
        }
        return 0;
    }

    public void reset() {
        this.resetACMStream(this.nativeHandle);
    }

    private native void resetACMStream(long var1);

    public Format setInputFormat(Format format) {
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.inputFormat = (AudioFormat)format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.outputFormat = (AudioFormat)format;
        return format;
    }
}

