/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.g723;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.g723.G723Dec;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    protected G723Dec decoder;

    public JavaDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("g723"), new AudioFormat("g723/rtp")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "G723 Decoder";
    }

    protected int calculateOutputSize(int n2) {
        return n2 / 24 * 480;
    }

    public void close() {
        this.freeDecoder();
    }

    protected void decode(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n4 / 24;
        int n6 = 24;
        int n7 = 0;
        while (n7 < n5) {
            this.decoder.decodeFrame(byArray, n2, byArray2, n3);
            ++n7;
            n2 += n6;
            n3 += 480;
        }
    }

    protected void freeDecoder() {
        this.decoder = null;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, true, false);
        }
        return this.controls;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, 1, 0, 1)};
        return this.supportedOutputFormats;
    }

    protected void initDecoder() {
        this.decoder.decoderReset();
    }

    public void open() throws ResourceUnavailableException {
        this.decoder = new G723Dec();
        this.decoder.decoderOpen();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n2 = buffer.getLength();
        int n3 = this.calculateOutputSize(buffer.getLength());
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, n3);
        this.decode(byArray, buffer.getOffset(), byArray2, 0, n2);
        this.updateOutput(buffer2, this.outputFormat, n3, 0);
        return 0;
    }

    public void reset() {
        this.resetDecoder();
    }

    protected void resetDecoder() {
        this.decoder.decoderReset();
    }
}

