/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.h263;

import com.ibm.media.codec.video.h263.FrameBuffer;
import com.ibm.media.codec.video.h263.H263RtpPayloadParser;
import com.ibm.media.codec.video.h263.ReadStream;
import java.awt.Point;

public class H263Decoder
extends ReadStream {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997-1999.";
    private static final boolean DEBUG = false;
    private static final int I_PICTURE = 0;
    private static final int P_PICTURE = 1;
    private static final int INTRA_STUFFING = -1;
    private static final int INTER_STUFFING = -1;
    private static final int ESCAPE_CODE = 7167;
    private static final int PSC = 32;
    private static final int GBSC_1 = 33;
    private static final int GBSC_17 = 49;
    private static final int GBSC_30 = 62;
    private static final int EOS = 63;
    private static final int INIT_FORMAT = 9;
    private static final int USER_DEFINED_FORMAT = 7;
    private static final int SUB_QCIF_FORMAT = 1;
    private static final int QCIF_PAL_FORMAT = 2;
    private static final int CIF_PAL_FORMAT = 3;
    private static final int W0 = 277;
    private static final int W1 = 362;
    private static final int W2 = 473;
    private static final int W3 = 669;
    public static final int H263_RC_PICTURE_NOT_DONE = 0;
    public static final int H263_RC_PICTURE_DONE = 1;
    public static final int H263_RC_PICTURE_FORMAT_NOT_SUPPORTED = 2;
    public static final int H263_RC_PICTURE_FORMAT_NOT_INITED = 3;
    public int TemporalReference;
    public int LastTemporalReference;
    private int rtpTemporalReference;
    private int HeaderPlus;
    private int TypeInformation;
    private int CodingType;
    private int UnrestrictedMV;
    private int DeblockingFilter;
    private int SourceFormat;
    private int CPM;
    private int Quantizer;
    private int GroupNumber;
    private int GOB_FrameID;
    private int[][] BlockData;
    private int[][] BlockPtr = new int[6][];
    private int[] BlockOffset = new int[6];
    private int[] FrameWidthBlock;
    private int LastValue;
    private int FrameWidth;
    private int FrameWidthDiv2;
    private int FrameWidthx8;
    private int FrameHeight;
    private int HorMV;
    private int VerMV;
    private int Half_HorMV;
    private int Half_VerMV;
    private int xFrameWidth;
    private int xFrameWidthDiv2;
    public FrameBuffer CurrentFrame;
    protected boolean frameDone;
    private boolean foundPSC = false;
    private boolean standardH263Only;
    private long prevTimeStamp = 0L;
    private FrameBuffer PreviousFrame;
    private FrameBuffer xPrevFrame;
    private int MB_address;
    private int FirstMBinGOB;
    private int MBperGOB;
    private int MBpositionInGOB;
    private int GOBperFrame;
    private boolean HeaderInGOB;
    private int CurrentLumiOffset;
    private int CurrentCromOffset;
    private int xCurrentLumiOffset;
    private int xCurrentCromOffset;
    private static final int[] LumiOffset;
    private static final int[] CromOffset;
    private static final int[] xLumiOffset;
    private static final int[] xCromOffset;
    private static final int[] CodedMap;
    private int[] MBtypeCurrGOB;
    private int[] MBtypePrevGOB;
    private Point[] MotVectCurrGOB;
    private Point[] MotVectPrevGOB;
    private int prevCBP;
    private static final int[] dQuant;
    private static final int[][] recLevel_tab;
    private static final int[] clipQ_tab;
    private static final int[] pre8x8_tab;
    private static final int[] STRENGTH;
    private static final int[] zigzag_tab;
    private static final int[] IntraMCBPC_VLC_tab0;
    private static final int[] IntraMCBPC_VLC_tab1;
    private static final int[] InterMCBPC_VLC_tab0;
    private static final int[] InterMCBPC_VLC_tab1;
    private static final int[] CBPY_VLC_tab0;
    private static final int[] CBPY_VLC_tab1;
    private static final int[] MVD1_VLC_tab0;
    private static final int[] MVD1_VLC_tab1;
    private static final int[] MVD2_VLC_tab0;
    private static final int[] MVD2_VLC_tab1;
    private static final int[] TCOEFF1_tab0;
    private static final int[] TCOEFF1_tab1;
    private static final int[] TCOEFF2_tab0;
    private static final int[] TCOEFF2_tab1;
    private static final int[] TCOEFF3_tab0;
    private static final int[] TCOEFF3_tab1;
    private static final int[] clipTable;
    private static final int[] DfiltClip;

    static {
        int n2;
        int n3;
        int n4;
        LumiOffset = new int[36];
        CromOffset = new int[36];
        xLumiOffset = new int[36];
        xCromOffset = new int[36];
        CodedMap = new int[2048];
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        dQuant = nArray;
        recLevel_tab = new int[32][128];
        clipQ_tab = new int[36];
        pre8x8_tab = new int[]{512, 710, 669, 602, 512, 402, 277, 141, 710, 985, 928, 835, 710, 558, 384, 196, 669, 928, 874, 787, 669, 526, 362, 185, 602, 835, 787, 708, 602, 473, 326, 166, 512, 710, 669, 602, 512, 402, 277, 141, 402, 558, 526, 473, 402, 316, 218, 111, 277, 384, 362, 326, 277, 218, 150, 76, 141, 196, 185, 166, 141, 111, 76, 39};
        STRENGTH = new int[31];
        zigzag_tab = new int[64];
        IntraMCBPC_VLC_tab0 = new int[64];
        IntraMCBPC_VLC_tab1 = new int[64];
        InterMCBPC_VLC_tab0 = new int[512];
        InterMCBPC_VLC_tab1 = new int[512];
        CBPY_VLC_tab0 = new int[64];
        CBPY_VLC_tab1 = new int[64];
        MVD1_VLC_tab0 = new int[256];
        MVD1_VLC_tab1 = new int[256];
        MVD2_VLC_tab0 = new int[256];
        MVD2_VLC_tab1 = new int[256];
        TCOEFF1_tab0 = new int[112];
        TCOEFF1_tab1 = new int[112];
        TCOEFF2_tab0 = new int[96];
        TCOEFF2_tab1 = new int[96];
        TCOEFF3_tab0 = new int[120];
        TCOEFF3_tab1 = new int[120];
        clipTable = new int[1024];
        DfiltClip = new int[512];
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        while (n8 < 32) {
            H263Decoder.zigzag_tab[n8] = n4 = n5 * 8 + n6;
            H263Decoder.zigzag_tab[63 - n8] = 63 - n4;
            n5 -= n7;
            if ((n6 += n7) < 0) {
                n7 = 1;
                n6 = 0;
            }
            if (n5 < 0) {
                n7 = -1;
                n5 = 0;
            }
            ++n8;
        }
        n4 = 0;
        while (n4 < 1024) {
            H263Decoder.clipTable[n4] = n4 < 256 ? n4 : (n4 < 512 ? 255 : 0);
            ++n4;
        }
        int n9 = 0;
        while (n9 < recLevel_tab.length) {
            n3 = 0;
            while (n3 < recLevel_tab[n9].length) {
                if (n3 == 0) {
                    H263Decoder.recLevel_tab[n9][n3] = 0;
                } else {
                    n2 = n9 * (2 * n3 + 1);
                    H263Decoder.recLevel_tab[n9][n3] = n2 < -2048 ? -2048 : (n2 > 2047 ? 2047 : n2);
                }
                ++n3;
            }
            ++n9;
        }
        n3 = 0;
        while (n3 < clipQ_tab.length) {
            n2 = n3 - 2;
            H263Decoder.clipQ_tab[n3] = n2 < 1 ? 1 : (n2 > 31 ? 31 : n2);
            ++n3;
        }
        n2 = 1;
        while (n2 < IntraMCBPC_VLC_tab0.length) {
            int n10 = n2 <= 3 ? 64 + n2 : (n2 <= 7 ? 64 : (H263Decoder.IntraMCBPC_VLC_tab0[n2] = n2 <= 31 ? n2 / 8 + 48 : 48));
            H263Decoder.IntraMCBPC_VLC_tab1[n2] = n2 <= 3 ? 6 : (n2 <= 7 ? 4 : (n2 <= 31 ? 3 : 1));
            ++n2;
        }
        int n11 = 1;
        while (n11 < InterMCBPC_VLC_tab0.length) {
            int n12 = n11 <= 1 ? -1 : (n11 <= 4 ? 69 - n11 : (n11 <= 5 ? 19 : (n11 <= 9 ? 53 - n11 / 2 : (n11 <= 11 ? 35 : (n11 <= 15 ? 51 : (n11 <= 19 ? 34 : (n11 <= 23 ? 33 : (n11 <= 27 ? 18 : (n11 <= 31 ? 17 : (n11 <= 39 ? 64 : (n11 <= 47 ? 3 : (n11 <= 63 ? 48 : (n11 <= 95 ? 2 : (n11 <= 127 ? 1 : (n11 <= 191 ? 32 : (H263Decoder.InterMCBPC_VLC_tab0[n11] = n11 < 256 ? 16 : 0))))))))))))))));
            H263Decoder.InterMCBPC_VLC_tab1[n11] = n11 <= 5 ? 9 : (n11 <= 11 ? 8 : (n11 <= 31 ? 7 : (n11 <= 47 ? 6 : (n11 <= 63 ? 5 : (n11 <= 127 ? 4 : (n11 <= 255 ? 3 : 1))))));
            ++n11;
        }
        int n13 = 2;
        while (n13 < CBPY_VLC_tab0.length) {
            int n14 = n13 <= 2 ? 105 : (n13 <= 3 ? 150 : (n13 <= 5 ? 135 : (n13 <= 7 ? 75 : (n13 <= 9 ? 45 : (n13 <= 11 ? 30 : (n13 <= 15 ? 15 : (n13 <= 19 ? 195 : (n13 <= 23 ? 165 : (n13 <= 27 ? 225 : (n13 <= 31 ? 90 : (n13 <= 35 ? 210 : (n13 <= 39 ? 60 : (n13 <= 43 ? 180 : (H263Decoder.CBPY_VLC_tab0[n13] = n13 <= 47 ? 120 : 240))))))))))))));
            H263Decoder.CBPY_VLC_tab1[n13] = n13 <= 3 ? 6 : (n13 <= 11 ? 5 : (n13 <= 47 ? 4 : 2));
            ++n13;
        }
        int n15 = 6;
        while (n15 < MVD1_VLC_tab0.length) {
            int n16 = n15 <= 11 ? (10 - n15 / 2) * (1 - (n15 & 1) * 2) : (n15 <= 15 ? 4 * (1 - (n15 & 2)) : (n15 <= 31 ? 3 * (1 - (1 & n15 >> 3) * 2) : (n15 <= 63 ? 2 * (1 - (1 & n15 >> 4) * 2) : (H263Decoder.MVD1_VLC_tab0[n15] = n15 < 128 ? 1 - (1 & n15 >> 5) * 2 : 0))));
            H263Decoder.MVD1_VLC_tab1[n15] = n15 <= 11 ? 8 : (n15 <= 15 ? 7 : (n15 <= 31 ? 5 : (n15 <= 63 ? 4 : (n15 <= 127 ? 3 : 1))));
            ++n15;
        }
        int n17 = 0;
        while (n17 < MVD2_VLC_tab0.length) {
            int n18 = n17 < 5 ? 0 : (n17 == 5 ? -32 : (n17 <= 7 ? 31 * (1 - (n17 & 1) * 2) : (n17 <= 31 ? (32 - (n17 >> 2)) * (1 - (1 & n17 >> 1) * 2) : (H263Decoder.MVD2_VLC_tab0[n17] = n17 <= 143 ? (28 - (n17 >> 3)) * (1 - (1 & n17 >> 2) * 2) : (19 - (n17 >> 4)) * (1 - (1 & n17 >> 3) * 2)))));
            H263Decoder.MVD2_VLC_tab1[n17] = n17 <= 4 ? 5 : (n17 <= 7 ? 13 : (n17 <= 31 ? 12 : (n17 <= 143 ? 11 : (n17 <= 191 ? 10 : 5))));
            ++n17;
        }
        int n19 = 0;
        while (n19 < TCOEFF1_tab0.length) {
            int n20 = n19 <= 3 ? 4225 - n19 * 16 : (n19 <= 6 ? 257 - n19 * 16 : (n19 <= 7 ? 4 : (n19 <= 15 ? 4225 - n19 / 2 * 16 : (n19 <= 23 ? 273 - n19 / 2 * 16 : (n19 <= 25 ? 18 : (n19 <= 27 ? 3 : (n19 <= 39 ? 193 - n19 / 4 * 16 : (n19 <= 47 ? 4097 : (n19 <= 79 ? 1 : (n19 <= 95 ? 17 : (H263Decoder.TCOEFF1_tab0[n19] = n19 <= 103 ? 33 : 2)))))))))));
            H263Decoder.TCOEFF1_tab1[n19] = n19 <= 7 ? 7 : (n19 <= 27 ? 6 : (n19 <= 39 ? 5 : (n19 <= 47 ? 4 : (n19 <= 79 ? 2 : (n19 <= 95 ? 3 : 4)))));
            ++n19;
        }
        int n21 = 0;
        while (n21 < TCOEFF2_tab0.length) {
            int n22 = n21 <= 1 ? 9 - n21 : (n21 <= 17 ? 4497 - n21 / 2 * 16 : (n21 <= 19 ? 4098 : (n21 <= 35 ? 513 - n21 / 2 * 16 : (n21 <= 39 ? 354 - n21 / 2 * 16 : (n21 <= 43 ? 27 - n21 / 2 : (n21 <= 75 ? 4529 - n21 / 4 * 16 : (n21 <= 83 ? 529 - n21 / 4 * 16 : (H263Decoder.TCOEFF2_tab0[n21] = n21 <= 91 ? 349 - n21 / 4 * 15 : 5))))))));
            H263Decoder.TCOEFF2_tab1[n21] = n21 <= 1 ? 10 : (n21 <= 43 ? 9 : 8);
            ++n21;
        }
        int n23 = 0;
        while (n23 < TCOEFF3_tab0.length) {
            int n24 = n23 <= 3 ? 4114 - n23 / 2 * 15 : (n23 <= 7 ? 13 - n23 / 2 : (n23 <= 23 ? 4577 - n23 / 4 * 16 : (n23 <= 43 ? 242 - n23 / 4 * 16 : (n23 <= 51 ? 227 - n23 / 4 * 16 : (n23 <= 55 ? 20 : (n23 <= 59 ? n23 / 2 * 9 - 240 : (n23 <= 63 ? n23 / 2 * 16 - 111 : (n23 <= 71 ? n23 / 2 * 16 + 4049 : (n23 <= 72 ? 22 : (n23 <= 73 ? 36 : (n23 <= 74 ? 67 : (n23 <= 75 ? 83 : (n23 <= 76 ? 99 : (n23 <= 77 ? 162 : (n23 <= 78 ? 401 : (n23 <= 79 ? 417 : (H263Decoder.TCOEFF3_tab0[n23] = n23 <= 87 ? n23 * 16 + 3345 : 7167)))))))))))))))));
            H263Decoder.TCOEFF3_tab1[n23] = n23 <= 7 ? 11 : (n23 <= 55 ? 10 : (n23 <= 71 ? 11 : (n23 <= 87 ? 12 : 6)));
            ++n23;
        }
        int n25 = 0;
        while (n25 < 31) {
            H263Decoder.STRENGTH[n25] = n25 < 6 ? (n25 >> 1) + 1 : (n25 < 9 ? 4 : (n25 < 13 ? n25 + 1 >> 1 : (n25 + 2) / 3 + 2));
            ++n25;
        }
        int n26 = 0;
        while (n26 < 512) {
            H263Decoder.DfiltClip[n26] = n26 < 128 ? 0 : (n26 < 384 ? n26 - 128 : 255);
            ++n26;
        }
    }

    public H263Decoder(boolean bl) {
        this.standardH263Only = bl;
        this.SourceFormat = 9;
        this.foundPSC = false;
        this.TemporalReference = 0;
        this.LastTemporalReference = 0;
        this.BlockData = new int[6][64];
        this.FrameWidthBlock = new int[6];
        this.MotVectCurrGOB = new Point[88];
        this.MotVectPrevGOB = new Point[88];
        int n2 = 0;
        while (n2 < 88) {
            this.MotVectCurrGOB[n2] = new Point(0, 0);
            this.MotVectPrevGOB[n2] = new Point(0, 0);
            ++n2;
        }
        this.MBtypeCurrGOB = new int[22];
        this.MBtypePrevGOB = new int[22];
    }

    private final void BasePredPel() {
        int[] nArray;
        int n2;
        int[] nArray2;
        int n3 = this.MotVectCurrGOB[this.MBpositionInGOB].x;
        int n4 = this.MotVectCurrGOB[this.MBpositionInGOB].y;
        if (n3 < -32 && this.MBpositionInGOB == 0) {
            n3 = -32;
        } else if (n3 > 32 && this.MBpositionInGOB == this.GOBperFrame - 1) {
            n3 = 32;
        }
        this.HorMV = n3 >> 1;
        this.Half_HorMV = n3 & 1;
        if (n4 < -32 && this.GroupNumber == 0) {
            n4 = -32;
        } else if (n4 > 32 && this.GroupNumber == this.GOBperFrame - 1) {
            n4 = 32;
        }
        this.VerMV = n4 >> 1;
        this.Half_VerMV = n4 & 1;
        int[] nArray3 = this.CurrentFrame.Y;
        int n5 = this.CurrentLumiOffset;
        if (this.UnrestrictedMV != 0) {
            nArray2 = this.xPrevFrame.Y;
            n2 = this.xCurrentLumiOffset + this.VerMV * this.xFrameWidth + this.HorMV;
        } else {
            nArray2 = this.PreviousFrame.Y;
            n2 = this.CurrentLumiOffset + this.VerMV * this.FrameWidth + this.HorMV;
        }
        if (this.Half_HorMV != 0 && this.Half_VerMV != 0) {
            this.InterpF16x16Pel(nArray2, n2, nArray3, n5);
        } else if (this.Half_HorMV != 0 || this.Half_VerMV != 0) {
            this.Interp16x16Pel(nArray2, n2, nArray3, n5, this.Half_HorMV, this.Half_VerMV);
        } else {
            this.Copy16x16Pel(nArray2, n2, nArray3, n5);
        }
        this.Half_HorMV |= this.HorMV & 1;
        this.HorMV >>= 1;
        this.Half_VerMV |= this.VerMV & 1;
        this.VerMV >>= 1;
        nArray3 = this.CurrentFrame.Cr;
        n5 = this.CurrentCromOffset;
        int[] nArray4 = this.CurrentFrame.Cb;
        if (this.UnrestrictedMV != 0) {
            nArray2 = this.xPrevFrame.Cr;
            n2 = this.xCurrentCromOffset + this.VerMV * this.xFrameWidthDiv2 + this.HorMV;
            nArray = this.xPrevFrame.Cb;
        } else {
            nArray2 = this.PreviousFrame.Cr;
            n2 = this.CurrentCromOffset + this.VerMV * this.FrameWidthDiv2 + this.HorMV;
            nArray = this.PreviousFrame.Cb;
        }
        if (this.Half_HorMV != 0 && this.Half_VerMV != 0) {
            this.InterpF8x8Pel(nArray2, n2, nArray3, n5);
            this.InterpF8x8Pel(nArray, n2, nArray4, n5);
        } else if (this.Half_HorMV != 0 || this.Half_VerMV != 0) {
            this.Interp8x8Pel(nArray2, n2, nArray3, n5, this.Half_HorMV, this.Half_VerMV);
            this.Interp8x8Pel(nArray, n2, nArray4, n5, this.Half_HorMV, this.Half_VerMV);
        } else {
            this.Copy8x8Pel(nArray2, n2, nArray3, n5);
            this.Copy8x8Pel(nArray, n2, nArray4, n5);
        }
    }

    private final int CALC_MVC(int n2, int n3) {
        return this.UnrestrictedMV == 0 ? (n2 + n3 + 96 & 0x3F) - 32 : (n3 >= 33 ? n2 + n3 & 0x3F : (n3 <= -32 ? -(-(n2 + n3) & 0x3F) : n2 + n3));
    }

    private final int ChangeFormat(int n2, int n3) {
        switch (n2) {
            case 1: {
                this.FrameWidth = 128;
                this.FrameHeight = 96;
                break;
            }
            case 2: {
                this.FrameWidth = 176;
                this.FrameHeight = 144;
                break;
            }
            case 3: {
                this.FrameWidth = 352;
                this.FrameHeight = 288;
                break;
            }
            default: {
                return 2;
            }
            case 7: 
        }
        this.GOBperFrame = this.FrameHeight >> 4;
        this.MBperGOB = this.FrameWidth >> 4;
        int n4 = 0;
        while (n4 < this.GOBperFrame) {
            H263Decoder.LumiOffset[n4] = (this.FrameWidth << 4) * n4;
            H263Decoder.CromOffset[n4] = (this.FrameWidth << 2) * n4;
            H263Decoder.xLumiOffset[n4] = 16 + (32 + this.FrameWidth << 4) * (n4 + 1);
            H263Decoder.xCromOffset[n4] = 8 + (16 + (this.FrameWidth >> 1) << 3) * (n4 + 1);
            ++n4;
        }
        this.FrameWidthDiv2 = this.FrameWidth >> 1;
        this.FrameWidthx8 = this.FrameWidth << 3;
        this.CurrentFrame = new FrameBuffer(this.FrameWidth, this.FrameHeight);
        this.PreviousFrame = new FrameBuffer(this.FrameWidth, this.FrameHeight);
        this.FrameWidthBlock[0] = this.FrameWidth;
        this.FrameWidthBlock[1] = this.FrameWidth;
        this.FrameWidthBlock[2] = this.FrameWidth;
        this.FrameWidthBlock[3] = this.FrameWidth;
        this.FrameWidthBlock[4] = this.FrameWidthDiv2;
        this.FrameWidthBlock[5] = this.FrameWidthDiv2;
        if (n3 == 1) {
            this.xFrameWidth = this.FrameWidth + 32;
            this.xFrameWidthDiv2 = this.xFrameWidth >> 1;
            this.xPrevFrame = new FrameBuffer(this.FrameWidth + 32, this.FrameHeight + 32);
        } else {
            this.xFrameWidth = this.FrameWidth;
            this.xFrameWidthDiv2 = this.xFrameWidth >> 1;
            this.xPrevFrame = null;
        }
        this.SourceFormat = n2;
        return 0;
    }

    private final void Copy16x16Pel(int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = this.FrameWidth;
        int n5 = this.xFrameWidth;
        int n6 = 0;
        while (n6 < 16) {
            System.arraycopy(nArray, n2, nArray2, n3, 16);
            n3 += n4;
            n2 += n5;
            ++n6;
        }
    }

    private final void Copy8x8Pel(int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = this.FrameWidthDiv2;
        int n5 = this.xFrameWidthDiv2;
        int n6 = 0;
        while (n6 < 8) {
            System.arraycopy(nArray, n2, nArray2, n3, 8);
            n3 += n4;
            n2 += n5;
            ++n6;
        }
    }

    public final void CopyExtendedFrame(int[] nArray, int[] nArray2, int n2, int n3, int n4, int n5) {
        int n6 = n2 * n3;
        int n7 = n4 * (n3 + (n5 << 1));
        int n8 = n4 * n5;
        int n9 = 0;
        int n10 = n8 + n5;
        while (n9 < n6) {
            System.arraycopy(nArray, n9, nArray2, n10, n2);
            n9 += n2;
            n10 += n4;
        }
        n10 = n8;
        n9 = 0;
        while (n10 < n7 - n8) {
            int n11 = 0;
            while (n11 < n5) {
                nArray2[n10 + n11] = nArray[n9];
                nArray2[n10 + n2 + n5 + n11] = nArray[n9 + n2 - 1];
                ++n11;
            }
            n10 += n4;
            n9 += n2;
        }
        n10 = 0;
        while (n10 < n8) {
            System.arraycopy(nArray2, n8, nArray2, n10, n5);
            System.arraycopy(nArray2, n8 + n2 + n5, nArray2, n10 + n2 + n5, n5);
            n10 += n4;
        }
        n10 = n7 - n8;
        while (n10 < n7) {
            System.arraycopy(nArray2, n7 - n8 - n4, nArray2, n10, n5);
            System.arraycopy(nArray2, n7 - n8 - n5, nArray2, n10 + n2 + n5, n5);
            n10 += n4;
        }
        n10 = n5;
        while (n10 < n8 + n5) {
            System.arraycopy(nArray2, n8 + n5, nArray2, n10, n2);
            System.arraycopy(nArray2, n7 - n8 - n4 + n5, nArray2, n10 + n7 - n8, n2);
            n10 += n4;
        }
    }

    public final int DecodeGobs(byte[] byArray, int n2) {
        int n3 = 0;
        this.setInBuf(byArray, n2);
        this.GetNextStartCode();
        int n4 = this.getBits(22);
        if (n4 != 32 && n4 != 63 && !this.foundPSC) {
            return 3;
        }
        if (n4 == 32) {
            this.foundPSC = true;
        } else if (n4 == 63) {
            return 0;
        }
        if (n4 == 63) {
            this.GetNextStartCode();
            n4 = this.getBits(22);
        }
        if (n4 != 32 && !this.foundPSC) {
            return 0;
        }
        if (n4 == 32) {
            int n5;
            this.foundPSC = true;
            int n6 = this.getBits(8);
            this.TypeInformation = this.getBits(8);
            int n7 = this.HeaderPlus = this.TypeInformation & 7;
            if (this.HeaderPlus == 7) {
                n3 = this.ParseHeaderPlus();
                if (n3 == 2) {
                    return n3;
                }
            } else {
                this.TypeInformation = this.getBits(5);
                if ((this.TypeInformation & 7) != 0) {
                    return 2;
                }
                this.CodingType = this.TypeInformation >> 4 & 1;
                this.UnrestrictedMV = (this.TypeInformation & 8) >> 3;
            }
            this.LastTemporalReference = this.TemporalReference;
            this.TemporalReference = n6;
            this.Quantizer = this.getBits(5);
            if (this.HeaderPlus != 7) {
                this.CPM = this.getBits(1);
                if (this.CPM != 0) {
                    this.getBits(2);
                }
            }
            if ((n5 = this.getBits(1)) == 1) {
                return 2;
            }
            if (n7 != this.SourceFormat && (n3 = this.ChangeFormat(n7, this.UnrestrictedMV)) == 2) {
                return n3;
            }
            FrameBuffer frameBuffer = this.CurrentFrame;
            this.CurrentFrame = this.PreviousFrame;
            this.PreviousFrame = frameBuffer;
            this.BlockPtr[0] = this.CurrentFrame.Y;
            this.BlockPtr[1] = this.CurrentFrame.Y;
            this.BlockPtr[2] = this.CurrentFrame.Y;
            this.BlockPtr[3] = this.CurrentFrame.Y;
            this.BlockPtr[4] = this.CurrentFrame.Cb;
            this.BlockPtr[5] = this.CurrentFrame.Cr;
            if (this.CodingType == 0) {
                this.GroupNumber = 0;
                this.GetIntraPictMB();
            } else {
                if (this.UnrestrictedMV == 1) {
                    this.xFrameWidth = this.FrameWidth + 32;
                    this.xFrameWidthDiv2 = this.xFrameWidth >> 1;
                    this.CopyExtendedFrame(this.PreviousFrame.Y, this.xPrevFrame.Y, this.FrameWidth, this.FrameHeight, this.xFrameWidth, 16);
                    this.CopyExtendedFrame(this.PreviousFrame.Cb, this.xPrevFrame.Cb, this.FrameWidthDiv2, this.FrameHeight >> 1, this.xFrameWidthDiv2, 8);
                    this.CopyExtendedFrame(this.PreviousFrame.Cr, this.xPrevFrame.Cr, this.FrameWidthDiv2, this.FrameHeight >> 1, this.xFrameWidthDiv2, 8);
                }
                this.GroupNumber = 0;
                this.GetInterPictMB();
            }
        } else if (n4 >= 33 && n4 <= 62) {
            int n8 = n4 & 0x1F;
            if (n8 != this.GroupNumber) {
                this.GroupNumber = n8;
            }
            if (this.CPM != 0) {
                this.skipBits(2);
            }
            this.GOB_FrameID = this.getBits(2);
            this.Quantizer = this.getBits(5);
            if (this.CodingType == 0) {
                this.GetIntraPictMB();
            } else {
                this.GetInterPictMB();
            }
        } else {
            return 2;
        }
        if (this.GroupNumber == this.GOBperFrame) {
            this.frameDone = true;
            this.foundPSC = false;
            if (this.DeblockingFilter == 1) {
                this.EdgeFilter();
            }
            return 1;
        }
        this.frameDone = false;
        return 0;
    }

    public final int DecodePicture(byte[] byArray, int n2, boolean bl) {
        int n3 = 0;
        if (bl) {
            this.frameDone = false;
            this.rdptr = n2;
            while (n3 == 0) {
                n3 = this.DecodeGobs(byArray, this.rdptr);
            }
        } else {
            n3 = this.DecodeGobs(byArray, n2);
        }
        return n3;
    }

    public final int DecodeRtpPacket(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, long l2) {
        int n5 = H263RtpPayloadParser.getMode(byArray2, n4);
        int n6 = H263RtpPayloadParser.getStartBit(byArray2, n4);
        int n7 = H263RtpPayloadParser.getEndBit(byArray2, n4);
        int n8 = H263RtpPayloadParser.getSRC(byArray2, n4);
        int n9 = 0;
        this.rdptr = n2;
        if (n5 == 0) {
            boolean bl = false;
            if (!this.frameDone && this.foundPSC && l2 != this.prevTimeStamp && l2 != 0L) {
                this.rtpTemporalReference = H263RtpPayloadParser.getTemporalReference(byArray2, n4);
                if (this.rtpTemporalReference != 0) {
                    this.TemporalReference = this.rtpTemporalReference;
                }
                this.frameDone = true;
                this.foundPSC = false;
                bl = true;
            }
            this.prevTimeStamp = l2;
            while (this.rdptr < n3 + n2) {
                try {
                    n9 = this.DecodeGobs(byArray, this.rdptr);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("[H263Decodeer::decodeRtpPacket] returning H263_RC_PICTURE_FORMAT_NOT_SUPPORTED");
                    return 2;
                }
            }
            if (bl) {
                bl = false;
                return 1;
            }
            return n9;
        }
        if (n5 == 1) {
            return 2;
        }
        return 2;
    }

    private final void EdgeFilter() {
        this.HorizEdgeFilter(this.CurrentFrame.Y, 0);
        this.VertEdgeFilter(this.CurrentFrame.Y, 0);
        this.HorizEdgeFilter(this.CurrentFrame.Cb, 1);
        this.VertEdgeFilter(this.CurrentFrame.Cb, 1);
        this.HorizEdgeFilter(this.CurrentFrame.Cr, 1);
        this.VertEdgeFilter(this.CurrentFrame.Cr, 1);
    }

    private final void FindMV() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.MB_address - this.FirstMBinGOB;
        int n7 = this.GetMVD_VLC();
        int n8 = this.GetMVD_VLC();
        if (n6 == 0) {
            n5 = 0;
            n4 = 0;
        } else {
            n5 = this.MotVectCurrGOB[n6 - 1].x;
            n4 = this.MotVectCurrGOB[n6 - 1].y;
        }
        if (this.HeaderInGOB) {
            this.MotVectCurrGOB[n6].x = this.CALC_MVC(n7, n5);
            this.MotVectCurrGOB[n6].y = this.CALC_MVC(n8, n4);
            return;
        }
        int n9 = this.MotVectPrevGOB[n6].x;
        int n10 = this.MotVectPrevGOB[n6].y;
        if (n6 + 1 == this.MBperGOB) {
            n3 = 0;
            n2 = 0;
        } else {
            n3 = this.MotVectPrevGOB[n6 + 1].x;
            n2 = this.MotVectPrevGOB[n6 + 1].y;
        }
        int n11 = this.median(n5, n9, n3);
        int n12 = this.median(n4, n10, n2);
        this.MotVectCurrGOB[n6].x = this.CALC_MVC(n7, n11);
        this.MotVectCurrGOB[n6].y = this.CALC_MVC(n8, n12);
    }

    private final int GetCBPY_VLC() {
        int n2 = this.nextBits(6);
        int n3 = CBPY_VLC_tab0[n2];
        int n4 = CBPY_VLC_tab1[n2];
        this.skipBits(n4);
        return n3;
    }

    private final void GetCoefficients(int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int[] nArray = zigzag_tab;
        int[] nArray2 = pre8x8_tab;
        int[][] nArray3 = recLevel_tab;
        int[] nArray4 = this.BlockData[n3];
        int[] nArray5 = TCOEFF1_tab0;
        int[] nArray6 = TCOEFF1_tab1;
        int[] nArray7 = TCOEFF2_tab0;
        int[] nArray8 = TCOEFF2_tab1;
        int[] nArray9 = TCOEFF3_tab0;
        int[] nArray10 = TCOEFF3_tab1;
        int n8 = n2;
        while (n8 < 64) {
            nArray4[n8] = 0;
            ++n8;
        }
        n8 = n2 - 1;
        do {
            int n9;
            int n10;
            int n11;
            if ((n5 = this.nextBits(13)) >= 1024) {
                n11 = (n5 >> 6) - 16;
                n6 = nArray5[n11];
                n7 = nArray6[n11];
            } else if (n5 >= 256) {
                n11 = (n5 >> 3) - 32;
                n6 = nArray7[n11];
                n7 = nArray8[n11];
            } else {
                n11 = (n5 >> 1) - 8;
                n6 = nArray9[n11];
                n7 = nArray10[n11];
            }
            this.skipBits(n7 + 1);
            int n12 = n6;
            if (n12 != 7167) {
                n10 = (n5 >> 12 - n7 & 1) != 0 ? -(n12 & 0xF) : n12 & 0xF;
                n9 = n12 >> 4 & 0x3F;
                n4 = n12 & 0x1000;
            } else {
                n12 = this.getBits(15);
                n10 = n12 << 24 >> 24;
                n9 = n12 >> 8 & 0x3F;
                n4 = n12 & 0x4000;
            }
            n8 += n9 + 1;
            int n13 = nArray[n8 &= 0x3F];
            if (n10 == 0) continue;
            n11 = n10 < 0 ? 1 : 0;
            n10 = Math.abs(n10);
            nArray4[n13] = (this.Quantizer & 1) != 0 ? nArray2[n13] * (n11 != 0 ? -nArray3[this.Quantizer][n10] : nArray3[this.Quantizer][n10]) : nArray2[n13] * (n11 != 0 ? 1 - nArray3[this.Quantizer][n10] : nArray3[this.Quantizer][n10] - 1);
        } while (n4 == 0);
        this.LastValue = n8;
    }

    private final int GetInterMCBPC_VLC() {
        int n2 = this.nextBits(9);
        int n3 = InterMCBPC_VLC_tab0[n2];
        int n4 = InterMCBPC_VLC_tab1[n2];
        this.skipBits(n4);
        return n3;
    }

    private final void GetInterPictMB() {
        int n2 = 0;
        int[] nArray = clipQ_tab;
        this.HeaderInGOB = true;
        do {
            this.FirstMBinGOB = this.GroupNumber * this.MBperGOB;
            this.CurrentLumiOffset = LumiOffset[this.GroupNumber];
            this.CurrentCromOffset = CromOffset[this.GroupNumber];
            this.xCurrentLumiOffset = xLumiOffset[this.GroupNumber];
            this.xCurrentCromOffset = xCromOffset[this.GroupNumber];
            this.MB_address = this.FirstMBinGOB;
            int n3 = this.FirstMBinGOB + this.MBperGOB;
            while (this.MB_address < n3) {
                int n4;
                this.MBpositionInGOB = this.MB_address - this.FirstMBinGOB;
                do {
                    if ((n4 = this.getBits(1)) == 0) continue;
                    if (this.UnrestrictedMV != 0) {
                        this.Copy16x16Pel(this.xPrevFrame.Y, this.xCurrentLumiOffset, this.CurrentFrame.Y, this.CurrentLumiOffset);
                        this.Copy8x8Pel(this.xPrevFrame.Cr, this.xCurrentCromOffset, this.CurrentFrame.Cr, this.CurrentCromOffset);
                        this.Copy8x8Pel(this.xPrevFrame.Cb, this.xCurrentCromOffset, this.CurrentFrame.Cb, this.CurrentCromOffset);
                    } else {
                        this.Copy16x16Pel(this.PreviousFrame.Y, this.CurrentLumiOffset, this.CurrentFrame.Y, this.CurrentLumiOffset);
                        this.Copy8x8Pel(this.PreviousFrame.Cr, this.CurrentCromOffset, this.CurrentFrame.Cr, this.CurrentCromOffset);
                        this.Copy8x8Pel(this.PreviousFrame.Cb, this.CurrentCromOffset, this.CurrentFrame.Cb, this.CurrentCromOffset);
                    }
                    this.MotVectCurrGOB[this.MBpositionInGOB].x = 0;
                    this.MotVectCurrGOB[this.MBpositionInGOB].y = 0;
                    this.CurrentLumiOffset += 16;
                    this.CurrentCromOffset += 8;
                    this.xCurrentLumiOffset += 16;
                    this.xCurrentCromOffset += 8;
                    break;
                } while ((n2 = this.GetInterMCBPC_VLC()) == -1);
                if (n4 == 0) {
                    int n5;
                    int n6;
                    int n7;
                    int n8 = n2 >> 4;
                    this.BlockOffset[0] = this.CurrentLumiOffset;
                    this.BlockOffset[1] = this.BlockOffset[0] + 8;
                    this.BlockOffset[2] = this.BlockOffset[0] + this.FrameWidthx8;
                    this.BlockOffset[3] = this.BlockOffset[2] + 8;
                    this.BlockOffset[4] = this.CurrentCromOffset;
                    this.BlockOffset[5] = this.CurrentCromOffset;
                    if (n8 >= 3) {
                        H263Decoder.CodedMap[this.MB_address] = 2;
                        n7 = this.GetCBPY_VLC() >> 4;
                        if (n8 == 4) {
                            this.Quantizer = nArray[this.Quantizer + dQuant[this.nextBits(2)]];
                            this.skipBits(2);
                        }
                        n6 = n7 << 2 | n2 & 3;
                        n5 = 0;
                        while (n5 < 6) {
                            int n9 = this.getBits(8);
                            if (n9 == 255) {
                                n9 = 128;
                            }
                            this.BlockData[n5][0] = n9 << 12;
                            if ((n6 & 0x20) != 0) {
                                this.GetCoefficients(1, n5);
                            }
                            this.idct8x8(this.BlockData[n5], this.BlockPtr[n5], this.BlockOffset[n5], this.FrameWidthBlock[n5], 1);
                            n6 <<= 1;
                            ++n5;
                        }
                        this.MotVectCurrGOB[this.MBpositionInGOB].x = 0;
                        this.MotVectCurrGOB[this.MBpositionInGOB].y = 0;
                    } else {
                        H263Decoder.CodedMap[this.MB_address] = 1;
                        n7 = this.GetCBPY_VLC();
                        if (n8 == 1) {
                            this.Quantizer = nArray[this.Quantizer + dQuant[this.nextBits(2)]];
                            this.skipBits(2);
                        }
                        this.FindMV();
                        this.BasePredPel();
                        n6 = n7 << 2 | n2 & 3;
                        n5 = 0;
                        while (n5 < 6) {
                            if ((n6 & 0x20) != 0) {
                                this.GetCoefficients(0, n5);
                                this.idct8x8(this.BlockData[n5], this.BlockPtr[n5], this.BlockOffset[n5], this.FrameWidthBlock[n5], 0);
                            }
                            n6 <<= 1;
                            ++n5;
                        }
                    }
                    this.CurrentLumiOffset += 16;
                    this.CurrentCromOffset += 8;
                    this.xCurrentLumiOffset += 16;
                    this.xCurrentCromOffset += 8;
                } else {
                    H263Decoder.CodedMap[this.MB_address] = 0;
                }
                ++this.MB_address;
            }
            Point[] pointArray = this.MotVectCurrGOB;
            this.MotVectCurrGOB = this.MotVectPrevGOB;
            this.MotVectPrevGOB = pointArray;
            ++this.GroupNumber;
            this.HeaderInGOB = false;
        } while (this.StartCodeFound() == 0 && this.GroupNumber < this.GOBperFrame);
    }

    private final int GetIntraMCBPC_VLC() {
        int n2 = this.nextBits(9);
        if (n2 == 1) {
            this.skipBits(9);
            return -1;
        }
        int n3 = n2 >> 3;
        int n4 = IntraMCBPC_VLC_tab0[n3];
        int n5 = IntraMCBPC_VLC_tab1[n3];
        this.skipBits(n5);
        return n4;
    }

    private final void GetIntraPictMB() {
        int[] nArray = clipQ_tab;
        do {
            this.FirstMBinGOB = this.GroupNumber * this.MBperGOB;
            this.CurrentLumiOffset = LumiOffset[this.GroupNumber];
            this.CurrentCromOffset = CromOffset[this.GroupNumber];
            this.MB_address = this.FirstMBinGOB;
            int n2 = this.FirstMBinGOB + this.MBperGOB;
            while (this.MB_address < n2) {
                int n3;
                while ((n3 = this.GetIntraMCBPC_VLC()) == -1) {
                }
                int n4 = n3 >> 4;
                int n5 = this.GetCBPY_VLC() >> 4;
                if (n4 == 4) {
                    this.Quantizer = nArray[this.Quantizer + dQuant[this.nextBits(2)]];
                    this.skipBits(2);
                }
                H263Decoder.CodedMap[this.MB_address] = 2;
                this.BlockOffset[0] = this.CurrentLumiOffset;
                this.BlockOffset[1] = this.BlockOffset[0] + 8;
                this.BlockOffset[2] = this.BlockOffset[0] + this.FrameWidthx8;
                this.BlockOffset[3] = this.BlockOffset[2] + 8;
                this.BlockOffset[4] = this.CurrentCromOffset;
                this.BlockOffset[5] = this.CurrentCromOffset;
                int n6 = n5 << 2 | n3 & 3;
                int n7 = 0;
                while (n7 < 6) {
                    int n8 = this.getBits(8);
                    if (n8 == 255) {
                        n8 = 128;
                    }
                    this.BlockData[n7][0] = n8 << 12;
                    if ((n6 & 0x20) != 0) {
                        this.GetCoefficients(1, n7);
                    }
                    this.idct8x8(this.BlockData[n7], this.BlockPtr[n7], this.BlockOffset[n7], this.FrameWidthBlock[n7], 1);
                    n6 <<= 1;
                    ++n7;
                }
                this.CurrentLumiOffset += 16;
                this.CurrentCromOffset += 8;
                ++this.MB_address;
            }
            ++this.GroupNumber;
        } while (this.StartCodeFound() == 0 && this.GroupNumber < this.GOBperFrame);
    }

    private final int GetMVD_VLC() {
        int n2;
        int n3;
        int n4 = this.nextBits(13);
        if (n4 >= 192) {
            int n5 = n4 >> 5;
            n3 = MVD1_VLC_tab0[n5];
            n2 = MVD1_VLC_tab1[n5];
        } else {
            int n6 = n4;
            n3 = MVD2_VLC_tab0[n6];
            n2 = MVD2_VLC_tab1[n6];
        }
        this.skipBits(n2);
        return n3;
    }

    private final void GetNextStartCode() {
        while (this.nextBits(17) != 1) {
            this.skipBits(1);
        }
    }

    private final void HorizEdgeFilter(int[] nArray, int n2) {
        int n3 = this.FrameWidth >> n2;
        int n4 = this.FrameHeight >> n2;
        int n5 = 8;
        while (n5 < n4) {
            int n6 = n5 >> 4 - n2;
            int n7 = n5 + (n2 - 1 << 3) >> 4;
            int n8 = n5 * n3;
            int n9 = 0;
            while (n9 < n3) {
                int n10 = n9 >> 4 - n2;
                if (CodedMap[(n6 + 1) * (n10 + 1)] > 0 || CodedMap[(n7 + 1) * (n10 + 1)] > 0) {
                    int n11 = nArray[n8 - (n3 << 1)] - (nArray[n8 - n3] << 2) + (nArray[n8] << 2) - nArray[n8 + n3] >> 3;
                    int n12 = (n11 < 0 ? -1 : 1) * Math.max(0, Math.abs(n11) - Math.max(0, Math.abs(n11) - STRENGTH[this.Quantizer - 1] << 1));
                    int n13 = Math.min(Math.abs(n12 >> 1), Math.max(-Math.abs(n12 >> 1), nArray[n8 - (n3 << 1)] - nArray[n8 + n3] >> 2));
                    nArray[n8 + n3] = nArray[n8 + n3] + n13;
                    nArray[n8] = DfiltClip[nArray[n8] - n12 + 128];
                    nArray[n8 - n3] = DfiltClip[nArray[n8 - n3] + n12 + 128];
                    nArray[n8 - (n3 << 1)] = nArray[n8 - (n3 << 1)] - n13;
                }
                ++n9;
                ++n8;
            }
            n5 += 8;
        }
    }

    private final void Interp16x16Pel(int[] nArray, int n2, int[] nArray2, int n3, int n4, int n5) {
        int n6 = n2;
        int n7 = n2 + n5 * this.xFrameWidth + n4;
        int n8 = this.FrameWidth;
        int n9 = this.xFrameWidth;
        int n10 = 0;
        while (n10 < 16) {
            int n11 = 0;
            while (n11 < 16) {
                nArray2[n3 + n11] = nArray[n6 + n11] + nArray[n7 + n11] + 1 >> 1;
                ++n11;
            }
            n3 += n8;
            n6 += n9;
            n7 += n9;
            ++n10;
        }
    }

    private final void Interp8x8Pel(int[] nArray, int n2, int[] nArray2, int n3, int n4, int n5) {
        int n6 = n2;
        int n7 = n2 + n5 * this.xFrameWidthDiv2 + n4;
        int n8 = this.FrameWidthDiv2 - 8;
        int n9 = this.xFrameWidthDiv2 - 8;
        int n10 = 0;
        while (n10 < 8) {
            int n11 = 0;
            while (n11 < 8) {
                nArray2[n3++] = nArray[n6++] + nArray[n7++] + 1 >> 1;
                ++n11;
            }
            n3 += n8;
            n6 += n9;
            n7 += n9;
            ++n10;
        }
    }

    private final void InterpF16x16Pel(int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = n2;
        int n5 = n2 + this.xFrameWidth;
        int n6 = this.FrameWidth - 15;
        int n7 = this.xFrameWidth - 16;
        int n8 = 0;
        while (n8 < 16) {
            int n9 = nArray[n4++];
            int n10 = nArray[n4++];
            int n11 = nArray[n4++];
            int n12 = nArray[n4++];
            int n13 = nArray[n4++];
            int n14 = nArray[n4++];
            int n15 = nArray[n4++];
            int n16 = nArray[n4++];
            int n17 = nArray[n4++];
            int n18 = nArray[n4++];
            int n19 = nArray[n4++];
            int n20 = nArray[n4++];
            int n21 = nArray[n4++];
            int n22 = nArray[n4++];
            int n23 = nArray[n4++];
            int n24 = nArray[n4++];
            int n25 = nArray[n4];
            int n26 = nArray[n5++];
            int n27 = nArray[n5++];
            int n28 = nArray[n5++];
            int n29 = nArray[n5++];
            int n30 = nArray[n5++];
            int n31 = nArray[n5++];
            int n32 = nArray[n5++];
            int n33 = nArray[n5++];
            int n34 = nArray[n5++];
            int n35 = nArray[n5++];
            int n36 = nArray[n5++];
            int n37 = nArray[n5++];
            int n38 = nArray[n5++];
            int n39 = nArray[n5++];
            int n40 = nArray[n5++];
            int n41 = nArray[n5++];
            int n42 = nArray[n5];
            nArray2[n3++] = n9 + n10 + n26 + n27 + 2 >> 2;
            nArray2[n3++] = n10 + n11 + n27 + n28 + 2 >> 2;
            nArray2[n3++] = n11 + n12 + n28 + n29 + 2 >> 2;
            nArray2[n3++] = n12 + n13 + n29 + n30 + 2 >> 2;
            nArray2[n3++] = n13 + n14 + n30 + n31 + 2 >> 2;
            nArray2[n3++] = n14 + n15 + n31 + n32 + 2 >> 2;
            nArray2[n3++] = n15 + n16 + n32 + n33 + 2 >> 2;
            nArray2[n3++] = n16 + n17 + n33 + n34 + 2 >> 2;
            nArray2[n3++] = n17 + n18 + n34 + n35 + 2 >> 2;
            nArray2[n3++] = n18 + n19 + n35 + n36 + 2 >> 2;
            nArray2[n3++] = n19 + n20 + n36 + n37 + 2 >> 2;
            nArray2[n3++] = n20 + n21 + n37 + n38 + 2 >> 2;
            nArray2[n3++] = n21 + n22 + n38 + n39 + 2 >> 2;
            nArray2[n3++] = n22 + n23 + n39 + n40 + 2 >> 2;
            nArray2[n3++] = n23 + n24 + n40 + n41 + 2 >> 2;
            nArray2[n3] = n24 + n25 + n41 + n42 + 2 >> 2;
            n3 += n6;
            n4 += n7;
            n5 += n7;
            ++n8;
        }
    }

    private final void InterpF8x8Pel(int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = n2;
        int n5 = n2 + this.xFrameWidthDiv2;
        int n6 = this.FrameWidthDiv2 - 7;
        int n7 = this.xFrameWidthDiv2 - 8;
        int n8 = 0;
        while (n8 < 8) {
            int n9 = nArray[n4++];
            int n10 = nArray[n4++];
            int n11 = nArray[n4++];
            int n12 = nArray[n4++];
            int n13 = nArray[n4++];
            int n14 = nArray[n4++];
            int n15 = nArray[n4++];
            int n16 = nArray[n4++];
            int n17 = nArray[n4];
            int n18 = nArray[n5++];
            int n19 = nArray[n5++];
            int n20 = nArray[n5++];
            int n21 = nArray[n5++];
            int n22 = nArray[n5++];
            int n23 = nArray[n5++];
            int n24 = nArray[n5++];
            int n25 = nArray[n5++];
            int n26 = nArray[n5];
            nArray2[n3++] = n9 + n10 + n18 + n19 + 2 >> 2;
            nArray2[n3++] = n10 + n11 + n19 + n20 + 2 >> 2;
            nArray2[n3++] = n11 + n12 + n20 + n21 + 2 >> 2;
            nArray2[n3++] = n12 + n13 + n21 + n22 + 2 >> 2;
            nArray2[n3++] = n13 + n14 + n22 + n23 + 2 >> 2;
            nArray2[n3++] = n14 + n15 + n23 + n24 + 2 >> 2;
            nArray2[n3++] = n15 + n16 + n24 + n25 + 2 >> 2;
            nArray2[n3] = n16 + n17 + n25 + n26 + 2 >> 2;
            n3 += n6;
            n4 += n7;
            n5 += n7;
            ++n8;
        }
    }

    private final int ParseHeaderPlus() {
        int n2;
        int n3 = 0;
        int n4 = this.getBits(3);
        if (n4 == 1) {
            n3 = this.getBits(3);
            n2 = this.getBits(1);
            if (n2 == 1) {
                return 2;
            }
            this.UnrestrictedMV = this.getBits(1);
            n2 = this.getBits(4);
            if (n2 > 1) {
                return 2;
            }
            this.DeblockingFilter = n2 & 1;
            n2 = this.getBits(9);
            if (n2 != 8) {
                return 2;
            }
        }
        this.CodingType = this.getBits(3);
        if (this.CodingType > 1) {
            return 2;
        }
        n2 = this.getBits(6);
        if (n2 != 1) {
            return 2;
        }
        this.CPM = this.getBits(1);
        if (this.CPM != 0) {
            this.getBits(2);
        }
        if (n3 == 6) {
            n2 = this.getBits(4);
            if (n2 != 2) {
                return 2;
            }
            int n5 = this.getBits(9);
            n2 = n5 + 1 << 2;
            if (n2 != this.FrameWidth) {
                this.SourceFormat = 9;
                this.FrameWidth = n2;
            }
            n2 = this.getBits(1);
            n5 = this.getBits(9);
            n2 = n5 << 2;
            if (n2 != this.FrameHeight) {
                this.SourceFormat = 9;
                this.FrameHeight = n2;
            }
        }
        return 1;
    }

    private final int StartCodeFound() {
        int n2 = this.nextBits(16);
        if (n2 == 0) {
            int n3 = 0;
            while ((n2 = this.nextBits(17)) != 1 && n3 < 7) {
                this.skipBits(1);
                ++n3;
            }
            if (n2 == 1) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private final void VertEdgeFilter(int[] nArray, int n2) {
        int n3 = this.FrameWidth >> n2;
        int n4 = this.FrameHeight >> n2;
        int n5 = 8;
        while (n5 < n3) {
            int n6 = n5 >> 4 - n2;
            int n7 = n5 + (n2 - 1 << 3) >> 4;
            int n8 = n5;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n9 >> 4 - n2;
                if (CodedMap[(n10 + 1) * (n6 + 1)] > 0 || CodedMap[(n10 + 1) * (n7 + 1)] > 0) {
                    int n11 = nArray[n8 - 2] - (nArray[n8 - 1] << 2) + (nArray[n8] << 2) - nArray[n8 + 1] >> 3;
                    int n12 = (n11 < 0 ? -1 : 1) * Math.max(0, Math.abs(n11) - Math.max(0, Math.abs(n11) - STRENGTH[this.Quantizer - 1] << 1));
                    int n13 = Math.min(Math.abs(n12 >> 1), Math.max(-Math.abs(n12 >> 1), nArray[n8 - 2] - nArray[n8 + 1] >> 2));
                    nArray[n8 + 1] = nArray[n8 + 1] + n13;
                    nArray[n8] = DfiltClip[nArray[n8] - n12 + 128];
                    nArray[n8 - 1] = DfiltClip[nArray[n8 - 1] + n12 + 128];
                    nArray[n8 - 2] = nArray[n8 - 2] - n13;
                }
                ++n9;
                n8 += n3;
            }
            n5 += 8;
        }
    }

    public void finalize() {
        this.CurrentFrame = null;
        this.PreviousFrame = null;
        this.xPrevFrame = null;
        this.MotVectCurrGOB = null;
        this.MotVectPrevGOB = null;
        this.MBtypeCurrGOB = null;
        this.MBtypePrevGOB = null;
    }

    private final void idct8x8(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22 = 7;
        int n23 = 15;
        int n24 = 23;
        int n25 = 31;
        int n26 = 39;
        int n27 = 47;
        int n28 = 55;
        int n29 = -1;
        while (n29 < 7) {
            int n30;
            int n31;
            int n32;
            int n33;
            int n34;
            int n35;
            int n36;
            int n37 = nArray[++n29];
            if (((n36 = nArray[++n22]) | (n35 = nArray[++n23]) | (n34 = nArray[++n24]) | (n33 = nArray[++n25]) | (n32 = nArray[++n26]) | (n31 = nArray[++n27]) | (n30 = nArray[++n28])) == 0) {
                nArray[n27] = nArray[n28] = n37;
                nArray[n26] = nArray[n28];
                nArray[n25] = nArray[n28];
                nArray[n24] = nArray[n28];
                nArray[n23] = nArray[n28];
                nArray[n22] = nArray[n28];
                continue;
            }
            n21 = n37 + n33;
            n20 = n37 - n33;
            n19 = n35 + n31;
            n18 = (362 * (n35 - n31) >> 8) - n19;
            n17 = n21 + n19;
            n16 = n21 - n19;
            n15 = n20 + n18;
            n14 = n20 - n18;
            n13 = n32 + n34;
            n12 = n32 - n34;
            n11 = n36 + n30;
            n10 = n36 - n30;
            n9 = n11 + n13;
            n20 = 362 * (n11 - n13) >> 8;
            n8 = 473 * (n12 + n10) >> 8;
            n21 = (277 * n10 >> 8) - n8;
            n18 = (-669 * n12 >> 8) + n8;
            n7 = n18 - n9;
            n6 = n20 - n7;
            n5 = n21 + n6;
            nArray[n29] = n17 + n9;
            nArray[n22] = n15 + n7;
            nArray[n23] = n14 + n6;
            nArray[n24] = n16 - n5;
            nArray[n25] = n16 + n5;
            nArray[n26] = n14 - n6;
            nArray[n27] = n15 - n7;
            nArray[n28] = n17 - n9;
        }
        int n38 = 0;
        int[] nArray3 = clipTable;
        int n39 = 0;
        while (n39 < 8) {
            int n40;
            int n41;
            int n42 = n38++;
            int n43 = nArray[n42];
            int n44 = n38++;
            int n45 = nArray[n44];
            int n46 = n38++;
            int n47 = nArray[n46];
            int n48 = n38++;
            int n49 = nArray[n48];
            int n50 = n38++;
            int n51 = nArray[n50];
            int n52 = n38++;
            int n53 = nArray[n52];
            int n54 = n38++;
            int n55 = nArray[n54];
            if ((n45 | n47 | n49 | n51 | n53 | n55 | (n41 = nArray[n40 = n38++])) == 0) {
                int n56;
                nArray[n54] = nArray[n40] = (n56 = n43 + 2048 >> 12);
                nArray[n52] = nArray[n40];
                nArray[n50] = nArray[n40];
                nArray[n48] = nArray[n40];
                nArray[n46] = nArray[n40];
                nArray[n44] = nArray[n40];
                nArray[n42] = nArray[n40];
                if (n4 != 0) {
                    n56 = nArray3[0x3FF & n56];
                    int n57 = n2++;
                    int n58 = n2++;
                    int n59 = n2++;
                    int n60 = n2++;
                    int n61 = n2++;
                    int n62 = n2++;
                    int n63 = n2++;
                    int n64 = n2++;
                    int n65 = n56;
                    nArray2[n64] = n65;
                    nArray2[n63] = n65;
                    nArray2[n62] = n65;
                    nArray2[n61] = n65;
                    nArray2[n60] = n65;
                    nArray2[n59] = n65;
                    nArray2[n58] = n65;
                    nArray2[n57] = n65;
                } else {
                    nArray2[n2] = nArray3[0x3FF & nArray2[n2++] + n56];
                    nArray2[n2] = nArray3[0x3FF & nArray2[n2++] + n56];
                    nArray2[n2] = nArray3[0x3FF & nArray2[n2++] + n56];
                    nArray2[n2] = nArray3[0x3FF & nArray2[n2++] + n56];
                    nArray2[n2] = nArray3[0x3FF & nArray2[n2++] + n56];
                    nArray2[n2] = nArray3[0x3FF & nArray2[n2++] + n56];
                    nArray2[n2] = nArray3[0x3FF & nArray2[n2++] + n56];
                    nArray2[n2] = nArray3[0x3FF & nArray2[n2++] + n56];
                }
                n2 += n3 - 8;
            } else {
                n21 = n43 + n51;
                n20 = n43 - n51;
                n19 = n47 + n55;
                n18 = (362 * (n47 - n55) >> 8) - n19;
                n17 = n21 + n19 + 2048;
                n16 = n21 - n19 + 2048;
                n15 = n20 + n18 + 2048;
                n14 = n20 - n18 + 2048;
                n13 = n53 + n49;
                n12 = n53 - n49;
                n11 = n45 + n41;
                n10 = n45 - n41;
                n9 = n11 + n13;
                n20 = 362 * (n11 - n13) >> 8;
                n8 = 473 * (n12 + n10) >> 8;
                n21 = (277 * n10 >> 8) - n8;
                n18 = (-669 * n12 >> 8) + n8;
                n7 = n18 - n9;
                n6 = n20 - n7;
                n5 = n21 + n6;
                if (n4 != 0) {
                    int n66 = n2++;
                    nArray[n42] = n17 + n9 >> 12;
                    nArray2[n66] = nArray3[0x3FF & nArray[n42]];
                    int n67 = n2++;
                    nArray[n44] = n15 + n7 >> 12;
                    nArray2[n67] = nArray3[0x3FF & nArray[n44]];
                    int n68 = n2++;
                    nArray[n46] = n14 + n6 >> 12;
                    nArray2[n68] = nArray3[0x3FF & nArray[n46]];
                    int n69 = n2++;
                    nArray[n48] = n16 - n5 >> 12;
                    nArray2[n69] = nArray3[0x3FF & nArray[n48]];
                    int n70 = n2++;
                    nArray[n50] = n16 + n5 >> 12;
                    nArray2[n70] = nArray3[0x3FF & nArray[n50]];
                    int n71 = n2++;
                    nArray[n52] = n14 - n6 >> 12;
                    nArray2[n71] = nArray3[0x3FF & nArray[n52]];
                    int n72 = n2++;
                    nArray[n54] = n15 - n7 >> 12;
                    nArray2[n72] = nArray3[0x3FF & nArray[n54]];
                    int n73 = n2++;
                    nArray[n40] = n17 - n9 >> 12;
                    nArray2[n73] = nArray3[0x3FF & nArray[n40]];
                } else {
                    int n74 = n2;
                    int n75 = n2++;
                    nArray[n42] = n17 + n9 >> 12;
                    nArray2[n74] = nArray3[0x3FF & nArray2[n75] + nArray[n42]];
                    int n76 = n2;
                    int n77 = n2++;
                    nArray[n44] = n15 + n7 >> 12;
                    nArray2[n76] = nArray3[0x3FF & nArray2[n77] + nArray[n44]];
                    int n78 = n2;
                    int n79 = n2++;
                    nArray[n46] = n14 + n6 >> 12;
                    nArray2[n78] = nArray3[0x3FF & nArray2[n79] + nArray[n46]];
                    int n80 = n2;
                    int n81 = n2++;
                    nArray[n48] = n16 - n5 >> 12;
                    nArray2[n80] = nArray3[0x3FF & nArray2[n81] + nArray[n48]];
                    int n82 = n2;
                    int n83 = n2++;
                    nArray[n50] = n16 + n5 >> 12;
                    nArray2[n82] = nArray3[0x3FF & nArray2[n83] + nArray[n50]];
                    int n84 = n2;
                    int n85 = n2++;
                    nArray[n52] = n14 - n6 >> 12;
                    nArray2[n84] = nArray3[0x3FF & nArray2[n85] + nArray[n52]];
                    int n86 = n2;
                    int n87 = n2++;
                    nArray[n54] = n15 - n7 >> 12;
                    nArray2[n86] = nArray3[0x3FF & nArray2[n87] + nArray[n54]];
                    int n88 = n2;
                    int n89 = n2++;
                    nArray[n40] = n17 - n9 >> 12;
                    nArray2[n88] = nArray3[0x3FF & nArray2[n89] + nArray[n40]];
                }
                n2 += n3 - 8;
            }
            ++n39;
        }
    }

    final void init() {
        this.SourceFormat = 9;
    }

    private final int median(int n2, int n3, int n4) {
        return n2 >= n3 ? (n3 >= n4 ? n3 : (n2 >= n4 ? n4 : n2)) : (n2 >= n4 ? n2 : (n3 >= n4 ? n4 : n3));
    }
}

