/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.vcm;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.controls.QualityAdapter;
import com.sun.media.vfw.BitMapInfo;
import com.sun.media.vfw.ICInfo;
import com.sun.media.vfw.VCM;
import java.awt.Dimension;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.QualityControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class NativeEncoder
extends BasicCodec {
    protected RGBFormat inputFormat = null;
    protected VideoFormat outputFormat = null;
    private static String[] supportedEncodings;
    private static BitMapInfo[] supportedOutBMIs;
    private int vcmHandle = 0;
    private boolean debug = false;
    private BitMapInfo biIn = null;
    private BitMapInfo biOut = null;
    private BitMapInfo biPrev = null;
    private boolean dropFrame = false;
    private boolean hasQuality = false;
    private boolean hasCrunch = false;
    private boolean hasTemporal = false;
    private boolean hasFastCompress = false;
    private boolean begun = false;
    private QualityControl qc = null;
    private Control[] controls = null;
    private float quality = 9000.0f;
    static final int AVIF_KEYFRAME = 16;
    int seqNo = 0;
    int keyFrameInterval = 4;
    int[] outFlags = new int[1];
    int[] ckid = new int[1];
    byte[] dataPrev = null;

    static {
        JMFSecurityManager.loadLibrary("jmvcm");
        supportedEncodings = null;
        supportedOutBMIs = null;
    }

    public NativeEncoder() {
        this.inputFormats = new VideoFormat[1];
        this.inputFormats[0] = new RGBFormat();
        this.outputFormats = new VideoFormat[1];
        this.outputFormats[0] = new VideoFormat(null);
    }

    static /* synthetic */ float access$0(NativeEncoder nativeEncoder) {
        return nativeEncoder.quality;
    }

    public synchronized void close() {
        if (this.vcmHandle != 0) {
            if (this.begun) {
                VCM.icCompressEnd(this.vcmHandle);
            }
            VCM.icClose(this.vcmHandle);
            this.begun = false;
        }
        this.vcmHandle = 0;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            if (this.qc == null) {
                this.qc = new QualityAdapter(this.quality, 0.0f, 10000.0f, true){

                    protected String getName() {
                        return "Video Encoder Quality";
                    }

                    public float setQuality(float f2) {
                        NativeEncoder.this.quality = f2;
                        return super.setQuality(f2);
                    }
                };
                this.controls = new Control[1];
                this.controls[0] = this.qc;
            } else {
                this.controls = new Control[0];
            }
        }
        return this.controls;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    public String getName() {
        return "VCM Encoder";
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedInputFormats() {
        this.inputFormats[0] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 1, -1);
        return this.inputFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null || !(format instanceof RGBFormat)) {
            return new VideoFormat[]{new VideoFormat(null)};
        }
        if (format.matches(this.inputFormats[0])) {
            Dimension dimension;
            if (supportedEncodings == null) {
                NativeEncoder.querySupportedEncodings();
            }
            if ((dimension = ((VideoFormat)format).getSize()) == null) {
                dimension = new Dimension(320, 240);
            }
            this.outputFormats = new VideoFormat[supportedEncodings.length];
            int n2 = 0;
            while (n2 < supportedEncodings.length) {
                int n3 = dimension.width * dimension.height;
                int n4 = n3 * NativeEncoder.supportedOutBMIs[n2].biBitCount / 8;
                if (n4 < n3) {
                    n4 = n3;
                }
                this.outputFormats[n2] = new VideoFormat(supportedEncodings[n2], dimension, n4, Format.byteArray, ((VideoFormat)format).getFrameRate());
                ++n2;
            }
            return this.outputFormats;
        }
        return new Format[0];
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Unknown formats");
        }
        Dimension dimension = this.inputFormat.getSize();
        if (dimension == null || dimension.width % 4 != 0 || dimension.height % 4 != 0) {
            Log.error("Class: " + this);
            Log.error("  can only encode in sizes of multiple of 4 pixels.");
            throw new ResourceUnavailableException("Wrong size.");
        }
        if (this.vcmHandle != 0) {
            this.close();
        }
        this.biIn = new BitMapInfo(this.inputFormat);
        this.biOut = new BitMapInfo(this.outputFormat);
        this.vcmHandle = VCM.icLocate("vidc", "rgb", this.biIn, this.biOut, 1);
        if (this.vcmHandle == 0) {
            throw new ResourceUnavailableException("Couldn't create compressor");
        }
        ICInfo iCInfo = new ICInfo();
        VCM.icGetInfo(this.vcmHandle, iCInfo);
        int n2 = iCInfo.dwFlags;
        this.hasQuality = (n2 & 1) != 0;
        this.hasCrunch = (n2 & 2) != 0;
        this.hasTemporal = (n2 & 4) != 0;
        this.hasFastCompress = (n2 & 0x20) != 0;
        this.begun = false;
        BitMapInfo bitMapInfo = new BitMapInfo();
        VCM.icCompressGetFormat(this.vcmHandle, this.biIn, bitMapInfo);
        this.biOut = bitMapInfo;
        if (!VCM.icCompressBegin(this.vcmHandle, this.biIn, this.biOut)) {
            VCM.icClose(this.vcmHandle);
            throw new ResourceUnavailableException("Couldn't create compressor");
        }
        this.begun = true;
        this.seqNo = this.seqNo + 3 & 0xFFFFFFFC;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        Object object = buffer2.getData();
        if (object == null || !(object instanceof byte[]) || ((byte[])object).length < this.outputFormat.getMaxDataLength()) {
            object = new byte[this.outputFormat.getMaxDataLength()];
        }
        buffer2.setData(object);
        buffer2.setFormat(this.outputFormat);
        if (this.dataPrev == null && this.hasTemporal) {
            this.dataPrev = new byte[this.inputFormat.getMaxDataLength()];
        }
        if (this.seqNo % this.keyFrameInterval == 0) {
            n2 |= 1;
        }
        ++this.seqNo;
        int n4 = VCM.icCompress(this.vcmHandle, n2, this.biOut, object, this.biIn, buffer.getData(), this.ckid, this.outFlags, this.seqNo, this.outputFormat.getMaxDataLength(), (int)this.quality, this.biIn, this.dataPrev);
        if ((this.outFlags[0] & 0x10) != 0) {
            n3 |= 0x10;
        }
        byte[] byArray = this.dataPrev;
        if (this.hasTemporal) {
            this.dataPrev = (byte[])buffer.getData();
            buffer.setData(byArray);
        }
        if (n4 < 0) {
            return 1;
        }
        buffer2.setFormat(this.outputFormat);
        buffer2.setSequenceNumber(this.seqNo);
        buffer2.setLength(this.biOut.biSizeImage);
        n3 = buffer2.getFlags() & 0xFFFFFFEF | n3 | 0x60;
        buffer2.setFlags(n3);
        return 0;
    }

    private static synchronized void querySupportedEncodings() {
        boolean bl;
        int n2;
        ICInfo iCInfo = new ICInfo();
        BitMapInfo bitMapInfo = new BitMapInfo();
        Vector<String> vector = new Vector<String>();
        Vector<BitMapInfo> vector2 = new Vector<BitMapInfo>();
        for (n2 = 0; (bl = VCM.icInfoEnum("vidc", n2, iCInfo)) && n2 <= 30; ++n2) {
            int n3 = VCM.icOpen("vidc", iCInfo.fccHandler, 1);
            if (n3 == 0) continue;
            BitMapInfo bitMapInfo2 = new BitMapInfo("RGB", 320, 240);
            bitMapInfo = new BitMapInfo("RGB", 320, 240);
            VCM.icCompressGetFormat(n3, bitMapInfo2, bitMapInfo);
            if (bitMapInfo.fourcc.equalsIgnoreCase(iCInfo.fccHandler) && !iCInfo.fccHandler.equalsIgnoreCase("mjpg") && !iCInfo.fccHandler.equalsIgnoreCase("dmb1")) {
                vector.addElement(bitMapInfo.fourcc);
                vector2.addElement(bitMapInfo);
            }
            VCM.icClose(n3);
        }
        supportedEncodings = new String[vector.size()];
        supportedOutBMIs = new BitMapInfo[vector.size()];
        n2 = 0;
        while (n2 < supportedEncodings.length) {
            NativeEncoder.supportedEncodings[n2] = (String)vector.elementAt(n2);
            NativeEncoder.supportedOutBMIs[n2] = (BitMapInfo)vector2.elementAt(n2);
            ++n2;
        }
    }

    public Format setInputFormat(Format format) {
        if (format instanceof RGBFormat && BasicPlugIn.matches(format, this.inputFormats) != null) {
            this.inputFormat = (RGBFormat)format;
            if (this.begun) {
                this.close();
                try {
                    Dimension dimension = ((RGBFormat)format).getSize();
                    int n2 = dimension.width * dimension.height;
                    int n3 = n2 * 24 / 8;
                    this.outputFormat = new VideoFormat(this.outputFormat.getEncoding(), dimension, n3, Format.byteArray, this.inputFormat.getFrameRate());
                    this.open();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return format;
        }
        return null;
    }

    public Format setOutputFormat(Format format) {
        if (format instanceof VideoFormat) {
            this.outputFormat = (VideoFormat)format;
            if (this.debug) {
                System.err.println("VCM.setOutputFormat : " + this.outputFormat);
            }
            return format;
        }
        return null;
    }
}

