/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPReporter;
import com.sun.media.rtp.RTPSinkStream;
import com.sun.media.rtp.RTPTransStats;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.TrueRandom;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.SendStream;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;

public class SendSSRCInfo
extends SSRCInfo
implements SenderReport,
SendStream {
    boolean inited = false;
    private static final int PACKET_SIZE = 4000;
    protected int packetsize = 0;
    protected Format myformat = null;
    protected long totalSamples = 0L;
    protected long lastSeq = -1L;
    protected long lastBufSeq = -1L;
    protected RTPTransStats stats = null;
    protected RTCPReporter rtcprep = null;
    static AudioFormat dviAudio = new AudioFormat("dvi/rtp");
    static AudioFormat gsmAudio = new AudioFormat("gsm/rtp");
    static AudioFormat g723Audio = new AudioFormat("g723/rtp");
    static AudioFormat ulawAudio = new AudioFormat("ULAW/rtp");
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");

    public SendSSRCInfo(SSRCCache sSRCCache, int n2) {
        super(sSRCCache, n2);
        this.maxseq = this.baseseq = (int)TrueRandom.rand();
        this.lasttimestamp = (int)TrueRandom.rand();
        this.sender = true;
        this.wassender = true;
        this.sinkstream = new RTPSinkStream();
        this.stats = new RTPTransStats();
    }

    public SendSSRCInfo(SSRCInfo sSRCInfo) {
        super(sSRCInfo);
        this.maxseq = this.baseseq = (int)TrueRandom.rand();
        this.lasttimestamp = (int)TrueRandom.rand();
        this.sender = true;
        this.wassender = true;
        this.sinkstream = new RTPSinkStream();
        this.stats = new RTPTransStats();
    }

    private int calculateSampleCount(Buffer buffer) {
        AudioFormat audioFormat = (AudioFormat)buffer.getFormat();
        if (audioFormat == null) {
            return -1;
        }
        long l2 = audioFormat.computeDuration(buffer.getLength());
        if (l2 == -1L) {
            return -1;
        }
        if (audioFormat.getSampleRate() != -1.0) {
            return (int)((double)l2 * audioFormat.getSampleRate() / 1.0E9);
        }
        if (audioFormat.getFrameRate() != -1.0) {
            return (int)((double)l2 * audioFormat.getFrameRate() / 1.0E9);
        }
        return -1;
    }

    public void close() {
        try {
            this.stop();
        }
        catch (IOException iOException) {}
        SSRCCache sSRCCache = this.getSSRCCache();
        sSRCCache.sm.removeSendStream(this);
    }

    protected void createDS() {
    }

    public DataSource getDataSource() {
        return this.pds;
    }

    public long getNTPTimeStampLSW() {
        return this.lastSRntptimestamp;
    }

    public long getNTPTimeStampMSW() {
        return this.lastSRntptimestamp >> 32;
    }

    public Participant getParticipant() {
        SSRCCache sSRCCache = this.getSSRCCache();
        if (this.sourceInfo instanceof LocalParticipant && sSRCCache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public long getRTPTimeStamp() {
        return this.lastSRrtptimestamp;
    }

    public long getSenderByteCount() {
        return this.lastSRoctetcount;
    }

    public Feedback getSenderFeedback() {
        SSRCCache sSRCCache = this.getSSRCCache();
        Report report = null;
        Vector vector = null;
        Vector vector2 = null;
        Feedback feedback = null;
        try {
            LocalParticipant localParticipant = sSRCCache.sm.getLocalParticipant();
            vector = localParticipant.getReports();
            int n2 = 0;
            while (n2 < vector.size()) {
                report = (Report)vector.elementAt(n2);
                vector2 = report.getFeedbackReports();
                int n3 = 0;
                while (n3 < vector2.size()) {
                    feedback = (Feedback)vector2.elementAt(n3);
                    long l2 = feedback.getSSRC();
                    if (l2 == this.getSSRC()) {
                        return feedback;
                    }
                    ++n3;
                }
                ++n2;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public long getSenderPacketCount() {
        return this.lastSRpacketcount;
    }

    public SenderReport getSenderReport() {
        SSRCCache sSRCCache = this.getSSRCCache();
        Report report = null;
        Vector vector = null;
        Vector vector2 = null;
        Feedback feedback = null;
        try {
            LocalParticipant localParticipant = sSRCCache.sm.getLocalParticipant();
            vector = localParticipant.getReports();
            int n2 = 0;
            while (n2 < vector.size()) {
                report = (Report)vector.elementAt(n2);
                vector2 = report.getFeedbackReports();
                int n3 = 0;
                while (n3 < vector2.size()) {
                    feedback = (Feedback)vector2.elementAt(n3);
                    long l2 = feedback.getSSRC();
                    if (l2 == this.getSSRC()) {
                        return (SenderReport)report;
                    }
                    ++n3;
                }
                ++n2;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public long getSequenceNumber(Buffer buffer) {
        long l2 = buffer.getSequenceNumber();
        if (this.lastSeq == -1L) {
            this.lastSeq = (long)((double)System.currentTimeMillis() * Math.random());
            this.lastBufSeq = l2;
            return this.lastSeq;
        }
        this.lastSeq = l2 - this.lastBufSeq > 1L ? (this.lastSeq += l2 - this.lastBufSeq) : ++this.lastSeq;
        this.lastBufSeq = l2;
        return this.lastSeq;
    }

    public TransmissionStats getSourceTransmissionStats() {
        return this.stats;
    }

    public RTPStream getStream() {
        return this;
    }

    public long getTimeStamp(Buffer buffer) {
        if (buffer.getFormat() instanceof AudioFormat) {
            if (mpegAudio.matches(buffer.getFormat())) {
                if (buffer.getTimeStamp() >= 0L) {
                    return buffer.getTimeStamp() * 90L / 1000000L;
                }
                return System.currentTimeMillis() * 90L;
            }
            this.totalSamples += (long)this.calculateSampleCount(buffer);
            return this.totalSamples;
        }
        if (buffer.getFormat() instanceof VideoFormat) {
            if (buffer.getTimeStamp() >= 0L) {
                return buffer.getTimeStamp() * 90L / 1000000L;
            }
            return System.currentTimeMillis() * 90L;
        }
        return buffer.getTimeStamp();
    }

    public int setBitRate(int n2) {
        if (this.sinkstream != null) {
            this.sinkstream.rate = n2;
        }
        return n2;
    }

    protected void setFormat(Format format) {
        this.myformat = format;
        if (this.sinkstream != null) {
            int n2 = 0;
            if (format instanceof AudioFormat) {
                if (ulawAudio.matches(format) || dviAudio.matches(format) || mpegAudio.matches(format)) {
                    n2 = (int)((AudioFormat)format).getSampleRate() * ((AudioFormat)format).getSampleSizeInBits();
                } else if (gsmAudio.matches(format)) {
                    n2 = 13200;
                } else if (g723Audio.matches(format)) {
                    n2 = 6300;
                }
                this.sinkstream.rate = n2;
            }
        } else {
            System.err.println("RTPSinkStream is NULL");
        }
    }

    public void setSourceDescription(SourceDescription[] sourceDescriptionArray) {
        super.setSourceDescription(sourceDescriptionArray);
    }

    public void start() throws IOException {
        if (!this.inited) {
            this.inited = true;
            this.probation = 0;
            this.initsource((int)TrueRandom.rand());
            this.lasttimestamp = (int)TrueRandom.rand();
        }
        if (this.pds != null) {
            this.pds.start();
        }
        if (this.sinkstream != null) {
            this.sinkstream.start();
        }
    }

    public void stop() throws IOException {
        if (this.pds != null) {
            this.pds.stop();
        }
        if (this.sinkstream != null) {
            this.sinkstream.stop();
        }
    }
}

